/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.diagram.core.listener;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.transaction.NotificationFilter;
import org.eclipse.emf.transaction.ResourceSetChangeEvent;
import org.eclipse.emf.transaction.ResourceSetListener;
import org.eclipse.emf.transaction.ResourceSetListenerImpl;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.diagram.core.listener.NotificationListener;
import org.eclipse.gmf.runtime.diagram.core.listener.NotificationPreCommitListener;
import org.eclipse.gmf.runtime.diagram.core.listener.NotificationUtil;
import org.eclipse.gmf.runtime.diagram.core.util.ViewUtil;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.View;

public class DiagramEventBroker
extends ResourceSetListenerImpl {
    private static String LISTEN_TO_ALL_FEATURES = "*";
    private final NotifierToKeyToListenersSetMap preListeners;
    private final NotifierToKeyToListenersSetMap postListeners;
    private static final Map instanceMap = new WeakHashMap();
    static /* synthetic */ Class class$0;

    private DiagramEventBroker() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.emf.ecore.EObject");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        super(NotificationFilter.createNotifierTypeFilter((Class)clazz));
        this.preListeners = new NotifierToKeyToListenersSetMap();
        this.postListeners = new NotifierToKeyToListenersSetMap();
    }

    public static DiagramEventBroker getInstance(TransactionalEditingDomain editingDomain) {
        WeakReference reference = (WeakReference)instanceMap.get(editingDomain);
        if (reference != null) {
            return (DiagramEventBroker)((Object)reference.get());
        }
        return null;
    }

    public static void startListening(TransactionalEditingDomain editingDomain) {
        DiagramEventBroker diagramEventBroker = DiagramEventBroker.getInstance(editingDomain);
        if (diagramEventBroker == null) {
            diagramEventBroker = new DiagramEventBroker();
            editingDomain.addResourceSetListener((ResourceSetListener)diagramEventBroker);
            instanceMap.put(editingDomain, new WeakReference<DiagramEventBroker>(diagramEventBroker));
        }
    }

    public static void stopListening(TransactionalEditingDomain editingDomain) {
        DiagramEventBroker diagramEventBroker = DiagramEventBroker.getInstance(editingDomain);
        if (diagramEventBroker != null) {
            editingDomain.removeResourceSetListener((ResourceSetListener)diagramEventBroker);
            instanceMap.remove(editingDomain);
        }
    }

    public Command transactionAboutToCommit(ResourceSetChangeEvent event) {
        Set deletedObjects = NotificationUtil.getDeletedObjects(event);
        CompoundCommand cc = new CompoundCommand();
        Iterator i = event.getNotifications().iterator();
        while (i.hasNext()) {
            Command cmd;
            Object notifier;
            Notification notification = (Notification)i.next();
            Object eventFeature = notification.getFeature();
            if (notification.isTouch() && notification.getEventType() != 9 || NotationPackage.eINSTANCE.getView_Mutable().equals(eventFeature) || !((notifier = notification.getNotifier()) instanceof EObject) || deletedObjects.contains(notification.getNotifier()) || (cmd = this.handleTransactionAboutToCommitEvent(notification)) == null) continue;
            cc.append(cmd);
        }
        return cc.isEmpty() ? null : cc;
    }

    public void resourceSetChanged(ResourceSetChangeEvent event) {
        Set deletedObjects = NotificationUtil.getDeletedObjects(event);
        Iterator i = event.getNotifications().iterator();
        while (i.hasNext()) {
            Object notifier;
            Notification notification = (Notification)i.next();
            Object eventFeature = notification.getFeature();
            if (notification.isTouch() && notification.getEventType() != 9 || NotationPackage.eINSTANCE.getView_Mutable().equals(eventFeature) || !((notifier = notification.getNotifier()) instanceof EObject) || deletedObjects.contains(notification.getNotifier())) continue;
            this.handleElementEvent(notification);
        }
    }

    private void fireNotification(Notification event) {
        Set listenerList = this.getInterestedNotificationListeners(event, false);
        if (!listenerList.isEmpty()) {
            ArrayList listenersSnapShot = new ArrayList(listenerList);
            if (!listenerList.isEmpty()) {
                Iterator listenerIT = listenersSnapShot.iterator();
                while (listenerIT.hasNext()) {
                    NotificationListener listener = (NotificationListener)listenerIT.next();
                    listener.notifyChanged(event);
                }
            }
        }
    }

    private Command fireTransactionAboutToCommit(Notification event) {
        Set listenerList = this.getInterestedNotificationListeners(event, true);
        if (!listenerList.isEmpty()) {
            ArrayList listenersSnapShot = new ArrayList(listenerList);
            if (!listenerList.isEmpty()) {
                CompoundCommand cc = new CompoundCommand();
                Iterator listenerIT = listenersSnapShot.iterator();
                while (listenerIT.hasNext()) {
                    NotificationPreCommitListener listener = (NotificationPreCommitListener)listenerIT.next();
                    Command cmd = listener.transactionAboutToCommit(event);
                    if (cmd == null) continue;
                    cc.append(cmd);
                }
                return cc.isEmpty() ? null : cc;
            }
        }
        return null;
    }

    public final void addNotificationListener(EObject target, NotificationPreCommitListener listener) {
        if (target != null) {
            this.preListeners.addListener(target, LISTEN_TO_ALL_FEATURES, listener);
        }
    }

    public final void addNotificationListener(EObject target, NotificationListener listener) {
        if (target != null) {
            this.postListeners.addListener(target, LISTEN_TO_ALL_FEATURES, listener);
        }
    }

    public final void addNotificationListener(EObject target, EStructuralFeature key, NotificationPreCommitListener listener) {
        if (target != null) {
            this.preListeners.addListener(target, key, listener);
        }
    }

    public final void addNotificationListener(EObject target, EStructuralFeature key, NotificationListener listener) {
        if (target != null) {
            this.postListeners.addListener(target, key, listener);
        }
    }

    public final void removeNotificationListener(EObject target, NotificationPreCommitListener listener) {
        if (target != null) {
            this.preListeners.removeListener(target, LISTEN_TO_ALL_FEATURES, listener);
        }
    }

    public final void removeNotificationListener(EObject target, NotificationListener listener) {
        if (target != null) {
            this.postListeners.removeListener(target, LISTEN_TO_ALL_FEATURES, listener);
        }
    }

    public final void removeNotificationListener(EObject target, Object key, NotificationPreCommitListener listener) {
        if (target != null) {
            this.preListeners.removeListener(target, key, listener);
        }
    }

    public final void removeNotificationListener(EObject target, Object key, NotificationListener listener) {
        if (target != null) {
            this.postListeners.removeListener(target, key, listener);
        }
    }

    public final void finalize() {
        try {
            Iterator iter = instanceMap.keySet().iterator();
            while (iter.hasNext()) {
                TransactionalEditingDomain editingDomain = (TransactionalEditingDomain)iter.next();
                editingDomain.removeResourceSetListener((ResourceSetListener)((DiagramEventBroker)((Object)((WeakReference)instanceMap.get(editingDomain)).get())));
            }
        }
        catch (Throwable throwable) {}
    }

    private Set getNotificationListeners(Object notifier, boolean preCommit) {
        NotifierToKeyToListenersSetMap listeners = preCommit ? this.preListeners : this.postListeners;
        return listeners.getListeners(notifier, LISTEN_TO_ALL_FEATURES);
    }

    private Set getNotificationListeners(Object notifier, Object key, boolean preCommit) {
        NotifierToKeyToListenersSetMap listeners;
        NotifierToKeyToListenersSetMap notifierToKeyToListenersSetMap = listeners = preCommit ? this.preListeners : this.postListeners;
        if (key != null) {
            if (!key.equals(LISTEN_TO_ALL_FEATURES)) {
                HashSet listenersSet = new HashSet();
                Set c = listeners.getListeners(notifier, key);
                if (c != null && !c.isEmpty()) {
                    listenersSet.addAll(c);
                }
                if ((c = listeners.getListeners(notifier, LISTEN_TO_ALL_FEATURES)) != null && !c.isEmpty()) {
                    listenersSet.addAll(c);
                }
                return listenersSet;
            }
            if (key.equals(LISTEN_TO_ALL_FEATURES)) {
                return listeners.getAllListeners(notifier);
            }
        }
        return listeners.getAllListeners(notifier);
    }

    private Set getInterestedNotificationListeners(Notification event, boolean preCommit) {
        HashSet listenerSet = new HashSet();
        Set c = this.getNotificationListeners(event.getNotifier(), event.getFeature(), preCommit);
        if (c != null) {
            listenerSet.addAll(c);
        }
        EObject notifier = (EObject)event.getNotifier();
        if (NotationPackage.eINSTANCE.getView_Visible().equals(event.getFeature()) && notifier.eContainer() != null) {
            listenerSet.addAll(this.getNotificationListeners(notifier.eContainer(), preCommit));
        } else if (notifier instanceof EAnnotation) {
            this.addListenersOfNotifier(listenerSet, notifier.eContainer(), event, preCommit);
        } else if (!(notifier instanceof View)) {
            while (notifier != null && !(notifier instanceof View)) {
                notifier = notifier.eContainer();
            }
            this.addListenersOfNotifier(listenerSet, notifier, event, preCommit);
        }
        return listenerSet;
    }

    private void addListenersOfNotifier(Set listenerSet, EObject notifier, Notification event, boolean preCommit) {
        Set c;
        if (notifier != null && (c = this.getNotificationListeners(notifier, event.getFeature(), preCommit)) != null) {
            if (listenerSet.isEmpty()) {
                listenerSet.addAll(c);
            } else {
                Iterator i = c.iterator();
                while (i.hasNext()) {
                    Object o = i.next();
                    listenerSet.add(o);
                }
            }
        }
    }

    private Command handleTransactionAboutToCommitEvent(Notification event) {
        EObject element = (EObject)event.getNotifier();
        if (element != null) {
            return this.fireTransactionAboutToCommit(event);
        }
        return null;
    }

    private void handleElementEvent(Notification event) {
        EObject element;
        if (!event.isTouch()) {
            element = (EObject)event.getNotifier();
            while (element != null && !(element instanceof View)) {
                element = element.eContainer();
            }
            if (!(element == null || NotationPackage.eINSTANCE.getView_TransientChildren() != element.eContainingFeature() && NotationPackage.eINSTANCE.getDiagram_TransientEdges() != element.eContainingFeature() || NotificationFilter.READ.matches(event))) {
                ViewUtil.persistElement((View)element);
            }
        }
        if ((element = (EObject)event.getNotifier()) != null) {
            this.fireNotification(event);
        }
    }

    private final class NotifierToKeyToListenersSetMap {
        private final Map listenersMap = new WeakHashMap();

        NotifierToKeyToListenersSetMap() {
        }

        public void addListener(EObject notifier, Object key, Object listener) {
            HashSet<Object> listenersSet;
            HashMap<Object, HashSet<Object>> keys = (HashMap<Object, HashSet<Object>>)this.listenersMap.get(notifier);
            if (keys == null) {
                keys = new HashMap<Object, HashSet<Object>>();
                this.listenersMap.put(notifier, keys);
            }
            if ((listenersSet = (HashSet<Object>)keys.get(key)) == null) {
                listenersSet = new HashSet<Object>();
                keys.put(key, listenersSet);
            }
            listenersSet.add(listener);
        }

        public void addListener(EObject notifier, Object listener) {
            this.addListener(notifier, LISTEN_TO_ALL_FEATURES, listener);
        }

        public void removeListener(EObject notifier, Object key, Object listener) {
            Map keys = (Map)this.listenersMap.get(notifier);
            if (keys != null) {
                Set listenersSet = (Set)keys.get(key);
                if (listenersSet != null) {
                    listenersSet.remove(listener);
                    if (listenersSet.isEmpty()) {
                        keys.remove(key);
                    }
                }
                if (keys.isEmpty()) {
                    this.listenersMap.remove(notifier);
                }
            }
        }

        public Set getListeners(Object notifier, Object key) {
            Set listenersSet;
            Map keys = (Map)this.listenersMap.get(notifier);
            if (keys != null && (listenersSet = (Set)keys.get(key)) != null) {
                return listenersSet;
            }
            return Collections.EMPTY_SET;
        }

        public Set getAllListeners(Object notifier) {
            Map keys = (Map)this.listenersMap.get(notifier);
            if (keys == null || keys.isEmpty()) {
                return Collections.EMPTY_SET;
            }
            HashSet listenersCollection = new HashSet();
            Set enteries = keys.entrySet();
            Iterator iter = enteries.iterator();
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                Set listenersSet = (Set)entry.getValue();
                if (listenersSet == null || listenersSet.isEmpty()) continue;
                listenersCollection.addAll(listenersSet);
            }
            return listenersCollection;
        }
    }
}

