/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.diagram.ui.actions.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.draw2d.Animation;
import org.eclipse.draw2d.XYLayout;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gef.tools.ToolUtilities;
import org.eclipse.gmf.runtime.diagram.ui.actions.DiagramAction;
import org.eclipse.gmf.runtime.diagram.ui.actions.internal.l10n.DiagramUIActionsMessages;
import org.eclipse.gmf.runtime.diagram.ui.actions.internal.l10n.DiagramUIActionsPluginImages;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ShapeCompartmentEditPart;
import org.eclipse.gmf.runtime.diagram.ui.requests.ArrangeRequest;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.ui.IWorkbenchPage;

public class ArrangeAction
extends DiagramAction {
    private boolean selectionOnly;

    protected ArrangeAction(IWorkbenchPage workbenchPage, boolean selectionOnly) {
        super(workbenchPage);
        this.selectionOnly = selectionOnly;
    }

    protected Request createTargetRequest() {
        return new ArrangeRequest(this.getId());
    }

    protected void updateTargetRequest() {
        ArrangeRequest request = (ArrangeRequest)this.getTargetRequest();
        request.setPartsToArrange(this.getOperationSet());
    }

    private boolean isArrangeAll() {
        return !this.selectionOnly;
    }

    protected Command getCommand() {
        EditPart parent;
        if (this.isArrangeAll()) {
            CompoundCommand arrangeCC = new CompoundCommand(this.getLabel());
            List elements = this.getOperationSet();
            Iterator iter = elements.iterator();
            while (iter.hasNext()) {
                EditPart element = (EditPart)iter.next();
                arrangeCC.add(element.getCommand(this.getTargetRequest()));
            }
            return arrangeCC;
        }
        if (this.getOperationSet().size() >= 2 && (parent = this.getSelectionParent(this.getOperationSet())) != null) {
            return parent.getCommand(this.getTargetRequest());
        }
        return UnexecutableCommand.INSTANCE;
    }

    protected boolean calculateEnabled() {
        GraphicalEditPart parent;
        EditPart parentEP;
        if (this.isArrangeAll() && !this.getOperationSet().isEmpty()) {
            return true;
        }
        return this.getOperationSet().size() >= 2 && (parentEP = this.getSelectionParent(this.getOperationSet())) instanceof GraphicalEditPart && (parent = (GraphicalEditPart)parentEP) != null && parent.getContentPane().getLayoutManager() instanceof XYLayout;
    }

    protected List createOperationSet() {
        List selection = this.getSelectedObjects();
        if (this.isArrangeAll()) {
            if (!selection.isEmpty()) {
                return this.getElementsToArrange(selection);
            }
            if (this.getDiagramEditPart() != null) {
                return this.createOperationSet(this.getDiagramEditPart().getChildren());
            }
            return Collections.EMPTY_LIST;
        }
        if (selection.isEmpty() || !(selection.get(0) instanceof IGraphicalEditPart)) {
            return Collections.EMPTY_LIST;
        }
        selection = ToolUtilities.getSelectionWithoutDependants((List)selection);
        return this.createOperationSet(selection);
    }

    private EditPart getSelectionParent(List editparts) {
        ListIterator li = editparts.listIterator();
        while (li.hasNext()) {
            Object obj = li.next();
            if (obj instanceof ConnectionEditPart || !(obj instanceof EditPart)) continue;
            return ((EditPart)obj).getParent();
        }
        return null;
    }

    private List createOperationSet(List editparts) {
        if (editparts == null || editparts.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        EditPart parent = this.getSelectionParent(editparts);
        if (parent == null) {
            return Collections.EMPTY_LIST;
        }
        int i = 1;
        while (i < editparts.size()) {
            EditPart part = (EditPart)editparts.get(i);
            if (!(part instanceof ConnectionEditPart) && part.getParent() != parent) {
                return Collections.EMPTY_LIST;
            }
            ++i;
        }
        return editparts;
    }

    protected boolean isSelectionListener() {
        return true;
    }

    public static ArrangeAction createArrangeAllAction(IWorkbenchPage workbenchPage) {
        ArrangeAction action = new ArrangeAction(workbenchPage, false);
        action.setId("arrangeAllAction");
        action.setText(DiagramUIActionsMessages.ArrangeAction_ArrangeAll_ActionLabelText);
        action.setToolTipText(DiagramUIActionsMessages.ArrangeAction_ArrangeAll_ActionToolTipText);
        action.setImageDescriptor(DiagramUIActionsPluginImages.DESC_ARRANGE_ALL);
        action.setDisabledImageDescriptor(DiagramUIActionsPluginImages.DESC_ARRANGE_ALL_DISABLED);
        action.setHoverImageDescriptor(DiagramUIActionsPluginImages.DESC_ARRANGE_ALL);
        return action;
    }

    public static ArrangeAction createToolbarArrangeAllAction(IWorkbenchPage workbenchPage) {
        ArrangeAction action = new ArrangeAction(workbenchPage, false);
        action.setId("toolbarArrangeAllAction");
        action.setText(DiagramUIActionsMessages.ArrangeAction_toolbar_ArrangeAll_ActionLabelText);
        action.setToolTipText(DiagramUIActionsMessages.ArrangeAction_toolbar_ArrangeAll_ActionToolTipText);
        action.setImageDescriptor(DiagramUIActionsPluginImages.DESC_ARRANGE_ALL);
        action.setDisabledImageDescriptor(DiagramUIActionsPluginImages.DESC_ARRANGE_ALL_DISABLED);
        action.setHoverImageDescriptor(DiagramUIActionsPluginImages.DESC_ARRANGE_ALL);
        return action;
    }

    public static ArrangeAction createArrangeSelectionAction(IWorkbenchPage workbenchPage) {
        ArrangeAction action = new ArrangeAction(workbenchPage, true);
        action.setId("arrangeSelectionAction");
        action.setText(DiagramUIActionsMessages.ArrangeAction_ArrangeSelection_ActionLabelText);
        action.setToolTipText(DiagramUIActionsMessages.ArrangeAction_ArrangeSelection_ActionToolTipText);
        action.setImageDescriptor(DiagramUIActionsPluginImages.DESC_ARRANGE_SELECTED);
        action.setDisabledImageDescriptor(DiagramUIActionsPluginImages.DESC_ARRANGE_SELECTED_DISABLED);
        action.setHoverImageDescriptor(DiagramUIActionsPluginImages.DESC_ARRANGE_SELECTED);
        return action;
    }

    public static ArrangeAction createToolbarArrangeSelectionAction(IWorkbenchPage workbenchPage) {
        ArrangeAction action = new ArrangeAction(workbenchPage, true);
        action.setId("toolbarArrangeSelectionAction");
        action.setText(DiagramUIActionsMessages.ArrangeAction_toolbar_ArrangeSelection_ActionLabelText);
        action.setToolTipText(DiagramUIActionsMessages.ArrangeAction_toolbar_ArrangeSelection_ActionToolTipText);
        action.setImageDescriptor(DiagramUIActionsPluginImages.DESC_ARRANGE_SELECTED);
        action.setDisabledImageDescriptor(DiagramUIActionsPluginImages.DESC_ARRANGE_SELECTED_DISABLED);
        action.setHoverImageDescriptor(DiagramUIActionsPluginImages.DESC_ARRANGE_SELECTED);
        return action;
    }

    protected void doRun(IProgressMonitor progressMonitor) {
        IPreferenceStore preferenceStore = (IPreferenceStore)this.getDiagramEditPart().getDiagramPreferencesHint().getPreferenceStore();
        boolean animatedLayout = preferenceStore.getBoolean("Global.enableAnimatedLayout");
        if (animatedLayout) {
            Animation.markBegin();
        }
        super.doRun(progressMonitor);
        if (animatedLayout) {
            int durationInc = 800;
            int factor = 10;
            int size = 0;
            List operationSet = this.getOperationSet();
            if (this.isArrangeAll()) {
                Iterator iter = operationSet.iterator();
                while (iter.hasNext()) {
                    IGraphicalEditPart element = (IGraphicalEditPart)iter.next();
                    size += element.getFigure().getChildren().size();
                }
            } else if (operationSet != null && !operationSet.isEmpty()) {
                IGraphicalEditPart container = (IGraphicalEditPart)this.getSelectionParent(operationSet);
                size += container.getFigure().getChildren().size();
            }
            int totalDuration = Math.min(durationInc * factor / 2, Math.max(durationInc, size / factor * durationInc));
            Animation.run((int)totalDuration);
        }
    }

    private List getElementsToArrange(List selection) {
        HashSet parentsSet = new HashSet();
        Iterator iter = selection.iterator();
        while (iter.hasNext()) {
            EditPart gEditPart;
            EditPart parentEditPart;
            Object element = iter.next();
            if (element instanceof ShapeCompartmentEditPart || element instanceof DiagramEditPart) {
                parentsSet.add(element);
                continue;
            }
            if (!(element instanceof EditPart) || !((parentEditPart = (gEditPart = (EditPart)element).getParent()) instanceof ShapeCompartmentEditPart) && !(parentEditPart instanceof DiagramEditPart) || parentsSet.contains(parentEditPart)) continue;
            parentsSet.add(parentEditPart);
        }
        if (parentsSet.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        ArrayList elements = new ArrayList();
        elements.addAll(parentsSet);
        return elements;
    }
}

