/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.diagram.ui.actions.internal;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gmf.runtime.diagram.ui.actions.internal.PropertyChangeAction;
import org.eclipse.gmf.runtime.diagram.ui.actions.internal.l10n.DiagramUIActionsMessages;
import org.eclipse.gmf.runtime.diagram.ui.actions.internal.l10n.DiagramUIActionsPluginImages;
import org.eclipse.gmf.runtime.diagram.ui.internal.properties.Properties;
import org.eclipse.gmf.runtime.diagram.ui.requests.ChangePropertyValueRequest;
import org.eclipse.gmf.runtime.draw2d.ui.figures.FigureUtilities;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.FontDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;

public class FontDialogAction
extends PropertyChangeAction {
    public FontDialogAction(IWorkbenchPage workbenchPage) {
        super(workbenchPage, Properties.ID_FONTCOLOR, DiagramUIActionsMessages.PropertyDescriptorFactory_Font);
        this.setId("fontDialogAction");
        this.setText(DiagramUIActionsMessages.FontAction_text);
        this.setToolTipText(DiagramUIActionsMessages.FontAction_tooltip);
        this.setImageDescriptor(DiagramUIActionsPluginImages.DESC_FONT_COLOR);
    }

    protected Object getNewPropertyValue() {
        return null;
    }

    protected void doRun(IProgressMonitor progressMonitor) {
        String name = (String)this.getOperationSetPropertyValue(Properties.ID_FONTNAME);
        Integer height = (Integer)this.getOperationSetPropertyValue(Properties.ID_FONTSIZE);
        Boolean bold = (Boolean)this.getOperationSetPropertyValue(Properties.ID_FONTBOLD);
        Boolean italic = (Boolean)this.getOperationSetPropertyValue(Properties.ID_FONTITALIC);
        int style = (bold != false ? 1 : 0) | (italic != false ? 2 : 0);
        FontData initFontData = new FontData(name, height.intValue(), style);
        Integer color = (Integer)this.getOperationSetPropertyValue(Properties.ID_FONTCOLOR);
        RGB initFontColor = FigureUtilities.integerToRGB((Integer)color);
        Shell shell = this.getDiagramGraphicalViewer().getControl().getShell();
        FontDialog fontDialog = new FontDialog(shell);
        fontDialog.setFontList(new FontData[]{initFontData});
        fontDialog.setRGB(initFontColor);
        FontData fData = fontDialog.open();
        RGB fColor = fontDialog.getRGB();
        if (fData != null && fColor != null) {
            CompoundCommand cc = new CompoundCommand(DiagramUIActionsMessages.PropertyDescriptorFactory_Font);
            cc.add(this.getCommand((Request)new ChangePropertyValueRequest(Properties.ID_FONTNAME, Properties.ID_FONTNAME, (Object)fData.getName())));
            cc.add(this.getCommand((Request)new ChangePropertyValueRequest(Properties.ID_FONTSIZE, Properties.ID_FONTSIZE, (Object)new Integer(fData.getHeight()))));
            cc.add(this.getCommand((Request)new ChangePropertyValueRequest(Properties.ID_FONTBOLD, Properties.ID_FONTBOLD, (Object)((fData.getStyle() & 1) != 0 ? 1 : 0))));
            cc.add(this.getCommand((Request)new ChangePropertyValueRequest(Properties.ID_FONTITALIC, Properties.ID_FONTITALIC, (Object)((fData.getStyle() & 2) != 0 ? 1 : 0))));
            cc.add(this.getCommand((Request)new ChangePropertyValueRequest(Properties.ID_FONTCOLOR, Properties.ID_FONTCOLOR, (Object)FigureUtilities.RGBToInteger((RGB)fColor))));
            this.execute((Command)cc, progressMonitor);
        }
    }
}

