/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.diagram.ui.actions.internal;

import java.util.List;
import java.util.ListIterator;
import org.eclipse.gmf.runtime.diagram.ui.actions.CheckedPropertyAction;
import org.eclipse.gmf.runtime.diagram.ui.actions.internal.l10n.DiagramUIActionsMessages;
import org.eclipse.gmf.runtime.diagram.ui.actions.internal.l10n.DiagramUIActionsPluginImages;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ITreeBranchEditPart;
import org.eclipse.gmf.runtime.diagram.ui.internal.l10n.DiagramUIPluginImages;
import org.eclipse.gmf.runtime.diagram.ui.internal.properties.Properties;
import org.eclipse.gmf.runtime.notation.Routing;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IWorkbenchPage;

public class RouterAction
extends CheckedPropertyAction {
    protected RouterAction(IWorkbenchPage workbenchPage, Routing routerType) {
        super(workbenchPage, Properties.ID_ROUTING, DiagramUIActionsMessages.ChangeRouterAction_ChangePropertyValueRequest_label, routerType);
    }

    public static RouterAction createRectilinearRouterAction(IWorkbenchPage workbenchPage) {
        RouterAction action = new RouterAction(workbenchPage, Routing.RECTILINEAR_LITERAL);
        action.setId("rectilinearRouterAction");
        action.setText(DiagramUIActionsMessages.ChangeRouterAction_Rectilinear_ActionLabelText);
        action.setToolTipText(DiagramUIActionsMessages.ChangeRouterAction_Rectilinear_ActionToolTipText);
        action.setImageDescriptor(DiagramUIActionsPluginImages.DESC_CHANGEROUTERACTION_RECTILINEAR);
        action.setDisabledImageDescriptor(DiagramUIActionsPluginImages.DESC_CHANGEROUTERACTION_RECTILINEAR_DISABLED);
        action.setHoverImageDescriptor(DiagramUIActionsPluginImages.DESC_CHANGEROUTERACTION_RECTILINEAR);
        return action;
    }

    public static RouterAction createObliqueRouterAction(IWorkbenchPage workbenchPage) {
        RouterAction action = new RouterAction(workbenchPage, Routing.MANUAL_LITERAL);
        action.setId("obliqueRouterAction");
        action.setText(DiagramUIActionsMessages.ChangeRouterAction_Oblique_ActionLabelText);
        action.setToolTipText(DiagramUIActionsMessages.ChangeRouterAction_Oblique_ActionToolTipText);
        ImageDescriptor enabledImage = DiagramUIPluginImages.DESC_CHANGEROUTERACTION_OBLIQUE;
        action.setImageDescriptor(enabledImage);
        action.setDisabledImageDescriptor(DiagramUIPluginImages.DESC_CHANGEROUTERACTION_OBLIQUE_DISABLED);
        action.setHoverImageDescriptor(enabledImage);
        return action;
    }

    public static RouterAction createTreeRouterAction(IWorkbenchPage workbenchPage) {
        RouterAction action = new RouterAction(workbenchPage, Routing.TREE_LITERAL);
        action.setId("treeRouterAction");
        action.setText(DiagramUIActionsMessages.ChangeRouterAction_Tree_ActionLabelText);
        action.setToolTipText(DiagramUIActionsMessages.ChangeRouterAction_Tree_ActionToolTipText);
        ImageDescriptor enabledImage = DiagramUIPluginImages.DESC_CHANGEROUTERACTION_TREE;
        action.setImageDescriptor(enabledImage);
        action.setDisabledImageDescriptor(DiagramUIPluginImages.DESC_CHANGEROUTERACTION_TREE_DISABLED);
        action.setHoverImageDescriptor(enabledImage);
        return action;
    }

    protected boolean calculateEnabled() {
        if (this.getId() == "treeRouterAction") {
            List selected = this.getSelectedObjects();
            if (selected.size() < 2) {
                return false;
            }
            ListIterator li = selected.listIterator();
            while (li.hasNext()) {
                if (li.next() instanceof ITreeBranchEditPart) continue;
                return false;
            }
        }
        return super.calculateEnabled();
    }
}

