/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.diagram.ui.actions.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.Request;
import org.eclipse.gmf.runtime.diagram.ui.actions.DiagramAction;
import org.eclipse.gmf.runtime.diagram.ui.actions.internal.l10n.DiagramUIActionsMessages;
import org.eclipse.gmf.runtime.diagram.ui.actions.internal.l10n.DiagramUIActionsPluginImages;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IBorderItemEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IPrimaryEditPart;
import org.eclipse.gmf.runtime.diagram.ui.internal.editparts.ISurfaceEditPart;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.actions.ActionFactory;

public class SelectAllAction
extends DiagramAction {
    private boolean selectShapes;
    private boolean selectConnections;

    private SelectAllAction(IWorkbenchPage partService, boolean selectShapes, boolean selectConnections) {
        super(partService);
        this.selectShapes = selectShapes;
        this.selectConnections = selectConnections;
    }

    protected Request createTargetRequest() {
        return null;
    }

    protected List createOperationSet() {
        List selection = this.getSelectedObjects();
        if (selection.isEmpty() || !(selection.get(0) instanceof IGraphicalEditPart)) {
            return Collections.EMPTY_LIST;
        }
        ArrayList selectables = new ArrayList();
        EditPart primaryEP = (EditPart)selection.get(selection.size() - 1);
        ArrayList nodeEditParts = new ArrayList();
        nodeEditParts.addAll(this.getSelectableNodes(primaryEP));
        if (this.selectShapes) {
            selectables.addAll(nodeEditParts);
        }
        if (this.selectConnections) {
            selectables.addAll(this.addSelectableConnections(nodeEditParts));
        }
        return this.filterEditPartsMatching(selectables, this.getSelectionConditional());
    }

    protected List getSelectableNodes(EditPart editpart) {
        if (editpart == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList retval = new ArrayList();
        this.getSelectableNodesInside(editpart, true, retval);
        return retval;
    }

    private void getSelectableNodesInside(EditPart editpart, boolean topLevel, List retval) {
        if (editpart instanceof ISurfaceEditPart) {
            this.getSelectableChildrenNodes(editpart, retval);
        } else if (editpart instanceof IPrimaryEditPart) {
            if (topLevel) {
                if (editpart instanceof ConnectionEditPart) {
                    ConnectionEditPart connection = (ConnectionEditPart)editpart;
                    EditPart source = connection.getSource();
                    EditPart target = connection.getTarget();
                    if (source != null && target != null) {
                        this.getSelectableNodesInside(source, true, retval);
                        if (target.getParent() != source.getParent()) {
                            this.getSelectableNodesInside(target, true, retval);
                        }
                    }
                } else {
                    this.getSelectableNodesInside(editpart.getParent(), true, retval);
                }
            } else {
                if (editpart.isSelectable()) {
                    retval.add(editpart);
                }
                this.getSelectableChildrenNodes(editpart, retval);
            }
        }
    }

    private void getSelectableChildrenNodes(EditPart editpart, List retval) {
        Iterator iter = editpart.getChildren().iterator();
        while (iter.hasNext()) {
            EditPart child = (EditPart)iter.next();
            this.getSelectableNodesInside(child, false, retval);
        }
    }

    private void getBorderItemEditParts(EditPart parent, Set retval) {
        Iterator iter = parent.getChildren().iterator();
        while (iter.hasNext()) {
            EditPart child = (EditPart)iter.next();
            if (child instanceof IBorderItemEditPart) {
                retval.add(child);
                retval.addAll(child.getChildren());
            }
            this.getBorderItemEditParts(child, retval);
        }
    }

    protected List addSelectableConnections(List editparts) {
        ArrayList<ConnectionEditPart> selectableConnections = new ArrayList<ConnectionEditPart>();
        DiagramEditPart diagramEditPart = this.getDiagramEditPart();
        HashSet connnectableEditParts = new HashSet(editparts);
        ListIterator li = editparts.listIterator();
        while (li.hasNext()) {
            this.getBorderItemEditParts((EditPart)li.next(), connnectableEditParts);
        }
        if (diagramEditPart != null) {
            Iterator connections = diagramEditPart.getConnections().iterator();
            while (connections.hasNext()) {
                ConnectionEditPart connection = (ConnectionEditPart)connections.next();
                if (!connnectableEditParts.contains(connection.getSource()) && !connnectableEditParts.contains(connection.getTarget())) continue;
                selectableConnections.add(connection);
            }
        }
        return selectableConnections;
    }

    protected EditPartViewer.Conditional getSelectionConditional() {
        return new EditPartViewer.Conditional(){

            public boolean evaluate(EditPart editpart) {
                return editpart.isSelectable();
            }
        };
    }

    protected boolean calculateEnabled() {
        return !this.getOperationSet().isEmpty();
    }

    protected void doRun(IProgressMonitor progressMonitor) {
        this.getDiagramGraphicalViewer().setSelection((ISelection)new StructuredSelection(this.getOperationSet()));
    }

    protected boolean isSelectionListener() {
        return true;
    }

    public static SelectAllAction createSelectAllAction(IWorkbenchPage partService) {
        SelectAllAction action = new SelectAllAction(partService, true, true);
        action.setId(ActionFactory.SELECT_ALL.getId());
        action.setText(DiagramUIActionsMessages.SelectAllAction_SelectAll);
        action.setToolTipText(DiagramUIActionsMessages.SelectAllAction_SelectAll);
        action.setImageDescriptor(DiagramUIActionsPluginImages.DESC_SELECTALL);
        action.setDisabledImageDescriptor(DiagramUIActionsPluginImages.DESC_SELECTALL_DISABLED);
        return action;
    }

    public static SelectAllAction createToolbarSelectAllAction(IWorkbenchPage partService) {
        SelectAllAction action = new SelectAllAction(partService, true, true);
        action.setId("toolbarSelectAllAction");
        action.setText(DiagramUIActionsMessages.SelectAllAction_toolbar_SelectAll);
        action.setToolTipText(DiagramUIActionsMessages.SelectAllAction_toolbar_SelectAll);
        action.setImageDescriptor(DiagramUIActionsPluginImages.DESC_SELECTALL);
        action.setDisabledImageDescriptor(DiagramUIActionsPluginImages.DESC_SELECTALL_DISABLED);
        return action;
    }

    public static SelectAllAction createSelectAllShapesAction(IWorkbenchPage partService) {
        SelectAllAction action = new SelectAllAction(partService, true, false);
        action.setId("selectAllShapesAction");
        action.setText(DiagramUIActionsMessages.SelectAllAction_SelectShapes);
        action.setToolTipText(DiagramUIActionsMessages.SelectAllAction_SelectShapes);
        action.setImageDescriptor(DiagramUIActionsPluginImages.DESC_SELECTSHAPES);
        action.setDisabledImageDescriptor(DiagramUIActionsPluginImages.DESC_SELECTSHAPES_DISABLED);
        return action;
    }

    public static SelectAllAction createToolbarSelectAllShapesAction(IWorkbenchPage partService) {
        SelectAllAction action = new SelectAllAction(partService, true, false);
        action.setId("toolbarSelectAllShapesAction");
        action.setText(DiagramUIActionsMessages.SelectAllAction_toolbar_SelectShapes);
        action.setToolTipText(DiagramUIActionsMessages.SelectAllAction_toolbar_SelectShapes);
        action.setImageDescriptor(DiagramUIActionsPluginImages.DESC_SELECTSHAPES);
        action.setDisabledImageDescriptor(DiagramUIActionsPluginImages.DESC_SELECTSHAPES_DISABLED);
        return action;
    }

    public static SelectAllAction createSelectAllConnectionsAction(IWorkbenchPage partService) {
        SelectAllAction action = new SelectAllAction(partService, false, true);
        action.setId("selectAllConnectorsAction");
        action.setText(DiagramUIActionsMessages.SelectAllAction_SelectConnections);
        action.setToolTipText(DiagramUIActionsMessages.SelectAllAction_SelectConnections);
        action.setImageDescriptor(DiagramUIActionsPluginImages.DESC_SELECTCONNECTIONS);
        action.setDisabledImageDescriptor(DiagramUIActionsPluginImages.DESC_SELECTCONNECTIONS_DISABLED);
        return action;
    }

    public static SelectAllAction createToolbarSelectAllConnectionsAction(IWorkbenchPage partService) {
        SelectAllAction action = new SelectAllAction(partService, false, true);
        action.setId("toolbarSelectAllConnectorsAction");
        action.setText(DiagramUIActionsMessages.SelectAllAction_toolbar_SelectConnections);
        action.setToolTipText(DiagramUIActionsMessages.SelectAllAction_toolbar_SelectConnections);
        action.setImageDescriptor(DiagramUIActionsPluginImages.DESC_SELECTCONNECTIONS);
        action.setDisabledImageDescriptor(DiagramUIActionsPluginImages.DESC_SELECTCONNECTIONS_DISABLED);
        return action;
    }
}

