/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.diagram.ui.printing.internal.util;

import java.util.Collection;
import java.util.Iterator;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.SWTGraphics;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gmf.runtime.diagram.core.preferences.PreferencesHint;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.diagram.ui.internal.pagesetup.PageInfoHelper;
import org.eclipse.gmf.runtime.diagram.ui.parts.DiagramGraphicalViewer;
import org.eclipse.gmf.runtime.diagram.ui.printing.internal.util.HeaderAndFooterHelper;
import org.eclipse.gmf.runtime.diagram.ui.printing.internal.util.PrintHelper;
import org.eclipse.gmf.runtime.draw2d.ui.internal.graphics.MapModeGraphics;
import org.eclipse.gmf.runtime.draw2d.ui.internal.graphics.PrinterGraphics;
import org.eclipse.gmf.runtime.draw2d.ui.mapmode.IMapMode;
import org.eclipse.gmf.runtime.draw2d.ui.mapmode.MapModeUtil;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.Assert;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.printing.Printer;
import org.eclipse.swt.widgets.Display;

public class DiagramPrinter
implements Runnable {
    protected Printer printer;
    private org.eclipse.swt.graphics.Point display_dpi;
    private boolean isScaledPercent = false;
    private int rows = 1;
    private int columns = 1;
    private GC gc;
    protected Graphics graphics;
    protected org.eclipse.swt.graphics.Point printerOffset;
    protected Rectangle logicalClientArea;
    private float userScale;
    protected Collection diagrams;
    private org.eclipse.swt.graphics.Point translated = null;
    private PreferencesHint preferencesHint;
    private IMapMode mm;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.gmf.runtime.diagram.ui.printing.internal.util.DiagramPrinter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    public DiagramPrinter(PreferencesHint preferencesHint, IMapMode mm) {
        this.preferencesHint = preferencesHint;
        this.mm = mm;
    }

    public DiagramPrinter(PreferencesHint preferencesHint) {
        this(preferencesHint, MapModeUtil.getMapMode());
    }

    protected IMapMode getMapMode() {
        return this.mm;
    }

    public void setColumns(int columns) {
        this.columns = columns;
    }

    public void setDiagrams(Collection diagrams) {
        this.diagrams = diagrams;
    }

    public void setDisplayDPI(org.eclipse.swt.graphics.Point display_dpi) {
        this.display_dpi = new org.eclipse.swt.graphics.Point(display_dpi.x, display_dpi.y);
    }

    public void setPrinter(Printer printer) {
        this.printer = printer;
    }

    public void setRows(int rows) {
        this.rows = rows;
    }

    public void setScaledPercent(int scalePercent) {
        this.isScaledPercent = true;
        this.userScale = (float)scalePercent / 100.0f;
    }

    public void run() {
        if (!$assertionsDisabled && this.printer == null) {
            throw new AssertionError((Object)"printer must be set");
        }
        if (!this.printer.startJob("Printing")) {
            return;
        }
        this.initialize();
        if (!$assertionsDisabled && this.diagrams == null) {
            throw new AssertionError();
        }
        Iterator it = this.diagrams.iterator();
        while (it.hasNext()) {
            Object obj = it.next();
            Assert.isTrue((boolean)(obj instanceof Diagram));
            DiagramEditPart dgrmEP = PrintHelper.createDiagramEditPart((Diagram)obj, this.preferencesHint);
            boolean loadedPreferences = PrintHelper.initializePreferences(dgrmEP, this.preferencesHint);
            if (!$assertionsDisabled && !(dgrmEP.getViewer() instanceof DiagramGraphicalViewer)) {
                throw new AssertionError();
            }
            IPreferenceStore fPreferences = ((DiagramGraphicalViewer)dgrmEP.getViewer()).getWorkspaceViewerPreferenceStore();
            this.doPrintDiagram(dgrmEP, loadedPreferences, fPreferences);
        }
        this.printer.endJob();
        this.dispose();
    }

    private void doPrintDiagram(DiagramEditPart dgrmEP, boolean loadedPreferences, IPreferenceStore fPreferences) {
        this.graphics.pushState();
        if (this.isScaledPercent) {
            this.printToScale(dgrmEP, loadedPreferences, fPreferences);
        } else {
            this.printToPages(dgrmEP, loadedPreferences, fPreferences);
        }
        this.graphics.popState();
    }

    private void initialize() {
        if (!$assertionsDisabled && this.printer == null) {
            throw new AssertionError((Object)"printer must be set");
        }
        this.gc = new GC((Drawable)this.printer);
        this.gc.setXORMode(false);
        SWTGraphics g = new SWTGraphics(this.gc);
        this.graphics = this.createMapModeGraphics((Graphics)g);
        this.graphics.scale((double)this.computePrinterDisplayScale());
        this.logicalClientArea = this.graphics.getClip(new Rectangle(this.printer.getClientArea()));
    }

    protected org.eclipse.swt.graphics.Point getPrinterOffset() {
        if (this.printerOffset == null) {
            int offsetX = this.printer.getBounds().width - this.printer.getClientArea().width;
            int offsetY = this.printer.getBounds().height - this.printer.getClientArea().height;
            offsetX = (int)((float)this.getMapMode().DPtoLP((int)((float)offsetX / 2.0f * (float)this.display_dpi.x / (float)this.printer.getDPI().x)) / this.userScale);
            offsetY = (int)((float)this.getMapMode().DPtoLP((int)((float)offsetY / 2.0f * (float)this.display_dpi.y / (float)this.printer.getDPI().y)) / this.userScale);
            this.printerOffset = new org.eclipse.swt.graphics.Point(offsetX, offsetY);
        }
        return this.printerOffset;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void printToScale(DiagramEditPart dgrmEP, boolean loadedPreferences, IPreferenceStore fPreferences) {
        if (!$assertionsDisabled && this.printer == null) {
            throw new AssertionError((Object)"printer must be set");
        }
        Rectangle figureBounds = PrintHelper.getPageBreakBounds(dgrmEP, loadedPreferences);
        this.translated = new org.eclipse.swt.graphics.Point(-figureBounds.x, -figureBounds.y);
        this.graphics.translate(this.translated.x, this.translated.y);
        this.graphics.scale((double)this.userScale);
        Point pageSize = PageInfoHelper.getPageSize((IPreferenceStore)fPreferences, (boolean)false, (IMapMode)this.getMapMode());
        float fNumRows = (float)figureBounds.height * this.userScale / (float)pageSize.y;
        int numRows = (int)Math.ceil(fNumRows);
        float fNumCols = (float)figureBounds.width * this.userScale / (float)pageSize.x;
        int numCols = (int)Math.ceil(fNumCols);
        PageInfoHelper.PageMargins margins = PageInfoHelper.getPageMargins((IPreferenceStore)fPreferences, (IMapMode)this.getMapMode());
        this.adjustMargins(margins, this.userScale, this.getPrinterOffset());
        GC gc_ = new GC((Drawable)Display.getDefault());
        FontData fontData = JFaceResources.getDefaultFont().getFontData()[0];
        Font font = new Font((Device)this.printer, fontData);
        try {
            int row = 1;
            block3: while (row <= numRows) {
                int col = 1;
                while (true) {
                    if (col > numCols) {
                        ++row;
                        continue block3;
                    }
                    this.printer.startPage();
                    this.drawPage(gc_, dgrmEP, fPreferences, figureBounds, margins, font, row, col);
                    this.printer.endPage();
                    ++col;
                }
            }
        }
        catch (Throwable throwable) {
            Object var16_17 = null;
            font.dispose();
            gc_.dispose();
            throw throwable;
        }
        {
            Object var16_18 = null;
        }
        font.dispose();
        gc_.dispose();
    }

    protected void drawHeaderAndFooter(GC gc_, DiagramEditPart dgrmEP, Rectangle figureBounds, Font font, int rowIndex, int colIndex) {
        int width = this.logicalClientArea.width;
        int height = this.logicalClientArea.height;
        this.graphics.pushState();
        this.graphics.setFont(font);
        this.graphics.scale((double)(1.0f / this.userScale));
        this.graphics.translate(-this.translated.x, -this.translated.y);
        String headerOrFooter = HeaderAndFooterHelper.makeHeaderOrFooterString("header", rowIndex, colIndex, dgrmEP);
        this.graphics.drawText(headerOrFooter, this.getMapMode().DPtoLP(5) + (width - this.getMapMode().DPtoLP(gc_.textExtent((String)headerOrFooter).x)) / 2, this.getMapMode().DPtoLP(5));
        headerOrFooter = HeaderAndFooterHelper.makeHeaderOrFooterString("footer", rowIndex, colIndex, dgrmEP);
        this.graphics.drawText(headerOrFooter, this.getMapMode().DPtoLP(5) + (width - this.getMapMode().DPtoLP(gc_.textExtent((String)headerOrFooter).x)) / 2, height - this.getMapMode().DPtoLP(20));
        this.graphics.popState();
    }

    protected void drawPage(GC gc_, DiagramEditPart dgrmEP, IPreferenceStore fPreferences, Rectangle figureBounds, PageInfoHelper.PageMargins margins, Font font, int rowIndex, int colIndex) {
        Point pageSize = PageInfoHelper.getPageSize((IPreferenceStore)fPreferences, (boolean)false, (IMapMode)this.getMapMode());
        int width = pageSize.x;
        int height = pageSize.y;
        int translateX = -(width * (colIndex - 1));
        int translateY = -(height * (rowIndex - 1));
        int scaledTranslateX = (int)((float)translateX / this.userScale);
        int scaledTranslateY = (int)((float)translateY / this.userScale);
        int scaledWidth = (int)((float)width / this.userScale);
        int scaledHeight = (int)((float)height / this.userScale);
        this.drawHeaderAndFooter(gc_, dgrmEP, figureBounds, font, rowIndex, colIndex);
        this.graphics.pushState();
        this.graphics.translate(scaledTranslateX += margins.left * colIndex + margins.right * (colIndex - 1), scaledTranslateY += margins.top * rowIndex + margins.bottom * (rowIndex - 1));
        Rectangle r = new Rectangle((scaledWidth - margins.left - margins.right) * (colIndex - 1) + figureBounds.x, (scaledHeight - margins.top - margins.bottom) * (rowIndex - 1) + figureBounds.y, scaledWidth - margins.left - margins.right, scaledHeight - margins.top - margins.bottom);
        this.graphics.clipRect(r);
        dgrmEP.getLayer((Object)"Printable Layers").paint(this.graphics);
        this.graphics.popState();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void printToPages(DiagramEditPart dgrmEP, boolean loadedPreferences, IPreferenceStore fPreferences) {
        if (!$assertionsDisabled && this.printer == null) {
            throw new AssertionError((Object)"printer must be set");
        }
        Rectangle figureBounds = PrintHelper.getPageBreakBounds(dgrmEP, loadedPreferences);
        Point pageBounds = PageInfoHelper.getPageSize((IPreferenceStore)fPreferences, (IMapMode)this.getMapMode());
        Rectangle translate = new Rectangle(Math.min(0, figureBounds.x), Math.min(0, figureBounds.y), Math.max(pageBounds.x, figureBounds.width), Math.max(pageBounds.y, figureBounds.height));
        Point pageSize = PageInfoHelper.getPageSize((IPreferenceStore)fPreferences, (boolean)true, (IMapMode)this.getMapMode());
        int offsetX = this.printer.getBounds().width - this.printer.getClientArea().width;
        int offsetY = this.printer.getBounds().height - this.printer.getClientArea().height;
        pageSize.x -= offsetX * this.columns;
        pageSize.y -= offsetY * this.rows;
        float vScale = (float)(this.rows * pageSize.y) / (float)translate.height;
        float hScale = (float)(this.columns * pageSize.x) / (float)translate.width;
        this.userScale = Math.min(hScale, vScale);
        this.translated = new org.eclipse.swt.graphics.Point((int)((float)(-translate.x) * this.userScale), (int)((float)(-translate.y) * this.userScale));
        this.graphics.translate(this.translated.x, this.translated.y);
        this.graphics.scale((double)this.userScale);
        PageInfoHelper.PageMargins margins = PageInfoHelper.getPageMargins((IPreferenceStore)fPreferences, (IMapMode)this.getMapMode());
        this.adjustMargins(margins, this.userScale, this.getPrinterOffset());
        GC gc_ = new GC((Drawable)Display.getDefault());
        FontData fontData = JFaceResources.getDefaultFont().getFontData()[0];
        Font font = new Font((Device)this.printer, fontData);
        try {
            int row = 1;
            block3: while (row <= this.rows) {
                int col = 1;
                while (true) {
                    if (col > this.columns) {
                        ++row;
                        continue block3;
                    }
                    this.printer.startPage();
                    this.drawPage(gc_, dgrmEP, fPreferences, translate, margins, font, row, col);
                    this.printer.endPage();
                    ++col;
                }
            }
        }
        catch (Throwable throwable) {
            Object var18_19 = null;
            font.dispose();
            gc_.dispose();
            throw throwable;
        }
        {
            Object var18_20 = null;
        }
        font.dispose();
        gc_.dispose();
    }

    private float computePrinterDisplayScale() {
        if (!$assertionsDisabled && this.printer == null) {
            throw new AssertionError((Object)"printer must be set");
        }
        if (!$assertionsDisabled && this.display_dpi == null) {
            throw new AssertionError((Object)"display_dpi must be set");
        }
        org.eclipse.swt.graphics.Point dpi = this.printer.getDPI();
        float scale = (float)dpi.x / (float)this.display_dpi.x;
        return scale;
    }

    private void dispose() {
        if (this.gc != null) {
            this.gc.dispose();
            this.gc = null;
        }
    }

    protected MapModeGraphics createMapModeGraphics(Graphics theGraphics) {
        return new MapModeGraphics((Graphics)new PrinterGraphics(theGraphics, this.printer, true), this.getMapMode());
    }

    protected PreferencesHint getPreferencesHint() {
        return this.preferencesHint;
    }

    protected void adjustMargins(PageInfoHelper.PageMargins margins, float scale, org.eclipse.swt.graphics.Point offset) {
        margins.left = (int)((float)margins.left / scale);
        margins.top = (int)((float)margins.top / scale);
        margins.right = (int)((float)margins.right / scale);
        margins.bottom = (int)((float)margins.bottom / scale);
        margins.left -= offset.x;
        margins.right += offset.x;
        margins.top -= offset.y;
        margins.bottom += offset.y;
        if (margins.left < 0) {
            margins.left = 0;
        }
        if (margins.right < 0) {
            margins.right = 0;
        }
        if (margins.top < 0) {
            margins.top = 0;
        }
        if (margins.bottom < 0) {
            margins.bottom = 0;
        }
    }
}

