/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.diagram.ui.render.internal.dialogs;

import java.io.File;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.gmf.runtime.common.ui.util.WindowUtil;
import org.eclipse.gmf.runtime.diagram.ui.image.ImageFileFormat;
import org.eclipse.gmf.runtime.diagram.ui.l10n.DiagramUIMessages;
import org.eclipse.gmf.runtime.diagram.ui.render.internal.DiagramUIRenderPlugin;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class CopyToImageDialog
extends Dialog {
    private String folder = null;
    private String fileName = null;
    private ImageFileFormat imageFormat = null;
    private boolean overwriteExisting = false;
    private Text folderText = null;
    private Text fileNameText = null;
    private Combo imageFormatCombo = null;
    private Button overwriteExistingCheckbox = null;
    private Label messageImageLabel = null;
    private Label messageLabel = null;
    private boolean fileNameValid = true;
    private boolean folderValid = true;
    private static final String DIALOG_TITLE = DiagramUIMessages.CopyToImageDialog_title;
    private static final String FOLDER_LABEL = DiagramUIMessages.CopyToImageDialog_folder_label;
    private static final String FILE_NAME_LABEL = DiagramUIMessages.CopyToImageDialog_folder_label;
    private static final String IMAGE_FORMAT_LABEL = DiagramUIMessages.CopyToImageDialog_folder_label;
    private static final String BROWSE_LABEL = DiagramUIMessages.CopyToImageDialog_browse_label;
    private static final String OVERWRITE_EXISTING_LABEL = DiagramUIMessages.CopyToImageDialog_overwriteExisting_label;
    private static final String DIRECTORY_DIALOG_TEXT = DiagramUIMessages.CopyToImageDialog_DirectoryDialog_text;
    private static final String DIRECTORY_DIALOG_MESSAGE = DiagramUIMessages.CopyToImageDialog_DirectoryDialog_message;
    private static final String FOLDER_BLANK_MESSAGE = DiagramUIMessages.CopyToImageDialog_validateFolderText_folderBlank;
    private static final String FOLDER_INVALID_MESSAGE = DiagramUIMessages.CopyToImageDialog_validateFolderText_folderInvalid;
    private static final String FOLDER_NOT_EXIST_MESSAGE = DiagramUIMessages.CopyToImageDialog_validateFolderText_folderNotExist;
    private static final String DEFAULT_IMAGE_FILENAME = DiagramUIMessages.CopyToImageDialog_filename_default;
    private static final String EMPTY_STRING = "";
    private static final String DOT_STRING = ".";
    private static final String DIALOG_SETTINGS_ID = "CopyToImageDialog";
    private static final String DIALOG_SETTINGS_FOLDER = "CopyToImageDialog.folder";
    private static final String DIALOG_SETTINGS_IMAGE_FORMAT = "CopyToImageDialog.imageFormat";
    private static final String DIALOG_SETTINGS_OVERWRITE = "CopyToImageDialog.overwriteExisting";

    public CopyToImageDialog(Shell shell, IPath path, String fileName) {
        super(shell);
        this.initDialogSettings(path);
        this.fileName = fileName != null ? fileName : DEFAULT_IMAGE_FILENAME;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        this.createFolderGroup(composite);
        this.createFileNameGroup(composite);
        this.createImageFormatGroup(composite);
        this.createOverwriteExistingGroup(composite);
        this.createMessageGroup(composite);
        return composite;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(DIALOG_TITLE);
    }

    private void createFolderGroup(Composite parent) {
        Composite composite = this.createComposite(parent, 4);
        this.createLabel(composite, FOLDER_LABEL);
        this.folderText = new Text(composite, 2048);
        this.folderText.setText(this.folder);
        this.folderText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CopyToImageDialog.this.validateFolderText();
            }
        });
        GridData gridData = new GridData(768);
        gridData.widthHint = 250;
        this.folderText.setLayoutData((Object)gridData);
        Button button = new Button(composite, 8);
        button.setText(BROWSE_LABEL);
        button.setLayoutData((Object)WindowUtil.makeButtonData((Button)button));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                CopyToImageDialog.this.handleBrowseButtonPressed();
            }
        });
    }

    private void createFileNameGroup(Composite parent) {
        Composite composite = this.createComposite(parent, 2);
        this.createLabel(composite, FILE_NAME_LABEL);
        this.fileNameText = new Text(composite, 2048);
        this.fileNameText.setText(String.valueOf(this.fileName) + DOT_STRING + this.imageFormat.getName().toLowerCase());
        this.fileNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CopyToImageDialog.this.validateFileNameText();
            }
        });
        GridData gridData = new GridData(768);
        gridData.widthHint = 250;
        this.fileNameText.setLayoutData((Object)gridData);
    }

    private void createImageFormatGroup(Composite parent) {
        Composite composite = this.createComposite(parent, 2);
        this.createLabel(composite, IMAGE_FORMAT_LABEL);
        this.imageFormatCombo = new Combo(composite, 12);
        this.imageFormatCombo.setItems(this.getImageFormatItems());
        this.imageFormatCombo.setText(this.imageFormat.getName());
        this.imageFormatCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CopyToImageDialog.this.imageFormat = ImageFileFormat.resolveImageFormat((int)CopyToImageDialog.this.imageFormatCombo.getSelectionIndex());
            }
        });
        GridData gridData = new GridData(768);
        gridData.widthHint = 250;
        this.imageFormatCombo.setLayoutData((Object)gridData);
    }

    private void createOverwriteExistingGroup(Composite parent) {
        Composite composite = this.createComposite(parent, 1);
        this.overwriteExistingCheckbox = new Button(composite, 16416);
        this.overwriteExistingCheckbox.setText(OVERWRITE_EXISTING_LABEL);
        GridData data = new GridData(768);
        this.overwriteExistingCheckbox.setLayoutData((Object)data);
        this.overwriteExistingCheckbox.setSelection(this.overwriteExisting);
        this.overwriteExistingCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                CopyToImageDialog.this.overwriteExisting = CopyToImageDialog.this.overwriteExistingCheckbox.getSelection();
            }
        });
    }

    private void createMessageGroup(Composite parent) {
        Composite composite = this.createComposite(parent, 2);
        this.messageImageLabel = new Label(composite, 0);
        this.messageImageLabel.setImage(JFaceResources.getImage((String)"dialog_message_error_image"));
        this.messageImageLabel.setVisible(false);
        this.messageLabel = new Label(composite, 0);
        GridData gridData = new GridData(768);
        gridData.widthHint = 250;
        this.messageLabel.setLayoutData((Object)gridData);
        this.messageLabel.setVisible(false);
    }

    private Composite createComposite(Composite parent, int columns) {
        Composite composite = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = columns;
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.makeColumnsEqualWidth = false;
        GridData data = new GridData(768);
        composite.setLayoutData((Object)data);
        composite.setLayout((Layout)gridLayout);
        return composite;
    }

    private Label createLabel(Composite parent, String text) {
        Label label = new Label(parent, 0);
        label.setText(text);
        return label;
    }

    private String[] getImageFormatItems() {
        String[] items = new String[ImageFileFormat.VALUES.length];
        int i = 0;
        while (i < ImageFileFormat.VALUES.length) {
            items[i] = ImageFileFormat.VALUES[i].getName();
            ++i;
        }
        return items;
    }

    public IPath getDestination() {
        StringBuffer extension = new StringBuffer(DOT_STRING);
        extension.append(this.imageFormat.getName().toLowerCase());
        StringBuffer f = new StringBuffer(this.fileName);
        if (!f.toString().endsWith(extension.toString())) {
            f.append(extension);
        }
        return new Path(this.folder).append(f.toString());
    }

    public ImageFileFormat getImageFormat() {
        return this.imageFormat;
    }

    public boolean overwriteExisting() {
        return this.overwriteExisting;
    }

    private void handleBrowseButtonPressed() {
        String selectedDirectory;
        File path;
        DirectoryDialog dialog = new DirectoryDialog(Display.getCurrent().getActiveShell());
        dialog.setMessage(DIRECTORY_DIALOG_MESSAGE);
        dialog.setText(DIRECTORY_DIALOG_TEXT);
        String dirName = this.folderText.getText();
        if (!dirName.equals(EMPTY_STRING) && (path = new File(dirName)).exists()) {
            dialog.setFilterPath(new Path(dirName).toOSString());
        }
        if ((selectedDirectory = dialog.open()) != null) {
            this.folderText.setText(selectedDirectory);
        }
    }

    private void validateFolderText() {
        if (this.folderText.getText().equals(EMPTY_STRING)) {
            this.setDialogErrorState(FOLDER_BLANK_MESSAGE);
            this.folderValid = false;
            return;
        }
        Path path = new Path(EMPTY_STRING);
        if (!path.isValidPath(this.folderText.getText())) {
            this.setDialogErrorState(FOLDER_INVALID_MESSAGE);
            this.folderValid = false;
            return;
        }
        File file = new File(this.folderText.getText());
        if (!file.exists()) {
            this.setDialogErrorState(FOLDER_NOT_EXIST_MESSAGE);
            this.folderValid = false;
            return;
        }
        this.folderValid = true;
        this.folder = this.folderText.getText();
        if (this.fileNameValid) {
            this.setDialogOKState();
        } else {
            this.validateFileNameText();
        }
    }

    private void validateFileNameText() {
        IStatus nameStatus = ResourcesPlugin.getWorkspace().validateName(this.fileNameText.getText(), 1);
        if (!nameStatus.isOK()) {
            this.setDialogErrorState(nameStatus.getMessage());
            this.fileNameValid = false;
            return;
        }
        this.fileNameValid = true;
        this.fileName = this.fileNameText.getText();
        if (this.folderValid) {
            this.setDialogOKState();
        } else {
            this.validateFolderText();
        }
    }

    private void setDialogErrorState(String message) {
        this.messageLabel.setText(message);
        this.messageImageLabel.setVisible(true);
        this.messageLabel.setVisible(true);
        this.getButton(0).setEnabled(false);
        this.getButton(1).getShell().setDefaultButton(this.getButton(1));
    }

    private void setDialogOKState() {
        this.messageImageLabel.setVisible(false);
        this.messageLabel.setVisible(false);
        this.getButton(0).setEnabled(true);
        this.getButton(0).getShell().setDefaultButton(this.getButton(0));
    }

    private IDialogSettings getDialogSettings() {
        IDialogSettings settings = DiagramUIRenderPlugin.getInstance().getDialogSettings();
        if ((settings = settings.getSection(DIALOG_SETTINGS_ID)) == null) {
            settings = DiagramUIRenderPlugin.getInstance().getDialogSettings().addNewSection(DIALOG_SETTINGS_ID);
        }
        return settings;
    }

    private void initDialogSettings(IPath path) {
        String persistentImageFormat;
        IDialogSettings dialogSettings = this.getDialogSettings();
        this.folder = "/";
        if (path == null) {
            String persistentFolder = dialogSettings.get(DIALOG_SETTINGS_FOLDER);
            if (persistentFolder != null) {
                this.folder = persistentFolder;
            }
        } else {
            this.folder = path.toOSString();
        }
        this.imageFormat = (persistentImageFormat = dialogSettings.get(DIALOG_SETTINGS_IMAGE_FORMAT)) == null ? ImageFileFormat.getDefaultImageFormat() : ImageFileFormat.resolveImageFormat((String)persistentImageFormat);
        this.overwriteExisting = dialogSettings.getBoolean(DIALOG_SETTINGS_OVERWRITE);
    }

    private void saveDialogSettings() {
        IDialogSettings dialogSettings = this.getDialogSettings();
        dialogSettings.put(DIALOG_SETTINGS_FOLDER, this.folder);
        dialogSettings.put(DIALOG_SETTINGS_IMAGE_FORMAT, this.imageFormat.getName().toLowerCase());
        dialogSettings.put(DIALOG_SETTINGS_OVERWRITE, this.overwriteExisting);
    }

    protected void okPressed() {
        super.okPressed();
        this.saveDialogSettings();
    }
}

