/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.diagram.ui.resources.editor.internal.util;

import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.xmi.FeatureNotFoundException;
import org.eclipse.emf.ecore.xmi.PackageNotFoundException;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.common.core.util.StringStatics;
import org.eclipse.gmf.runtime.common.core.util.Trace;
import org.eclipse.gmf.runtime.common.ui.internal.CommonUIPlugin;
import org.eclipse.gmf.runtime.diagram.ui.resources.editor.internal.EditorDebugOptions;
import org.eclipse.gmf.runtime.diagram.ui.resources.editor.internal.EditorPlugin;
import org.eclipse.gmf.runtime.diagram.ui.resources.editor.internal.l10n.EditorMessages;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class DiagramIOUtil {
    private static String TITLE_OPEN = EditorMessages.compatibility_title_open;
    private static String MESSAGE1_OPEN = EditorMessages.compatibility_message1_open;
    private static String MESSAGE2_OPEN = EditorMessages.compatibility_message2_open;
    private static String MESSAGE3_OPEN = EditorMessages.compatibility_message3_open;
    private static String UNABLE_TO_LOAD_DIAGRAM = EditorMessages.Diagram_UNABLE_TO_LOAD_RESOURCE;
    private static String NO_DIAGRAM_IN_RESOURCE = EditorMessages.Diagram_NO_DIAGRAM_IN_RESOURCE;
    private static String TITLE_SAVE = EditorMessages.compatibility_title_save;
    private static String MESSAGE1_SAVE = EditorMessages.compatibility_message1_save;
    private static String MESSAGE2_SAVE = EditorMessages.compatibility_message2_save;
    static /* synthetic */ Class class$0;

    public static Diagram load(TransactionalEditingDomain domain, IFile file, boolean bTryCompatible, IProgressMonitor monitor) throws CoreException {
        FileLoader loader = new FileLoader(file);
        return DiagramIOUtil.load(domain, loader, bTryCompatible, monitor);
    }

    public static Diagram load(TransactionalEditingDomain domain, IStorage storage, boolean bTryCompatible, IProgressMonitor monitor) throws CoreException {
        ILoader loader = null;
        loader = storage instanceof IFile ? new FileLoader((IFile)storage) : new StorageLoader(storage);
        return DiagramIOUtil.load(domain, loader, bTryCompatible, monitor);
    }

    private static Diagram load(TransactionalEditingDomain domain, ILoader loader, boolean bTryCompatible, IProgressMonitor monitor) throws CoreException {
        Resource notationModel = null;
        try {
            try {
                notationModel = loader.load(domain, 0, monitor);
            }
            catch (Exception e) {
                if (bTryCompatible) {
                    Exception exc;
                    Throwable t = e.getCause();
                    Throwable causeError = t.getCause();
                    if (causeError == null) {
                        causeError = t;
                    }
                    String errMsg = causeError.getLocalizedMessage();
                    if (causeError instanceof Resource.IOWrappedException && (exc = ((Resource.IOWrappedException)causeError).getWrappedException()) != null) {
                        causeError = exc;
                    }
                    if (causeError instanceof PackageNotFoundException || causeError instanceof ClassNotFoundException || causeError instanceof FeatureNotFoundException) {
                        if (DiagramIOUtil.shouldLoadInCompatibilityMode(errMsg)) {
                            notationModel = loader.load(domain, 4, monitor);
                        }
                        return null;
                    }
                    throw new CoreException((IStatus)new Status(4, EditorPlugin.getPluginId(), 1, UNABLE_TO_LOAD_DIAGRAM, causeError));
                }
                throw e;
            }
            if (notationModel == null) {
                throw new RuntimeException(UNABLE_TO_LOAD_DIAGRAM);
            }
            Iterator rootContents = notationModel.getContents().iterator();
            while (rootContents.hasNext()) {
                EObject rootElement = (EObject)rootContents.next();
                if (!(rootElement instanceof Diagram)) continue;
                return (Diagram)rootElement;
            }
            throw new RuntimeException(NO_DIAGRAM_IN_RESOURCE);
        }
        catch (Exception e) {
            EditorPlugin editorPlugin = EditorPlugin.getInstance();
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.gmf.runtime.diagram.ui.resources.editor.internal.util.DiagramIOUtil");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Trace.catching((Plugin)editorPlugin, (String)EditorDebugOptions.EXCEPTIONS_CATCHING, (Class)clazz, (String)"load(IFile, boolean)", (Throwable)e);
            CoreException thrownExcp = null;
            thrownExcp = e instanceof CoreException ? (CoreException)((Object)e) : new CoreException((IStatus)new Status(4, EditorPlugin.getPluginId(), 1, e.getMessage(), (Throwable)e));
            EditorPlugin editorPlugin2 = EditorPlugin.getInstance();
            Class<?> clazz2 = class$0;
            if (clazz2 == null) {
                try {
                    clazz2 = class$0 = Class.forName("org.eclipse.gmf.runtime.diagram.ui.resources.editor.internal.util.DiagramIOUtil");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Trace.throwing((Plugin)editorPlugin2, (String)EditorDebugOptions.EXCEPTIONS_THROWING, (Class)clazz2, (String)"load(IFile, boolean)", (Throwable)thrownExcp);
            throw thrownExcp;
        }
    }

    public static void save(TransactionalEditingDomain domain, IFile file, Diagram diagram, boolean bKeepUnrecognizedData, IProgressMonitor progressMonitor) throws CoreException {
        HashMap options = new HashMap();
        int nOptions = 0;
        if (bKeepUnrecognizedData) {
            nOptions |= 4;
        }
        DiagramIOUtil.save(domain, file, diagram, progressMonitor, options);
    }

    public static void save(TransactionalEditingDomain domain, IFile file, Diagram diagram, IProgressMonitor progressMonitor, Map options) throws CoreException {
        Resource notationModel = diagram.eResource();
        String fileName = file.getFullPath().toOSString();
        notationModel.setURI(URI.createPlatformResourceURI((String)fileName, (boolean)true));
        try {
            notationModel.save(options);
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(4, EditorPlugin.getPluginId(), 5, e.getLocalizedMessage(), null));
        }
        if (progressMonitor != null) {
            progressMonitor.done();
        }
    }

    private static boolean shouldLoadInCompatibilityMode(String errMsg) {
        boolean bLoadAgain = false;
        IPreferenceStore prefs = CommonUIPlugin.getDefault().getPreferenceStore();
        prefs.setDefault("Modeling.openUnrecognizedVersions", "prompt");
        String szOption = prefs.getString("Modeling.openUnrecognizedVersions");
        if (szOption == "prompt") {
            StringBuffer displayErrors = new StringBuffer();
            displayErrors.append(MESSAGE1_OPEN);
            displayErrors.append(StringStatics.PLATFORM_NEWLINE);
            if (errMsg != null && errMsg.trim().length() > 0) {
                displayErrors.append(StringStatics.PLATFORM_NEWLINE);
                displayErrors.append(errMsg);
            }
            displayErrors.append(StringStatics.PLATFORM_NEWLINE);
            displayErrors.append(StringStatics.PLATFORM_NEWLINE);
            displayErrors.append(MESSAGE2_OPEN);
            displayErrors.append(StringStatics.PLATFORM_NEWLINE);
            displayErrors.append(StringStatics.PLATFORM_NEWLINE);
            displayErrors.append(MESSAGE3_OPEN);
            MessageDialogWithToggle dlg = MessageDialogWithToggle.openYesNoQuestion((Shell)Display.getDefault().getActiveShell(), (String)TITLE_OPEN, (String)displayErrors.toString(), null, (boolean)false, null, null);
            boolean bl = bLoadAgain = dlg.getReturnCode() == 2;
            if (dlg.getToggleState()) {
                String state = "always";
                if (!bLoadAgain) {
                    state = "never";
                }
                prefs.setValue("Modeling.openUnrecognizedVersions", state);
            }
        } else {
            bLoadAgain = szOption == "always";
        }
        return bLoadAgain;
    }

    public static void unload(TransactionalEditingDomain domain, Diagram diagram) {
        diagram.eResource().unload();
    }

    public static boolean hasUnrecognizedData(Resource resource) {
        boolean bKeepUnrecognizedData = false;
        if (resource instanceof XMLResource && !((XMLResource)resource).getEObjectToExtensionMap().isEmpty()) {
            IPreferenceStore prefs = CommonUIPlugin.getDefault().getPreferenceStore();
            prefs.setDefault("Modeling.saveUnrecognizedVersions", "prompt");
            String szOption = prefs.getString("Modeling.saveUnrecognizedVersions");
            if (szOption == "prompt") {
                String display = String.valueOf(MESSAGE1_SAVE) + StringStatics.PLATFORM_NEWLINE + StringStatics.PLATFORM_NEWLINE + MESSAGE2_SAVE;
                MessageDialogWithToggle dlg = MessageDialogWithToggle.openYesNoQuestion((Shell)Display.getDefault().getActiveShell(), (String)TITLE_SAVE, (String)display, null, (boolean)false, null, null);
                boolean bl = bKeepUnrecognizedData = dlg.getReturnCode() == 2;
                if (dlg.getToggleState()) {
                    prefs.setValue("Modeling.saveUnrecognizedVersions", szOption);
                }
            } else if (szOption == "always") {
                bKeepUnrecognizedData = true;
            }
        }
        return bKeepUnrecognizedData;
    }

    private static interface ILoader {
        public Resource load(TransactionalEditingDomain var1, int var2, IProgressMonitor var3) throws CoreException;
    }

    private static class FileLoader
    implements ILoader {
        private IFile fFile;
        static final /* synthetic */ boolean $assertionsDisabled;
        static /* synthetic */ Class class$0;

        static {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.gmf.runtime.diagram.ui.resources.editor.internal.util.DiagramIOUtil$FileLoader");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            $assertionsDisabled = !clazz.desiredAssertionStatus();
        }

        public FileLoader(IFile file) {
            if (!$assertionsDisabled && file == null) {
                throw new AssertionError();
            }
            this.fFile = file;
        }

        public Resource load(TransactionalEditingDomain domain, int loadOptions, IProgressMonitor monitor) throws CoreException {
            this.fFile.refreshLocal(0, monitor);
            URI uri = URI.createPlatformResourceURI((String)this.fFile.getFullPath().toString(), (boolean)true);
            Resource resource = domain.getResourceSet().getResource(uri, true);
            return resource;
        }
    }

    private static class StorageLoader
    implements ILoader {
        private IStorage fStorage;
        static final /* synthetic */ boolean $assertionsDisabled;
        static /* synthetic */ Class class$0;

        static {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.gmf.runtime.diagram.ui.resources.editor.internal.util.DiagramIOUtil$StorageLoader");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            $assertionsDisabled = !clazz.desiredAssertionStatus();
        }

        public StorageLoader(IStorage storage) {
            if (!$assertionsDisabled && storage == null) {
                throw new AssertionError();
            }
            this.fStorage = storage;
        }

        public Resource load(TransactionalEditingDomain editingDomain, int loadOptions, IProgressMonitor monitor) throws CoreException {
            String storagePath = this.fStorage.getFullPath().toString();
            Resource resource = editingDomain.getResourceSet().getResource(URI.createPlatformResourceURI((String)storagePath, (boolean)true), true);
            return resource;
        }
    }
}

