/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.diagram.ui.resources.editor.internal.util;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.gmf.runtime.common.core.util.Log;
import org.eclipse.gmf.runtime.common.core.util.StringStatics;
import org.eclipse.gmf.runtime.diagram.ui.resources.editor.internal.EditorPlugin;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;

public class Util {
    protected static final String ELEMENTS_AND_RELATIONSHIPS_PATH = "elementsandrelationships" + StringStatics.PATH_SEPARATOR;
    static final String PLUGIN_ID = "org.eclipse.gmf.runtime.diagram.ui.resources.editor";
    static /* synthetic */ Class class$0;

    public static IProject getProject(IFile file) {
        return file.getProject();
    }

    public static IProject getProject(IEditorPart editor) {
        IResource resource;
        if (editor == null) {
            return null;
        }
        IEditorInput input = editor.getEditorInput();
        if (input == null) {
            return null;
        }
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.core.resources.IResource");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((resource = (IResource)input.getAdapter((Class)clazz)) == null) {
            return null;
        }
        IProject project = resource.getProject();
        return project;
    }

    public static void logWarning(String s) {
        Log.warning((Plugin)EditorPlugin.getInstance(), (int)0, (String)s);
    }

    public static void logError(String s) {
        Log.error((Plugin)EditorPlugin.getInstance(), (int)0, (String)s);
    }

    public static void logInfo(String s) {
        Log.info((Plugin)EditorPlugin.getInstance(), (int)0, (String)s);
    }

    public static void reportException(CoreException e) {
        final IStatus status = e.getStatus();
        Util.logError(status.getMessage());
        Display display = Util.getStandardDisplay();
        display.asyncExec(new Runnable(){

            public void run() {
                ErrorDialog.openError(null, null, null, (IStatus)status);
            }
        });
    }

    public static Display getStandardDisplay() {
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        return display;
    }

    public static void reportException(Throwable e, final String title, String message, String pluginId) {
        if (e instanceof InvocationTargetException) {
            e = ((InvocationTargetException)e).getTargetException();
        }
        Status status = null;
        if (e instanceof CoreException) {
            Util.reportException((CoreException)e);
            return;
        }
        if (message == null) {
            message = e.getMessage();
        }
        if (message == null) {
            message = e.toString();
        }
        status = new Status(4, pluginId, 0, message, e);
        Util.logError(message);
        Status fstatus = status;
        Display display = Util.getStandardDisplay();
        display.asyncExec(new Runnable((IStatus)fstatus){
            private final /* synthetic */ IStatus val$fstatus;
            {
                this.val$fstatus = iStatus;
            }

            public void run() {
                ErrorDialog.openError(null, (String)title, null, (IStatus)this.val$fstatus);
            }
        });
    }

    public static void reportException(Throwable e, String title, String message) {
        Util.reportException(e, title, message, PLUGIN_ID);
    }
}

