/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.draw2d.ui.figures;

import java.util.List;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gmf.runtime.draw2d.ui.geometry.LineSeg;
import org.eclipse.gmf.runtime.draw2d.ui.geometry.PointListUtilities;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;

public class FigureUtilities
extends org.eclipse.draw2d.FigureUtilities {
    public static Integer colorToInteger(Color c) {
        return new Integer(c.getBlue() << 16 | c.getGreen() << 8 | c.getRed());
    }

    public static Color integerToColor(Integer i) {
        if (i == null) {
            return null;
        }
        int color = i;
        return new Color(null, color & 0xFF, (color & 0xFF00) >> 8, (color & 0xFF0000) >> 16);
    }

    public static Integer RGBToInteger(RGB rgb) {
        return new Integer(rgb.blue << 16 | rgb.green << 8 | rgb.red);
    }

    public static RGB integerToRGB(Integer color) {
        int n = color;
        return new RGB(n & 0xFF, (n & 0xFF00) >> 8, (n & 0xFF0000) >> 16);
    }

    public static Point getLocation(int pos, Rectangle topos, Rectangle constraint) {
        Rectangle b = constraint.getCopy();
        Point svb = new Point(b.x, b.y);
        switch (pos) {
            case 1: {
                svb.x += b.width / 2;
                break;
            }
            case 4: {
                svb.x += b.width / 2;
                svb.y += b.height;
                break;
            }
            case 8: {
                svb.y += b.height / 2 - topos.height / 2;
                break;
            }
            case 16: {
                svb.x += b.width;
                svb.y += b.height / 2 - topos.height / 2;
                break;
            }
            case 17: {
                svb.x += b.width - topos.width;
                break;
            }
            case 20: {
                svb.x += b.width - topos.width;
                svb.y += b.height - topos.height;
                break;
            }
            case 12: {
                svb.x += b.width;
                svb.y += topos.height;
                break;
            }
            case 5: 
            case 24: {
                svb.x += b.width / 2 - topos.width / 2;
                svb.y += b.height / 2 - topos.height / 2;
                break;
            }
        }
        return svb;
    }

    public static Point getLocation(int pos, Dimension dim, Rectangle constraint) {
        return FigureUtilities.getLocation(pos, new Rectangle(0, 0, dim.width, dim.height), constraint);
    }

    public static List getLineSegments(PointList points) {
        return PointListUtilities.getLineSegments(points);
    }

    public static LineSeg getNearestSegment(List mySegments, int xCoord, int yCoord) {
        return PointListUtilities.getNearestSegment(mySegments, xCoord, yCoord);
    }

    public static int findNearestLineSegIndexOfPoint(PointList points, Point ptCoord) {
        return PointListUtilities.findNearestLineSegIndexOfPoint(points, ptCoord);
    }
}

