/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.draw2d.ui.figures;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.ChangeEvent;
import org.eclipse.draw2d.ChangeListener;
import org.eclipse.draw2d.Clickable;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.ScrollBar;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.gmf.runtime.draw2d.ui.figures.FigureUtilities;
import org.eclipse.gmf.runtime.draw2d.ui.internal.figures.DropShadowButtonBorder;
import org.eclipse.gmf.runtime.draw2d.ui.internal.figures.ImageFigureEx;
import org.eclipse.gmf.runtime.draw2d.ui.internal.l10n.Draw2dUIPluginImages;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;

public class ListScrollBar
extends ScrollBar {
    private static ImageConstants icons = new ImageConstants();
    private Image upIcon;
    private Image upPressedIcon;
    private Image upGrayedIcon;
    private Image downIcon;
    private Image downPressedIcon;
    private Image downGrayedIcon;
    private ImageFigureEx upLabel;
    private ImageFigureEx downLabel;
    private static Border dropshadow = new DropShadowButtonBorder();

    public ListScrollBar(int orientation, Insets insets, Dimension size, int stepInc, int pageInc) {
        this.setOrientation(orientation);
        MarginBorder margin = new MarginBorder(insets.top, insets.left, insets.bottom, insets.right);
        this.setBorder((Border)margin);
        this.setPreferredSize(size.width, size.height);
        this.setStepIncrement(stepInc);
        this.setPageIncrement(pageInc);
        this.upIcon = this.isHorizontal() ? icons.left : icons.up;
        this.upPressedIcon = this.isHorizontal() ? icons.leftPressed : icons.upPressed;
        this.upGrayedIcon = this.isHorizontal() ? icons.leftGrayed : icons.upGrayed;
        this.downIcon = this.isHorizontal() ? icons.right : icons.down;
        this.downPressedIcon = this.isHorizontal() ? icons.rightPressed : icons.downPressed;
        this.downGrayedIcon = this.isHorizontal() ? icons.rightGrayed : icons.downGrayed;
    }

    protected Clickable createDefaultDownButton() {
        this.downLabel = new ImageFigureEx(this.downIcon);
        this.downLabel.setOpaque(true);
        this.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                ListScrollBar.this.updateDownLabel();
            }
        });
        Clickable button = new Clickable((IFigure)this.downLabel);
        button.getModel().addChangeListener(new ChangeListener(){

            public void handleStateChanged(ChangeEvent event) {
                ListScrollBar.this.updateDownLabel();
            }
        });
        button.setFiringMethod(1);
        button.setRolloverEnabled(true);
        button.setBorder(dropshadow);
        button.setOpaque(false);
        return button;
    }

    protected Clickable createDefaultUpButton() {
        this.upLabel = new ImageFigureEx(this.upIcon);
        this.upLabel.setOpaque(true);
        this.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                ListScrollBar.this.updateUpLabel();
            }
        });
        Clickable button = new Clickable((IFigure)this.upLabel);
        button.getModel().addChangeListener(new ChangeListener(){

            public void handleStateChanged(ChangeEvent event) {
                ListScrollBar.this.updateUpLabel();
            }
        });
        button.setFiringMethod(1);
        button.setRolloverEnabled(true);
        button.setBorder(dropshadow);
        button.setOpaque(false);
        return button;
    }

    protected void initialize() {
        super.initialize();
        this.setPageUp(null);
        this.setPageDown(null);
        this.setThumb(null);
        this.setOpaque(false);
    }

    private void updateDownLabel() {
        Image icon = null;
        if (((Clickable)this.getButtonDown()).getModel().isPressed() || !((Clickable)this.getButtonDown()).getModel().isMouseOver()) {
            icon = this.downPressedIcon;
        }
        if (this.getValue() >= this.getMaximum() - this.getExtent()) {
            icon = this.downGrayedIcon;
            this.getButtonDown().setEnabled(false);
        } else {
            this.getButtonDown().setEnabled(true);
            if (icon == null) {
                icon = this.downIcon;
            }
        }
        this.downLabel.setImage(icon);
    }

    private void updateUpLabel() {
        Image icon = null;
        if (((Clickable)this.getButtonUp()).getModel().isPressed() || !((Clickable)this.getButtonUp()).getModel().isMouseOver()) {
            icon = this.upPressedIcon;
        }
        if (this.getValue() <= this.getMinimum()) {
            icon = this.upGrayedIcon;
            this.getButtonUp().setEnabled(false);
        } else {
            this.getButtonUp().setEnabled(true);
            if (icon == null) {
                icon = this.upIcon;
            }
        }
        this.upLabel.setImage(icon);
    }

    private static class ImageConstants {
        private final Image up;
        private final Image upPressed;
        private final Image upGrayed;
        private final Image down;
        private final Image downPressed;
        private final Image downGrayed;
        private final Image left;
        private final Image leftPressed;
        private final Image leftGrayed;
        private final Image right;
        private final Image rightPressed;
        private final Image rightGrayed;

        public ImageConstants() {
            RGB[] palette2 = new RGB[]{FigureUtilities.integerToColor(new Integer(25)).getRGB(), new RGB(0, 0, 0), new RGB(0, 0, 0), new RGB(0, 0, 0)};
            RGB[] palette1 = new RGB[]{FigureUtilities.integerToColor(new Integer(24)).getRGB(), new RGB(0, 0, 0)};
            ImageData image = Draw2dUIPluginImages.DESC_DOWN_ARROW.getImageData();
            this.down = this.convert(image, palette2);
            image = Draw2dUIPluginImages.DESC_UP_ARROW.getImageData();
            this.up = this.convert(image, palette2);
            image = Draw2dUIPluginImages.DESC_LEFT_ARROW.getImageData();
            this.left = this.convert(image, palette2);
            image = Draw2dUIPluginImages.DESC_RIGHT_ARROW.getImageData();
            this.right = this.convert(image, palette2);
            this.upPressed = Draw2dUIPluginImages.get("icons/uppressedarrow.gif");
            this.downPressed = Draw2dUIPluginImages.get("icons/downpressedarrow.gif");
            this.leftPressed = Draw2dUIPluginImages.get("icons/leftpressedarrow.gif");
            this.rightPressed = Draw2dUIPluginImages.get("icons/rightpressedarrow.gif");
            image = Draw2dUIPluginImages.DESC_UP_GRAY_ARROW.getImageData();
            this.upGrayed = this.convert(image, palette1);
            image = Draw2dUIPluginImages.DESC_DOWN_GRAY_ARROW.getImageData();
            this.downGrayed = this.convert(image, palette1);
            image = Draw2dUIPluginImages.DESC_LEFT_GRAY_ARROW.getImageData();
            this.leftGrayed = this.convert(image, palette1);
            image = Draw2dUIPluginImages.DESC_RIGHT_GRAY_ARROW.getImageData();
            this.rightGrayed = this.convert(image, palette1);
            palette1 = null;
            palette2 = null;
        }

        private Image convert(ImageData theData, RGB[] colors) {
            theData.palette = new PaletteData(colors);
            return new Image((Device)Display.getCurrent(), theData);
        }
    }
}

