/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.draw2d.ui.figures;

import com.ibm.icu.text.BreakIterator;
import com.ibm.icu.util.StringTokenizer;
import java.util.ArrayList;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.FigureUtilities;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.PositionConstants;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gmf.runtime.draw2d.ui.mapmode.MapModeUtil;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;

public class WrapLabel
extends Figure
implements PositionConstants {
    private static String _ellipse = "...";
    private static final Dimension EMPTY_DIMENSION = new Dimension(0, 0);
    private static int FLAG_SELECTED = MAX_FLAG << 1;
    private static int FLAG_HASFOCUS = MAX_FLAG << 2;
    private static int FLAG_UNDERLINED = MAX_FLAG << 3;
    private static int FLAG_STRIKEDTHROUGH = MAX_FLAG << 4;
    private static int FLAG_WRAP = MAX_FLAG << 5;
    private static int FLAG_TEXT_ALIGN = MAX_FLAG << 6;
    private static int FLAG_WRAP_ALIGN = MAX_FLAG << 9;
    private static int FLAG_ICON_ALIGN = MAX_FLAG << 12;
    private static int FLAG_LABEL_ALIGN = MAX_FLAG << 15;
    private static int FLAG_TEXT_PLACEMENT = MAX_FLAG << 18;
    private String text = "";
    private String subStringText;
    private Dimension textSize;
    private Point textLocation;
    private Dimension cachedPrefSizeHint = new Dimension(-1, -1);
    private Dimension cachedTextSizeHint = new Dimension(-1, -1);
    private Point iconLocation;
    private IconInfo iconInfo = null;

    public WrapLabel() {
        this.setTextAlignment(2);
        this.setIconAlignment(2);
        this.setLabelAlignment(2);
        this.setTextWrapAlignment(1);
        this.setTextPlacement(16);
    }

    public WrapLabel(String s) {
        this.setText(s);
    }

    public WrapLabel(Image i) {
        this.setIcon(i);
    }

    public WrapLabel(String s, Image i) {
        this.setText(s);
        this.setIcon(i);
    }

    private void alignOnHeight(Point loc, Dimension size, int alignment) {
        Insets insets = this.getInsets();
        switch (alignment) {
            case 8: {
                loc.y = insets.top;
                break;
            }
            case 32: {
                loc.y = this.bounds.height - size.height - insets.bottom;
                break;
            }
            default: {
                loc.y = (this.bounds.height - size.height) / 2;
            }
        }
    }

    private void alignOnWidth(Point loc, Dimension size, int alignment) {
        Insets insets = this.getInsets();
        switch (alignment) {
            case 1: {
                loc.x = insets.left;
                break;
            }
            case 4: {
                loc.x = this.bounds.width - size.width - insets.right;
                break;
            }
            default: {
                loc.x = (this.bounds.width - size.width) / 2;
            }
        }
    }

    private void calculateAlignment() {
        Dimension iconSize = this.getTotalIconSize();
        switch (this.getTextPlacement()) {
            case 8: 
            case 16: {
                this.alignOnHeight(this.textLocation, this.getTextSize(), this.getTextAlignment());
                this.alignOnHeight(this.getIconLocation(), iconSize, this.getIconAlignment());
                break;
            }
            case 1: 
            case 4: {
                this.alignOnWidth(this.textLocation, this.getSubStringTextSize(), this.getTextAlignment());
                this.alignOnWidth(this.getIconLocation(), iconSize, this.getIconAlignment());
            }
        }
    }

    protected Dimension calculateLabelSize(Dimension txtSize) {
        int gap = this.getIconTextGap();
        if (!this.hasIcons() || this.getText().equals("")) {
            gap = 0;
        }
        Dimension d = new Dimension(0, 0);
        Dimension iconSize = this.getTotalIconSize();
        if (this.getTextPlacement() == 8 || this.getTextPlacement() == 16) {
            d.width = iconSize.width + gap + txtSize.width;
            d.height = Math.max(iconSize.height, txtSize.height);
        } else {
            d.width = Math.max(iconSize.width, txtSize.width);
            d.height = iconSize.height + gap + txtSize.height;
        }
        return d;
    }

    private void calculateLocations() {
        this.textLocation = new Point();
        this.iconLocation = new Point();
        this.calculatePlacement();
        this.calculateAlignment();
        Dimension offset = this.getSize().getDifference(this.getPreferredSize(this.getSize().width, this.getSize().height));
        offset.width += this.getTextSize().width - this.getSubStringTextSize().width;
        switch (this.getLabelAlignment()) {
            case 2: {
                offset.scale(0.5);
                break;
            }
            case 1: {
                offset.scale(0.0);
                break;
            }
            case 4: {
                offset.scale(1.0);
                break;
            }
            case 8: {
                offset.height = 0;
                offset.scale(0.5);
                break;
            }
            case 32: {
                offset.height *= 2;
                offset.scale(0.5);
                break;
            }
            default: {
                offset.scale(0.5);
            }
        }
        switch (this.getTextPlacement()) {
            case 8: 
            case 16: {
                offset.height = 0;
                break;
            }
            case 1: 
            case 4: {
                offset.width = 0;
            }
        }
        this.textLocation.translate(offset);
        this.iconLocation.translate(offset);
    }

    private void calculatePlacement() {
        int gap = this.getIconTextGap();
        if (!this.hasIcons() || this.text.equals("")) {
            gap = 0;
        }
        Insets insets = this.getInsets();
        Dimension iconSize = this.getTotalIconSize();
        switch (this.getTextPlacement()) {
            case 16: {
                this.iconLocation.x = insets.left;
                this.textLocation.x = iconSize.width + gap + insets.left;
                break;
            }
            case 8: {
                this.textLocation.x = insets.left;
                this.iconLocation.x = this.getSubStringTextSize().width + gap + insets.left;
                break;
            }
            case 1: {
                this.textLocation.y = insets.top;
                this.iconLocation.y = this.getTextSize().height + gap + insets.top;
                break;
            }
            case 4: {
                this.textLocation.y = iconSize.height + gap + insets.top;
                this.iconLocation.y = insets.top;
            }
        }
    }

    protected Dimension calculateSubStringTextSize() {
        return this.getTextExtents(this.getSubStringText(), this.getFont());
    }

    protected Dimension calculateTextSize(int wHint, int hHint) {
        return this.getTextExtents(this.getWrappedText(wHint, hHint), this.getFont());
    }

    private void clearLocations() {
        this.textLocation = null;
        this.iconLocation = null;
    }

    public Image getIcon() {
        return this.getIcon(0);
    }

    public Image getIcon(int index) {
        if (this.iconInfo == null) {
            return null;
        }
        return this.iconInfo.getIcon(index);
    }

    protected boolean hasIcons() {
        return !Dimension.SINGLETON.equals((Object)this.getTotalIconSize());
    }

    public int getIconAlignment() {
        return this.getAlignment(FLAG_ICON_ALIGN);
    }

    public Rectangle getIconBounds() {
        return new Rectangle(this.getBounds().getLocation().translate(this.getIconLocation()), this.getTotalIconSize());
    }

    protected Point getIconLocation() {
        if (this.iconLocation == null) {
            this.calculateLocations();
        }
        return this.iconLocation;
    }

    public int getIconTextGap() {
        return MapModeUtil.getMapMode((IFigure)this).DPtoLP(3);
    }

    public Dimension getMinimumSize(int w, int h) {
        if (this.minSize != null) {
            return this.minSize;
        }
        this.minSize = new Dimension();
        if (this.getLayoutManager() != null) {
            this.minSize.setSize(this.getLayoutManager().getMinimumSize((IFigure)this, w, h));
        }
        Dimension d = this.getTextExtents(this.getEllipse(), this.getFont()).intersect(this.getTextExtents(this.getText(), this.getFont()));
        Dimension labelSize = this.calculateLabelSize(d);
        Insets insets = this.getInsets();
        labelSize.expand(insets.getWidth(), insets.getHeight());
        this.minSize.union(labelSize);
        return this.minSize;
    }

    public Dimension getPreferredSize(int wHint, int hHint) {
        if (this.prefSize == null || wHint != this.cachedPrefSizeHint.width || hHint != this.cachedPrefSizeHint.height) {
            this.prefSize = this.calculateLabelSize(this.getTextSize(wHint, hHint));
            Insets insets = this.getInsets();
            this.prefSize.expand(insets.getWidth(), insets.getHeight());
            if (this.getLayoutManager() != null) {
                this.prefSize.union(this.getLayoutManager().getPreferredSize((IFigure)this, wHint, hHint));
            }
            this.prefSize.union(this.getMinimumSize(wHint, hHint));
            this.cachedPrefSizeHint.width = wHint;
            this.cachedPrefSizeHint.height = hHint;
        }
        return this.prefSize;
    }

    public Dimension getMaximumSize() {
        return this.prefSize;
    }

    public String getSubStringText() {
        if (this.subStringText != null) {
            return this.subStringText;
        }
        Dimension shrink = this.getPreferredSize(this.getSize().width, this.getSize().height).getDifference(this.getSize());
        Dimension effectiveSize = this.getTextSize().getExpanded(-shrink.width, -shrink.height);
        Font f = this.getFont();
        int fontHeight = MapModeUtil.getMapMode((IFigure)this).DPtoLP(FigureUtilities.getFontMetrics((Font)f).getHeight());
        int maxLines = (int)((double)effectiveSize.height / (double)fontHeight);
        StringBuffer accumlatedText = new StringBuffer();
        StringBuffer remainingText = new StringBuffer(this.getText());
        int i = 0;
        int j = 0;
        while (remainingText.length() > 0 && j++ < maxLines) {
            i = this.getLineWrapPosition(remainingText.toString(), f, effectiveSize.width);
            if (accumlatedText.length() > 0) {
                accumlatedText.append("\n");
            }
            if (i == 0 || remainingText.length() > i && j == maxLines) {
                int dotsWidth = this.getTextExtents((String)this.getEllipse(), (Font)f).width;
                i = this.getLargestSubstringConfinedTo(remainingText.toString(), f, Math.max(effectiveSize.width - dotsWidth, 0));
                accumlatedText.append(remainingText.substring(0, i));
                accumlatedText.append(this.getEllipse());
            } else {
                accumlatedText.append(remainingText.substring(0, i));
            }
            remainingText.delete(0, i);
        }
        this.subStringText = accumlatedText.toString();
        return this.subStringText;
    }

    private String getWrappedText(int wHint, int hHint) {
        if (!this.isTextWrapped() || wHint == -1) {
            return this.getText();
        }
        Dimension iconSize = this.getTotalIconSize();
        if (this.hasIcons()) {
            switch (this.getTextPlacement()) {
                case 8: 
                case 16: {
                    wHint -= iconSize.width + this.getIconTextGap();
                    break;
                }
                case 1: 
                case 4: {
                    if (hHint == -1) break;
                    hHint -= iconSize.height + this.getIconTextGap();
                }
            }
        }
        Font f = this.getFont();
        int maxLines = Integer.MAX_VALUE;
        if (hHint != -1) {
            int fontHeight = MapModeUtil.getMapMode((IFigure)this).DPtoLP(FigureUtilities.getFontMetrics((Font)f).getHeight());
            maxLines = (int)((double)hHint / (double)fontHeight);
        }
        StringBuffer accumlatedText = new StringBuffer();
        StringBuffer remainingText = new StringBuffer(this.getText());
        int i = 0;
        int j = 0;
        while (remainingText.length() > 0 && j++ < maxLines) {
            i = this.getLineWrapPosition(remainingText.toString(), f, wHint);
            if (i == 0) break;
            if (accumlatedText.length() > 0) {
                accumlatedText.append("\n");
            }
            accumlatedText.append(remainingText.substring(0, i));
            remainingText.delete(0, i);
        }
        return accumlatedText.toString();
    }

    protected Dimension getSubStringTextSize() {
        return this.calculateSubStringTextSize();
    }

    public String getText() {
        return this.text;
    }

    public int getTextAlignment() {
        return this.getAlignment(FLAG_TEXT_ALIGN);
    }

    private int getLabelAlignment() {
        return this.getAlignment(FLAG_LABEL_ALIGN);
    }

    public Rectangle getTextBounds() {
        return new Rectangle(this.getBounds().getLocation().translate(this.getTextLocation()), this.getTextSize());
    }

    protected Point getTextLocation() {
        if (this.textLocation != null) {
            return this.textLocation;
        }
        this.calculateLocations();
        return this.textLocation;
    }

    public int getTextPlacement() {
        return this.getPlacement(FLAG_TEXT_PLACEMENT);
    }

    protected Dimension getTextSize(int wHint, int hHint) {
        if (this.textSize == null || wHint != this.cachedTextSizeHint.width || hHint != this.cachedTextSizeHint.height) {
            this.textSize = this.calculateTextSize(wHint, hHint);
            this.cachedTextSizeHint.width = wHint;
            this.cachedTextSizeHint.height = hHint;
        }
        return this.textSize;
    }

    private final Dimension getTextSize() {
        return this.getTextSize(this.getSize().width, this.getSize().height);
    }

    public void invalidate() {
        this.prefSize = null;
        this.minSize = null;
        this.clearLocations();
        this.textSize = null;
        this.subStringText = null;
        if (this.iconInfo != null) {
            this.iconInfo.invalidate();
        }
        super.invalidate();
    }

    public boolean isTextTruncated() {
        return !this.getSubStringTextSize().equals((Object)this.getTextSize());
    }

    public void paintFigure(Graphics graphics) {
        if (this.isSelected()) {
            graphics.pushState();
            graphics.setBackgroundColor(ColorConstants.menuBackgroundSelected);
            graphics.fillRectangle(this.getSelectionRectangle());
            graphics.popState();
            graphics.setForegroundColor(ColorConstants.white);
        }
        if (this.hasFocus()) {
            graphics.pushState();
            graphics.setXORMode(true);
            graphics.setForegroundColor(ColorConstants.menuBackgroundSelected);
            graphics.setBackgroundColor(ColorConstants.white);
            graphics.drawFocus(this.getSelectionRectangle().resize(-1, -1));
            graphics.popState();
        }
        if (this.isOpaque()) {
            super.paintFigure(graphics);
        }
        Rectangle figBounds = this.getBounds();
        graphics.translate(figBounds.x, figBounds.y);
        if (this.hasIcons()) {
            this.paintIcons(graphics);
        }
        if (!this.isEnabled()) {
            graphics.translate(1, 1);
            graphics.setForegroundColor(ColorConstants.buttonLightest);
            this.paintText(graphics);
            graphics.translate(-1, -1);
            graphics.setForegroundColor(ColorConstants.buttonDarker);
        }
        this.paintText(graphics);
        graphics.translate(-figBounds.x, -figBounds.y);
    }

    private void paintText(Graphics graphics) {
        String subString = this.getSubStringText();
        StringTokenizer tokenizer = new StringTokenizer(subString, "\n");
        Font f = this.getFont();
        int fontHeight = MapModeUtil.getMapMode((IFigure)this).DPtoLP(FigureUtilities.getFontMetrics((Font)f).getHeight());
        int textWidth = this.getTextExtents((String)subString, (Font)f).width;
        int y = this.getTextLocation().y;
        if (FigureUtilities.getFontMetrics((Font)f).getLeading() == 0) {
            int offset = MapModeUtil.getMapMode((IFigure)this).DPtoLP(2);
            y += offset;
        }
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            int tokenWidth = this.getTextExtents((String)token, (Font)f).width;
            int x = this.getTextLocation().x;
            switch (this.getTextWrapAlignment()) {
                case 2: {
                    x += (textWidth - tokenWidth) / 2;
                    break;
                }
                case 4: {
                    x += textWidth - tokenWidth;
                }
            }
            Rectangle clipRect = new Rectangle();
            graphics.getClip(clipRect);
            if (tokenWidth + x <= clipRect.getTopRight().x) {
                Rectangle newClipRect = new Rectangle(clipRect);
                newClipRect.width += tokenWidth / token.length() / 2;
                graphics.setClip(newClipRect);
            }
            graphics.drawText(token, x, y);
            graphics.setClip(clipRect);
            y += fontHeight;
            if (this.isTextUnderlined()) {
                graphics.drawLine(x, y - 1, x + tokenWidth, y - 1);
            }
            if (!this.isTextStrikedThrough()) continue;
            graphics.drawLine(x, y - fontHeight / 2 + 1, x + tokenWidth, y - fontHeight / 2 + 1);
        }
    }

    private void paintIcons(Graphics graphics) {
        Point p = Point.SINGLETON;
        p.setLocation(this.getIconLocation());
        int num = this.getNumberofIcons();
        int i = 0;
        while (i < num) {
            Image icon = this.getIcon(i);
            if (icon != null) {
                graphics.drawImage(icon, p);
                p.x += this.getIconSize((int)i).width;
            }
            ++i;
        }
    }

    public void setIcon(Image image) {
        this.setIcon(image, 0);
    }

    public void setIcon(Image image, int index) {
        if (this.iconInfo == null) {
            this.iconInfo = new IconInfo();
        }
        if (this.iconInfo.getIcon(index) == image) {
            return;
        }
        this.iconInfo.setIcon(image, index);
        this.revalidate();
        this.repaint();
    }

    public void setIconAlignment(int align) {
        if (this.getIconAlignment() == align) {
            return;
        }
        this.setAlignmentFlags(align, FLAG_ICON_ALIGN);
        this.clearLocations();
        this.repaint();
    }

    protected Dimension getIconSize(int index) {
        if (this.iconInfo == null) {
            return EMPTY_DIMENSION;
        }
        return this.iconInfo.getIconSize(index);
    }

    protected int getNumberofIcons() {
        if (this.iconInfo == null) {
            return 0;
        }
        return this.iconInfo.getNumberofIcons();
    }

    protected Dimension getTotalIconSize() {
        if (this.iconInfo == null) {
            return EMPTY_DIMENSION;
        }
        return this.iconInfo.getTotalIconSize();
    }

    public void setLabelAlignment(int align) {
        if (this.getLabelAlignment() == align) {
            return;
        }
        this.setAlignmentFlags(align, FLAG_LABEL_ALIGN);
        this.clearLocations();
        this.repaint();
    }

    protected String getEllipse() {
        return _ellipse;
    }

    public void setText(String s) {
        if (s == null) {
            s = "";
        }
        if (this.text.equals(s)) {
            return;
        }
        this.text = s;
        this.revalidate();
        this.repaint();
    }

    public void setTextAlignment(int align) {
        if (this.getTextAlignment() == align) {
            return;
        }
        this.setAlignmentFlags(align, FLAG_TEXT_ALIGN);
        this.clearLocations();
        this.repaint();
    }

    public void setTextPlacement(int where) {
        if (this.getTextPlacement() == where) {
            return;
        }
        this.setPlacementFlags(where, FLAG_TEXT_PLACEMENT);
        this.revalidate();
        this.repaint();
    }

    public void setTextUnderline(boolean b) {
        if (this.isTextUnderlined() == b) {
            return;
        }
        this.setFlag(FLAG_UNDERLINED, b);
        this.repaint();
    }

    public boolean isTextUnderlined() {
        return (this.flags & FLAG_UNDERLINED) != 0;
    }

    public void setTextStrikeThrough(boolean b) {
        if (this.isTextStrikedThrough() == b) {
            return;
        }
        this.setFlag(FLAG_STRIKEDTHROUGH, b);
        this.repaint();
    }

    public boolean isTextStrikedThrough() {
        return (this.flags & FLAG_STRIKEDTHROUGH) != 0;
    }

    public void setTextWrap(boolean b) {
        if (this.isTextWrapped() == b) {
            return;
        }
        this.setFlag(FLAG_WRAP, b);
        this.revalidate();
        this.repaint();
    }

    public boolean isTextWrapped() {
        return (this.flags & FLAG_WRAP) != 0;
    }

    public void setTextWrapWidth(int i) {
    }

    public void setTextWrapAlignment(int i) {
        if (this.getTextWrapAlignment() == i) {
            return;
        }
        this.setAlignmentFlags(i, FLAG_WRAP_ALIGN);
        this.repaint();
    }

    public int getTextWrapAlignment() {
        return this.getAlignment(FLAG_WRAP_ALIGN);
    }

    private void setPlacementFlags(int align, int flagOffset) {
        this.flags &= ~(7 * flagOffset);
        switch (align) {
            case 16: {
                this.flags |= 1 * flagOffset;
                break;
            }
            case 8: {
                this.flags |= 2 * flagOffset;
                break;
            }
            case 1: {
                this.flags |= 3 * flagOffset;
                break;
            }
            case 4: {
                this.flags |= 4 * flagOffset;
            }
        }
    }

    private int getPlacement(int flagOffset) {
        int wrapValue = this.flags & 7 * flagOffset;
        if (wrapValue == 1 * flagOffset) {
            return 16;
        }
        if (wrapValue == 2 * flagOffset) {
            return 8;
        }
        if (wrapValue == 3 * flagOffset) {
            return 1;
        }
        if (wrapValue == 4 * flagOffset) {
            return 4;
        }
        return 16;
    }

    private void setAlignmentFlags(int align, int flagOffset) {
        this.flags &= ~(7 * flagOffset);
        switch (align) {
            case 2: {
                this.flags |= 1 * flagOffset;
                break;
            }
            case 8: {
                this.flags |= 2 * flagOffset;
                break;
            }
            case 1: {
                this.flags |= 3 * flagOffset;
                break;
            }
            case 4: {
                this.flags |= 4 * flagOffset;
                break;
            }
            case 32: {
                this.flags |= 5 * flagOffset;
            }
        }
    }

    private int getAlignment(int flagOffset) {
        int wrapValue = this.flags & 7 * flagOffset;
        if (wrapValue == 1 * flagOffset) {
            return 2;
        }
        if (wrapValue == 2 * flagOffset) {
            return 8;
        }
        if (wrapValue == 3 * flagOffset) {
            return 1;
        }
        if (wrapValue == 4 * flagOffset) {
            return 4;
        }
        if (wrapValue == 5 * flagOffset) {
            return 32;
        }
        return 2;
    }

    public void setSelected(boolean b) {
        if (this.isSelected() == b) {
            return;
        }
        this.setFlag(FLAG_SELECTED, b);
        this.repaint();
    }

    public boolean isSelected() {
        return (this.flags & FLAG_SELECTED) != 0;
    }

    public void setFocus(boolean b) {
        if (this.hasFocus() == b) {
            return;
        }
        this.setFlag(FLAG_HASFOCUS, b);
        this.repaint();
    }

    public boolean hasFocus() {
        return (this.flags & FLAG_HASFOCUS) != 0;
    }

    private Rectangle getSelectionRectangle() {
        Rectangle figBounds = this.getTextBounds();
        figBounds.expand(new Insets(MapModeUtil.getMapMode((IFigure)this).DPtoLP(2), MapModeUtil.getMapMode((IFigure)this).DPtoLP(2), 0, 0));
        this.translateToParent((Translatable)figBounds);
        figBounds.intersect(this.getBounds());
        return figBounds;
    }

    private int getLineWrapPosition(String s, Font f, int w) {
        BreakIterator iter = BreakIterator.getLineInstance();
        iter.setText(s);
        int start = iter.first();
        int end = iter.next();
        if (this.getTextExtents((String)s.substring((int)start, (int)end), (Font)f).width > w) {
            iter = BreakIterator.getCharacterInstance();
            iter.setText(s);
            start = iter.first();
        }
        while ((end = iter.next()) != -1 && this.getTextExtents((String)s.substring((int)start, (int)end), (Font)f).width <= w) {
        }
        return end == -1 ? iter.last() : iter.previous();
    }

    private int getLargestSubstringConfinedTo(String s, Font f, int w) {
        float avg = MapModeUtil.getMapMode((IFigure)this).DPtoLP(FigureUtilities.getFontMetrics((Font)f).getAverageCharWidth());
        int min = 0;
        int max = s.length() + 1;
        int guess = 0;
        int guessSize = 0;
        while (max - min > 1) {
            if ((guess += (int)((float)(w - guessSize) / avg)) >= max) {
                guess = max - 1;
            }
            if (guess <= min) {
                guess = min + 1;
            }
            if ((guessSize = this.getTextExtents((String)s.substring((int)0, (int)guess), (Font)f).width) < w) {
                min = guess;
                continue;
            }
            max = guess;
        }
        return min;
    }

    private Dimension getTextExtents(String s, Font f) {
        Dimension d = FigureUtilities.getTextExtents((String)s, (Font)f);
        return new Dimension(MapModeUtil.getMapMode((IFigure)this).DPtoLP(d.width), MapModeUtil.getMapMode((IFigure)this).DPtoLP(d.height));
    }

    private class IconInfo {
        private ArrayList icons = new ArrayList();
        private Dimension totalIconSize;

        IconInfo() {
        }

        public Image getIcon(int i) {
            if (i >= this.icons.size()) {
                return null;
            }
            return (Image)this.icons.get(i);
        }

        public void setIcon(Image icon, int i) {
            if (i >= this.icons.size()) {
                int j = this.icons.size();
                while (j < i) {
                    this.icons.add(null);
                    ++j;
                }
                this.icons.add(icon);
                this.icons.trimToSize();
            } else {
                this.icons.set(i, icon);
            }
        }

        public Dimension getIconSize(int i) {
            Image img = this.getIcon(i);
            if (img != null && !img.isDisposed()) {
                org.eclipse.swt.graphics.Rectangle imgBounds = img.getBounds();
                return new Dimension(MapModeUtil.getMapMode((IFigure)WrapLabel.this).DPtoLP(imgBounds.width), MapModeUtil.getMapMode((IFigure)WrapLabel.this).DPtoLP(imgBounds.height));
            }
            return EMPTY_DIMENSION;
        }

        public int getNumberofIcons() {
            return this.icons.size();
        }

        public Dimension getTotalIconSize() {
            if (this.totalIconSize != null) {
                return this.totalIconSize;
            }
            this.totalIconSize = new Dimension(0, 0);
            int i = 0;
            while (i < this.getNumberofIcons()) {
                Dimension iconSize = this.getIconSize(i);
                if (iconSize != null) {
                    this.totalIconSize.width += iconSize.width;
                    if (iconSize.height > this.totalIconSize.height) {
                        this.totalIconSize.height = iconSize.height;
                    }
                }
                ++i;
            }
            return this.totalIconSize;
        }

        public void invalidate() {
            this.totalIconSize = null;
        }
    }
}

