/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.draw2d.ui.geometry;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Ray;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Transform;
import org.eclipse.gmf.runtime.common.core.util.Trace;
import org.eclipse.gmf.runtime.draw2d.ui.geometry.LineSeg;
import org.eclipse.gmf.runtime.draw2d.ui.internal.Draw2dDebugOptions;
import org.eclipse.gmf.runtime.draw2d.ui.internal.Draw2dPlugin;

public class PointListUtilities {
    static final int INTERSECT_TOLERANCE = 1;
    static final int MIN_LINE_LENGTH = 5;
    public static final int DEFAULT_BEZIERLINES = 16;
    static final int MAX_BEZIERLINES = 32;
    private static final int BIGDISTANCE = 32766;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.gmf.runtime.draw2d.ui.geometry.PointListUtilities");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    static boolean flattenSegments(PointList points, int straightLineTolerance) {
        boolean changed = false;
        int i = 0;
        while (i < points.size() - 1) {
            Point ptStart = points.getPoint(i);
            Point ptTerm = null;
            if (i + 1 < points.size()) {
                ptTerm = points.getPoint(i + 1);
            }
            Point ptNext = null;
            if (i + 2 < points.size()) {
                ptNext = points.getPoint(i + 2);
            }
            if (points.size() <= 2 || ptTerm == null || ptNext == null) {
                return changed;
            }
            if (PointListUtilities.sameOrientation(ptStart, ptTerm, ptNext, straightLineTolerance)) {
                PointListUtilities.removePoint(points, i + 1);
                Ray seg = new Ray(ptStart, ptTerm);
                if (seg.y < straightLineTolerance) {
                    points.setPoint(new Point(ptNext.x, ptStart.y), i + 1);
                } else if (seg.x < straightLineTolerance) {
                    points.setPoint(new Point(ptStart.x, ptNext.y), i + 1);
                }
                changed = true;
            }
            ++i;
        }
        return changed;
    }

    private static Point removePoint(PointList points, int index) {
        Point removedPt = points.getPoint(index);
        int i = index;
        while (i < points.size() - 1) {
            points.setPoint(points.getPoint(i + 1), i);
            ++i;
        }
        points.setSize(points.size() - 1);
        return removedPt;
    }

    public static boolean normalizeSegments(PointList points) {
        return PointListUtilities.normalizeSegments(points, 0);
    }

    public static boolean normalizeSegments(PointList points, int straightLineTolerance) {
        boolean hasChanged = false;
        int i = 1;
        while (i < points.size() - 1) {
            Ray nextVector = new Ray(points.getPoint(i), points.getPoint(i - 1));
            int nextLength = (int)nextVector.length();
            if (nextLength <= straightLineTolerance) {
                points.removePoint(i);
                hasChanged = true;
            }
            ++i;
        }
        if (hasChanged |= PointListUtilities.flattenSegments(points, straightLineTolerance)) {
            PointListUtilities.normalizeSegments(points, straightLineTolerance);
        }
        return hasChanged;
    }

    public static Point getPointsSupremum(PointList points) {
        Point theSupremum = points.getFirstPoint();
        int i = 1;
        while (i < points.size()) {
            Point other = points.getPoint(i);
            theSupremum = new Point(Math.max(theSupremum.x, other.x), Math.max(theSupremum.y, other.y));
            ++i;
        }
        return theSupremum;
    }

    public static Point getPointsInfimum(PointList points) {
        Point theInfimum = points.getFirstPoint();
        int i = 1;
        while (i < points.size()) {
            Point other = points.getPoint(i);
            theInfimum = new Point(Math.min(theInfimum.x, other.x), Math.min(theInfimum.y, other.y));
            ++i;
        }
        return theInfimum;
    }

    public static PointList createPointsFromRect(Rectangle rBox) {
        PointList points = new PointList(5);
        Point pt = new Point(rBox.getLeft().x, rBox.getTop().y);
        points.addPoint(pt);
        pt = new Point(rBox.getRight().x, rBox.getTop().y);
        points.addPoint(pt);
        pt = new Point(rBox.getRight().x, rBox.getBottom().y);
        points.addPoint(pt);
        pt = new Point(rBox.getLeft().x, rBox.getBottom().y);
        points.addPoint(pt);
        pt = new Point(rBox.getLeft().x, rBox.getTop().y);
        points.addPoint(pt);
        return points;
    }

    private static void reAdjustBoxSize(List boxSegs, Point containedPoint) {
        if (!$assertionsDisabled && boxSegs.size() != 4) {
            throw new AssertionError();
        }
        LineSeg seg = PointListUtilities.getNearestSegment(boxSegs, containedPoint.x, containedPoint.y);
        LineSeg newSeg = seg.getParallelLineSegThroughPoint(containedPoint);
        ListIterator li = boxSegs.listIterator();
        LineSeg prev = null;
        LineSeg next = null;
        LineSeg current = null;
        if (li.hasNext()) {
            current = (LineSeg)li.next();
        }
        while (current != null) {
            next = li.hasNext() ? (LineSeg)li.next() : null;
            if (current.equals(seg)) {
                if (prev != null) {
                    prev.setTerminus(newSeg.getOrigin());
                }
                current.setOrigin(newSeg.getOrigin());
                current.setTerminus(newSeg.getTerminus());
                if (next != null) {
                    next.setOrigin(newSeg.getTerminus());
                }
            }
            current = next;
        }
    }

    public static PointList routeAroundRect(PointList points, Rectangle rBox, int nSmoothFactor, boolean bIncludeIntersectionPoints, int nBuffer) {
        Point infimumPoint = PointListUtilities.getPointsInfimum(points);
        Point supremumPoint = PointListUtilities.getPointsSupremum(points);
        Ray diameter = new Ray(infimumPoint, supremumPoint);
        Rectangle rPoly = new Rectangle(infimumPoint.x, infimumPoint.y, diameter.x, diameter.y);
        rPoly.expand(1, 1);
        if (rPoly.intersects(rBox)) {
            PointList rBoxPoly = PointListUtilities.createPointsFromRect(rBox);
            Point firstPoint = points.getFirstPoint();
            Point lastPoint = points.getLastPoint();
            boolean bFPContained = rBox.contains(firstPoint);
            boolean bLPContained = rBox.contains(lastPoint);
            if (bFPContained || bLPContained) {
                List boxSegs = PointListUtilities.getLineSegments(rBoxPoly);
                if (bFPContained) {
                    PointListUtilities.reAdjustBoxSize(boxSegs, firstPoint);
                }
                if (bLPContained) {
                    PointListUtilities.reAdjustBoxSize(boxSegs, lastPoint);
                }
                rBoxPoly.removeAllPoints();
                ListIterator li = boxSegs.listIterator();
                while (li.hasNext()) {
                    LineSeg seg = (LineSeg)li.next();
                    rBoxPoly.addPoint(seg.getOrigin());
                    if (li.hasNext()) continue;
                    rBoxPoly.addPoint(seg.getTerminus());
                }
            }
            return PointListUtilities.routeAroundPoly(points, rBoxPoly, nSmoothFactor, true, bIncludeIntersectionPoints, nBuffer);
        }
        return null;
    }

    public static List getLineSegments(PointList points) {
        if (points.size() <= 1) {
            return new ArrayList(0);
        }
        ArrayList<LineSeg> lines = new ArrayList<LineSeg>(points.size() - 1);
        int i = 0;
        while (i < points.size() - 1) {
            lines.add(new LineSeg(points.getPoint(i), points.getPoint(i + 1)));
            ++i;
        }
        return lines;
    }

    public static PointList routeAroundPoly(PointList points, PointList poly, int nSmoothFactor, boolean bShortestDistance, boolean bIncludeIntersectionPoints, int nBuffer) {
        LineSeg pCurBoxSeg = null;
        Point ptIntersect = new Point();
        PointList rPolyPoints = new PointList(points.size() * 2);
        List rBoxSegments = PointListUtilities.getLineSegments(poly);
        Point ptIntersect1 = null;
        Point ptPrevIntersect = new Point(-100, -100);
        int nPointsSinceFirstIntersection = 0;
        int nCurrentLength1 = 0;
        int nCurrentLength = 0;
        List mySegments = PointListUtilities.getLineSegments(points);
        ListIterator listIter = mySegments.listIterator();
        while (listIter.hasNext()) {
            LineSeg pSegment = (LineSeg)listIter.next();
            boolean bFoundIntersects = false;
            ListIterator boxIter = rBoxSegments.listIterator();
            while (boxIter.hasNext()) {
                LineSeg pBoxSegment = (LineSeg)boxIter.next();
                ptIntersect = pSegment.intersect(pBoxSegment, 1);
                if (ptIntersect == null) continue;
                if (Math.abs(ptPrevIntersect.x - ptIntersect.x) > 2 || Math.abs(ptPrevIntersect.y - ptIntersect.y) > 2) {
                    if (ptIntersect1 != null) {
                        LineSeg pCurBoxSeg2;
                        Point ptIntersect2 = null;
                        PointList newRoutePoints = new PointList();
                        int nCurrentLength2 = nCurrentLength + (int)((double)pSegment.distanceAlong(ptIntersect) * pSegment.length());
                        if (nCurrentLength1 < nCurrentLength2) {
                            ptIntersect2 = new Point(ptIntersect);
                            pCurBoxSeg2 = pBoxSegment;
                        } else {
                            ptIntersect2 = new Point(ptIntersect1);
                            pCurBoxSeg2 = pCurBoxSeg;
                            ptIntersect1 = new Point(ptIntersect);
                            pCurBoxSeg = pBoxSegment;
                        }
                        PointListUtilities.getRoutedPoints(points, newRoutePoints, ptIntersect1, ptIntersect2, rPolyPoints.getLastPoint(), pSegment.getTerminus(), pCurBoxSeg, pCurBoxSeg2, poly, nSmoothFactor, bShortestDistance, bIncludeIntersectionPoints, nBuffer);
                        while (nPointsSinceFirstIntersection > 0) {
                            rPolyPoints.removePoint(rPolyPoints.size() - 1);
                            --nPointsSinceFirstIntersection;
                        }
                        int i = 0;
                        while (i < newRoutePoints.size()) {
                            rPolyPoints.addPoint(newRoutePoints.getPoint(i));
                            ++i;
                        }
                        rPolyPoints.addPoint(new Point(pSegment.getTerminus()));
                        ptIntersect1 = null;
                        bFoundIntersects = true;
                        break;
                    }
                    ptIntersect1 = new Point(ptIntersect);
                    pCurBoxSeg = pBoxSegment;
                    rPolyPoints.addPoint(new Point(pSegment.getOrigin()));
                    nPointsSinceFirstIntersection = 0;
                    nCurrentLength1 = nCurrentLength + (int)((double)pSegment.distanceAlong(ptIntersect) * pSegment.length());
                }
                ptPrevIntersect = new Point(ptIntersect);
            }
            nCurrentLength = (int)((double)nCurrentLength + pSegment.length());
            if (bFoundIntersects) continue;
            rPolyPoints.addPoint(new Point(pSegment.getOrigin()));
            if (ptIntersect1 != null) {
                ++nPointsSinceFirstIntersection;
            }
            if (listIter.hasNext()) continue;
            rPolyPoints.addPoint(new Point(pSegment.getTerminus()));
        }
        if (points.size() != rPolyPoints.size()) {
            return rPolyPoints;
        }
        return null;
    }

    public static PointList copyPoints(PointList pointsFrom) {
        PointList points = new PointList(pointsFrom.size());
        PointListUtilities.copyFrom(points, pointsFrom);
        return points;
    }

    private static void copyFrom(PointList pointsTo, PointList pointsFrom) {
        pointsTo.removeAllPoints();
        int i = 0;
        while (i < pointsFrom.size()) {
            pointsTo.addPoint(pointsFrom.getPoint(i));
            ++i;
        }
    }

    private static int addRoutedPoints(PointList routePoints, LineSeg pCurBoxSeg1, LineSeg pCurBoxSeg2, PointList routePoly, boolean bForward, int nBuffer) {
        Point pNewPoint = null;
        float fOffset = 0.0f;
        int nDistance = 0;
        List rBoxSegments = PointListUtilities.getLineSegments(routePoly);
        ListIterator boxIter = bForward ? rBoxSegments.listIterator() : rBoxSegments.listIterator(rBoxSegments.size());
        while (!(bForward ? !boxIter.hasNext() : !boxIter.hasPrevious())) {
            LineSeg seg;
            LineSeg lineSeg = seg = bForward ? (LineSeg)boxIter.next() : (LineSeg)boxIter.previous();
            if (seg.equals(pCurBoxSeg1)) break;
        }
        do {
            Point ptEnd;
            fOffset = (float)nBuffer / (float)pCurBoxSeg1.length();
            if (bForward) {
                fOffset = (float)((double)fOffset + 1.0);
                ptEnd = pCurBoxSeg1.getTerminus();
            } else {
                fOffset = (float)((double)fOffset * -1.0);
                ptEnd = pCurBoxSeg1.getOrigin();
            }
            if (routePoints.size() > 0) {
                nDistance = (int)((double)nDistance + routePoints.getLastPoint().getDistance(ptEnd));
            }
            pNewPoint = nBuffer > 0 ? new Point(pCurBoxSeg1.locatePoint(fOffset, nBuffer, LineSeg.Sign.POSITIVE)) : new Point(ptEnd);
            routePoints.addPoint(pNewPoint);
            if (pCurBoxSeg1.equals(pCurBoxSeg2)) continue;
            if (bForward) {
                if (!boxIter.hasNext()) {
                    boxIter = rBoxSegments.listIterator();
                }
                pCurBoxSeg1 = (LineSeg)boxIter.next();
                continue;
            }
            if (!boxIter.hasPrevious()) {
                boxIter = rBoxSegments.listIterator(rBoxSegments.size());
            }
            pCurBoxSeg1 = (LineSeg)boxIter.previous();
        } while (!pCurBoxSeg1.equals(pCurBoxSeg2));
        return nDistance;
    }

    private static void getRoutedPoints(PointList points, PointList newRoutePoints, Point ptIntersect1, Point ptIntersect2, Point ptPrev, Point ptNext, LineSeg pCurBoxSeg1, LineSeg pCurBoxSeg2, PointList routePoly, int nSmoothFactor, boolean bShortestDistance, boolean bIncludeIntersectionPoints, int nBuffer) {
        PointList newRoutePoints1 = new PointList();
        PointList newRoutePoints2 = new PointList();
        Point ptAbove = new Point(ptIntersect1);
        if (nBuffer > 0) {
            float dDistance = pCurBoxSeg1.distanceAlong(ptIntersect1);
            ptAbove = pCurBoxSeg1.locatePoint(dDistance, nBuffer, LineSeg.Sign.POSITIVE);
        }
        newRoutePoints1.addPoint(new Point(ptAbove));
        newRoutePoints2.addPoint(new Point(ptAbove));
        int nDistance1 = 0;
        int nDistance2 = 0;
        LineSeg pCurSeg = pCurBoxSeg1;
        nDistance1 += PointListUtilities.addRoutedPoints(newRoutePoints1, pCurSeg, pCurBoxSeg2, routePoly, true, nBuffer);
        nDistance1 = (int)((double)nDistance1 + newRoutePoints1.getLastPoint().getDistance(ptIntersect2));
        pCurSeg = pCurBoxSeg1;
        nDistance2 += PointListUtilities.addRoutedPoints(newRoutePoints2, pCurSeg, pCurBoxSeg2, routePoly, false, nBuffer);
        nDistance2 = (int)((double)nDistance2 + newRoutePoints2.getLastPoint().getDistance(ptIntersect2));
        ptAbove = new Point(ptIntersect2);
        if (nBuffer > 0) {
            float dDistance = pCurBoxSeg2.distanceAlong(ptIntersect2);
            ptAbove = pCurBoxSeg2.locatePoint(dDistance, nBuffer, LineSeg.Sign.POSITIVE);
        }
        newRoutePoints1.addPoint(new Point(ptAbove));
        newRoutePoints2.addPoint(new Point(ptAbove));
        if (nDistance1 < nDistance2 && bShortestDistance || nDistance1 > nDistance2 && !bShortestDistance) {
            PointListUtilities.copyFrom(newRoutePoints, newRoutePoints1);
        } else {
            PointListUtilities.copyFrom(newRoutePoints, newRoutePoints2);
        }
        if (!bIncludeIntersectionPoints && newRoutePoints.size() >= 3) {
            PointList checkPoints = new PointList(newRoutePoints.size() + 2);
            checkPoints.addPoint(new Point(ptPrev));
            int i = 0;
            while (i < newRoutePoints.size()) {
                checkPoints.addPoint(new Point(newRoutePoints.getPoint(i)));
                ++i;
            }
            checkPoints.addPoint(new Point(ptNext));
            int nIndex = 0;
            Point ptStart = checkPoints.getPoint(nIndex++);
            Point ptCheckSkip = checkPoints.getPoint(nIndex++);
            Object ptEnd = checkPoints.getPoint(nIndex++);
            List polySegments = PointListUtilities.getLineSegments(routePoly);
            newRoutePoints.removeAllPoints();
            while (ptEnd != null) {
                LineSeg tempSeg = new LineSeg(ptStart, (Point)ptEnd);
                Point ptIntersect = new Point();
                boolean bAddPoint = false;
                ListIterator segIter = polySegments.listIterator();
                while (segIter.hasNext()) {
                    LineSeg pPolySegment = (LineSeg)segIter.next();
                    ptIntersect = tempSeg.intersect(pPolySegment, 1);
                    if (ptIntersect == null) continue;
                    bAddPoint = true;
                    break;
                }
                if (bAddPoint) {
                    newRoutePoints.addPoint(new Point(ptCheckSkip));
                    ptStart = new Point(ptCheckSkip);
                }
                ptCheckSkip = new Point(ptEnd);
                ptEnd = nIndex < checkPoints.size() ? checkPoints.getPoint(nIndex++) : null;
            }
        }
        if (nSmoothFactor > 0) {
            PointList tempPoly = PointListUtilities.calcSmoothPolyline(newRoutePoints, nSmoothFactor, 16);
            PointListUtilities.copyFrom(newRoutePoints, tempPoly);
        }
    }

    public static final PointList calcSmoothPolyline(PointList points, int nSmoothFactor, int nBezierSteps) {
        PointList theBezierPoints = PointListUtilities.calcBezier(points, nSmoothFactor, 0, points.size() - 1);
        return PointListUtilities.calcApproxPolylineFromBezier(theBezierPoints, nBezierSteps);
    }

    public static PointList calcSmoothPolyline(PointList points, int nSmoothFactor, int nBezierSteps, int nStartIndex, int nEndIndex) {
        PointList theBezierPoints = PointListUtilities.calcBezier(points, nSmoothFactor, nStartIndex, nEndIndex);
        return PointListUtilities.calcApproxPolylineFromBezier(theBezierPoints, nBezierSteps);
    }

    private static PointList calcBezier(PointList points, int nSmoothFactor, int nStartIndex, int nEndIndex) {
        Point ptPrevControl = null;
        PointList theBezierPoints = new PointList(points.size() * 2);
        List theSegments = PointListUtilities.getLineSegments(points);
        int i = 0;
        while (i < theSegments.size()) {
            LineSeg pLineSeg = (LineSeg)theSegments.get(i);
            double dLineLength = pLineSeg.length();
            double dControlLength = dLineLength * (double)nSmoothFactor / 100.0;
            boolean bAddToBezier = false;
            if (i >= nStartIndex && i <= nEndIndex) {
                bAddToBezier = true;
            } else if (i > nEndIndex) {
                return theBezierPoints;
            }
            if (dLineLength > 5.0) {
                Point ptStartControl = new Point();
                Point ptTerminusControl = new Point();
                Point ptStart = new Point(pLineSeg.getOrigin());
                Point ptTerminus = new Point(pLineSeg.getTerminus());
                if (theBezierPoints.size() == 0 && bAddToBezier) {
                    theBezierPoints.addPoint(ptStart);
                }
                if (ptPrevControl != null) {
                    LineSeg prevControlSeg = new LineSeg(ptPrevControl, ptStart);
                    ptStartControl = new Point();
                    prevControlSeg.pointOn((int)Math.round(prevControlSeg.length() + dControlLength), LineSeg.KeyPoint.ORIGIN, ptStartControl);
                } else {
                    ptStartControl = new Point();
                    pLineSeg.pointOn((int)Math.round(dControlLength), LineSeg.KeyPoint.ORIGIN, ptStartControl);
                }
                if (bAddToBezier) {
                    theBezierPoints.addPoint(ptStartControl);
                }
                LineSeg pNextSeg = null;
                if (i + 1 < theSegments.size()) {
                    pNextSeg = (LineSeg)theSegments.get(i + 1);
                    while (pNextSeg != null && pNextSeg.length() < 5.0) {
                        pNextSeg = ++i + 1 < theSegments.size() ? (LineSeg)theSegments.get(i + 1) : null;
                    }
                }
                if (pNextSeg != null) {
                    Ray ptVector1 = new Ray(pLineSeg.getOrigin(), pLineSeg.getTerminus());
                    Ray ptVector2 = new Ray(pNextSeg.getOrigin(), pNextSeg.getTerminus());
                    double dNewAngle = 0.0;
                    LineSeg.TrigValues val = pLineSeg.getTrigValues(ptVector2);
                    dNewAngle = Math.atan2(-val.sinTheta, -val.cosTheta);
                    dNewAngle = dNewAngle > 0.0 ? (Math.PI - dNewAngle) / -2.0 : (-Math.PI - dNewAngle) / -2.0;
                    Transform trans = new Transform();
                    trans.setRotation(dNewAngle);
                    Point ptVector1Prime = trans.getTransformed(new Point(ptVector1.x, ptVector1.y));
                    LineSeg nextControlSeg = new LineSeg(new Point(0, 0), new Point(ptVector1Prime.x, ptVector1Prime.y));
                    Point ptProjection = new Point();
                    nextControlSeg.pointOn((int)Math.round(dControlLength), LineSeg.KeyPoint.ORIGIN, ptProjection);
                    ptTerminusControl = new Point(pLineSeg.getTerminus().x - ptProjection.x, pLineSeg.getTerminus().y - ptProjection.y);
                } else {
                    pLineSeg.pointOn((int)Math.round(dLineLength - dControlLength), LineSeg.KeyPoint.ORIGIN, ptTerminusControl);
                }
                ptPrevControl = new Point(ptTerminusControl);
                if (bAddToBezier) {
                    theBezierPoints.addPoint(ptTerminusControl);
                    theBezierPoints.addPoint(ptTerminus);
                }
            }
            ++i;
        }
        return theBezierPoints;
    }

    private static PointList calcApproxPolylineFromBezier(PointList points, int nBezierSteps) {
        PointList thePolyPoints = new PointList(points.size() * nBezierSteps + 2);
        boolean bStart = true;
        if (points.size() < 4) {
            return thePolyPoints;
        }
        Point ptCtl1 = new Point();
        int i = 0;
        while (i < points.size() - 3) {
            if (bStart) {
                ptCtl1 = new Point(points.getPoint(i));
                bStart = false;
            } else {
                thePolyPoints.removePoint(thePolyPoints.size() - 1);
            }
            Point ptCtl2 = new Point(points.getPoint(i + 1));
            Point ptCtl3 = new Point(points.getPoint(i + 2));
            Point ptCtl4 = new Point(points.getPoint(i + 3));
            if (!PointListUtilities.BezierToLines(thePolyPoints, ptCtl1, ptCtl2, ptCtl3, ptCtl4, nBezierSteps)) {
                return null;
            }
            ptCtl1 = new Point(ptCtl4);
            i += 3;
        }
        thePolyPoints.setPoint(points.getPoint(0), 0);
        thePolyPoints.setPoint(points.getPoint(points.size() - 1), thePolyPoints.size() - 1);
        return thePolyPoints;
    }

    private static boolean BezierToLines(PointList thePolyPoints, Point ptCtl1, Point ptCtl2, Point ptCtl3, Point ptCtl4, int nSteps) {
        int i;
        boolean bRC = true;
        nSteps = Math.min(32, nSteps);
        double[] lpWorkX = new double[3 * nSteps + 2];
        double[] lpWorkY = new double[3 * nSteps + 2];
        lpWorkX[0] = ptCtl1.x;
        lpWorkX[1] = ptCtl2.x;
        lpWorkX[2] = ptCtl3.x;
        lpWorkX[3] = ptCtl4.x;
        lpWorkY[0] = ptCtl1.y;
        lpWorkY[1] = ptCtl2.y;
        lpWorkY[2] = ptCtl3.y;
        lpWorkY[3] = ptCtl4.y;
        int nLinePoints = 2;
        int nTotalPoints = 4;
        while (nLinePoints <= nSteps) {
            i = nTotalPoints - 1;
            while (i > 0) {
                lpWorkX[2 * i] = lpWorkX[i];
                lpWorkY[2 * i] = lpWorkY[i];
                --i;
            }
            nTotalPoints = 2 * nTotalPoints - 1;
            i = nTotalPoints - 2;
            while (i > 0) {
                lpWorkX[i] = (lpWorkX[i - 1] + lpWorkX[i + 1]) / 2.0;
                lpWorkY[i] = (lpWorkY[i - 1] + lpWorkY[i + 1]) / 2.0;
                i -= 2;
            }
            i = nTotalPoints - 3;
            while (i > 0) {
                if (i % 6 != 0) {
                    lpWorkX[i] = (lpWorkX[i - 1] + lpWorkX[i + 1]) / 2.0;
                    lpWorkY[i] = (lpWorkY[i - 1] + lpWorkY[i + 1]) / 2.0;
                }
                i -= 2;
            }
            i = nTotalPoints - 4;
            while (i > 0) {
                lpWorkX[i] = (lpWorkX[i - 1] + lpWorkX[i + 1]) / 2.0;
                lpWorkY[i] = (lpWorkY[i - 1] + lpWorkY[i + 1]) / 2.0;
                i -= 6;
            }
            nLinePoints = nTotalPoints / 3 + 1;
        }
        i = 0;
        while (i < nSteps) {
            Point ptTemp = new Point();
            int j = 3 * i;
            ptTemp.x = (int)Math.round(lpWorkX[j]);
            ptTemp.y = (int)Math.round(lpWorkY[j]);
            thePolyPoints.addPoint(ptTemp);
            ++i;
        }
        return bRC;
    }

    public static Point pointOn(PointList points, long theDistance, LineSeg.KeyPoint fromKeyPoint, Point ptResult) {
        List mySegments = PointListUtilities.getLineSegments(points);
        return PointListUtilities.pointOn(mySegments, theDistance, fromKeyPoint, ptResult);
    }

    public static long getPointsLength(PointList points) {
        List segs = PointListUtilities.getLineSegments(points);
        return PointListUtilities.length(segs);
    }

    protected static long length(List mySegments) {
        long theLength = 0L;
        ListIterator lineIter = mySegments.listIterator();
        while (lineIter.hasNext()) {
            LineSeg aSegment = (LineSeg)lineIter.next();
            theLength += Math.round(aSegment.length());
        }
        return theLength;
    }

    public static LineSeg getNearestSegment(List mySegments, int xCoord, int yCoord) {
        long minDistance = 32766L;
        long nextDistance = 0L;
        LineSeg closeSegment = null;
        LineSeg firstSegment = mySegments.isEmpty() ? null : (LineSeg)mySegments.get(0);
        ListIterator lineIter = mySegments.listIterator();
        while (lineIter.hasNext()) {
            LineSeg aSegment = (LineSeg)lineIter.next();
            nextDistance = aSegment.distanceToPoint(xCoord, yCoord);
            if (nextDistance >= minDistance) continue;
            closeSegment = aSegment;
            minDistance = nextDistance;
        }
        if (closeSegment != null) {
            return closeSegment;
        }
        return firstSegment;
    }

    protected static Point pointOn(List mySegments, long theDistance, LineSeg.KeyPoint fromKeyPoint, Point ptResult) {
        long thisLength = PointListUtilities.length(mySegments);
        long halfLength = thisLength / 2L;
        if (theDistance >= thisLength) {
            if (fromKeyPoint == LineSeg.KeyPoint.ORIGIN) {
                ((LineSeg)mySegments.get(mySegments.size() - 1)).pointOn(theDistance - thisLength, LineSeg.KeyPoint.TERMINUS, ptResult);
                return ptResult;
            }
            if (fromKeyPoint == LineSeg.KeyPoint.MIDPOINT) {
                ((LineSeg)mySegments.get(mySegments.size() - 1)).pointOn(theDistance - halfLength, LineSeg.KeyPoint.TERMINUS, ptResult);
                return ptResult;
            }
            if (fromKeyPoint == LineSeg.KeyPoint.TERMINUS) {
                ((LineSeg)mySegments.get(mySegments.size() - 1)).pointOn(theDistance, LineSeg.KeyPoint.TERMINUS, ptResult);
                return ptResult;
            }
            IllegalArgumentException iae = new IllegalArgumentException();
            Draw2dPlugin draw2dPlugin = Draw2dPlugin.getInstance();
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.gmf.runtime.draw2d.ui.geometry.PointListUtilities");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Trace.throwing((Plugin)draw2dPlugin, (String)Draw2dDebugOptions.EXCEPTIONS_THROWING, (Class)clazz, (String)"pointOn()", (Throwable)iae);
            throw iae;
        }
        if (theDistance < 0L) {
            if (fromKeyPoint == LineSeg.KeyPoint.ORIGIN) {
                ((LineSeg)mySegments.get(0)).pointOn(theDistance, fromKeyPoint, ptResult);
                return ptResult;
            }
            if (fromKeyPoint == LineSeg.KeyPoint.MIDPOINT) {
                return PointListUtilities.pointOn(mySegments, halfLength + theDistance, LineSeg.KeyPoint.ORIGIN, ptResult);
            }
            if (fromKeyPoint == LineSeg.KeyPoint.TERMINUS) {
                ((LineSeg)mySegments.get(mySegments.size() - 1)).pointOn(theDistance, fromKeyPoint, ptResult);
                return ptResult;
            }
            IllegalArgumentException iae = new IllegalArgumentException();
            Draw2dPlugin draw2dPlugin = Draw2dPlugin.getInstance();
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.gmf.runtime.draw2d.ui.geometry.PointListUtilities");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Trace.throwing((Plugin)draw2dPlugin, (String)Draw2dDebugOptions.EXCEPTIONS_THROWING, (Class)clazz, (String)"pointOn()", (Throwable)iae);
            throw iae;
        }
        LocateInfo locateInfo = new LocateInfo();
        if (!PointListUtilities.locateSegment(mySegments, (double)theDistance / (double)thisLength, fromKeyPoint, locateInfo)) {
            return null;
        }
        locateInfo.theSegment.pointOn(locateInfo.remainingDist, fromKeyPoint == LineSeg.KeyPoint.MIDPOINT ? LineSeg.KeyPoint.ORIGIN : fromKeyPoint, ptResult);
        return ptResult;
    }

    private static boolean locateSegment(List mySegments, double pctDist, LineSeg.KeyPoint fromKeyPoint, LocateInfo locateInfo) {
        double thePctDist = pctDist;
        if (pctDist < 0.0) {
            thePctDist = 0.0;
        } else if (1.0 < pctDist) {
            thePctDist = 1.0;
        }
        long theLength = PointListUtilities.length(mySegments);
        long remainingLength = Math.round(thePctDist * (double)theLength);
        long nextLength = 0L;
        locateInfo.theSegment = null;
        if (fromKeyPoint == LineSeg.KeyPoint.MIDPOINT || fromKeyPoint == LineSeg.KeyPoint.ORIGIN) {
            if (fromKeyPoint == LineSeg.KeyPoint.MIDPOINT) {
                remainingLength += theLength / 2L;
            }
            ListIterator lineIter = mySegments.listIterator();
            while (lineIter.hasNext()) {
                LineSeg aSegment = (LineSeg)lineIter.next();
                nextLength = Math.round(aSegment.length());
                if (nextLength >= remainingLength) {
                    locateInfo.theSegment = aSegment;
                    break;
                }
                remainingLength -= nextLength;
            }
        } else if (fromKeyPoint == LineSeg.KeyPoint.TERMINUS) {
            ListIterator lineIter = mySegments.listIterator(mySegments.size());
            while (lineIter.hasPrevious()) {
                LineSeg aSegment = (LineSeg)lineIter.previous();
                nextLength = Math.round(aSegment.length());
                if (nextLength >= remainingLength) {
                    locateInfo.theSegment = aSegment;
                    break;
                }
                remainingLength -= nextLength;
            }
        } else {
            IllegalArgumentException iae = new IllegalArgumentException();
            Draw2dPlugin draw2dPlugin = Draw2dPlugin.getInstance();
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.gmf.runtime.draw2d.ui.geometry.PointListUtilities");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Trace.throwing((Plugin)draw2dPlugin, (String)Draw2dDebugOptions.EXCEPTIONS_THROWING, (Class)clazz, (String)"pointOn()", (Throwable)iae);
            throw iae;
        }
        locateInfo.remainingDist = remainingLength;
        return true;
    }

    protected static double distanceAlong(List mySegments, Point aPoint) {
        LineSeg theSegment = PointListUtilities.getNearestSegment(mySegments, aPoint.x, aPoint.y);
        double linePct = PointListUtilities.segmentDistance(mySegments, theSegment, LineSeg.KeyPoint.ORIGIN);
        double segmentPct = theSegment.distanceAlong(aPoint);
        if (0.0 <= segmentPct && segmentPct <= 1.0) {
            long polyLength = PointListUtilities.length(mySegments);
            if (polyLength != 0L) {
                linePct += segmentPct * (theSegment.length() / (double)polyLength);
            }
            return linePct;
        }
        return segmentPct;
    }

    protected static double segmentDistance(List mySegments, LineSeg theSegment, LineSeg.KeyPoint uptoKeyPoint) {
        long accumulatedLength = 0L;
        ListIterator lineIter = mySegments.listIterator();
        while (lineIter.hasNext()) {
            LineSeg aSegment = (LineSeg)lineIter.next();
            if (theSegment.equals(aSegment)) {
                long polyLength;
                if (uptoKeyPoint != LineSeg.KeyPoint.ORIGIN) {
                    if (uptoKeyPoint == LineSeg.KeyPoint.MIDPOINT) {
                        accumulatedLength = (long)((double)accumulatedLength + aSegment.length() / 2.0);
                    } else if (uptoKeyPoint == LineSeg.KeyPoint.TERMINUS) {
                        accumulatedLength = (long)((double)accumulatedLength + aSegment.length());
                    } else {
                        IllegalArgumentException iae = new IllegalArgumentException();
                        Draw2dPlugin draw2dPlugin = Draw2dPlugin.getInstance();
                        Class<?> clazz = class$0;
                        if (clazz == null) {
                            try {
                                clazz = class$0 = Class.forName("org.eclipse.gmf.runtime.draw2d.ui.geometry.PointListUtilities");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        Trace.throwing((Plugin)draw2dPlugin, (String)Draw2dDebugOptions.EXCEPTIONS_THROWING, (Class)clazz, (String)"pointOn()", (Throwable)iae);
                        throw iae;
                    }
                }
                if ((polyLength = PointListUtilities.length(mySegments)) != 0L) {
                    return (double)accumulatedLength / (double)polyLength;
                }
                return 0.0;
            }
            accumulatedLength = (long)((double)accumulatedLength + aSegment.length());
        }
        return 0.0;
    }

    public static PointList routeAroundPoint(PointList points, Point ptCenter, int nHeight, int nWidth, int nSmoothFactor, int nInclineOffset, boolean bTop) {
        List mySegments = PointListUtilities.getLineSegments(points);
        long nPolyLength = PointListUtilities.length(mySegments);
        long nCenterDistance = Math.round(PointListUtilities.distanceAlong(mySegments, ptCenter) * (double)nPolyLength);
        Point ptMidStart = new Point();
        PointListUtilities.pointOn(mySegments, nCenterDistance - (long)(nWidth / 2), LineSeg.KeyPoint.ORIGIN, ptMidStart);
        Point ptMidEnd = new Point();
        PointListUtilities.pointOn(mySegments, nCenterDistance + (long)(nWidth / 2), LineSeg.KeyPoint.ORIGIN, ptMidEnd);
        LineSeg lineNew = new LineSeg(ptMidStart, ptMidEnd);
        Point ptStart = new Point();
        lineNew.pointOn(nInclineOffset, LineSeg.KeyPoint.ORIGIN, ptStart);
        LocateInfo locateInfo = new LocateInfo();
        if (!PointListUtilities.locateSegment(mySegments, (double)(nCenterDistance - (long)nWidth / 2L) / (double)nPolyLength, LineSeg.KeyPoint.ORIGIN, locateInfo)) {
            return null;
        }
        LineSeg pStartSeg = locateInfo.theSegment;
        Point ptEnd = new Point();
        lineNew.pointOn(nInclineOffset, LineSeg.KeyPoint.TERMINUS, ptEnd);
        if (!PointListUtilities.locateSegment(mySegments, (double)(nCenterDistance + (long)nWidth / 2L) / (double)nPolyLength, LineSeg.KeyPoint.ORIGIN, locateInfo)) {
            return null;
        }
        LineSeg pEndSeg = locateInfo.theSegment;
        float fSlope = lineNew.slope();
        int nDir = 1;
        if (bTop && fSlope <= 0.0f || !bTop && fSlope > 0.0f) {
            nDir *= -1;
        }
        LineSeg lineStart = new LineSeg(LineSeg.KeyPoint.ORIGIN, ptStart.x, ptStart.y, lineNew.perpSlope(), nHeight, nDir);
        LineSeg lineEnd = new LineSeg(LineSeg.KeyPoint.ORIGIN, ptEnd.x, ptEnd.y, lineNew.perpSlope(), nHeight, nDir);
        PointList rRotatedBox = new PointList();
        rRotatedBox.addPoint(new Point(ptMidStart));
        rRotatedBox.addPoint(new Point(lineStart.getTerminus()));
        rRotatedBox.addPoint(new Point(lineEnd.getTerminus()));
        rRotatedBox.addPoint(new Point(ptMidEnd));
        rRotatedBox.addPoint(new Point(ptMidStart));
        PointList rPolyPoints = new PointList(rRotatedBox.size() * 32 + points.size());
        boolean bFoundStart = false;
        boolean bFoundEnd = false;
        int nPointsSinceStart = 0;
        List boxSegments = PointListUtilities.getLineSegments(rRotatedBox);
        ListIterator lineIter = mySegments.listIterator();
        while (lineIter.hasNext()) {
            LineSeg pSegment = (LineSeg)lineIter.next();
            if (pSegment.equals(pStartSeg)) {
                rPolyPoints.addPoint(new Point(pSegment.getOrigin()));
                bFoundStart = true;
            }
            if (pSegment == pEndSeg) {
                PointList newRoutePoints = new PointList(rRotatedBox.size() * 32);
                LineSeg pCurSeg1 = (LineSeg)boxSegments.get(0);
                LineSeg pCurSeg2 = (LineSeg)boxSegments.get(boxSegments.size() - 1);
                PointListUtilities.getRoutedPoints(points, newRoutePoints, ptMidStart, ptMidEnd, ptMidStart, ptMidEnd, pCurSeg1, pCurSeg2, rRotatedBox, nSmoothFactor, false, true, 0);
                while (nPointsSinceStart > 0) {
                    rPolyPoints.removePoint(rPolyPoints.size() - 1);
                    --nPointsSinceStart;
                }
                int i = 0;
                while (i < newRoutePoints.size()) {
                    rPolyPoints.addPoint(new Point(newRoutePoints.getPoint(i)));
                    ++i;
                }
                rPolyPoints.addPoint(new Point(pSegment.getTerminus()));
                bFoundEnd = true;
                continue;
            }
            rPolyPoints.addPoint(new Point(pSegment.getOrigin()));
            if (bFoundStart) {
                ++nPointsSinceStart;
            }
            if (lineIter.hasNext()) continue;
            rPolyPoints.addPoint(new Point(pSegment.getTerminus()));
        }
        if (bFoundEnd) {
            return rPolyPoints;
        }
        return null;
    }

    public static int findNearestLineSegIndexOfPoint(PointList points, Point ptCoord) {
        List mySegments = PointListUtilities.getLineSegments(points);
        ListIterator lineIter = mySegments.listIterator();
        int nNextIndex = 0;
        int nMinIndex = 0;
        long minDistance = 32766L;
        long nextDistance = 0L;
        while (lineIter.hasNext()) {
            LineSeg aSegment = (LineSeg)lineIter.next();
            ++nNextIndex;
            nextDistance = aSegment.distanceToPoint(ptCoord.x, ptCoord.y);
            if (nextDistance >= minDistance) continue;
            minDistance = nextDistance;
            nMinIndex = nNextIndex;
        }
        return nMinIndex;
    }

    public static boolean findIntersections(PointList points, PointList poly, PointList intersections, PointList distances) {
        List polySegments = PointListUtilities.getLineSegments(poly);
        List mySegments = PointListUtilities.getLineSegments(points);
        Point pLastIntersect = null;
        double dCurrentLength = 0.0;
        ListIterator segIter = mySegments.listIterator();
        while (segIter.hasNext()) {
            LineSeg pSegment = (LineSeg)segIter.next();
            double dSegLength = pSegment.length();
            ListIterator polyIter = polySegments.listIterator();
            while (polyIter.hasNext()) {
                LineSeg pPolySegment = (LineSeg)polyIter.next();
                Point ptIntersect = pSegment.intersect(pPolySegment, 1);
                if (ptIntersect == null) continue;
                boolean bAddIntersect = true;
                if (pLastIntersect != null && Math.abs(pLastIntersect.x - ptIntersect.x) < 2 && Math.abs(pLastIntersect.y - ptIntersect.y) < 2) {
                    bAddIntersect = false;
                }
                if (!bAddIntersect) continue;
                pLastIntersect = new Point(ptIntersect);
                intersections.addPoint(pLastIntersect);
                Point ptDistance = new Point(0, 0);
                ptDistance.x = (int)Math.round(dCurrentLength + (double)pSegment.distanceAlong(ptIntersect) * dSegLength);
                distances.addPoint(ptDistance);
            }
            dCurrentLength += dSegLength;
        }
        return intersections.size() > 0;
    }

    public static Point calculatePointRelativeToLine(PointList pointList, int fromLine, int fromEnd, boolean isPercentage) {
        double fractionDistance = 0.0;
        fractionDistance = isPercentage ? (double)fromEnd / 100.0 : (double)fromEnd / (double)pointList.size();
        LocateInfo locateInfo = new LocateInfo();
        if (PointListUtilities.locateSegment(PointListUtilities.getLineSegments(pointList), fractionDistance, LineSeg.KeyPoint.ORIGIN, locateInfo)) {
            double inSegPercDist = 0.0;
            LineSeg seg = locateInfo.theSegment;
            if (seg.length() > 0.0) {
                inSegPercDist = (double)locateInfo.remainingDist / seg.length();
            }
            Point location = seg.locatePoint(inSegPercDist, Math.abs(fromLine), fromLine > 0 ? LineSeg.Sign.POSITIVE : LineSeg.Sign.NEGATIVE);
            return location;
        }
        return null;
    }

    public static Point pickClosestPoint(PointList points, Point p) {
        Point result = points.getFirstPoint();
        int i = 1;
        while (i < points.size()) {
            Point temp = points.getPoint(i);
            if (Math.abs(temp.x - p.x) < Math.abs(result.x - p.x)) {
                result = temp;
            } else if (Math.abs(temp.y - p.y) < Math.abs(result.y - p.y)) {
                result = temp;
            }
            ++i;
        }
        return result;
    }

    public static Point pickFarestPoint(PointList points, Point p) {
        Point result = points.getFirstPoint();
        int i = 1;
        while (i < points.size()) {
            Point temp = points.getPoint(i);
            if (Math.abs(temp.x - p.x) > Math.abs(result.x - p.x)) {
                result = temp;
            } else if (Math.abs(temp.y - p.y) > Math.abs(result.y - p.y)) {
                result = temp;
            }
            ++i;
        }
        return result;
    }

    static boolean sameOrientation(Point pt1, Point pt2, Point pt3, int straightLineTolerance) {
        LineSeg line = new LineSeg(pt1, pt3);
        Point pt = line.perpIntersect(pt2.x, pt2.y);
        return Math.round(pt.getDistance(new Point(pt2.x, pt2.y))) < (long)straightLineTolerance;
    }

    private static class LocateInfo {
        public long remainingDist;
        public LineSeg theSegment;

        LocateInfo() {
        }
    }
}

