/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.draw2d.ui.internal.figures;

import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gmf.runtime.draw2d.ui.mapmode.MapModeUtil;
import org.eclipse.swt.graphics.Image;

public class ImageFigureEx
extends Figure {
    private Image img;
    private Dimension size = new Dimension();
    private int alignment;

    public ImageFigureEx() {
        this(null, 2);
    }

    public ImageFigureEx(Image image) {
        this(image, 2);
    }

    public ImageFigureEx(Image image, int alignment) {
        this.setImage(image);
        this.setAlignment(alignment);
    }

    public Image getImage() {
        return this.img;
    }

    public Dimension getPreferredSize(int wHint, int hHint) {
        return this.size;
    }

    protected void paintFigure(Graphics graphics) {
        int x;
        int y;
        super.paintFigure(graphics);
        if (this.getImage() == null) {
            return;
        }
        Rectangle area = this.getClientArea();
        switch (this.alignment & 5) {
            case 1: {
                y = area.y;
                break;
            }
            case 4: {
                y = area.y + area.height - this.size.height;
                break;
            }
            default: {
                y = (area.height - this.size.height) / 2 + area.y;
            }
        }
        switch (this.alignment & 0x18) {
            case 16: {
                x = area.x + area.width - this.size.width;
                break;
            }
            case 8: {
                x = area.x;
                break;
            }
            default: {
                x = (area.width - this.size.width) / 2 + area.x;
            }
        }
        graphics.drawImage(this.getImage(), x, y);
    }

    public void setAlignment(int flag) {
        this.alignment = flag;
    }

    public void setImage(Image image) {
        if (this.img == image) {
            return;
        }
        this.img = image;
        if (this.img != null) {
            org.eclipse.swt.graphics.Rectangle r = image.getBounds();
            this.size = new Dimension(MapModeUtil.getMapMode((IFigure)this).DPtoLP(r.width), MapModeUtil.getMapMode((IFigure)this).DPtoLP(r.height));
        } else {
            this.size = new Dimension();
        }
        this.revalidate();
        this.repaint();
    }
}

