/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.draw2d.ui.internal.graph;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.graph.DirectedGraph;
import org.eclipse.draw2d.graph.DirectedGraphLayout;
import org.eclipse.draw2d.graph.Edge;
import org.eclipse.draw2d.graph.EdgeList;
import org.eclipse.draw2d.graph.Node;
import org.eclipse.draw2d.graph.NodeList;
import org.eclipse.draw2d.graph.Subgraph;
import org.eclipse.gmf.runtime.draw2d.ui.internal.graph.VirtualNode;

public class CompositeDirectedGraphLayout
extends DirectedGraphLayout {
    public void visit(DirectedGraph graph) {
        this.layoutNodes(graph.nodes, false);
    }

    private void layoutNodes(NodeList nodes, boolean virtualPass) {
        EdgeList edges = new EdgeList();
        Iterator iter = nodes.iterator();
        while (iter.hasNext()) {
            Node element = (Node)iter.next();
            if (element instanceof Subgraph && !(element instanceof VirtualNode)) {
                this.layoutNodes(((Subgraph)element).members, virtualPass);
            }
            Iterator edgesIter = element.outgoing.iterator();
            while (edgesIter.hasNext()) {
                Edge edge = (Edge)edgesIter.next();
                if (!nodes.contains((Object)edge.target)) continue;
                edges.add((Object)edge);
            }
        }
        if (!virtualPass) {
            virtualNodesToNodes virtualNodesNodes = new virtualNodesToNodes();
            this.createVirtualNodes(nodes, edges, virtualNodesNodes);
            NodeList vituralNodes = virtualNodesNodes.getVirtualNodes();
            int size = vituralNodes.size();
            if (size > 0) {
                edges = virtualNodesNodes.getEdges();
                Iterator iter2 = vituralNodes.iterator();
                while (iter2.hasNext()) {
                    Subgraph virtualNode = (Subgraph)iter2.next();
                    this.layoutNodes(virtualNode.members, true);
                }
                this.adjustVirtualNodesWidthAndHeight(vituralNodes);
            }
        }
        int nodesSize = nodes.size();
        HashMap nodeToOutGoing = new HashMap();
        HashMap nodeToIncomingGoing = new HashMap();
        this.removeDisconnectedEdges(nodes, nodeToOutGoing, nodeToIncomingGoing);
        if (nodesSize >= 2) {
            DirectedGraph g = new DirectedGraph();
            g.nodes = nodes;
            g.edges = edges;
            DirectedGraphLayout layout = new DirectedGraphLayout();
            layout.visit(g);
        }
        this.restoreDisconnectedEdges(nodeToOutGoing, nodeToIncomingGoing);
    }

    private void restoreDisconnectedEdges(Map nodeToOutGoing, Map nodeToIncomingGoing) {
        this.restoreEdges(nodeToOutGoing.entrySet(), true);
        this.restoreEdges(nodeToIncomingGoing.entrySet(), false);
    }

    private void removeDisconnectedEdges(NodeList nodes, Map nodeToOutGoing, Map nodeToIncomingGoing) {
        Iterator iter = nodes.iterator();
        while (iter.hasNext()) {
            Node element = (Node)iter.next();
            this.pushExtraEdges(nodes, nodeToOutGoing, element, (List)element.outgoing, false);
            this.pushExtraEdges(nodes, nodeToIncomingGoing, element, (List)element.incoming, true);
        }
    }

    private void createVirtualNodes(NodeList nodes, EdgeList edges, virtualNodesToNodes virtualNodesNodes) {
        HashSet handledEdges = new HashSet();
        this.recursiveHandleVirtualNode(nodes, edges, virtualNodesNodes, handledEdges, new HashSet(nodes));
    }

    private void recursiveHandleVirtualNode(NodeList nodes, EdgeList edges, virtualNodesToNodes virtualNodesNodes, Set handledEdges, Set nodesSnapeShot) {
        Iterator edgeIter = edges.iterator();
        while (edgeIter.hasNext()) {
            Edge element = (Edge)edgeIter.next();
            if (handledEdges.contains(element)) continue;
            handledEdges.add(element);
            if (!nodesSnapeShot.contains(element.source) || !nodesSnapeShot.contains(element.target)) continue;
            Node source = element.source;
            Node target = element.target;
            boolean sourceHandled = true;
            boolean targetHandled = true;
            Subgraph sg = virtualNodesNodes.getVirtualContainer(source);
            Subgraph sg1 = virtualNodesNodes.getVirtualContainer(target);
            if (sg == null) {
                sourceHandled = false;
                sg = sg1;
            }
            if (sg1 == null) {
                targetHandled = false;
            }
            if (!sourceHandled && !targetHandled) {
                sg = new VirtualNode(null, source.getParent());
                sg.setPadding(new Insets(30));
                if (source.getParent() == null) {
                    nodes.add((Object)sg);
                }
            }
            if (!sourceHandled) {
                this.addNode(sg, source, nodes);
                virtualNodesNodes.addNode(sg, source);
            }
            if (!targetHandled) {
                this.addNode(sg, target, nodes);
                virtualNodesNodes.addNode(sg, target);
            }
            if (!sourceHandled) {
                this.recursiveHandleVirtualNode(nodes, source.outgoing, virtualNodesNodes, handledEdges, nodesSnapeShot);
                this.recursiveHandleVirtualNode(nodes, source.incoming, virtualNodesNodes, handledEdges, nodesSnapeShot);
            }
            if (targetHandled) continue;
            this.recursiveHandleVirtualNode(nodes, target.outgoing, virtualNodesNodes, handledEdges, nodesSnapeShot);
            this.recursiveHandleVirtualNode(nodes, target.incoming, virtualNodesNodes, handledEdges, nodesSnapeShot);
        }
    }

    private void pushExtraEdges(NodeList nodes, Map nodeToIncomingGoing, Node element, List list, boolean sourceCheck) {
        ArrayList<Edge> edges = new ArrayList<Edge>();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Node nodeToCheck;
            Edge edge = (Edge)iterator.next();
            Node node = nodeToCheck = sourceCheck ? edge.source : edge.target;
            if (nodes.contains((Object)nodeToCheck)) continue;
            edges.add(edge);
            iterator.remove();
            Node sourceNode = null;
            Node targetNode = null;
            sourceNode = this.getParent(edge.source);
            targetNode = this.getParent(edge.target);
            sourceNode = !sourceCheck || sourceNode != null ? sourceNode : edge.source;
            Node node2 = targetNode = sourceCheck || targetNode != null ? targetNode : edge.target;
            if (sourceCheck || sourceNode == null || targetNode == null || sourceNode == targetNode || edge.source == sourceNode && edge.target == targetNode) continue;
            Edge virtualEdge = new Edge(sourceNode, targetNode, edge.getDelta(), edge.weight);
            virtualEdge.setPadding(edge.getPadding());
        }
        if (!edges.isEmpty()) {
            nodeToIncomingGoing.put(element, edges);
        }
    }

    private Node getParent(Node node) {
        Subgraph parent = node.getParent();
        if (parent != null && parent instanceof VirtualNode) {
            parent = parent.getParent();
        }
        return parent;
    }

    private void restoreEdges(Set entries, boolean outgoing) {
        Iterator iter = entries.iterator();
        while (iter.hasNext()) {
            Map.Entry entry = (Map.Entry)iter.next();
            Node node = (Node)entry.getKey();
            List edgesList = (List)entry.getValue();
            Iterator iterator = edgesList.iterator();
            while (iterator.hasNext()) {
                Edge edgeToRestore = (Edge)iterator.next();
                if (outgoing) {
                    node.outgoing.add((Object)edgeToRestore);
                    continue;
                }
                node.incoming.add((Object)edgeToRestore);
            }
        }
    }

    private void adjustVirtualNodesWidthAndHeight(NodeList vituralNodes) {
        Iterator iter = vituralNodes.iterator();
        while (iter.hasNext()) {
            Subgraph subGraph = (Subgraph)iter.next();
            this.adjustVirtualNodeWidthAndHeight(subGraph);
        }
    }

    private void adjustVirtualNodeWidthAndHeight(Subgraph subGraph) {
        NodeList nodes = subGraph.members;
        if (nodes.isEmpty()) {
            return;
        }
        int size = nodes.size();
        Node node = nodes.getNode(0);
        int top = node.y;
        int left = node.x;
        int bottom = top + node.height;
        int right = left + node.width;
        int index = 1;
        while (index < size) {
            node = (Node)nodes.get(index);
            if (top > node.y) {
                top = node.y;
            }
            if (bottom < node.y + node.height) {
                bottom = node.y + node.height;
            }
            if (left > node.x) {
                left = node.x;
            }
            if (right < node.x + node.width) {
                right = node.x + node.width;
            }
            ++index;
        }
        subGraph.width = right - left;
        subGraph.height = bottom - top;
    }

    private void addNode(Subgraph parent, Node node, NodeList nodes) {
        if (node.getParent() != null) {
            node.getParent().members.remove((Object)node);
        }
        node.setParent(parent);
        parent.addMember(node);
        nodes.remove((Object)node);
    }

    private class virtualNodesToNodes
    extends HashMap {
        Set virtualNodes = new HashSet();

        virtualNodesToNodes() {
        }

        public void addNode(Subgraph sg, Node node) {
            this.virtualNodes.add(sg);
            this.put(node, sg);
        }

        public EdgeList getEdges() {
            EdgeList edges = new EdgeList();
            Iterator iter = this.virtualNodes.iterator();
            while (iter.hasNext()) {
                Node element = (Node)iter.next();
                Iterator iterator = element.outgoing.iterator();
                while (iterator.hasNext()) {
                    Edge edge = (Edge)iterator.next();
                    if (!this.virtualNodes.contains(edge.target)) continue;
                    edges.add((Object)edge);
                }
            }
            return edges;
        }

        public Subgraph getVirtualContainer(Node node) {
            return (Subgraph)this.get(node);
        }

        public NodeList getVirtualNodes() {
            NodeList nodeList = new NodeList();
            nodeList.addAll((Collection)this.virtualNodes);
            return nodeList;
        }
    }
}

