/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.draw2d.ui.internal.graphics;

import org.eclipse.core.runtime.Plugin;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.SWTGraphics;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gmf.runtime.common.core.util.Log;
import org.eclipse.gmf.runtime.draw2d.ui.internal.Draw2dPlugin;
import org.eclipse.gmf.runtime.draw2d.ui.internal.graphics.MapModeGraphics;
import org.eclipse.gmf.runtime.draw2d.ui.internal.graphics.ScaledGraphics;
import org.eclipse.gmf.runtime.draw2d.ui.mapmode.IMapMode;
import org.eclipse.swt.SWTException;

public class ScalableFreeformLayeredPane
extends org.eclipse.draw2d.ScalableFreeformLayeredPane
implements IMapMode {
    boolean antiAlias = true;
    private IMapMode mm;

    protected IMapMode getMapMode() {
        return this.mm;
    }

    public ScalableFreeformLayeredPane(IMapMode mm) {
        this.mm = mm;
    }

    public void setAntiAlias(boolean antiAliasValue) {
        this.antiAlias = antiAliasValue;
        super.repaint();
    }

    protected void paintClientArea(Graphics graphics) {
        if (graphics instanceof SWTGraphics && this.antiAlias) {
            graphics.setAntialias(1);
        } else {
            graphics.setAntialias(0);
        }
        MapModeGraphics gMM = this.createMapModeGraphics(graphics);
        gMM.pushState();
        if (this.getChildren().isEmpty()) {
            gMM.popState();
            return;
        }
        try {
            if (this.getScale() == 1.0) {
                super.paintClientArea((Graphics)gMM);
            } else {
                boolean optimizeClip;
                ScaledGraphics g = this.createScaledGraphics(gMM);
                boolean bl = optimizeClip = this.getBorder() == null || this.getBorder().isOpaque();
                if (!optimizeClip) {
                    g.clipRect(this.getBounds().getCropped(this.getInsets()));
                }
                g.scale(this.getScale());
                g.pushState();
                this.paintChildren(g);
                g.dispose();
                gMM.restoreState();
            }
        }
        catch (SWTException e) {
            Log.error((Plugin)Draw2dPlugin.getInstance(), (int)4, (String)e.getMessage(), (Throwable)e);
        }
        gMM.popState();
    }

    protected ScaledGraphics createScaledGraphics(MapModeGraphics gMM) {
        ScaledGraphics g = new ScaledGraphics(gMM);
        return g;
    }

    protected MapModeGraphics createMapModeGraphics(Graphics graphics) {
        MapModeGraphics gMM = new MapModeGraphics(graphics, this.getMapMode());
        return gMM;
    }

    public Rectangle getClientArea(Rectangle rect) {
        super.getClientArea(rect);
        this.getMapMode().DPtoLP((Translatable)rect);
        return rect;
    }

    public void translateToParent(Translatable t) {
        super.translateToParent(t);
        this.getMapMode().LPtoDP(t);
    }

    public void translateFromParent(Translatable t) {
        super.translateFromParent(t);
        this.getMapMode().DPtoLP(t);
    }

    public int DPtoLP(int deviceUnit) {
        return this.getMapMode().DPtoLP(deviceUnit);
    }

    public Translatable DPtoLP(Translatable t) {
        return this.getMapMode().DPtoLP(t);
    }

    public int LPtoDP(int logicalUnit) {
        return this.getMapMode().LPtoDP(logicalUnit);
    }

    public Translatable LPtoDP(Translatable t) {
        return this.getMapMode().LPtoDP(t);
    }
}

