/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.draw2d.ui.internal.routers;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.draw2d.AbsoluteBendpoint;
import org.eclipse.draw2d.Bendpoint;
import org.eclipse.draw2d.BendpointConnectionRouter;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gmf.runtime.common.core.util.Trace;
import org.eclipse.gmf.runtime.draw2d.ui.geometry.LineSeg;
import org.eclipse.gmf.runtime.draw2d.ui.internal.Draw2dDebugOptions;
import org.eclipse.gmf.runtime.draw2d.ui.internal.Draw2dPlugin;
import org.eclipse.gmf.runtime.draw2d.ui.internal.routers.BranchRouter;
import org.eclipse.gmf.runtime.draw2d.ui.internal.routers.ITreeConnection;
import org.eclipse.gmf.runtime.draw2d.ui.internal.routers.OrthogonalRouter;
import org.eclipse.gmf.runtime.draw2d.ui.mapmode.MapModeUtil;

public class TreeRouter
extends BendpointConnectionRouter
implements OrthogonalRouter {
    private BranchRouter branchRouter = new BranchRouter(this);
    private ArrayList connectionList = new ArrayList();
    private Dimension trunkVertex;
    private Orientation trunkOrientation;
    private boolean updatingPeers = false;
    private int DEFAULT_TRUNK_HEIGHT = 32;
    static /* synthetic */ Class class$0;

    public void invalidate(Connection conn) {
        if (conn.getSourceAnchor() == null || conn.getSourceAnchor().getOwner() == null || conn.getTargetAnchor() == null || conn.getTargetAnchor().getOwner() == null) {
            return;
        }
        ListIterator li = this.connectionList.listIterator();
        while (li.hasNext()) {
            Connection connNext = (Connection)li.next();
            if (this.trunkVertexEqual(connNext, conn)) continue;
            this.updateConstraint(connNext);
        }
    }

    private boolean trunkVertexEqual(Connection connMaster, Connection connSlave) {
        PointList cmPts = connMaster.getPoints();
        PointList csPts = connSlave.getPoints();
        if (cmPts.size() > 2 && csPts.size() > 2) {
            return cmPts.getPoint(2).equals((Object)csPts.getPoint(2));
        }
        return false;
    }

    public Point getTrunkLocation(Connection conn) {
        Dimension vertex = this.getTrunkVertex();
        Point target = this.getTrunkOrientation().getEdge(conn.getTargetAnchor().getOwner().getBounds());
        Point ptTrunkLoc = new Point(vertex.width, vertex.height);
        ptTrunkLoc = ptTrunkLoc.getTranslated(target);
        return ptTrunkLoc;
    }

    public void setTrunkLocation(Connection conn, Point ptTrunkLoc) {
        Point ptRelTrunkLoc = new Point(ptTrunkLoc);
        if (this.isTopDown(conn)) {
            if (ptTrunkLoc.y < conn.getTargetAnchor().getOwner().getBounds().getCenter().y) {
                this.setTrunkOrientation(Orientation.TOP);
            } else {
                this.setTrunkOrientation(Orientation.BOTTOM);
            }
        } else if (ptTrunkLoc.x < conn.getTargetAnchor().getOwner().getBounds().getCenter().x) {
            this.setTrunkOrientation(Orientation.LEFT);
        } else {
            this.setTrunkOrientation(Orientation.RIGHT);
        }
        Point target = this.getTrunkOrientation().getEdge(conn.getTargetAnchor().getOwner().getBounds());
        Dimension currentVertex = ptRelTrunkLoc.getDifference(target);
        this.setTrunkVertex(currentVertex);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void updateConstraint(Connection conn) {
        Object var4_5;
        if (this.isUpdatingPeers()) {
            return;
        }
        ArrayList<AbsoluteBendpoint> bendpoints = (ArrayList<AbsoluteBendpoint>)conn.getRoutingConstraint();
        if (bendpoints == null) {
            bendpoints = new ArrayList<AbsoluteBendpoint>(conn.getPoints().size());
        }
        if (bendpoints != null) {
            Point sourceRefPoint = conn.getSourceAnchor().getReferencePoint();
            conn.translateToRelative((Translatable)sourceRefPoint);
            Point targetRefPoint = conn.getTargetAnchor().getReferencePoint();
            conn.translateToRelative((Translatable)targetRefPoint);
            Point ptTrunk = this.getTrunkLocation(conn);
            Point ptSource = this.getBranchRouter().getSourceLocation(conn, ptTrunk);
            bendpoints.clear();
            PointList pts = this.getBranchRouter().recreateBranch(conn, ptSource, ptTrunk);
            int i = 0;
            while (i < pts.size()) {
                AbsoluteBendpoint bp = new AbsoluteBendpoint(pts.getPoint(i));
                bendpoints.add(bp);
                ++i;
            }
        }
        this.setUpdatingPeers(true);
        try {
            try {
                this.setConstraint(conn, bendpoints);
                conn.invalidate();
                conn.validate();
            }
            catch (Exception e) {
                Draw2dPlugin draw2dPlugin = Draw2dPlugin.getInstance();
                Class<?> clazz = class$0;
                if (clazz == null) {
                    Class<?> clazz2;
                    try {
                        clazz2 = Class.forName("org.eclipse.gmf.runtime.draw2d.ui.internal.routers.TreeRouter");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    clazz = class$0 = clazz2;
                }
                Trace.catching((Plugin)draw2dPlugin, (String)Draw2dDebugOptions.EXCEPTIONS_CATCHING, (Class)clazz, (String)"updateConstraint", (Throwable)e);
            }
        }
        catch (Throwable throwable) {
            var4_5 = null;
            this.setUpdatingPeers(false);
            throw throwable;
        }
        {
            var4_5 = null;
            this.setUpdatingPeers(false);
            return;
        }
    }

    public PointList getPointsFromConstraint(Connection conn) {
        List bendpoints = (List)conn.getRoutingConstraint();
        if (bendpoints == null) {
            return new PointList();
        }
        PointList points = new PointList(bendpoints.size());
        int i = 0;
        while (i < bendpoints.size()) {
            Bendpoint bp = (Bendpoint)bendpoints.get(i);
            points.addPoint(bp.getLocation());
            ++i;
        }
        TreeRouter.straightenPoints(points, MapModeUtil.getMapMode((IFigure)conn).DPtoLP(3));
        return points;
    }

    protected static void straightenPoints(PointList newLine, int tolerance) {
        int i = 0;
        while (i < newLine.size() - 1) {
            int yDelta;
            Point ptCurrent = newLine.getPoint(i);
            Point ptNext = newLine.getPoint(i + 1);
            int xDelta = Math.abs(ptNext.x - ptCurrent.x);
            if (xDelta < (yDelta = Math.abs(ptNext.y - ptCurrent.y))) {
                if (xDelta > tolerance) {
                    return;
                }
                ptNext.x = ptCurrent.x;
            } else {
                if (yDelta > tolerance) {
                    return;
                }
                ptNext.y = ptCurrent.y;
            }
            newLine.setPoint(ptNext, i + 1);
            ++i;
        }
    }

    protected BranchRouter getBranchRouter() {
        return this.branchRouter;
    }

    public void remove(Connection conn) {
        if (conn.getSourceAnchor() == null || conn.getTargetAnchor() == null) {
            return;
        }
        int index = this.connectionList.indexOf(conn);
        this.connectionList.remove(conn);
        int i = index + 1;
        while (i < this.connectionList.size()) {
            ((Connection)this.connectionList.get(i)).revalidate();
            ++i;
        }
        this.getBranchRouter().remove(conn);
    }

    public boolean isTopDown(Connection conn) {
        boolean vertical = true;
        if (conn instanceof ITreeConnection) {
            vertical = ((ITreeConnection)conn).getOrientation().equals(ITreeConnection.Orientation.VERTICAL) ? (vertical = true) : false;
        }
        return vertical;
    }

    private void checkTrunkVertex(Connection conn) {
        if (this.getTrunkVertex() == null) {
            Rectangle sourceRect = conn.getSourceAnchor().getOwner().getBounds();
            Rectangle targetRect = conn.getTargetAnchor().getOwner().getBounds();
            Dimension default_trunk = new Dimension(0, this.DEFAULT_TRUNK_HEIGHT);
            conn.translateToRelative((Translatable)default_trunk);
            if (this.isTopDown(conn)) {
                if (sourceRect.getCenter().y < targetRect.getCenter().y) {
                    this.setTrunkVertex(new Dimension(0, -default_trunk.height));
                    this.setTrunkOrientation(Orientation.TOP);
                } else {
                    this.setTrunkVertex(new Dimension(0, default_trunk.height));
                    this.setTrunkOrientation(Orientation.BOTTOM);
                }
            } else if (sourceRect.getCenter().x < targetRect.getCenter().x) {
                this.setTrunkVertex(new Dimension(-default_trunk.height, 0));
                this.setTrunkOrientation(Orientation.LEFT);
            } else {
                this.setTrunkVertex(new Dimension(default_trunk.height, 0));
                this.setTrunkOrientation(Orientation.RIGHT);
            }
        }
    }

    public void route(Connection conn) {
        if (conn.getSourceAnchor() == null || conn.getSourceAnchor().getOwner() == null || conn.getTargetAnchor() == null || conn.getTargetAnchor().getOwner() == null) {
            super.route(conn);
            return;
        }
        if (!this.connectionList.contains(conn)) {
            this.connectionList.add(conn);
        }
        this.checkTrunkVertex(conn);
        this.getBranchRouter().route(conn);
        this.invalidate(conn);
    }

    protected Dimension getTrunkVertex() {
        return this.trunkVertex;
    }

    protected void setTrunkVertex(Dimension trunkVertex) {
        this.trunkVertex = trunkVertex;
    }

    protected Orientation getTrunkOrientation() {
        return this.trunkOrientation;
    }

    protected void setTrunkOrientation(Orientation trunkOrientation) {
        this.trunkOrientation = trunkOrientation;
    }

    public boolean isOrthogonalTreeBranch(Connection conn, PointList points) {
        if (this.isTreeBranch(conn, points)) {
            LineSeg branch = new LineSeg(points.getPoint(0), points.getPoint(1));
            LineSeg trunkShoulder = new LineSeg(points.getPoint(1), points.getPoint(2));
            LineSeg trunk = new LineSeg(points.getPoint(2), points.getPoint(3));
            if (this.isTopDown(conn)) {
                return branch.isVertical() && trunkShoulder.isHorizontal() && trunk.isVertical();
            }
            return branch.isHorizontal() && trunkShoulder.isVertical() && trunk.isHorizontal();
        }
        return false;
    }

    public boolean isTreeBranch(Connection conn, PointList points) {
        if (points.size() == 4) {
            Rectangle targetBounds = conn.getTargetAnchor().getOwner().getBounds();
            Rectangle sourceBounds = conn.getSourceAnchor().getOwner().getBounds();
            if (this.isTopDown(conn)) {
                return points.getPoint((int)0).x > sourceBounds.x && points.getPoint((int)0).x < sourceBounds.x + sourceBounds.width && points.getPoint((int)3).x > targetBounds.x && points.getPoint((int)3).x < targetBounds.x + targetBounds.width;
            }
            return points.getPoint((int)0).y > sourceBounds.y && points.getPoint((int)0).y < sourceBounds.y + sourceBounds.height && points.getPoint((int)3).y > targetBounds.y && points.getPoint((int)3).y < targetBounds.y + targetBounds.height;
        }
        return false;
    }

    public List getConnectionList() {
        return (List)this.connectionList.clone();
    }

    protected boolean isUpdatingPeers() {
        return this.updatingPeers;
    }

    protected void setUpdatingPeers(boolean updatingPeers) {
        this.updatingPeers = updatingPeers;
    }

    private static class Orientation {
        public static Orientation TOP = new Orientation();
        public static Orientation BOTTOM = new Orientation();
        public static Orientation RIGHT = new Orientation();
        public static Orientation LEFT = new Orientation();

        Orientation() {
        }

        public Point getEdge(Rectangle bounds) {
            if (this == TOP) {
                return bounds.getTop();
            }
            if (this == BOTTOM) {
                return bounds.getBottom();
            }
            if (this == RIGHT) {
                return bounds.getRight();
            }
            return bounds.getLeft();
        }
    }
}

