/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.emf.clipboard.core;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.gmf.runtime.emf.clipboard.core.CopyOperation;
import org.eclipse.gmf.runtime.emf.clipboard.core.IClipboardSupport;
import org.eclipse.gmf.runtime.emf.clipboard.core.OverrideCopyOperation;
import org.eclipse.gmf.runtime.emf.clipboard.core.OverridePasteChildOperation;
import org.eclipse.gmf.runtime.emf.clipboard.core.PasteAction;
import org.eclipse.gmf.runtime.emf.clipboard.core.PasteChildOperation;
import org.eclipse.gmf.runtime.emf.clipboard.core.PasteOption;

public class AbstractClipboardSupport
implements IClipboardSupport {
    private static final Object NULL_TOKEN = Boolean.FALSE;
    private final Map nameFeatureMap = new HashMap();
    static /* synthetic */ Class class$0;

    public PasteAction getPasteCollisionAction(EClass eClass) {
        return PasteAction.ADD;
    }

    public boolean hasPasteOption(EObject contextEObject, EStructuralFeature eStructuralFeature, PasteOption pasteOption) {
        return ((Object)((Object)pasteOption)).equals((Object)PasteOption.NORMAL);
    }

    public boolean isCopyAlways(EObject context, EReference eReference, Object value) {
        if (eReference.isTransient() || eReference.isDerived()) {
            return false;
        }
        return eReference.isContainment();
    }

    public boolean shouldOverrideChildPasteOperation(EObject parentElement, EObject childEObject) {
        return false;
    }

    public boolean shouldOverrideCopyOperation(Collection eObjects, Map hintMap) {
        return false;
    }

    public OverridePasteChildOperation getOverrideChildPasteOperation(PasteChildOperation overriddenChildPasteOperation) {
        return null;
    }

    public OverrideCopyOperation getOverrideCopyOperation(CopyOperation overriddenCopyOperation) {
        return null;
    }

    public Collection getExcludedCopyObjects(Set eObjects) {
        return Collections.EMPTY_SET;
    }

    public XMLResource getResource(EObject eObject) {
        return (XMLResource)eObject.eResource();
    }

    public boolean shouldSaveContainmentFeature(EObject eObject) {
        if (EcorePackage.eINSTANCE == eObject.eClass().getEPackage()) {
            return false;
        }
        try {
            eObject.eResource().getURIFragment(eObject);
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    public void performPostPasteProcessing(Set pastedEObjects) {
    }

    protected EAttribute getNameAttribute(EClass eClass) {
        EAttribute result = null;
        Object value = this.nameFeatureMap.get(eClass);
        if (value != NULL_TOKEN && (result = (EAttribute)value) == null) {
            this.nameFeatureMap.put(eClass, NULL_TOKEN);
            Iterator iter = eClass.getEAllAttributes().iterator();
            while (iter.hasNext()) {
                EAttribute next = (EAttribute)iter.next();
                Class clazz = next.getEType().getInstanceClass();
                Class<?> clazz2 = class$0;
                if (clazz2 == null) {
                    try {
                        clazz2 = Class.forName("java.lang.String");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (clazz != clazz2 || next.isMany() || !"name".equalsIgnoreCase(next.getName())) continue;
                result = next;
                this.nameFeatureMap.put(eClass, result);
                break;
            }
        }
        return result;
    }

    public boolean isNameable(EObject eObject) {
        return this.getNameAttribute(eObject.eClass()) != null;
    }

    public String getName(EObject eObject) {
        EAttribute attr = this.getNameAttribute(eObject.eClass());
        if (attr == null) {
            throw new IllegalArgumentException("eObject not nameable");
        }
        return (String)eObject.eGet((EStructuralFeature)attr);
    }

    public void setName(EObject eObject, String name) {
        EAttribute attr = this.getNameAttribute(eObject.eClass());
        if (attr == null) {
            throw new IllegalArgumentException("eObject not nameable");
        }
        eObject.eSet((EStructuralFeature)attr, (Object)name);
    }

    public void destroy(EObject eObject) {
        EReference ref;
        EObject container = eObject.eContainer();
        if (container != null && (ref = eObject.eContainmentFeature()) != null) {
            if (ref.isMany()) {
                ((Collection)container.eGet((EStructuralFeature)ref)).remove(eObject);
            } else {
                container.eSet((EStructuralFeature)ref, null);
            }
        }
    }

    public void sendCreateNotification(EObject eObject) {
    }

    public boolean canContain(EObject container, EReference reference, EClass containedType) {
        return reference.getEContainingClass().isSuperTypeOf(container.eClass()) && reference.getEReferenceType().isSuperTypeOf(containedType);
    }
}

