/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.emf.clipboard.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.ExtendedMetaData;
import org.eclipse.emf.ecore.util.FeatureMapUtil;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.gmf.runtime.emf.clipboard.core.ClipboardUtil;
import org.eclipse.gmf.runtime.emf.clipboard.core.IClipboardSupport;
import org.eclipse.gmf.runtime.emf.clipboard.core.internal.ClipboardPlugin;

public final class ClipboardSupportUtil {
    public static final int NONE = -1;
    private static final String ONE = "1";
    private static final String UNDERSCORE = "_";
    private static final String RESOLVE = "resolve";
    private static final EReference[] EMPTY_REF_ARRAY = new EReference[0];
    static /* synthetic */ Class class$0;

    private ClipboardSupportUtil() {
    }

    public static Collection getCopyElements(Collection elements) {
        Iterator it = elements.iterator();
        EObject element = null;
        HashSet<EObject> set = new HashSet<EObject>();
        while (it.hasNext()) {
            element = (EObject)it.next();
            set.add(element);
        }
        elements.clear();
        elements.addAll(ClipboardSupportUtil.getUniqueElementsAncestry(set));
        return elements;
    }

    private static Set getUniqueElementsAncestry(Set elementSet) {
        Iterator it = elementSet.iterator();
        EObject container = null;
        block0: while (it.hasNext()) {
            container = ((EObject)it.next()).eContainer();
            while (container != null) {
                if (elementSet.contains(container)) {
                    it.remove();
                    continue block0;
                }
                container = container.eContainer();
            }
        }
        return elementSet;
    }

    public static List setEObjectList(EObject eObject, EReference reference, List referencedObjects) {
        if (ClipboardSupportUtil.isOkToSetEList(eObject, reference)) {
            if (reference.isContainment()) {
                ClipboardSupportUtil.sendCreateEvent(referencedObjects);
            }
            eObject.eSet((EStructuralFeature)reference, (Object)referencedObjects);
        }
        return referencedObjects;
    }

    static boolean isMutable(EReference reference) {
        boolean result = reference.isChangeable();
        if (result && reference.isDerived()) {
            EStructuralFeature group = ExtendedMetaData.INSTANCE.getGroup((EStructuralFeature)reference);
            result = group != null && !FeatureMapUtil.isFeatureMap((EStructuralFeature)reference);
        }
        return result;
    }

    public static boolean isOkToSetEList(EObject eObject, EReference reference) {
        return ClipboardSupportUtil.isMutable(reference);
    }

    public static List appendEObjectListAt(EObject eObject, EReference reference, List referencedObjects) {
        ArrayList<EObject> list = new ArrayList<EObject>();
        EObject childEObject = null;
        Iterator childIt = referencedObjects.iterator();
        while (childIt.hasNext()) {
            childEObject = (EObject)childIt.next();
            if ((childEObject = ClipboardSupportUtil.appendEObjectAt(eObject, reference, childEObject)) == null) continue;
            list.add(childEObject);
        }
        return list;
    }

    public static EObject appendEObjectAt(EObject eObject, EReference reference, EObject referencedObject) {
        if (!ClipboardSupportUtil.isOkToAppendEObjectAt(eObject, reference, referencedObject)) {
            return null;
        }
        if (reference.isContainment()) {
            ClipboardSupportUtil.sendCreateEvent(referencedObject);
        }
        ((Collection)eObject.eGet((EStructuralFeature)reference)).add(referencedObject);
        return referencedObject;
    }

    public static EObject appendEObject(Resource resource, EObject referencedObject) {
        ClipboardSupportUtil.sendCreateEvent(referencedObject);
        resource.getContents().add((Object)referencedObject);
        return referencedObject;
    }

    public static EObject setEObject(EObject eObject, EReference reference, EObject referencedObject) {
        if (!ClipboardSupportUtil.isOkToSetEObject(eObject, reference, referencedObject)) {
            return null;
        }
        if (reference.isContainment()) {
            ClipboardSupportUtil.sendCreateEvent(referencedObject);
        }
        eObject.eSet((EStructuralFeature)reference, (Object)referencedObject);
        return referencedObject;
    }

    public static void setEAttribute(EObject eObject, EAttribute attribute, Object value) {
        if (ClipboardSupportUtil.isOkToSetEAttribute(eObject, attribute, value)) {
            eObject.eSet((EStructuralFeature)attribute, value);
        }
    }

    private static IClipboardSupport createClipboardSupport(EObject eObject) {
        return ClipboardUtil.createClipboardSupport(eObject.eClass());
    }

    public static void sendCreateEvent(EObject eObject) {
        IClipboardSupport cSupport = ClipboardSupportUtil.createClipboardSupport(eObject);
        if (cSupport != null) {
            cSupport.sendCreateNotification(eObject);
        }
    }

    public static void sendCreateEvent(List eObjects) {
        Iterator i = eObjects.iterator();
        while (i.hasNext()) {
            ClipboardSupportUtil.sendCreateEvent((EObject)i.next());
        }
    }

    public static boolean isOkToSetEAttribute(EObject eObject, EAttribute attribute, Object value) {
        if (value != null && attribute != null) {
            return attribute.isChangeable();
        }
        return false;
    }

    public static void destroyEObject(EObject eObject, EReference reference) {
        if (!ClipboardSupportUtil.isOkToDestroyEObject(eObject, reference)) {
            return;
        }
        EObject current = (EObject)eObject.eGet((EStructuralFeature)reference);
        if (current == null) {
            return;
        }
        if (reference.isContainment()) {
            ClipboardSupportUtil.createClipboardSupport(current).destroy(current);
        } else {
            eObject.eSet((EStructuralFeature)reference, null);
        }
    }

    public static void destroyEObjectInCollection(EObject eObject, EReference reference, EObject referencedObject) {
        if (!ClipboardSupportUtil.isOkToDestroyEObjectInCollection(eObject, reference)) {
            return;
        }
        if (reference.isContainment()) {
            ClipboardSupportUtil.createClipboardSupport(referencedObject).destroy(referencedObject);
        } else {
            ((Collection)eObject.eGet((EStructuralFeature)reference)).remove(referencedObject);
        }
    }

    public static void destroyEObjectInResource(EObject referencedObject) {
        ClipboardSupportUtil.createClipboardSupport(referencedObject).destroy(referencedObject);
    }

    public static boolean isOkToAppendEObjectAt(EObject eObject, EReference reference, EObject referencedObject) {
        int upperBound;
        int lowerBound;
        if (ClipboardSupportUtil.isMutable(reference) && (lowerBound = reference.getLowerBound()) != (upperBound = reference.getUpperBound())) {
            if (eObject.eIsSet((EStructuralFeature)reference)) {
                List list = (List)eObject.eGet((EStructuralFeature)reference);
                return (upperBound == -1 || list.size() < upperBound) && !list.contains(referencedObject);
            }
            return upperBound == -1 || upperBound > 0;
        }
        return false;
    }

    public static boolean isOkToSetEObject(EObject eObject, EReference reference, EObject referencedObject) {
        if (ClipboardSupportUtil.isMutable(reference)) {
            Object value = eObject.eGet((EStructuralFeature)reference);
            return referencedObject != null && value != referencedObject;
        }
        return false;
    }

    public static boolean isOkToDestroyEObject(EObject eObject, EReference reference) {
        if (reference.isChangeable()) {
            Object value = eObject.eGet((EStructuralFeature)reference);
            return value != null;
        }
        return false;
    }

    public static boolean isOkToDestroyEObjectInCollection(EObject eObject, EReference reference) {
        int upperBound;
        int lowerBound;
        if (ClipboardSupportUtil.isMutable(reference) && (lowerBound = reference.getLowerBound()) != (upperBound = reference.getUpperBound()) && eObject.eIsSet((EStructuralFeature)reference)) {
            List list = (List)eObject.eGet((EStructuralFeature)reference);
            return list.size() > lowerBound;
        }
        return false;
    }

    private static ENamedElement matchName(ENamedElement[] elements, String name, boolean trySubNames) {
        int i = 0;
        while (i < elements.length) {
            if (elements[i].getName().equalsIgnoreCase(name)) {
                return elements[i];
            }
            ++i;
        }
        if (trySubNames) {
            i = 0;
            while (i < elements.length) {
                if (elements[i].getName().indexOf(name) != -1 || name.indexOf(elements[i].getName()) != -1) {
                    return elements[i];
                }
                ++i;
            }
        }
        return null;
    }

    public static boolean isChild(EObject eParent, EObject eObject) {
        EObject eContainer = eObject.eContainer();
        while (eContainer != null) {
            if (eContainer.equals(eParent)) {
                return true;
            }
            eContainer = eContainer.eContainer();
        }
        return false;
    }

    public static boolean hasNameCollision(EObject eObject1, EObject eObject2) {
        if (eObject1.eClass().equals(eObject2.eClass())) {
            String childEObjectName;
            IClipboardSupport cs = ClipboardSupportUtil.createClipboardSupport(eObject1);
            if (eObject1.equals(eObject2)) {
                return false;
            }
            if (ClipboardSupportUtil.isNameable(eObject1) && !ClipboardSupportUtil.isEmptyName(childEObjectName = cs.getName(eObject2)) && childEObjectName.equalsIgnoreCase(cs.getName(eObject1))) {
                return true;
            }
        }
        return false;
    }

    private static boolean isEmptyName(String elementName) {
        return elementName == null || elementName.length() == 0;
    }

    private static boolean isNameable(EObject eObject) {
        return ClipboardSupportUtil.createClipboardSupport(eObject).isNameable(eObject);
    }

    public static boolean hasNameCollision(Collection list, EObject eObject) {
        Iterator it = list.iterator();
        EObject eOther = null;
        while (it.hasNext()) {
            eOther = (EObject)it.next();
            if (!ClipboardSupportUtil.hasNameCollision(eOther, eObject)) continue;
            return true;
        }
        return false;
    }

    public static void rename(Collection list, EObject eObject, String prefix) {
        int close_index;
        String prefix_underscore;
        if (!ClipboardSupportUtil.isNameable(eObject)) {
            return;
        }
        String new_name = null;
        String name = ClipboardSupportUtil.createClipboardSupport(eObject).getName(eObject);
        if (name.startsWith(prefix_underscore = String.valueOf(prefix) + UNDERSCORE) && (close_index = name.indexOf(UNDERSCORE, prefix_underscore.length())) != -1) {
            String copy_prefix = name.substring(0, close_index);
            int open_index = copy_prefix.indexOf(UNDERSCORE);
            String copy_count_str = copy_prefix.substring(open_index + 1);
            try {
                int copy_count = Integer.parseInt(copy_count_str);
                String name_proper = name.substring(close_index + 1).trim();
                new_name = String.valueOf(prefix_underscore) + ++copy_count + UNDERSCORE + name_proper;
            }
            catch (NumberFormatException nfe) {
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.eclipse.gmf.runtime.emf.clipboard.core.ClipboardSupportUtil");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                ClipboardPlugin.catching(clazz, "rename", nfe);
                new_name = null;
            }
        }
        if (new_name == null) {
            new_name = String.valueOf(prefix_underscore) + ONE + UNDERSCORE + name;
        }
        ClipboardSupportUtil.createClipboardSupport(eObject).setName(eObject, new_name);
        if (ClipboardSupportUtil.hasNameCollision(list, eObject)) {
            ClipboardSupportUtil.rename(list, eObject, prefix);
        }
    }

    public static boolean containsAny(Collection collection1, Collection collection2) {
        Iterator it = collection2.iterator();
        while (it.hasNext()) {
            if (!collection1.contains(it.next())) continue;
            return true;
        }
        return false;
    }

    public static EObject resolve(EObject proxy, Map idToEObjectMap) {
        URI proxyUri = ((InternalEObject)proxy).eProxyURI();
        if (proxyUri != null) {
            try {
                EObject resolvedObject;
                String id = ClipboardSupportUtil.getProxyID(proxyUri);
                if (id == null || id.length() == 0) {
                    id = proxyUri.fragment();
                }
                if ((resolvedObject = (EObject)idToEObjectMap.get(id)) != null && resolvedObject != proxy) {
                    return ClipboardSupportUtil.resolve(resolvedObject, idToEObjectMap);
                }
            }
            catch (Exception exception) {
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.eclipse.gmf.runtime.emf.clipboard.core.ClipboardSupportUtil");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                ClipboardPlugin.catching(clazz, RESOLVE, exception);
            }
        }
        return proxy;
    }

    public static EObject resolve(EObject proxy, XMLResource resource) {
        URI proxyUri = ((InternalEObject)proxy).eProxyURI();
        if (proxyUri != null) {
            try {
                EObject resolvedObject;
                String id = ClipboardSupportUtil.getProxyID(proxyUri);
                if (id == null || id.length() == 0) {
                    id = proxyUri.fragment();
                }
                if ((resolvedObject = resource.getEObject(id)) != null && resolvedObject != proxy) {
                    return ClipboardSupportUtil.resolve(resolvedObject, resource);
                }
            }
            catch (Exception exception) {
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.eclipse.gmf.runtime.emf.clipboard.core.ClipboardSupportUtil");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                ClipboardPlugin.catching(clazz, RESOLVE, exception);
            }
        }
        return proxy;
    }

    private static String getProxyID(URI proxyUri) {
        String uriFragment = proxyUri.fragment();
        int index = uriFragment.indexOf(63);
        return index != -1 ? uriFragment.substring(0, index) : uriFragment;
    }

    public static EReference getPasteContainmentFeature(EObject parentEObject, EObject eObject, EReference originalReference) {
        ArrayList<EReference> compatibleRefrencesList = new ArrayList<EReference>();
        EClass parentEClass = parentEObject.eClass();
        EClass childEClass = eObject.eClass();
        Iterator it = parentEClass.getEAllReferences().iterator();
        EReference parentReference = null;
        while (it.hasNext()) {
            parentReference = (EReference)it.next();
            if (!parentReference.isContainment()) continue;
            if (originalReference != null && parentReference.equals(originalReference)) {
                return parentReference;
            }
            if (!ClipboardSupportUtil.isMutable(parentReference) || !ClipboardSupportUtil.createClipboardSupport(parentEObject).canContain(parentEObject, parentReference, childEClass)) continue;
            compatibleRefrencesList.add(parentReference);
        }
        if (compatibleRefrencesList.size() == 0) {
            return null;
        }
        if (compatibleRefrencesList.size() == 1) {
            return (EReference)compatibleRefrencesList.get(0);
        }
        EReference[] references = compatibleRefrencesList.toArray(EMPTY_REF_ARRAY);
        EReference ref = null;
        if (originalReference != null) {
            ref = (EReference)ClipboardSupportUtil.matchName((ENamedElement[])references, originalReference.getName(), true);
        }
        return ref == null ? (EReference)ClipboardSupportUtil.matchName((ENamedElement[])references, childEClass.getName(), true) : ref;
    }
}

