/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.gef.ui.figures;

import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.ImageFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.PrecisionPoint;
import org.eclipse.draw2d.geometry.Ray;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gmf.runtime.draw2d.ui.geometry.LineSeg;
import org.eclipse.gmf.runtime.draw2d.ui.geometry.PointListUtilities;
import org.eclipse.gmf.runtime.gef.ui.figures.SlidableAnchor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;

public class SlidableImageAnchor
extends SlidableAnchor {
    private ImageFigure imageFig;

    public SlidableImageAnchor() {
    }

    public SlidableImageAnchor(IFigure f) {
        super(f);
    }

    public SlidableImageAnchor(IFigure container, ImageFigure imageFig) {
        super(container);
        this.imageFig = imageFig;
    }

    public SlidableImageAnchor(IFigure f, ImageFigure imageFig, PrecisionPoint p) {
        super(f, p);
        this.imageFig = imageFig;
    }

    protected Image getImage() {
        return this.imageFig.getImage();
    }

    protected IFigure getContainer() {
        return this.getOwner();
    }

    protected Point getLocation(Point ownReference, Point foreignReference) {
        Image image = this.getImage();
        if (image == null) {
            return super.getLocation(ownReference, foreignReference);
        }
        Rectangle ownerRect = new Rectangle(this.getBox());
        PointList intersections = this.getIntersectionPoints(ownReference, foreignReference);
        if (intersections != null && intersections.size() != 0) {
            Point ptRef = PointListUtilities.pickFarestPoint((PointList)intersections, (Point)foreignReference);
            Point ptEdge = PointListUtilities.pickClosestPoint((PointList)intersections, (Point)foreignReference);
            Point loc = ImageAnchorLocation.getInstance(this.getImage()).getLocation(ptRef, ptEdge, ownerRect, this.isDefaultAnchor());
            if (loc != null) {
                loc = this.normalizeToStraightlineTolerance(foreignReference, loc, 3);
            }
            return loc;
        }
        return null;
    }

    private static class ImageAnchorLocation {
        private static Map imageAnchorLocationMap = new WeakHashMap();
        private Map locationMap = new HashMap();
        private ImageData imgData = null;
        private ImageData transMaskData = null;

        static ImageAnchorLocation getInstance(Image image) {
            ImageAnchorLocation imgAnchorLoc = (ImageAnchorLocation)imageAnchorLocationMap.get(image);
            if (imgAnchorLoc == null) {
                imgAnchorLoc = new ImageAnchorLocation(image);
                imageAnchorLocationMap.put(image, imgAnchorLoc);
            }
            return imgAnchorLoc;
        }

        ImageAnchorLocation(Image img) {
            this.imgData = img.getImageData();
            this.transMaskData = this.imgData.getTransparencyMask();
        }

        protected ImageData getImageData() {
            return this.imgData;
        }

        protected ImageData getTransparencyMaskData() {
            return this.transMaskData;
        }

        protected boolean isTransparentAt(int x, int y, boolean checkAdjacent) {
            if (x < 0 || x >= this.getImageData().width || y < 0 || y >= this.getImageData().height) {
                return true;
            }
            int transValue = 255;
            if (this.getTransparencyMaskData() != null) {
                int n = transValue = this.getTransparencyMaskData().getPixel(x, y) == 0 ? 0 : 255;
            }
            if (transValue != 0 && this.getImageData().alphaData != null) {
                transValue = this.getImageData().getAlpha(x, y);
            }
            boolean trans = false;
            if (transValue < 10) {
                trans = true;
                if (checkAdjacent) {
                    trans &= this.isTransparentAt(x + 1, y, false);
                    trans &= this.isTransparentAt(x + 1, y + 1, false);
                    trans &= this.isTransparentAt(x + 1, y - 1, false);
                    trans &= this.isTransparentAt(x - 1, y + 1, false);
                    trans &= this.isTransparentAt(x - 1, y, false);
                    trans &= this.isTransparentAt(x - 1, y - 1, false);
                    trans &= this.isTransparentAt(x, y + 1, false);
                    trans &= this.isTransparentAt(x, y - 1, false);
                }
            }
            return trans;
        }

        private Point getLocation(Point start, Point edge, Rectangle containerRect, boolean isDefaultAnchor) {
            int angle = this.calculateAngleOfEntry(start, edge);
            Point top = containerRect.getTopLeft();
            Point ptIntersect = null;
            if (isDefaultAnchor) {
                ptIntersect = (Point)this.locationMap.get(new Integer(angle));
            }
            if (ptIntersect == null) {
                Dimension dim = edge.getDifference(top);
                Point edgeImg = new Point(Math.max(0, Math.min(dim.width, this.getImageData().width - 1)), Math.max(0, Math.min(dim.height, this.getImageData().height - 1)));
                Dimension startDim = start.getDifference(top);
                Point startImg = new Point(Math.max(0, Math.min(startDim.width, this.getImageData().width - 1)), Math.max(0, Math.min(startDim.height, this.getImageData().height - 1)));
                ptIntersect = this.calculateIntersection(startImg, edgeImg);
                if (ptIntersect == null) {
                    return null;
                }
                if (isDefaultAnchor) {
                    this.locationMap.put(new Integer(angle), ptIntersect);
                }
            }
            return ptIntersect.getTranslated(top.x, top.y);
        }

        private int calculateAngleOfEntry(Point start, Point edge) {
            LineSeg lineSeg = new LineSeg(start, edge);
            Ray ray = new Ray(lineSeg.getOrigin(), new Point(lineSeg.getOrigin().x + 1, lineSeg.getOrigin().y));
            double angle = 0.0;
            LineSeg.TrigValues trig = lineSeg.getTrigValues(ray);
            if (trig != null) {
                angle = Math.atan2(-trig.sinTheta, -trig.cosTheta) + Math.PI;
            }
            int keyAngle = (int)Math.round(angle * 360.0 / (Math.PI * 2));
            return keyAngle - keyAngle % 10;
        }

        private Point calculateIntersection(Point start, Point edge) {
            Point opaque = new Point(edge);
            LineSeg line = new LineSeg(start, edge);
            long distance = Math.round(line.length());
            while (opaque.x >= 0 && opaque.x < this.getImageData().width && opaque.y >= 0 && opaque.y < this.getImageData().height) {
                if (!this.isTransparentAt(opaque.x, opaque.y, true)) {
                    return opaque;
                }
                line.pointOn(distance, LineSeg.KeyPoint.ORIGIN, opaque);
                --distance;
            }
            return null;
        }
    }
}

