#!/bin/sh
# *********************************************************************
# Copyright (c) 2006 IBM Corporation and others.
# All rights reserved.   This program and the accompanying materials
# are made available under the terms of the Eclipse Public License v1.0
# which accompanies this distribution, and is available at
# http://www.eclipse.org/legal/epl-v10.html
# $Id: run_example.sh,v 1.1 2006/01/26 20:33:22 dnsmith Exp $
#
# Contributors: 
# IBM - Initial API and implementation
# *********************************************************************
#
# USAGE:  run_example.sh
# PURPOSE:  Illustrates the functional capabilities of the Generic Log Adapter (GLA)
#           run-time using an example adapter file and sample log file.
# ASSUMPTIONS:  This shell file assumes the GLA run-time and required files are
#               stored in the following directory structure:
#      $GLA_HOME/bin    - GLA base shell files
#      $GLA_HOME/config - GLA adapter configuration files
#      $GLA_HOME/lib    - GLA run-time and required jars
#      $GLA_HOME/schema - GLA adapter configuration schema files
# INSTRUCTIONS:
#     If the GLA run-time and required files are stored as indicated in the
#         assumptions section above, change the value of the GLA_HOME
#         environment variable to the absolute path where the GLA run-time
#         and required files are stored.  This shell file executes the
#         base shell file $GLA_HOME/bin/gla.sh.  Open the base shell
#         file $GLA_HOME/bin/gla.sh in an editor and follow the
#         instructions in that file.
#     If the GLA run-time files are stored in a plug-in (e.g. Eclipse)
#         environment, perform the following instructions:
#        1) Open the base shell file scripts/gla.sh located in the
#           org.eclipse.hyades.logging.adapter plugin directory in an editor
#           and follow the instructions in that file.
#        2) Change the value of the GLA_HOME environment variable below to the
#           absolute path of the new directory created as a result of step 1)
#

GLA_HOME=/home/eclipse/GenericLogAdapter
export GLA_HOME

CUR_DIR=`pwd`
export CUR_DIR

cd "$GLA_HOME/config/XML/Java/logging/v1.4"

"$GLA_HOME"/bin/gla.sh static_example.adapter

cd "$CUR_DIR"

