/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.probekit.editor.internal.core.newFile;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.hyades.models.internal.probekit.DataItem;
import org.eclipse.hyades.models.internal.probekit.DataType;
import org.eclipse.hyades.models.internal.probekit.FragmentType;
import org.eclipse.hyades.probekit.editor.internal.core.newFile.IProbeMetaData;
import org.eclipse.hyades.probekit.editor.internal.core.newFile.ProbekitTypesSingleton;
import org.eclipse.hyades.probekit.editor.internal.core.util.ProbekitMessages;

public abstract class AbstractProbeMetaData
implements IProbeMetaData {
    private FragmentType _probeFragmentType;
    private List _dataItems;
    protected static final String DEFAULT_CODE = ProbekitMessages._65;

    protected AbstractProbeMetaData() {
        this.setFragmentType(this.getDefaultFragmentType());
        this._dataItems = new ArrayList(ProbekitTypesSingleton.singleton().getDataTypes(this.getFragmentType()).length);
    }

    protected AbstractProbeMetaData(IProbeMetaData probe) {
        this();
        this.setTypes(probe);
    }

    public String getCode() {
        return DEFAULT_CODE;
    }

    public final FragmentType getFragmentType() {
        return this._probeFragmentType;
    }

    public final String getFragmentTypeExplanation() {
        return ProbekitTypesSingleton.singleton().getFragmentTypeExplanation(this.getFragmentType());
    }

    public final void setFragmentType(FragmentType type) {
        this._probeFragmentType = this.isValidFragmentType(type) ? type : this.getDefaultFragmentType();
    }

    protected abstract FragmentType getDefaultFragmentType();

    public void release() {
        this._probeFragmentType = null;
        this._dataItems.clear();
    }

    protected final void setTypes(IProbeMetaData probe) {
        this.release();
        this.setFragmentType(probe.getFragmentType());
        DataItem[] items = probe.getDataItems();
        int i = 0;
        while (i < items.length) {
            DataItem item = items[i];
            this._dataItems.add(item);
            ++i;
        }
    }

    public void forceValid() {
        FragmentType type = this.getFragmentType();
        FragmentType[] validTypes = this.getAvailableFragmentTypes();
        boolean valid = false;
        int i = 0;
        while (i < validTypes.length) {
            FragmentType validType = validTypes[i];
            if (validType.equals(type)) {
                valid = true;
                break;
            }
            ++i;
        }
        if (!valid) {
            this.setFragmentType(this.getDefaultFragmentType());
        }
        DataItem[] dataItems = this.getDataItems();
        DataItem[] temp = new DataItem[dataItems.length];
        int count = 0;
        int i2 = 0;
        while (i2 < dataItems.length) {
            DataItem item = dataItems[i2];
            if (this.isValidDataItem(type, item)) {
                temp[count++] = item;
            }
            ++i2;
        }
        DataItem[] validItems = new DataItem[count];
        System.arraycopy(temp, 0, validItems, 0, count);
        this.setDataItems(validItems);
    }

    public DataType[] getAvailableDataTypes() {
        DataType[] allTypes = ProbekitTypesSingleton.singleton().getDataTypes(this.getFragmentType());
        DataType[] typesUsedSoFar = this.getInUseDataTypes();
        DataType[] temp = new DataType[allTypes.length];
        int count = 0;
        int i = 0;
        while (i < allTypes.length) {
            DataType type = allTypes[i];
            boolean inUse = false;
            int j = 0;
            while (j < typesUsedSoFar.length) {
                DataType inUseType = typesUsedSoFar[j];
                if (type.equals(inUseType)) {
                    inUse = true;
                    break;
                }
                ++j;
            }
            if (!inUse) {
                temp[count++] = type;
            }
            ++i;
        }
        DataType[] availableTypes = new DataType[count];
        System.arraycopy(temp, 0, availableTypes, 0, count);
        return availableTypes;
    }

    public String[] getDataTypeNames(DataItem selectedItem) {
        DataType[] types = this.getAvailableDataTypes();
        String[] names = null;
        if (selectedItem == null) {
            names = new String[types.length];
            int i = 0;
            while (i < types.length) {
                names[i] = types[i].getName();
                ++i;
            }
        } else {
            DataType type = selectedItem.getType();
            names = new String[types.length + 1];
            names[0] = type.getName();
            int i = 0;
            while (i < types.length) {
                names[i + 1] = types[i].getName();
                ++i;
            }
        }
        return names;
    }

    public String getDataTypeExplanation(DataItem item) {
        if (item == null) {
            return "";
        }
        return ProbekitTypesSingleton.singleton().getDataTypeExplanation(item.getType());
    }

    public int countDataItems() {
        return this._dataItems.size();
    }

    public DataItem[] getDataItems() {
        return this._dataItems.toArray(new DataItem[0]);
    }

    public void addDataItem(DataItem item) {
        this._dataItems.add(item);
    }

    public void removeDataItem(DataItem item) {
        this._dataItems.remove(item);
    }

    public void setDataItems(DataItem[] items) {
        this._dataItems.clear();
        int i = 0;
        while (i < items.length) {
            this._dataItems.add(items[i]);
            ++i;
        }
    }

    public void setDataItem(int index, DataItem item) {
        this._dataItems.set(index, item);
    }

    public DataItem[] getInvalidDataItems(FragmentType type) {
        DataItem[] dataItems = this.getDataItems();
        DataItem[] temp = new DataItem[dataItems.length];
        int count = 0;
        int i = 0;
        while (i < dataItems.length) {
            DataItem item = dataItems[i];
            if (!this.isValidDataItem(type, item)) {
                temp[count++] = item;
            }
            ++i;
        }
        DataItem[] invalidItems = new DataItem[count];
        System.arraycopy(temp, 0, invalidItems, 0, count);
        return invalidItems;
    }

    private boolean isValidFragmentType(FragmentType type) {
        FragmentType[] validTypes = this.getAvailableFragmentTypes();
        int i = 0;
        while (i < validTypes.length) {
            FragmentType validType = validTypes[i];
            if (validType.equals(type)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean isValidDataItem(FragmentType type, DataItem item) {
        DataType[] items = ProbekitTypesSingleton.singleton().getDataTypes(type);
        DataType itemType = item.getType();
        int i = 0;
        while (i < items.length) {
            if (itemType.equals(items[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private final DataType[] getInUseDataTypes() {
        DataItem[] items = this.getDataItems();
        DataType[] inUse = new DataType[items.length];
        int i = 0;
        while (i < items.length) {
            DataItem item = items[i];
            inUse[i] = item.getType();
            ++i;
        }
        return inUse;
    }
}

