/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.probekit.editor.internal.core.newFile;

import java.util.Arrays;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.hyades.models.internal.probekit.DataItem;
import org.eclipse.hyades.models.internal.probekit.DataType;
import org.eclipse.hyades.models.internal.probekit.DocumentRoot;
import org.eclipse.hyades.models.internal.probekit.Fragment;
import org.eclipse.hyades.models.internal.probekit.FragmentType;
import org.eclipse.hyades.models.internal.probekit.Probe;
import org.eclipse.hyades.models.internal.probekit.Probekit;
import org.eclipse.hyades.models.internal.probekit.ProbekitFactory;
import org.eclipse.hyades.models.internal.probekit.ProbekitPackage;
import org.eclipse.hyades.probekit.editor.internal.core.newFile.IProbeMetaData;
import org.eclipse.hyades.probekit.editor.internal.core.newFile.ProbekitTypesSingleton;
import org.eclipse.hyades.probekit.editor.internal.core.util.JavaUtil;
import org.eclipse.hyades.probekit.editor.internal.core.util.ProbekitMessages;
import org.eclipse.hyades.probekit.ui.internal.ProbekitUIPlugin;
import org.eclipse.jdt.core.JavaModelException;

public final class ProbeFileModel {
    private IProbeMetaData _probeMetaData = null;
    private String _sourceContainerPath = null;
    private String _fileName = "myprobe.probe";
    private String _encoding = null;
    private static final String FILE_EXTENSION = ".probe";
    private static final String FILE_NAME_DEFAULT = "myprobe.probe";
    private static final String NO_CONTAINER = "";
    private static final String XML_ENCODING_CHOICES = "ASCII UTF-8 UTF-16 UTF-16BE UTF-16LE ISO-8859-1";
    private static final String XML_ENCODING_DEFAULT = "UTF-8";
    private static final ProbekitPackage PROBEKIT_PACKAGE = ProbekitPackage.eINSTANCE;
    private static final ProbekitFactory PROBEKIT_FACTORY = PROBEKIT_PACKAGE.getProbekitFactory();

    public ProbeFileModel(IProbeMetaData probe) {
        this.setProbeMetaData(probe);
    }

    public final DocumentRoot createInitialModel() {
        DocumentRoot documentRoot = PROBEKIT_FACTORY.createDocumentRoot();
        Probekit probekit = PROBEKIT_FACTORY.createProbekit();
        documentRoot.setProbekit(probekit);
        if (this.getProbeMetaData().getProbeType() != 2) {
            probekit.getProbe().add((Object)this.createProbe());
        }
        return documentRoot;
    }

    public Probe createProbe() {
        Probe probe = PROBEKIT_FACTORY.createProbe();
        FragmentType type = this.getProbeMetaData().getFragmentType();
        Fragment fragment = PROBEKIT_FACTORY.createFragment();
        fragment.setType(type);
        fragment.setCode(this.getProbeMetaData().getCode());
        fragment.getData().addAll(Arrays.asList(this.getProbeMetaData().getDataItems()));
        probe.getFragment().add((Object)fragment);
        return probe;
    }

    public void forceValid() {
        this.getProbeMetaData().forceValid();
    }

    public IFile getModelFile() throws JavaModelException {
        IContainer sourceContainer = JavaUtil.getSourceContainer(this._sourceContainerPath);
        if (sourceContainer == null) {
            return null;
        }
        IPath filePath = sourceContainer.getFullPath().append(this._fileName);
        return ResourcesPlugin.getWorkspace().getRoot().getFile(filePath);
    }

    public String[] getXMLEncodingChoices() {
        StringTokenizer stringTokenizer = new StringTokenizer(XML_ENCODING_CHOICES);
        String[] choices = new String[stringTokenizer.countTokens()];
        int count = 0;
        while (stringTokenizer.hasMoreTokens()) {
            choices[count++] = stringTokenizer.nextToken();
        }
        return choices;
    }

    public String getDefaultEncoding() {
        return XML_ENCODING_DEFAULT;
    }

    public String getEncoding() {
        if (this._encoding != null) {
            return this._encoding;
        }
        return this.getDefaultEncoding();
    }

    public void setEncoding(String encoding) {
        this._encoding = encoding;
    }

    public void release() {
        this.getProbeMetaData().release();
    }

    public DataItem createDataItem() {
        DataType[] availableTypes = this.getProbeMetaData().getAvailableDataTypes();
        DataItem item = ProbekitTypesSingleton.singleton().createDataItem(availableTypes, this.getProbeMetaData().countDataItems());
        this.getProbeMetaData().addDataItem(item);
        return item;
    }

    public String getDataExplanation() {
        return ProbekitMessages._66;
    }

    public boolean isValidCombination(IProbeMetaData newProbe, FragmentType type) {
        DataItem[] invalidDataItems = this.getInvalidDataItems(newProbe, type);
        return invalidDataItems.length == 0;
    }

    public boolean isValidFileName() {
        if (!this._fileName.endsWith(FILE_EXTENSION)) {
            return false;
        }
        return this._fileName.length() > FILE_EXTENSION.length();
    }

    public boolean isValidFile() {
        try {
            IFile file = this.getModelFile();
            if (file == null || file.exists()) {
                return false;
            }
        }
        catch (JavaModelException exc) {
            ProbekitUIPlugin.getPlugin().log((Object)exc);
            return false;
        }
        return true;
    }

    public boolean isValidSourceContainer() {
        try {
            IContainer container = JavaUtil.getSourceContainer(this.getSourceContainerPath());
            return container != null;
        }
        catch (JavaModelException javaModelException) {
            return false;
        }
    }

    public boolean isValidDataItems() {
        DataItem[] items = this.getProbeMetaData().getDataItems();
        return ProbekitTypesSingleton.singleton().isValidDataItemNames(items);
    }

    public DataItem[] getInvalidDataItems(IProbeMetaData probe, FragmentType type) {
        return probe.getInvalidDataItems(type);
    }

    public IProbeMetaData getProbeMetaData() {
        return this._probeMetaData;
    }

    public void setProbeMetaData(IProbeMetaData probe) {
        this._probeMetaData = probe;
    }

    public String getSourceContainerPath() {
        return this._sourceContainerPath;
    }

    public void setSourceContainerPath(String containerPath) {
        this._sourceContainerPath = containerPath;
    }

    public void setSourceContainer(IContainer container) {
        String path = container == null ? NO_CONTAINER : container.getFullPath().toString();
        this.setSourceContainerPath(path);
    }

    public String getFileName() {
        return this._fileName;
    }

    public void setFileName(String fileName) {
        this._fileName = fileName;
    }
}

