/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.probekit.editor.internal.core.util;

import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.JavaCore;

public final class ConversionUtil {
    public static final char FILE_SEPARATOR = System.getProperty("file.separator").charAt(0);
    public static final String LINE_SEPARATOR = System.getProperty("line.separator");

    public static String toOSStringFromURL(URL url) throws IOException {
        URL localURL = FileLocator.toFileURL((URL)url);
        String result = localURL.getPath();
        if ("win32".equals(Platform.getOS())) {
            if (result.charAt(0) == '/') {
                result = result.substring(1);
            }
            result = result.replace('/', FILE_SEPARATOR);
        }
        return result;
    }

    public static IResource[] toResourceFromJavaElements(IJavaElement[] elements) {
        HashSet<IResource> resources = new HashSet<IResource>(elements.length);
        int i = 0;
        while (i < elements.length) {
            IJavaElement element = elements[i];
            IResource resource = element.getResource();
            if (resource != null && resource.isAccessible()) {
                resources.add(resource);
            }
            ++i;
        }
        return resources.toArray(new IResource[0]);
    }

    public static IResource[] toResourceFromCompounds(List elements) {
        HashSet resources = new HashSet(elements.size());
        Iterator iterator = elements.iterator();
        while (iterator.hasNext()) {
            IResource res;
            Object element = iterator.next();
            if (element instanceof IResource) {
                resources.add(element);
                continue;
            }
            if (!(element instanceof IJavaElement) || (res = ((IJavaElement)element).getResource()) == null || !res.isAccessible()) continue;
            resources.add(res);
        }
        return resources.toArray(new IResource[0]);
    }

    public static IFile[] toFileArrayFromIClassFiles(List classFiles) {
        HashSet<IResource> files = new HashSet<IResource>(classFiles.size());
        Iterator iterator = classFiles.iterator();
        while (iterator.hasNext()) {
            IClassFile cFile = (IClassFile)iterator.next();
            IResource res = cFile.getResource();
            if (res == null) continue;
            files.add(res);
        }
        return files.toArray(new IFile[0]);
    }

    public static IJavaElement[] toJavaElementFromResources(IResource[] resources) {
        HashSet<IJavaElement> elements = new HashSet<IJavaElement>(resources.length);
        int i = 0;
        while (i < resources.length) {
            IResource res = resources[i];
            IJavaElement element = JavaCore.create((IResource)res);
            if (element != null && element.exists()) {
                elements.add(element);
            }
            ++i;
        }
        return elements.toArray(new IJavaElement[0]);
    }

    public static IJavaElement[] castToJavaElementFromArray(Object[] obj) {
        IJavaElement[] result = new IJavaElement[obj.length];
        int i = 0;
        while (i < obj.length) {
            result[i] = (IJavaElement)obj[i];
            ++i;
        }
        return result;
    }

    public static IJavaElement[] castToJavaElementFromCollection(Collection collection) {
        return collection.toArray(new IJavaElement[0]);
    }

    public static String toLineDelimitedString(List list) {
        StringBuffer buffer = new StringBuffer(LINE_SEPARATOR);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            buffer.append(iterator.next());
            buffer.append(LINE_SEPARATOR);
        }
        return buffer.toString();
    }

    public static String toLineDelimitedString(String[] string) {
        StringBuffer buffer = new StringBuffer(LINE_SEPARATOR);
        int i = 0;
        while (i < string.length) {
            buffer.append(string[i]);
            buffer.append(LINE_SEPARATOR);
            ++i;
        }
        return buffer.toString();
    }

    public static String toLineDelimitedString(IMarker[] markers) throws CoreException {
        StringBuffer buffer = new StringBuffer(LINE_SEPARATOR);
        int i = 0;
        while (i < markers.length) {
            IMarker marker = markers[i];
            Object message = marker.getAttribute("message");
            buffer.append(message);
            buffer.append(LINE_SEPARATOR);
            ++i;
        }
        return buffer.toString();
    }

    private ConversionUtil() {
    }
}

