/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.probekit.editor.internal.core.util;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.hyades.probekit.editor.internal.core.util.ResourceUtil;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;

public class JavaUtil {
    public static final String DOT_CLASS_EXTENSION = ".class";
    public static final String DOT_JAVA_EXTENSION = ".java";
    public static final String JAVA_EXTENSION = "java";
    public static final String CLASS_EXTENSION = "class";
    public static final String PROBEKIT_CLASS_FOLDER_NAME = "_probekit_probes_";

    public static IJavaElement[] getDirectChildren(IJavaElement parent, IJavaElement[] children) {
        HashSet<IJavaElement> temp = new HashSet<IJavaElement>(children.length);
        int i = 0;
        while (i < children.length) {
            IJavaElement element = children[i];
            IJavaElement directChild = JavaUtil.getDirectChild(parent, element);
            if (directChild != null) {
                temp.add(directChild);
            }
            ++i;
        }
        return temp.toArray(new IJavaElement[0]);
    }

    private static IJavaElement getDirectChild(IJavaElement parent, IJavaElement element) {
        IJavaElement directChild = element;
        IJavaElement elementParent = element.getParent();
        while (elementParent != null) {
            if (parent.equals(elementParent)) {
                return directChild;
            }
            directChild = elementParent;
            elementParent = elementParent.getParent();
        }
        return null;
    }

    public static IPackageFragment[] getAllPackageFragments(IJavaProject jp) throws JavaModelException {
        IPackageFragmentRoot[] roots = jp.getAllPackageFragmentRoots();
        ArrayList<IJavaElement> fragments = new ArrayList<IJavaElement>(roots.length);
        int i = 0;
        while (i < roots.length) {
            IPackageFragmentRoot root = roots[i];
            IJavaElement[] rootFragments = root.getChildren();
            int j = 0;
            while (j < rootFragments.length) {
                fragments.add(rootFragments[j]);
                ++j;
            }
            ++i;
        }
        return fragments.toArray(new IPackageFragment[fragments.size()]);
    }

    public static IClassFile getClassFile(IFile file) {
        IJavaElement element = JavaCore.create((IFile)file);
        IClassFile result = null;
        if (element != null && element.getElementType() == 6) {
            result = (IClassFile)element;
        }
        return result;
    }

    public static IClassFile[] getClassFiles(IFile javaFile) throws JavaModelException {
        ICompilationUnit cu = (ICompilationUnit)JavaCore.create((IFile)javaFile);
        if (cu == null || !cu.exists()) {
            return new IClassFile[0];
        }
        IType[] types = cu.getAllTypes();
        HashSet<IClassFile> files = new HashSet<IClassFile>(types.length);
        int i = 0;
        while (i < types.length) {
            IType type = types[i];
            IClassFile cfile = JavaUtil.getClassFile(JavaUtil.getOutputContainer(javaFile), type);
            if (cfile != null) {
                files.add(cfile);
            }
            ++i;
        }
        return files.toArray(new IClassFile[0]);
    }

    public static IFile[] getCompiledFiles(IClassFile[] cFiles) {
        HashSet<IFile> files = new HashSet<IFile>(cFiles.length);
        int i = 0;
        while (i < cFiles.length) {
            IFile file;
            IClassFile cFile = cFiles[i];
            IResource res = cFile.getResource();
            if (res != null && CLASS_EXTENSION.equals((file = (IFile)res).getFileExtension())) {
                files.add(file);
            }
            ++i;
        }
        return files.toArray(new IFile[files.size()]);
    }

    public static IFile[] getCompiledFiles(IFile javaFile) throws JavaModelException {
        IClassFile[] cFiles = JavaUtil.getClassFiles(javaFile);
        return JavaUtil.getCompiledFiles(cFiles);
    }

    private static IClassFile getClassFile(IContainer outputContainer, IType type) {
        IClassFile cfile = type.getClassFile();
        if (cfile != null) {
            return cfile;
        }
        Path newFile = new Path(String.valueOf(type.getTypeQualifiedName()) + DOT_CLASS_EXTENSION);
        IPackageFragment packageFragment = type.getPackageFragment();
        Path newFilePackage = new Path(packageFragment.getElementName().replace('.', '/'));
        IFile file = outputContainer.getFile(newFilePackage.append((IPath)newFile));
        return JavaUtil.getClassFile(file);
    }

    public static IJavaProject[] getAllJavaProjects() {
        IProject[] projects = ResourceUtil.ROOT.getProjects();
        IJavaProject[] javaProjects = new IJavaProject[projects.length];
        int count = 0;
        int i = 0;
        while (i < projects.length) {
            IJavaProject jp = JavaCore.create((IProject)projects[i]);
            if (jp.exists()) {
                javaProjects[count++] = jp;
            }
            ++i;
        }
        IJavaProject[] results = new IJavaProject[count];
        System.arraycopy(javaProjects, 0, results, 0, count);
        return results;
    }

    public static IJavaProject[] getSourceJavaProjects() throws JavaModelException {
        IJavaProject[] jprojects = JavaUtil.getAllJavaProjects();
        ArrayList<IJavaProject> temp = new ArrayList<IJavaProject>(25);
        int i = 0;
        while (i < jprojects.length) {
            IJavaProject jp = jprojects[i];
            List srcContainers = JavaUtil.getSourceContainers(jp);
            if (srcContainers.size() > 0) {
                temp.add(jp);
            }
            ++i;
        }
        return temp.toArray(new IJavaProject[0]);
    }

    public static IProject[] getProjects(List resources) {
        HashSet<IProject> projects = new HashSet<IProject>(resources.size());
        Iterator iterator = resources.iterator();
        while (iterator.hasNext()) {
            IResource res = (IResource)iterator.next();
            projects.add(res.getProject());
        }
        return projects.toArray(new IProject[0]);
    }

    public static IJavaProject[] getJavaProjectsFromCompound(List resources) {
        HashSet<IJavaProject> projects = new HashSet<IJavaProject>(resources.size());
        Iterator iterator = resources.iterator();
        while (iterator.hasNext()) {
            Object obj = iterator.next();
            IJavaProject jp = null;
            if (obj instanceof IResource) {
                IResource res = (IResource)obj;
                IProject project = res.getProject();
                jp = JavaCore.create((IProject)project);
            } else if (obj instanceof IJavaElement) {
                IJavaElement element = (IJavaElement)obj;
                jp = element.getJavaProject();
            }
            if (jp == null || !jp.exists()) continue;
            projects.add(jp);
        }
        return projects.toArray(new IJavaProject[projects.size()]);
    }

    public static IProject[] getProjects(IJavaProject[] javaProjects) {
        IProject[] projects = new IProject[javaProjects.length];
        int i = 0;
        while (i < javaProjects.length) {
            projects[i] = javaProjects[i].getProject();
            ++i;
        }
        return projects;
    }

    public static boolean isBinaryProject(IJavaProject jp) throws JavaModelException {
        if (jp == null) {
            return false;
        }
        return JavaUtil.getSourceContainerEntries(jp).isEmpty();
    }

    public static IPath createClassFolder(IJavaProject jp) throws JavaModelException, CoreException {
        IPath jpPath = jp.getProject().getFullPath();
        IPath newClassFolderPath = jpPath.append(PROBEKIT_CLASS_FOLDER_NAME);
        IFolder newFolder = ResourcesPlugin.getWorkspace().getRoot().getFolder(newClassFolderPath);
        if (!newFolder.exists()) {
            newFolder.create(true, true, (IProgressMonitor)new NullProgressMonitor());
        }
        if (!jp.isOnClasspath((IResource)newFolder)) {
            IClasspathEntry newClassFolderEntry = JavaCore.newLibraryEntry((IPath)newClassFolderPath, null, null);
            IClasspathEntry[] oldClasspath = jp.getRawClasspath();
            IClasspathEntry[] newClasspath = new IClasspathEntry[oldClasspath.length + 1];
            System.arraycopy(oldClasspath, 0, newClasspath, 0, oldClasspath.length);
            newClasspath[oldClasspath.length] = newClassFolderEntry;
            jp.setRawClasspath(newClasspath, (IProgressMonitor)new NullProgressMonitor());
        }
        return newClassFolderPath;
    }

    public static IContainer[] getClassContainers(IJavaProject jp) throws JavaModelException {
        HashSet<IResource> temp = new HashSet<IResource>();
        IClasspathEntry[] classpath = jp.getResolvedClasspath(true);
        int i = 0;
        while (i < classpath.length) {
            IResource resource;
            IClasspathEntry entry = classpath[i];
            if (entry.getEntryKind() == 1 && (resource = ResourceUtil.ROOT.findMember(entry.getPath())) != null && resource.getType() != 1) {
                temp.add(resource);
            }
            ++i;
        }
        return temp.toArray(new IContainer[temp.size()]);
    }

    public static IContainer getOutputContainer(IFile res) throws JavaModelException {
        IContainer container = res.getParent();
        IClasspathEntry sourceContainer = JavaUtil.getSourceContainerEntry(container);
        if (sourceContainer == null) {
            return null;
        }
        IPath outputPath = sourceContainer.getOutputLocation();
        if (outputPath == null) {
            IJavaProject jp = JavaCore.create((IProject)res.getProject());
            outputPath = jp.getOutputLocation();
        }
        return (IContainer)ResourceUtil.ROOT.findMember(outputPath);
    }

    public static List getSourceContainers() throws JavaModelException {
        return JavaUtil.getSourceContainers(JavaUtil.getSourceJavaProjects());
    }

    public static List getSourceContainers(IJavaProject[] javaProjects) throws JavaModelException {
        ArrayList includedResources = new ArrayList(javaProjects.length);
        int i = 0;
        while (i < javaProjects.length) {
            IJavaProject jp = javaProjects[i];
            includedResources.addAll(JavaUtil.getSourceContainers(jp));
            ++i;
        }
        return includedResources;
    }

    public static List getSourceContainers(IJavaProject jp) throws JavaModelException {
        List entries = JavaUtil.getSourceContainerEntries(jp);
        ArrayList<IResource> containers = new ArrayList<IResource>(entries.size());
        Iterator iterator = entries.iterator();
        while (iterator.hasNext()) {
            IResource resource;
            IClasspathEntry entry = (IClasspathEntry)iterator.next();
            if (entry.getEntryKind() != 3 || (resource = JavaUtil.getResource(entry)) == null || !resource.isAccessible()) continue;
            containers.add(resource);
        }
        return containers;
    }

    public static List getSourceContainerEntries(IJavaProject jp) throws JavaModelException {
        ArrayList<IClasspathEntry> containers = new ArrayList<IClasspathEntry>(10);
        IProject project = jp.getProject();
        if (project.isAccessible() && jp.exists()) {
            IClasspathEntry[] entries = jp.getResolvedClasspath(true);
            int i = 0;
            while (i < entries.length) {
                IClasspathEntry entry = entries[i];
                if (entry.getEntryKind() == 3) {
                    containers.add(entry);
                }
                ++i;
            }
        }
        return containers;
    }

    private static IClasspathEntry getSourceContainerEntry(IContainer container) throws JavaModelException {
        IJavaProject jp = JavaCore.create((IProject)container.getProject());
        List entries = JavaUtil.getSourceContainerEntries(jp);
        Iterator iterator = entries.iterator();
        while (iterator.hasNext()) {
            IClasspathEntry entry = (IClasspathEntry)iterator.next();
            if (!entry.getPath().isPrefixOf(container.getFullPath())) continue;
            return entry;
        }
        return null;
    }

    public static IContainer getSourceContainer(String containerPath) throws JavaModelException {
        IResource res = ResourceUtil.ROOT.findMember(containerPath);
        if (res == null) {
            return null;
        }
        if (!res.isAccessible()) {
            return null;
        }
        if (res.getType() == 1) {
            return null;
        }
        IContainer container = (IContainer)res;
        if (JavaUtil.isSourceContainer(container)) {
            return container;
        }
        return null;
    }

    private static IResource getResource(IClasspathEntry entry) {
        return ResourceUtil.ROOT.findMember(entry.getPath());
    }

    public static boolean isSourceContainer(IContainer container) throws JavaModelException {
        IProject project = container.getProject();
        IJavaProject jp = JavaCore.create((IProject)project);
        if (jp == null) {
            return false;
        }
        List sourceContainers = JavaUtil.getSourceContainers(jp);
        return sourceContainers.contains(container);
    }

    public static boolean isClassFile(IJavaElement element) {
        IResource res;
        int elementType = element.getElementType();
        return elementType == 6 && (res = element.getResource()) != null;
    }

    public static boolean isArchive(IJavaElement element) {
        IPackageFragmentRoot root;
        int elementType = element.getElementType();
        return elementType == 3 && (root = (IPackageFragmentRoot)element).isArchive();
    }

    private JavaUtil() {
    }
}

