/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.probekit.editor.internal.core.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.hyades.models.internal.probekit.DataItem;
import org.eclipse.hyades.probekit.editor.internal.core.util.JavaUtil;
import org.eclipse.hyades.probekit.editor.internal.core.util.ResourceUtil;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;

public class ProbekitUtil {
    private static final String PROBE_EXTENSION = "probe";
    public static final String URI_SCHEME_PLATFORM = "platform";
    public static final String URI_RESOURCE = "/resource";
    public static final String PROBEKIT_ICON_PATH = "full/wizban/NewProbekit";

    public static String getDataTypeName(DataItem item) {
        if (item == null) {
            return "";
        }
        String typeName = item.getType().getName();
        String result = typeName == null ? "" : typeName;
        return result;
    }

    public static String getDataItemName(DataItem item) {
        if (item == null) {
            return "";
        }
        String itemName = item.getName();
        String result = itemName == null ? "" : itemName;
        return result;
    }

    public static List getProbeFiles() throws JavaModelException, CoreException {
        List containers = JavaUtil.getSourceContainers();
        Iterator iterator = containers.iterator();
        ArrayList<IResource> includedResources = new ArrayList<IResource>(100);
        while (iterator.hasNext()) {
            IContainer container = (IContainer)iterator.next();
            IResource[] members = container.members();
            int j = 0;
            while (j < members.length) {
                IResource resource = members[j];
                if (resource.getType() == 1 && PROBE_EXTENSION.equals(resource.getFileExtension())) {
                    includedResources.add(resource);
                }
                ++j;
            }
        }
        return includedResources;
    }

    public static boolean isSupportedPlatform() {
        String os = Platform.getOS();
        if ("linux".equals(os)) {
            return true;
        }
        if ("solaris".equals(os)) {
            return true;
        }
        return "win32".equals(os);
    }

    public static IFile getProbeFile(EObject eObject) {
        Resource resource = eObject.eResource();
        URI uri = resource.getURI();
        if (uri.scheme().equals(URI_SCHEME_PLATFORM)) {
            String segments = uri.path();
            int index = URI_RESOURCE.length();
            String filePathString = segments.substring(index);
            IFile file = ResourceUtil.ROOT.getFile((IPath)new Path(filePathString));
            return file;
        }
        return null;
    }

    public static IJavaProject getJavaProject(EObject eObject) {
        IFile probeFile = ProbekitUtil.getProbeFile(eObject);
        if (probeFile != null && probeFile.isAccessible()) {
            IProject project = probeFile.getProject();
            return JavaCore.create((IProject)project);
        }
        return null;
    }

    public static Collection unwrap(Collection collection) {
        if (collection == null) {
            return null;
        }
        if (collection.isEmpty()) {
            return collection;
        }
        ArrayList result = new ArrayList();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Object o = iterator.next();
            if (o instanceof EObjectContainmentEList) {
                result.addAll((EObjectContainmentEList)o);
                continue;
            }
            result.add(o);
        }
        return result;
    }

    private ProbekitUtil() {
    }
}

