/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.probekit.editor.internal.core.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;

public final class ResourceUtil {
    public static final String PROBEKIT_EDITOR_ID = "org.eclipse.hyades.probekit.ui";
    public static final String NO_TEXT = "";
    public static final IWorkspaceRoot ROOT = ResourcesPlugin.getWorkspace().getRoot();
    private static String[] languageStrings = null;

    public static IStatus createStatusOk() {
        return ResourceUtil.createInitialStatus(1, NO_TEXT, 0, null);
    }

    public static IStatus createInitialStatus(int severity, String message) {
        return ResourceUtil.createInitialStatus(severity, message, 0, null);
    }

    public static IStatus createInitialStatus(int severity, Throwable exc) {
        return ResourceUtil.createInitialStatus(severity, NO_TEXT, 0, exc);
    }

    public static IStatus createInitialStatus(int severity, String message, Throwable exc) {
        return ResourceUtil.createInitialStatus(severity, message, 0, exc);
    }

    public static IStatus createInitialStatus(int severity, String message, int pluginSpecificCode) {
        return ResourceUtil.createInitialStatus(severity, message, pluginSpecificCode, null);
    }

    public static IStatus createInitialStatus(int severity, String message, int pluginSpecificCode, Throwable exc) {
        Status status = new Status(severity, PROBEKIT_EDITOR_ID, pluginSpecificCode, message, exc);
        return status;
    }

    public static String getString(String string) {
        if (string == null) {
            return NO_TEXT;
        }
        return string;
    }

    public static String getBaseName(IFile file) {
        String name = file.getName();
        int dotIndex = name.lastIndexOf(46);
        if (dotIndex == -1) {
            return name;
        }
        return name.substring(0, dotIndex);
    }

    public static Object[] filter(Object[] objects, Object[] toList) {
        List<Object> list = Arrays.asList(toList);
        return ResourceUtil.filter(objects, list);
    }

    public static Object[] filter(Object[] objects, List resources) {
        ArrayList<Object> temp = new ArrayList<Object>(objects.length);
        int i = 0;
        while (i < objects.length) {
            Object obj = objects[i];
            if (resources.contains(obj)) {
                temp.add(obj);
            }
            ++i;
        }
        return temp.toArray();
    }

    public static IResource[] getDirectChildren(IContainer container, IResource[] resources) {
        HashSet<IResource> temp = new HashSet<IResource>(resources.length);
        int i = 0;
        while (i < resources.length) {
            IResource res = resources[i];
            if (ResourceUtil.isMember(container, res)) {
                temp.add(ResourceUtil.getDirectChild(container, res));
            }
            ++i;
        }
        return temp.toArray(new IResource[0]);
    }

    private static IResource getDirectChild(IContainer container, IResource res) {
        IPath containerFullPath = container.getFullPath();
        IPath resourceFullPath = res.getFullPath();
        int containerPathCount = containerFullPath.segmentCount();
        int pathLength = resourceFullPath.segmentCount();
        int neededTrim = pathLength - containerPathCount - 1;
        IPath directChildPath = resourceFullPath.removeLastSegments(neededTrim);
        return ROOT.findMember(directChildPath);
    }

    public static IPath getRelativePath(IContainer container, IPath path) {
        IPath containerFullPath = container.getFullPath();
        int matchingFirstSegments = containerFullPath.matchingFirstSegments(path);
        IPath relPath = path.removeFirstSegments(matchingFirstSegments);
        return relPath;
    }

    public static boolean isMember(IContainer container, IResource res) {
        if (container.equals((Object)res)) {
            return false;
        }
        IPath containerFullPath = container.getFullPath();
        IPath resourceFullPath = res.getFullPath();
        return containerFullPath.isPrefixOf(resourceFullPath);
    }

    public static Set getErrors(IMarker[] markers) throws CoreException {
        HashSet<IMarker> markerSet = new HashSet<IMarker>(markers.length);
        int i = 0;
        while (i < markers.length) {
            IMarker marker = markers[i];
            Integer severity = (Integer)marker.getAttribute("severity");
            if (severity == 2) {
                markerSet.add(marker);
            }
            ++i;
        }
        return markerSet;
    }

    public static void waitForBuildToFinish(IProgressMonitor monitor) {
        try {
            Platform.getJobManager().join(ResourcesPlugin.FAMILY_AUTO_BUILD, monitor);
        }
        catch (InterruptedException interruptedException) {
        }
        catch (OperationCanceledException operationCanceledException) {}
    }

    private static String getLanguageISO3066(Locale locale) {
        String result = NO_TEXT;
        String language = locale.getLanguage();
        String country = locale.getCountry();
        if (language.length() > 0) {
            result = country.length() == 0 ? language : String.valueOf(language) + "-" + country;
        }
        return result;
    }

    public static String getLanguageDefault() {
        return ResourceUtil.getLanguageISO3066(Locale.getDefault());
    }

    public static String[] getLanguages() {
        if (languageStrings == null) {
            Locale[] locales = Locale.getAvailableLocales();
            HashSet<String> languages = new HashSet<String>(locales.length);
            int i = 0;
            while (i < locales.length) {
                Locale locale = locales[i];
                String language = ResourceUtil.getLanguageISO3066(locale);
                if (language.length() > 0) {
                    languages.add(language);
                }
                ++i;
            }
            languages.add(NO_TEXT);
            languageStrings = languages.toArray(new String[languages.size()]);
            Arrays.sort(languageStrings);
        }
        return languageStrings;
    }

    private ResourceUtil() {
    }
}

