/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.probekit.editor.internal.presentation;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.hyades.models.internal.probekit.Import;
import org.eclipse.hyades.models.internal.probekit.Probe;
import org.eclipse.hyades.models.internal.probekit.ProbekitFactory;
import org.eclipse.hyades.probekit.editor.internal.core.util.ProbekitMessages;
import org.eclipse.hyades.probekit.editor.internal.core.util.ResourceUtil;
import org.eclipse.hyades.probekit.editor.internal.presentation.GridUtil;
import org.eclipse.hyades.probekit.editor.internal.presentation.IDetails;
import org.eclipse.hyades.probekit.editor.internal.presentation.ProbekitWidgetFactory;
import org.eclipse.hyades.probekit.editor.internal.provider.AllImportsItemProvider;
import org.eclipse.hyades.probekit.editor.internal.provider.ImportItemProvider;
import org.eclipse.hyades.probekit.editor.internal.provider.ProbekitItemProviderAdapterFactory;
import org.eclipse.hyades.probekit.ui.internal.ProbekitUIPlugin;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class AllImportsDetails
extends Composite
implements IDetails,
ModifyListener {
    protected final String TEXT = ProbekitUIPlugin.getPlugin().getString("_UI_Import_text_feature");
    private ProbekitWidgetFactory _factory;
    protected ImportItemProvider _importsProvider;
    protected AllImportsItemProvider _allImportsProvider;
    private Composite _widgetComposite;
    Button _addButton;
    Button _removeButton;
    private static final int NO_INDEX = -1;
    private Probe _probe;
    private WidgetFocusListener _widgetFocusListener = new WidgetFocusListener();
    protected ScrolledComposite sc1;
    protected Composite page;

    public AllImportsDetails(ProbekitWidgetFactory factory, ProbekitItemProviderAdapterFactory itemFactory, Composite composite, int style) {
        super(composite, style);
        this._factory = factory;
        this._importsProvider = (ImportItemProvider)itemFactory.createImportAdapter();
        this._allImportsProvider = (AllImportsItemProvider)itemFactory.createAllImportsProviderAdapter();
        AllImportsDetails parent = this;
        this.setLayoutData(GridUtil.createFill());
        this.setLayout((Layout)new GridLayout());
        this.createControl(parent);
    }

    public Control getFocusTo() {
        return this._widgetFocusListener.getCurrentControl();
    }

    private void createControl(Composite parent) {
        this.sc1 = new ScrolledComposite(parent, 768);
        this.sc1.setLayoutData((Object)GridUtil.createFill());
        this.sc1.setExpandHorizontal(true);
        this.sc1.setExpandVertical(true);
        this.page = new Composite((Composite)this.sc1, 0);
        this.sc1.setContent((Control)this.page);
        GridLayout detailLayout = new GridLayout();
        detailLayout.numColumns = 2;
        this.page.setLayout((Layout)detailLayout);
        this.page.setLayoutData((Object)GridUtil.createFill());
        Label label = this._factory.createLabel(this.page, ProbekitMessages._20, 0);
        GridData data = new GridData();
        data.horizontalSpan = 2;
        label.setLayoutData((Object)data);
        this.createWidgetComposite(this.page);
        this.createButtons(this.page);
        this.refreshPageSize();
    }

    private void createWidgetComposite(Composite parent) {
        this._widgetComposite = this._factory.createComposite(parent, 0);
        GridLayout widgetLayout = new GridLayout();
        this._widgetComposite.setLayout((Layout)widgetLayout);
        this._widgetComposite.setLayoutData((Object)GridUtil.createFill());
    }

    private void createButtons(Composite parent) {
        ButtonSelectionListener listener = new ButtonSelectionListener();
        Composite buttonGroup = this._factory.createComposite(parent, 0);
        GridLayout buttonLayout = new GridLayout();
        buttonLayout.makeColumnsEqualWidth = true;
        buttonGroup.setLayout((Layout)buttonLayout);
        buttonGroup.setLayoutData((Object)GridUtil.createVerticalFill());
        buttonGroup.setFont(parent.getFont());
        this._addButton = this._factory.createButton(buttonGroup, ProbekitMessages._125, 8);
        GridData addData = GridUtil.createHorizontalFill();
        this._addButton.setLayoutData((Object)addData);
        this._addButton.addSelectionListener((SelectionListener)listener);
        this._addButton.addFocusListener((FocusListener)this._widgetFocusListener);
        this._removeButton = this._factory.createButton(buttonGroup, ProbekitMessages._119, 8);
        GridData removeData = GridUtil.createHorizontalFill();
        this._removeButton.setLayoutData((Object)removeData);
        this._removeButton.addSelectionListener((SelectionListener)listener);
        this._removeButton.addFocusListener((FocusListener)this._widgetFocusListener);
        this.refreshButtons();
    }

    private Text createWidget() {
        Text importWidget = this._factory.createText(this._widgetComposite, "", 0);
        importWidget.setLayoutData((Object)new GridData(768));
        importWidget.addModifyListener((ModifyListener)this);
        importWidget.addFocusListener((FocusListener)this._widgetFocusListener);
        this.refreshPane();
        this.refreshPageSize();
        return importWidget;
    }

    protected Import createImport() {
        Import anImport = ProbekitFactory.eINSTANCE.createImport();
        this._allImportsProvider.addAndNotify(this.getProbe(), anImport);
        return anImport;
    }

    protected void removeImport(int index) {
        Import selected = this.getImport(index);
        if (selected != null) {
            this._allImportsProvider.removeAndNotify(this.getProbe(), selected);
            this.refreshImports(index);
        }
    }

    protected int removeImportAndWidget() {
        Text widget = this.getSelectedWidget();
        int index = this.getIndex((Widget)widget);
        this.removeImport(index);
        if (index >= this.getImportList().size()) {
            --index;
        }
        this.refreshWidgets();
        this.refreshPane();
        this.refreshPageSize();
        return index;
    }

    protected Text addWidgetIfNecessary(int index) {
        Text widget = null;
        Control[] children = this._widgetComposite.getChildren();
        if (children.length <= index) {
            widget = this.createWidget();
        } else {
            widget = (Text)children[index];
            widget.setVisible(true);
            this.refreshPane();
        }
        return widget;
    }

    protected Import addImportIfNecessary(int index) {
        Import anImport = null;
        int size = this.getImportList().size();
        if (index >= size) {
            anImport = this.createImport();
        }
        return anImport;
    }

    private void refreshWidgets() {
        Control[] children = this._widgetComposite.getChildren();
        int importSize = this.getImportList().size();
        int i = children.length - 1;
        while (i >= importSize) {
            Text text = (Text)children[i];
            text.setVisible(false);
            --i;
        }
    }

    private void refreshPane() {
        this._widgetComposite.layout(true);
        this._widgetComposite.redraw();
        this._widgetComposite.update();
    }

    protected void refreshPageSize() {
        this.sc1.setMinSize(this.page.computeSize(-1, -1));
        this.page.layout();
    }

    private void refreshImports(int index) {
        int importSize = this.getImportList().size();
        Control[] children = this._widgetComposite.getChildren();
        int i = index;
        while (i < importSize) {
            Import anImport = this.getImport(i);
            Text text = (Text)children[i];
            if (anImport.getText() != null) {
                text.setText(anImport.getText());
            }
            ++i;
        }
    }

    void refreshButtons() {
        if (this.getProbe() == null || this.getImportList().size() == 0) {
            this._removeButton.setEnabled(false);
        } else {
            Text text = this.getSelectedWidget();
            boolean enabled = text != null;
            this._removeButton.setEnabled(enabled);
        }
    }

    protected Text getWidget(int index) {
        if (index <= -1) {
            return null;
        }
        this.addWidgetIfNecessary(index);
        this.addImportIfNecessary(index);
        Control[] children = this._widgetComposite.getChildren();
        Text importWidget = (Text)children[index];
        return importWidget;
    }

    Text getSelectedWidget() {
        Control control = this.getFocusTo();
        if (control instanceof Text) {
            return (Text)control;
        }
        return null;
    }

    protected EList getImportList() {
        return this.getProbe().getImport();
    }

    protected Probe getProbe() {
        return this._probe;
    }

    int getIndex(Widget text) {
        Control[] children = this._widgetComposite.getChildren();
        int i = 0;
        while (i < children.length) {
            if (children[i].equals(text)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    Import getImport(int index) {
        Object value;
        if (index <= -1) {
            return null;
        }
        if (index < this.getImportList().size() && (value = this.getImportList().get(index)) != null) {
            return (Import)value;
        }
        return null;
    }

    void select(int index) {
        if (index > -1 && index <= this._widgetComposite.getChildren().length) {
            Text widget = this.getWidget(index);
            widget.setFocus();
            String text = widget.getText();
            int length = text.length();
            widget.setSelection(0, length);
        }
    }

    public boolean updateCurrentSelection(Object currentSelection) {
        return false;
    }

    private void select(Import importObject) {
        int index = this.getImportList().indexOf((Object)importObject);
        this.select(index);
    }

    public void display(Object object) {
        Import importObject = null;
        if (object instanceof EObjectContainmentEList) {
            this._probe = (Probe)((EObjectContainmentEList)object).getEObject();
        } else {
            importObject = (Import)object;
            this._probe = (Probe)importObject.eContainer();
        }
        if (!this.isThisFocusControl()) {
            EList importList = this.getImportList();
            int size = importList.size();
            int i = 0;
            while (i < size) {
                Import anImport = (Import)importList.get(i);
                this.displayImport(anImport, this.getWidget(i));
                ++i;
            }
            this.refreshWidgets();
            this.refreshButtons();
            this.refreshPane();
        }
        if (importObject != null) {
            this.select(importObject);
        } else {
            this.setFocusTo();
        }
    }

    private boolean isThisFocusControl() {
        if (this.isFocusControl()) {
            return true;
        }
        if (this._widgetComposite.isFocusControl()) {
            return true;
        }
        if (this._addButton.isFocusControl()) {
            return true;
        }
        if (this._removeButton.isFocusControl()) {
            return true;
        }
        Control[] children = this._widgetComposite.getChildren();
        int size = children.length;
        int i = 0;
        while (i < size) {
            Control control = children[i];
            if (control.isFocusControl()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private void displayImport(Import importObj, Text importWidget) {
        if (importWidget.isFocusControl()) {
            return;
        }
        importWidget.setText(ResourceUtil.getString(importObj.getText()));
    }

    public void modifyText(ModifyEvent e) {
        Text importWidget = (Text)e.getSource();
        int index = this.getIndex((Widget)importWidget);
        Import anImport = this.getImport(index);
        if (anImport == null) {
            return;
        }
        String text = importWidget.getText().trim();
        if (!text.equals(anImport.getText())) {
            if (text.length() == 0 && anImport.getText() == null) {
                return;
            }
            IItemPropertyDescriptor descriptor = this._importsProvider.getPropertyDescriptor(anImport, this.TEXT);
            if (descriptor != null) {
                descriptor.setPropertyValue((Object)anImport, (Object)text);
            }
        }
    }

    public void dispose() {
        this._factory = null;
        this._importsProvider = null;
        this._allImportsProvider = null;
        this._widgetComposite = null;
        this._addButton = null;
        this._removeButton = null;
        this._widgetFocusListener = null;
        this._probe = null;
    }

    public boolean isDetailsFor(Object object) {
        EObjectContainmentEList list;
        return object instanceof EObjectContainmentEList ? (list = (EObjectContainmentEList)object).getFeatureID() == 5 : object instanceof Import;
    }

    public void setFocusTo() {
        if (this.getImportList().size() > 0) {
            this.select(0);
        }
    }

    private void setVisible(Point location) {
        ScrollBar verticalBar;
        ScrollBar horizontalBar = this.sc1.getHorizontalBar();
        if (horizontalBar != null) {
            horizontalBar.setSelection(location.x);
            Event event = new Event();
            event.widget = horizontalBar;
            horizontalBar.notifyListeners(13, event);
        }
        if ((verticalBar = this.sc1.getVerticalBar()) != null) {
            verticalBar.setSelection(location.y);
            Event event = new Event();
            event.widget = verticalBar;
            verticalBar.notifyListeners(13, event);
        }
    }

    public void refresh() {
    }

    private class WidgetFocusListener
    implements FocusListener {
        private Text _currentControl = null;

        WidgetFocusListener() {
        }

        public Text getCurrentControl() {
            return this._currentControl;
        }

        public void focusLost(FocusEvent e) {
        }

        public void focusGained(FocusEvent e) {
            if (e.getSource() instanceof Text) {
                this._currentControl = (Text)e.getSource();
            }
            if (e.getSource() instanceof Control) {
                Control control = (Control)e.getSource();
                AllImportsDetails.this.setVisible(control.getLocation());
            }
            AllImportsDetails.this.refreshButtons();
        }
    }

    private class ButtonSelectionListener
    implements SelectionListener {
        ButtonSelectionListener() {
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void widgetSelected(SelectionEvent event) {
            if (event.widget.equals(AllImportsDetails.this._addButton)) {
                this.add();
            } else if (event.widget.equals(AllImportsDetails.this._removeButton)) {
                this.remove();
            }
            AllImportsDetails.this.refreshButtons();
        }

        private void add() {
            int size = AllImportsDetails.this.getImportList().size();
            Import anImport = AllImportsDetails.this.addImportIfNecessary(size);
            Text widget = AllImportsDetails.this.addWidgetIfNecessary(size);
            String text = anImport.getText() == null ? "" : anImport.getText();
            widget.setText(text);
            AllImportsDetails.this.select(size);
            AllImportsDetails.this.refresh();
        }

        private void remove() {
            int selected = AllImportsDetails.this.removeImportAndWidget();
            AllImportsDetails.this.select(selected);
        }
    }
}

