/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.probekit.editor.internal.presentation;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.hyades.models.internal.probekit.Probe;
import org.eclipse.hyades.models.internal.probekit.ProbekitFactory;
import org.eclipse.hyades.models.internal.probekit.Target;
import org.eclipse.hyades.probekit.editor.internal.core.util.ProbekitMessages;
import org.eclipse.hyades.probekit.editor.internal.presentation.BaseDetails;
import org.eclipse.hyades.probekit.editor.internal.presentation.GridUtil;
import org.eclipse.hyades.probekit.editor.internal.presentation.ProbekitWidgetFactory;
import org.eclipse.hyades.probekit.editor.internal.presentation.TargetDetails;
import org.eclipse.hyades.probekit.editor.internal.presentation.TargetTypeEnum;
import org.eclipse.hyades.probekit.editor.internal.provider.AllTargetsItemProvider;
import org.eclipse.hyades.probekit.editor.internal.provider.ProbekitItemProviderAdapterFactory;
import org.eclipse.hyades.probekit.editor.internal.provider.TargetItemProvider;
import org.eclipse.hyades.probekit.ui.internal.ProbekitUIPlugin;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class AllTargetsDetails
extends BaseDetails {
    private static final String DOT = ".";
    private static final String STAR = "*";
    private ProbekitWidgetFactory _factory;
    private ProbekitItemProviderAdapterFactory _itemFactory;
    protected AllTargetsItemProvider _allTargetsProvider;
    protected TargetItemProvider _itemProvider;
    private Probe _probe;
    private Button _upButton;
    private Button _downButton;
    private Button _addButton;
    private Button _editButton;
    private Button _removeButton;
    private TableViewer _tableViewer;
    static final String[] COLUMNS = new String[]{ProbekitMessages._106, ProbekitMessages._107, ProbekitMessages._108, ProbekitMessages._109, ProbekitMessages._110};
    static final String[] FEATURES = new String[]{ProbekitUIPlugin.getPlugin().getString("_UI_Target_type_feature"), ProbekitUIPlugin.getPlugin().getString("_UI_Target_package_feature"), ProbekitUIPlugin.getPlugin().getString("_UI_Target_className_feature"), ProbekitUIPlugin.getPlugin().getString("_UI_Target_method_feature"), ProbekitUIPlugin.getPlugin().getString("_UI_Target_signature_feature")};
    ComboBoxCellEditor _comboBoxCellEditor;

    public AllTargetsDetails(ProbekitWidgetFactory factory, ProbekitItemProviderAdapterFactory itemFactory, Composite composite, int style) {
        super(composite, style);
        this._factory = factory;
        this._itemFactory = itemFactory;
        this._allTargetsProvider = (AllTargetsItemProvider)itemFactory.createAllTargetsProviderAdapter();
        this._itemProvider = (TargetItemProvider)itemFactory.createTargetAdapter();
        AllTargetsDetails parent = this;
        this.setLayoutData(GridUtil.createFill());
        this.setLayout((Layout)new GridLayout());
        this.createControl(parent);
    }

    private void createControl(Composite parent) {
        ScrolledComposite sc1 = new ScrolledComposite(parent, 768);
        sc1.setLayoutData((Object)GridUtil.createFill());
        sc1.setExpandHorizontal(true);
        sc1.setExpandVertical(true);
        Composite page = new Composite((Composite)sc1, 0);
        sc1.setContent((Control)page);
        GridLayout detailLayout = new GridLayout();
        detailLayout.numColumns = COLUMNS.length;
        detailLayout.makeColumnsEqualWidth = false;
        page.setLayout((Layout)detailLayout);
        page.setLayoutData((Object)GridUtil.createFill());
        Label label = this._factory.createLabel(page, ProbekitMessages._23, 0);
        GridData data = new GridData();
        data.horizontalSpan = COLUMNS.length;
        data.widthHint = 400;
        label.setLayoutData((Object)data);
        this.createTable(page);
        sc1.setMinSize(page.computeSize(-1, -1));
    }

    private void createTable(Composite parent) {
        TargetModifyListener listener = new TargetModifyListener();
        this.createTableViewer(parent, listener);
        this.createTableButtons(parent, listener);
    }

    private void createTableViewer(Composite parent, TargetModifyListener listener) {
        this._tableViewer = new TableViewer(parent, 68356);
        Table table = this._tableViewer.getTable();
        CellEditor[] cellEditors = new CellEditor[COLUMNS.length];
        TableColumn comboCell = new TableColumn(table, 16384);
        comboCell.setText(COLUMNS[0]);
        String[] comboboxItems = new String[]{TargetTypeEnum.INCLUDE.getTranslatedType(), TargetTypeEnum.EXCLUDE.getTranslatedType()};
        this._comboBoxCellEditor = new ComboBoxCellEditor((Composite)table, comboboxItems);
        cellEditors[0] = this._comboBoxCellEditor;
        int i = 1;
        while (i < COLUMNS.length) {
            TableColumn textCell = new TableColumn(table, 16384);
            textCell.setText(COLUMNS[i]);
            cellEditors[i] = new TextCellEditor((Composite)table);
            ++i;
        }
        this._tableViewer.setCellEditors(cellEditors);
        this._tableViewer.setCellModifier((ICellModifier)new TargetCellModifier());
        this._tableViewer.setContentProvider((IContentProvider)new TargetContentProvider());
        this._tableViewer.setLabelProvider((IBaseLabelProvider)new TargetColumnLabelProvider());
        this._tableViewer.setColumnProperties(COLUMNS);
        GridData tableData = GridUtil.createFill();
        table.setLayoutData((Object)tableData);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        table.setFont(parent.getFont());
        table.addSelectionListener((SelectionListener)listener);
        table.addControlListener((ControlListener)new TargetControlListener(table));
    }

    private void createTableButtons(Composite parent, TargetModifyListener listener) {
        Composite buttonGroup = this._factory.createComposite(parent, 0);
        GridLayout buttonLayout = new GridLayout();
        buttonLayout.makeColumnsEqualWidth = true;
        buttonGroup.setLayout((Layout)buttonLayout);
        GridData buttonData = GridUtil.createVerticalFill();
        buttonData.grabExcessHorizontalSpace = false;
        buttonGroup.setLayoutData((Object)buttonData);
        buttonGroup.setFont(parent.getFont());
        this._addButton = this._factory.createButton(buttonGroup, ProbekitMessages._125, 8);
        GridData addData = GridUtil.createHorizontalFill();
        this._addButton.setLayoutData((Object)addData);
        this._addButton.addSelectionListener((SelectionListener)listener);
        this._editButton = this._factory.createButton(buttonGroup, ProbekitMessages._118, 8);
        GridData editData = GridUtil.createHorizontalFill();
        this._editButton.setLayoutData((Object)editData);
        this._editButton.addSelectionListener((SelectionListener)listener);
        this._removeButton = this._factory.createButton(buttonGroup, ProbekitMessages._119, 8);
        GridData removeData = GridUtil.createHorizontalFill();
        this._removeButton.setLayoutData((Object)removeData);
        this._removeButton.addSelectionListener((SelectionListener)listener);
        this._upButton = this._factory.createButton(buttonGroup, ProbekitMessages._120, 8);
        GridData upData = GridUtil.createHorizontalFill();
        this._upButton.setLayoutData((Object)upData);
        this._upButton.addSelectionListener((SelectionListener)listener);
        this._downButton = this._factory.createButton(buttonGroup, ProbekitMessages._121, 8);
        GridData downData = GridUtil.createHorizontalFill();
        this._downButton.setLayoutData((Object)downData);
        this._downButton.addSelectionListener((SelectionListener)listener);
        this.refreshButtons();
    }

    protected Target addTarget() {
        Target aTarget = ProbekitFactory.eINSTANCE.createTarget();
        aTarget.setType(TargetTypeEnum.INCLUDE.getType());
        aTarget.setPackage(STAR);
        aTarget.setClassName(STAR);
        aTarget.setMethod(STAR);
        aTarget.setSignature(STAR);
        this._allTargetsProvider.addAndNotify(this.getProbe(), aTarget);
        return aTarget;
    }

    protected void removeTarget(Target selected) {
        if (selected != null) {
            this._allTargetsProvider.removeAndNotify(this.getProbe(), selected);
        }
    }

    protected EList getTargetItems() {
        return this.getProbe().getTarget();
    }

    protected Probe getProbe() {
        return this._probe;
    }

    protected TableViewer getTableViewer() {
        return this._tableViewer;
    }

    Target getItem(int index) {
        if (index == -1) {
            return null;
        }
        return (Target)this.getTableViewer().getElementAt(index);
    }

    int getSelectedIndex() {
        return this.getTableViewer().getTable().getSelectionIndex();
    }

    void refreshTable() {
        this.getTableViewer().refresh();
    }

    public boolean updateCurrentSelection(Object currentSelection) {
        this.setCurrentSelection(currentSelection);
        return false;
    }

    public void setCurrentSelection(Object currentSelection) {
        if (currentSelection instanceof EObjectContainmentEList) {
            this._probe = (Probe)((EObjectContainmentEList)currentSelection).getEObject();
        } else {
            Target targetObject = (Target)currentSelection;
            this._probe = (Probe)targetObject.eContainer();
            this.select(targetObject);
        }
        this.getTableViewer().setInput((Object)this.getTargetItems());
    }

    private void select(Target targetObject) {
        TableItem[] items = this._tableViewer.getTable().getItems();
        int i = 0;
        while (i < items.length) {
            TableItem item = items[i];
            if (item.getData().equals(targetObject)) {
                this.select(i);
                return;
            }
            ++i;
        }
    }

    private void select(int index) {
        this.getTableViewer().getTable().select(index);
    }

    public void display(Object o) {
        this.setCurrentSelection(o);
    }

    public void setFocusTo() {
    }

    public boolean isDetailsFor(Object object) {
        EObjectContainmentEList list;
        return object instanceof EObjectContainmentEList ? (list = (EObjectContainmentEList)object).getFeatureID() == 4 : object instanceof Target;
    }

    void refreshButtons() {
        if (this.getProbe() == null || this.getTargetItems().size() == 0) {
            this._removeButton.setEnabled(false);
            this._editButton.setEnabled(false);
            this._upButton.setEnabled(false);
            this._downButton.setEnabled(false);
        } else {
            int index = this.getSelectedIndex();
            Target item = this.getItem(index);
            boolean enabled = item != null;
            this._removeButton.setEnabled(enabled);
            this._editButton.setEnabled(enabled);
            this._upButton.setEnabled(enabled && index > 0);
            this._downButton.setEnabled(enabled && index < this.getTargetItems().size() - 1);
        }
    }

    String getFilterName(Target target) {
        StringBuffer buffer = new StringBuffer();
        String pkg = target.getPackage();
        if (pkg != null && !"".equals(pkg)) {
            buffer.append(pkg);
        } else {
            buffer.append(STAR);
        }
        String clazz = target.getClassName();
        buffer.append(DOT);
        if (clazz != null && !"".equals(clazz)) {
            buffer.append(clazz);
        } else {
            buffer.append(STAR);
        }
        String method = target.getMethod();
        buffer.append(DOT);
        if (method != null && !"".equals(method)) {
            buffer.append(method);
        } else {
            buffer.append(STAR);
        }
        String signature = target.getSignature();
        buffer.append(DOT);
        if (signature != null && !"".equals(signature)) {
            buffer.append(signature);
        } else {
            buffer.append(STAR);
        }
        return buffer.toString();
    }

    protected Button getAddButton() {
        return this._addButton;
    }

    protected Button getEditButton() {
        return this._editButton;
    }

    protected Button getRemoveButton() {
        return this._removeButton;
    }

    protected Button getUpButton() {
        return this._upButton;
    }

    protected Button getDownButton() {
        return this._downButton;
    }

    public void refresh() {
    }

    private class TargetModifyListener
    implements SelectionListener {
        TargetModifyListener() {
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void widgetSelected(SelectionEvent event) {
            if (event.widget.equals(AllTargetsDetails.this.getAddButton())) {
                this.add();
            } else if (event.widget.equals(AllTargetsDetails.this.getEditButton())) {
                this.edit();
            } else if (event.widget.equals(AllTargetsDetails.this.getRemoveButton())) {
                this.remove();
            } else if (event.widget.equals(AllTargetsDetails.this.getUpButton())) {
                this.moveUp();
            } else if (event.widget.equals(AllTargetsDetails.this.getDownButton())) {
                this.moveDown();
            }
            AllTargetsDetails.this.refreshButtons();
        }

        private void add() {
            AllTargetsDetails.this.addTarget();
            AllTargetsDetails.this.refreshTable();
            AllTargetsDetails.this.select(AllTargetsDetails.this.getTableViewer().getTable().getItemCount() - 1);
        }

        private void remove() {
            int index = AllTargetsDetails.this.getSelectedIndex();
            Target item = AllTargetsDetails.this.getItem(index);
            if (item != null) {
                AllTargetsDetails.this.removeTarget(item);
                --index;
            }
            AllTargetsDetails.this.refreshTable();
            AllTargetsDetails.this.select(index);
        }

        private void edit() {
            int index = AllTargetsDetails.this.getSelectedIndex();
            Target item = AllTargetsDetails.this.getItem(index);
            if (item != null) {
                TargetDialog dialog = new TargetDialog(AllTargetsDetails.this.getShell(), item, AllTargetsDetails.this._factory, AllTargetsDetails.this._itemFactory);
                dialog.setBlockOnOpen(true);
                dialog.setTitle(ProbekitMessages._111);
                dialog.open();
                AllTargetsDetails.this.refreshTable();
                AllTargetsDetails.this.select(index);
            }
        }

        private void moveUp() {
            int selectedIndex = AllTargetsDetails.this.getSelectedIndex();
            Target item = AllTargetsDetails.this.getItem(selectedIndex);
            if (item != null && selectedIndex > 0) {
                AllTargetsDetails.this.getTargetItems().remove((Object)item);
                AllTargetsDetails.this.getTargetItems().add(selectedIndex - 1, (Object)item);
                AllTargetsDetails.this.refreshTable();
                AllTargetsDetails.this.select(selectedIndex - 1);
            }
        }

        private void moveDown() {
            int selectedIndex = AllTargetsDetails.this.getSelectedIndex();
            Target item = AllTargetsDetails.this.getItem(selectedIndex);
            if (item != null && selectedIndex < AllTargetsDetails.this.getTargetItems().size() - 1) {
                AllTargetsDetails.this.getTargetItems().remove((Object)item);
                AllTargetsDetails.this.getTargetItems().add(selectedIndex + 1, (Object)item);
                AllTargetsDetails.this.refreshTable();
                AllTargetsDetails.this.select(selectedIndex + 1);
            }
        }
    }

    private class TargetColumnLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        TargetColumnLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            String result = null;
            if (element instanceof Target) {
                Target item = (Target)element;
                if (columnIndex == 0) {
                    result = item.getType();
                } else if (columnIndex == 1) {
                    result = item.getPackage();
                } else if (columnIndex == 2) {
                    result = item.getClassName();
                } else if (columnIndex == 3) {
                    result = item.getMethod();
                } else if (columnIndex == 4) {
                    result = item.getSignature();
                }
            }
            return result == null ? "" : result;
        }
    }

    private class TargetContentProvider
    implements IStructuredContentProvider {
        TargetContentProvider() {
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            return AllTargetsDetails.this.getTargetItems().toArray();
        }
    }

    private class TargetCellModifier
    implements ICellModifier {
        TargetCellModifier() {
        }

        public Object getValue(Object element, String property) {
            Object value = null;
            if (element instanceof Target) {
                Target item = (Target)element;
                if (property.equals(COLUMNS[0])) {
                    String typeName = item.getType() == null ? "" : item.getType();
                    value = this.getCellIndex(typeName);
                } else if (property.equals(COLUMNS[1])) {
                    value = item.getPackage();
                } else if (property.equals(COLUMNS[2])) {
                    value = item.getClassName();
                } else if (property.equals(COLUMNS[3])) {
                    value = item.getMethod();
                } else if (property.equals(COLUMNS[4])) {
                    value = item.getSignature();
                }
            }
            return value == null ? "" : value;
        }

        private Integer getCellIndex(String typeName) {
            Integer index = null;
            String[] items = AllTargetsDetails.this._comboBoxCellEditor.getItems();
            int i = 0;
            while (i < items.length) {
                String itemText = items[i];
                if (itemText.equals(typeName)) {
                    index = new Integer(i);
                    break;
                }
                ++i;
            }
            if (index == null) {
                index = new Integer(0);
            }
            return index;
        }

        public boolean canModify(Object element, String property) {
            return true;
        }

        public void modify(Object element, String property, Object value) {
            TableItem item = (TableItem)element;
            Target target = (Target)item.getData();
            String newval = null;
            String oldval = null;
            String propertyId = null;
            if (property.equals(COLUMNS[0])) {
                Integer cellIndex = (Integer)value;
                String[] items = AllTargetsDetails.this._comboBoxCellEditor.getItems();
                String typeName = items[cellIndex];
                TargetTypeEnum type = TargetTypeEnum.getTargetType(typeName);
                oldval = target.getType();
                newval = type.getType();
                propertyId = FEATURES[0];
            } else if (property.equals(COLUMNS[1])) {
                oldval = target.getPackage();
                newval = (String)value;
                propertyId = FEATURES[1];
            } else if (property.equals(COLUMNS[2])) {
                oldval = target.getClassName();
                newval = (String)value;
                propertyId = FEATURES[2];
            } else if (property.equals(COLUMNS[3])) {
                oldval = target.getMethod();
                newval = (String)value;
                propertyId = FEATURES[3];
            } else if (property.equals(COLUMNS[4])) {
                oldval = target.getSignature();
                newval = (String)value;
                propertyId = FEATURES[4];
            }
            if (!newval.equals(oldval)) {
                IItemPropertyDescriptor descriptor = AllTargetsDetails.this._itemProvider.getPropertyDescriptor(target, propertyId);
                if (descriptor != null) {
                    descriptor.setPropertyValue((Object)target, (Object)newval);
                }
                AllTargetsDetails.this._tableViewer.refresh();
            }
        }
    }

    private static class TargetDialog
    extends Dialog {
        private Target _item;
        private ProbekitWidgetFactory _factory;
        private ProbekitItemProviderAdapterFactory _itemFactory;
        private String _title;

        public TargetDialog(Shell shell, Target item, ProbekitWidgetFactory factory, ProbekitItemProviderAdapterFactory itemFactory) {
            super(shell);
            int shellStyle = this.getShellStyle();
            this.setShellStyle(shellStyle | 0x10);
            this._item = item;
            this._factory = factory;
            this._itemFactory = itemFactory;
        }

        public Target getResult() {
            return this._item;
        }

        protected Control createDialogArea(Composite parent) {
            TargetDetails details = new TargetDetails(this._factory, this._itemFactory, parent, 16);
            details.display(this._item);
            return details;
        }

        protected void configureShell(Shell shell) {
            super.configureShell(shell);
            if (this.getTitle() != null) {
                shell.setText(this.getTitle());
            }
        }

        private String getTitle() {
            return this._title;
        }

        public void setTitle(String title) {
            this._title = title;
        }
    }

    class TargetControlListener
    extends ControlAdapter {
        Table table;

        public TargetControlListener(Table table) {
            this.table = table;
        }

        protected void resizeColumns(int width) {
            TableColumn[] cols = this.table.getColumns();
            int i = 0;
            while (i < cols.length) {
                cols[i].setWidth(width);
                ++i;
            }
        }

        public void controlResized(ControlEvent e) {
            Rectangle area = this.table.getClientArea();
            Point preferredSize = this.table.computeSize(-1, -1);
            int width = area.width - 2 * this.table.getBorderWidth();
            if (preferredSize.y > area.height) {
                Point vBarSize = this.table.getVerticalBar().getSize();
                width -= vBarSize.x;
            }
            this.resizeColumns(width / COLUMNS.length);
        }
    }
}

