/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.probekit.editor.internal.presentation;

import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.hyades.models.internal.probekit.ControlKey;
import org.eclipse.hyades.models.internal.probekit.impl.ControlKeyImpl;
import org.eclipse.hyades.probekit.editor.internal.core.util.ProbekitMessages;
import org.eclipse.hyades.probekit.editor.internal.presentation.BaseDetails;
import org.eclipse.hyades.probekit.editor.internal.presentation.GridUtil;
import org.eclipse.hyades.probekit.editor.internal.presentation.ProbekitWidgetFactory;
import org.eclipse.hyades.probekit.editor.internal.provider.ControlKeyItemProvider;
import org.eclipse.hyades.probekit.editor.internal.provider.ProbekitItemProviderAdapterFactory;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class ControlKeyDetails
extends BaseDetails
implements ModifyListener {
    protected final String NAME = "Name";
    protected final String VALUE = "Value";
    protected Text name;
    protected Text value;
    protected boolean isDisplaying;
    protected ControlKey currentSelection;
    protected ControlKeyItemProvider itemProvider;
    protected ProbekitItemProviderAdapterFactory itemFactory;

    public ControlKeyDetails(ProbekitWidgetFactory factory, ProbekitItemProviderAdapterFactory itemFactory, Composite composite, int style) {
        super(composite, style);
        this.itemFactory = itemFactory;
        GridLayout detailLayout = new GridLayout();
        detailLayout.numColumns = 1;
        this.setLayout((Layout)detailLayout);
        this.setLayoutData(GridUtil.createFill());
        factory.createLabel(this, ProbekitMessages._12, 0);
        this.name = factory.createText(this, "", 0);
        this.name.setLayoutData((Object)new GridData(768));
        factory.createLabel(this, ProbekitMessages._13, 0);
        this.value = factory.createText(this, "", 0);
        this.value.setLayoutData((Object)new GridData(768));
        this.name.addModifyListener((ModifyListener)this);
        this.value.addModifyListener((ModifyListener)this);
        this.itemProvider = (ControlKeyItemProvider)itemFactory.createControlKeyAdapter();
        this.addFocusListenerTo((Control)this.name);
        this.addFocusListenerTo((Control)this.value);
    }

    public void display(Object object) {
        if (this.name.isFocusControl() || this.value.isFocusControl()) {
            return;
        }
        this.currentSelection = (ControlKey)object;
        this.isDisplaying = true;
        this.name.setText(this.currentSelection.getName() == null ? "" : this.currentSelection.getName());
        this.value.setText(this.currentSelection.getValue() == null ? "" : this.currentSelection.getValue());
        this.isDisplaying = false;
    }

    public boolean updateCurrentSelection(Object currentSelection) {
        this.currentSelection = (ControlKey)currentSelection;
        this.currentSelection.setName(this.name.getText().trim());
        this.currentSelection.setValue(this.value.getText().trim());
        return false;
    }

    public void setFocusToText() {
        this.name.setFocus();
        this.name.selectAll();
    }

    public void modifyText(ModifyEvent e) {
        String text;
        if (this.currentSelection == null) {
            return;
        }
        if (e.getSource() == this.name) {
            String text2 = this.name.getText().trim();
            if (!text2.equals(this.currentSelection.getName())) {
                if (text2.length() == 0 && this.currentSelection.getName() == null) {
                    return;
                }
                IItemPropertyDescriptor descriptor = this.itemProvider.getPropertyDescriptor(this.currentSelection, "Name");
                if (descriptor != null) {
                    descriptor.setPropertyValue((Object)this.currentSelection, (Object)text2);
                }
            }
        } else if (e.getSource() == this.value && !(text = this.value.getText().trim()).equals(this.currentSelection.getValue())) {
            if (text.length() == 0 && this.currentSelection.getValue() == null) {
                return;
            }
            IItemPropertyDescriptor descriptor = this.itemProvider.getPropertyDescriptor(this.currentSelection, "Value");
            if (descriptor != null) {
                descriptor.setPropertyValue((Object)this.currentSelection, (Object)text);
            }
        }
    }

    public void dispose() {
        this.itemFactory = null;
        this.itemProvider = null;
        this.name = null;
        this.value = null;
    }

    public boolean isDetailsFor(Object object) {
        return object instanceof ControlKey || object instanceof ControlKeyImpl;
    }

    public void setFocusTo() {
        this.setFocusToText();
    }

    public void refresh() {
    }
}

