/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.probekit.editor.internal.presentation;

import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.hyades.models.internal.probekit.Description;
import org.eclipse.hyades.models.internal.probekit.impl.DescriptionImpl;
import org.eclipse.hyades.probekit.editor.internal.core.util.ProbekitMessages;
import org.eclipse.hyades.probekit.editor.internal.presentation.BaseDetails;
import org.eclipse.hyades.probekit.editor.internal.presentation.GridUtil;
import org.eclipse.hyades.probekit.editor.internal.presentation.ProbekitWidgetFactory;
import org.eclipse.hyades.probekit.editor.internal.provider.DescriptionItemProvider;
import org.eclipse.hyades.probekit.editor.internal.provider.ProbekitItemProviderAdapterFactory;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class DescriptionDetails
extends BaseDetails
implements ModifyListener {
    protected final String LANGUAGE = "Lang";
    protected final String DESCRIPTION = "Value";
    protected Text language;
    protected Text description;
    protected boolean isDisplaying;
    protected Description currentSelection;
    protected DescriptionItemProvider itemProvider;
    protected ProbekitItemProviderAdapterFactory itemFactory;

    public DescriptionDetails(ProbekitWidgetFactory factory, ProbekitItemProviderAdapterFactory itemFactory, Composite composite, int style) {
        super(composite, style);
        this.itemFactory = itemFactory;
        GridLayout detailLayout = new GridLayout();
        detailLayout.numColumns = 1;
        this.setLayout((Layout)detailLayout);
        this.setLayoutData(GridUtil.createFill());
        factory.createLabel(this, ProbekitMessages._14, 0);
        this.language = factory.createText(this, "", 0);
        this.language.setLayoutData((Object)new GridData(768));
        this.language.setData((Object)new Integer(0));
        factory.createLabel(this, ProbekitMessages._17, 0);
        this.description = factory.createText(this, "", 834);
        GridData descLayout = new GridData(1808);
        this.description.setLayoutData((Object)descLayout);
        this.description.setData((Object)new Integer(3));
        this.language.addModifyListener((ModifyListener)this);
        this.description.addModifyListener((ModifyListener)this);
        this.itemProvider = (DescriptionItemProvider)itemFactory.createDescriptionAdapter();
        this.addFocusListenerTo((Control)this.language);
        this.addFocusListenerTo((Control)this.description);
    }

    public void display(Object object) {
        if (this.language.isFocusControl() || this.description.isFocusControl()) {
            return;
        }
        this.currentSelection = (Description)object;
        this.isDisplaying = true;
        this.language.setText(this.currentSelection.getLang() == null ? "" : this.currentSelection.getLang());
        this.description.setText(this.currentSelection.getValue() == null ? "" : this.currentSelection.getValue());
        this.isDisplaying = false;
    }

    public boolean updateCurrentSelection(Object currentSelection) {
        this.currentSelection = (Description)currentSelection;
        this.currentSelection.setLang(this.language.getText().trim());
        this.currentSelection.setValue(this.description.getText());
        return false;
    }

    public void setFocusToText() {
        this.language.setFocus();
        this.language.selectAll();
    }

    public void modifyText(ModifyEvent e) {
        String text;
        if (this.currentSelection == null) {
            return;
        }
        if (e.getSource() == this.language) {
            String text2 = this.language.getText().trim();
            if (!text2.equals(this.currentSelection.getLang())) {
                if (text2.length() == 0 && this.currentSelection.getLang() == null) {
                    return;
                }
                IItemPropertyDescriptor descriptor = this.itemProvider.getPropertyDescriptor(this.currentSelection, "Lang");
                if (descriptor != null) {
                    descriptor.setPropertyValue((Object)this.currentSelection, (Object)text2);
                }
            }
        } else if (e.getSource() == this.description && !(text = this.description.getText()).equals(this.currentSelection.getValue())) {
            if (text.length() == 0 && this.currentSelection.getValue() == null) {
                return;
            }
            IItemPropertyDescriptor descriptor = this.itemProvider.getPropertyDescriptor(this.currentSelection, "Value");
            if (descriptor != null) {
                descriptor.setPropertyValue((Object)this.currentSelection, (Object)text);
            }
        }
    }

    public void dispose() {
        this.itemFactory = null;
        this.itemProvider = null;
        this.description = null;
        this.language = null;
    }

    public boolean isDetailsFor(Object object) {
        return object instanceof Description || object instanceof DescriptionImpl;
    }

    public void setFocusTo() {
        this.setFocusToText();
    }

    public void refresh() {
    }
}

