/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.probekit.editor.internal.presentation;

import java.util.ArrayList;
import org.eclipse.hyades.probekit.editor.internal.presentation.AllImportsDetails;
import org.eclipse.hyades.probekit.editor.internal.presentation.AllTargetsDetails;
import org.eclipse.hyades.probekit.editor.internal.presentation.ControlKeyDetails;
import org.eclipse.hyades.probekit.editor.internal.presentation.ControlNameDetails;
import org.eclipse.hyades.probekit.editor.internal.presentation.DescriptionDetails;
import org.eclipse.hyades.probekit.editor.internal.presentation.FragmentAtClassScopeDetails;
import org.eclipse.hyades.probekit.editor.internal.presentation.FragmentDetails;
import org.eclipse.hyades.probekit.editor.internal.presentation.IDetails;
import org.eclipse.hyades.probekit.editor.internal.presentation.InvocationObjectDetails;
import org.eclipse.hyades.probekit.editor.internal.presentation.NameDetails;
import org.eclipse.hyades.probekit.editor.internal.presentation.ProbekitWidgetFactory;
import org.eclipse.hyades.probekit.editor.internal.presentation.StaticFieldDetails;
import org.eclipse.hyades.probekit.editor.internal.provider.ProbekitItemProviderAdapterFactory;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class DetailsContent
extends Composite {
    protected StackLayout detailsLayout;
    protected ProbekitWidgetFactory widgetFactory;
    protected ProbekitItemProviderAdapterFactory factory;
    protected Composite[] details;
    protected Composite currentDetails;

    public DetailsContent(ProbekitWidgetFactory widgetFactory, ProbekitItemProviderAdapterFactory factory, Composite composite, int style) {
        super(composite, style);
        this.widgetFactory = widgetFactory;
        this.factory = factory;
    }

    public void createContent() {
        this.detailsLayout = new StackLayout();
        this.setLayout((Layout)this.detailsLayout);
        GridData detailsGrid = new GridData(1808);
        detailsGrid.horizontalIndent = 10;
        this.setLayoutData(detailsGrid);
        ArrayList<Composite> detailsList = new ArrayList<Composite>();
        detailsList.add(new DescriptionDetails(this.widgetFactory, this.factory, this, 0));
        detailsList.add(new FragmentAtClassScopeDetails(this.widgetFactory, this.factory, this, 0));
        detailsList.add(new NameDetails(this.widgetFactory, this.factory, this, 0));
        detailsList.add(new ControlNameDetails(this.widgetFactory, this.factory, this, 0));
        detailsList.add(new ControlKeyDetails(this.widgetFactory, this.factory, this, 0));
        detailsList.add(new AllImportsDetails(this.widgetFactory, this.factory, this, 0));
        detailsList.add(new InvocationObjectDetails(this.widgetFactory, this.factory, this, 0));
        detailsList.add(new AllTargetsDetails(this.widgetFactory, this.factory, this, 0));
        detailsList.add(new FragmentDetails(this.widgetFactory, this.factory, this, 0));
        detailsList.add(new StaticFieldDetails(this.widgetFactory, this.factory, this, 0));
        this.details = new Composite[detailsList.size()];
        this.details = detailsList.toArray(this.details);
        this.hideDetails();
    }

    public void showDetailsFor(Object data) {
        Composite detail = this.getDetailsFor(data);
        if (detail != null) {
            this.setCurrentDetails(detail);
            this.showDetail(detail, data);
        } else {
            this.hideDetails();
        }
    }

    public void setFocusFor(Object object) {
        Composite detail = this.getDetailsFor(object);
        if (detail != null) {
            this.setCurrentDetails(detail);
            this.setFocusToControl(detail);
        }
    }

    private void setFocusToControl(Composite detail) {
        Control cc = ((IDetails)detail).getFocusTo();
        if (cc != null && !cc.isDisposed()) {
            if (cc instanceof Text) {
                Text tt = (Text)cc;
                tt.setFocus();
                tt.selectAll();
            } else {
                cc.setFocus();
            }
        } else {
            ((IDetails)detail).setFocusTo();
        }
    }

    private void hideDetails() {
        int i = 0;
        while (i < this.details.length) {
            this.details[i].setVisible(false);
            ++i;
        }
    }

    private Composite getDetailsFor(Object object) {
        int i = 0;
        while (i < this.details.length) {
            if (((IDetails)this.details[i]).isDetailsFor(object)) {
                return this.details[i];
            }
            ++i;
        }
        return null;
    }

    private void showDetail(Composite detail, Object data) {
        IDetails currentDetails = (IDetails)detail;
        currentDetails.display(data);
        this.detailsLayout.topControl = detail;
        this.layout();
    }

    public void dispose() {
        this.factory = null;
        this.widgetFactory = null;
        int i = 0;
        while (i < this.details.length) {
            this.details[i].dispose();
            ++i;
        }
    }

    private void setCurrentDetails(Composite details) {
        this.currentDetails = details;
    }

    private Composite getCurrentDetails() {
        return this.currentDetails;
    }

    public void refresh() {
        if (this.getCurrentDetails() != null) {
            ((IDetails)this.getCurrentDetails()).refresh();
        }
    }
}

