/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.probekit.editor.internal.presentation;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.CreateChildCommand;
import org.eclipse.emf.edit.command.RemoveCommand;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.hyades.models.internal.probekit.Label;
import org.eclipse.hyades.models.internal.probekit.Probekit;
import org.eclipse.hyades.models.internal.probekit.ProbekitFactory;
import org.eclipse.hyades.models.internal.probekit.ProbekitPackage;
import org.eclipse.hyades.probekit.editor.internal.core.util.ProbekitMessages;
import org.eclipse.hyades.probekit.editor.internal.core.util.ResourceUtil;
import org.eclipse.hyades.probekit.editor.internal.presentation.GridUtil;
import org.eclipse.hyades.probekit.editor.internal.presentation.LabelDialog;
import org.eclipse.hyades.probekit.editor.internal.presentation.ProbekitEditor;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class GeneralTab
extends Composite {
    private static final String LABEL_DEFAULT_NAME_PREFIX = "a";
    protected final String[] COLUMNS = new String[]{ProbekitMessages._112, ProbekitMessages._113, ProbekitMessages._114};
    private static final String LANGUAGE_DEFAULT = ResourceUtil.getLanguageDefault();
    private static final String DESCRIPTION_DEFAULT = "";
    private Probekit _probekit;
    private TableViewer _tableViewer;
    private Button _addButton;
    private Button _removeButton;
    private Button _editButton;
    private Text _errorMessage;
    private TextCellEditor _nameCellEditor;
    private ComboBoxCellEditor _languageBoxCellEditor;
    private TextCellEditor _descriptionCellEditor;
    private EditingDomain _editingDomain;
    private Set _languagesInUse;
    private Text _idField;
    private Text _versionField;
    public final GeneralTabSelectionListener GENERAL_TAB_SELECTION_LISTENER = new GeneralTabSelectionListener();

    public GeneralTab(EditingDomain domain, Composite parent, int style, Probekit probekit) {
        super(parent, style);
        this._probekit = probekit;
        this._editingDomain = domain;
        this._languagesInUse = new HashSet();
        this.createControl(this);
    }

    protected Probekit getProbekit() {
        return this._probekit;
    }

    public void dispose() {
        this._editingDomain = null;
        this._languagesInUse = null;
        this._addButton = null;
        this._removeButton = null;
        this._editButton = null;
        this._errorMessage = null;
        this._nameCellEditor = null;
        this._languageBoxCellEditor = null;
        this._descriptionCellEditor = null;
        this._idField = null;
        this._versionField = null;
        this._probekit = null;
        this._tableViewer = null;
    }

    public boolean isPageFor(Object object) {
        return object instanceof Probekit || object instanceof Label;
    }

    private void createControl(Composite parent) {
        GridData pageData = GridUtil.createFill();
        parent.setLayoutData((Object)pageData);
        GridLayout pageLayout = new GridLayout();
        parent.setLayout((Layout)pageLayout);
        this.createErrorMessage(parent);
        this.createLabels(parent);
        this.createTable(parent, this.getProbekit());
        this.validate();
    }

    private void createLabels(Composite parent) {
        ProbekitListener listener = new ProbekitListener();
        Composite page = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        page.setLayout((Layout)layout);
        page.setLayoutData((Object)GridUtil.createHorizontalFill());
        org.eclipse.swt.widgets.Label idLabel = new org.eclipse.swt.widgets.Label(page, 0);
        idLabel.setText(ProbekitMessages._116);
        GridData idLabelData = new GridData(1);
        idLabel.setLayoutData((Object)idLabelData);
        this._idField = new Text(page, 18432);
        GridData gd = GridUtil.createHorizontalFill();
        this._idField.setLayoutData((Object)gd);
        this._idField.setText(ResourceUtil.getString(this.getProbekit().getId()));
        this._idField.addModifyListener((ModifyListener)listener);
        this._idField.setFocus();
        org.eclipse.swt.widgets.Label versionLabel = new org.eclipse.swt.widgets.Label(page, 0);
        versionLabel.setText(ProbekitMessages._117);
        GridData versionLabelData = new GridData(1);
        versionLabel.setLayoutData((Object)versionLabelData);
        this._versionField = new Text(page, 18432);
        GridData gd2 = GridUtil.createHorizontalFill();
        this._versionField.setLayoutData((Object)gd2);
        this._versionField.setText(ResourceUtil.getString(this.getProbekit().getVersion()));
        this._versionField.addModifyListener((ModifyListener)listener);
    }

    private void createTable(Composite parent, Probekit probekit) {
        Composite page = new Composite(parent, 0);
        page.setFont(parent.getFont());
        GridLayout pageLayout = new GridLayout();
        pageLayout.numColumns = 2;
        page.setLayout((Layout)pageLayout);
        GridData pageData = GridUtil.createFill();
        page.setLayoutData((Object)pageData);
        this.createTableViewer(page);
        this.createTableButtons(page);
    }

    private void createErrorMessage(Composite page) {
        this._errorMessage = new Text(page, 76);
        this._errorMessage.setLayoutData((Object)GridUtil.createHorizontalFill());
        this._errorMessage.setBackground(page.getBackground());
        this._errorMessage.setForeground(PlatformUI.getWorkbench().getDisplay().getSystemColor(3));
        this._errorMessage.setFont(page.getFont());
    }

    private void createTableViewer(Composite page) {
        this._tableViewer = new TableViewer(page, 68100);
        TableLayout tableLayout = new TableLayout();
        Table table = this._tableViewer.getTable();
        CellEditor[] cellEditors = new CellEditor[this.COLUMNS.length];
        TableColumn nameCell = new TableColumn(table, 16384);
        nameCell.setText(this.COLUMNS[0]);
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(40));
        this._nameCellEditor = new TextCellEditor((Composite)table);
        cellEditors[0] = this._nameCellEditor;
        TableColumn comboCell = new TableColumn(table, 16384);
        comboCell.setText(this.COLUMNS[1]);
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(20));
        String[] comboboxItems = ResourceUtil.getLanguages();
        this._languageBoxCellEditor = new ComboBoxCellEditor((Composite)table, comboboxItems);
        cellEditors[1] = this._languageBoxCellEditor;
        TableColumn textCell = new TableColumn(table, 16384);
        textCell.setText(this.COLUMNS[2]);
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(40));
        this._descriptionCellEditor = new TextCellEditor((Composite)table);
        cellEditors[2] = this._descriptionCellEditor;
        this._tableViewer.setCellEditors(cellEditors);
        this._tableViewer.setCellModifier((ICellModifier)new LanguageCellModifier());
        this._tableViewer.setContentProvider((IContentProvider)new LanguageContentProvider());
        this._tableViewer.setLabelProvider((IBaseLabelProvider)new LanguageColumnLabelProvider());
        this._tableViewer.setInput((Object)this.getLabels());
        this._tableViewer.setColumnProperties(this.COLUMNS);
        GridData tableData = new GridData(1808);
        table.setLayoutData((Object)tableData);
        table.setLayout((Layout)tableLayout);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        table.setFont(page.getFont());
        table.addSelectionListener((SelectionListener)new LanguageSelectionListener());
    }

    private void createTableButtons(Composite page) {
        LanguageSelectionListener listener = new LanguageSelectionListener();
        Composite buttonGroup = new Composite(page, 0);
        buttonGroup.setFont(page.getFont());
        GridLayout buttonLayout = new GridLayout();
        buttonLayout.makeColumnsEqualWidth = true;
        buttonGroup.setLayout((Layout)buttonLayout);
        GridData buttonData = GridUtil.createVerticalFill();
        buttonGroup.setLayoutData((Object)buttonData);
        this._addButton = new Button(buttonGroup, 8);
        this._addButton.setText(ProbekitMessages._125);
        GridData addData = new GridData(770);
        this._addButton.setLayoutData((Object)addData);
        this._addButton.addSelectionListener((SelectionListener)listener);
        this._editButton = new Button(buttonGroup, 8);
        this._editButton.setText(ProbekitMessages._118);
        GridData editData = new GridData(770);
        this._editButton.setLayoutData((Object)editData);
        this._editButton.addSelectionListener((SelectionListener)listener);
        this._removeButton = new Button(buttonGroup, 8);
        this._removeButton.setText(ProbekitMessages._119);
        GridData removeData = new GridData(770);
        this._removeButton.setLayoutData((Object)removeData);
        this._removeButton.addSelectionListener((SelectionListener)listener);
        this.refreshButtons();
    }

    private void refreshButtons() {
        this._addButton.setEnabled(true);
        Label item = this.getSelectedItem();
        boolean enabled = item != null;
        this._editButton.setEnabled(enabled);
        this._removeButton.setEnabled(enabled);
    }

    Label getSelectedItem() {
        int idx = this._tableViewer.getTable().getSelectionIndex();
        if (idx == -1) {
            return null;
        }
        return (Label)this._tableViewer.getElementAt(idx);
    }

    List getLabels() {
        return this.getProbekit().getLabel();
    }

    void refresh() {
        this.refreshTable();
        this.refreshButtons();
    }

    void refreshTable() {
        this._tableViewer.refresh();
    }

    void validate() {
        String errorMessage = null;
        List labels = this.getLabels();
        Iterator iterator = labels.iterator();
        while (iterator.hasNext()) {
            Label label = (Label)iterator.next();
            this._languagesInUse.add(ResourceUtil.getString(label.getLang()));
        }
        if (this._languagesInUse.size() != labels.size()) {
            errorMessage = ProbekitMessages._115;
        }
        this.setErrorMessage(errorMessage);
        this._languagesInUse.clear();
    }

    public void createLabel() {
        Label label = ProbekitFactory.eINSTANCE.createLabel();
        label.setLang(LANGUAGE_DEFAULT);
        label.setName(this.getUniqueLabelName(LANGUAGE_DEFAULT));
        label.setDescription(DESCRIPTION_DEFAULT);
        CreateChildCommand command = new CreateChildCommand(this._editingDomain, (EObject)this._probekit, (EStructuralFeature)ProbekitPackage.eINSTANCE.getProbekit_Label(), (Object)label, (Collection)Collections.EMPTY_LIST);
        this._editingDomain.getCommandStack().execute((Command)command);
    }

    private String getUniqueLabelName(String language) {
        int count = this._probekit.getLabel().size();
        StringBuffer buffer = new StringBuffer(LABEL_DEFAULT_NAME_PREFIX);
        buffer.append(language);
        buffer.append(count);
        return buffer.toString();
    }

    public void updateLabel(int index, Label label, Label oldLabel) {
        RemoveCommand command = new RemoveCommand(this._editingDomain, (EObject)this._probekit, (EStructuralFeature)ProbekitPackage.eINSTANCE.getProbekit_Label(), (Object)oldLabel);
        this._editingDomain.getCommandStack().execute((Command)command);
        command = new AddCommand(this._editingDomain, (EObject)this._probekit, (EStructuralFeature)ProbekitPackage.eINSTANCE.getProbekit_Label(), (Object)label, index);
        this._editingDomain.getCommandStack().execute((Command)command);
    }

    public void updateProbekit() {
        EObject documentRoot = this._probekit.eContainer();
        SetCommand command = new SetCommand(this._editingDomain, documentRoot, (EStructuralFeature)ProbekitPackage.eINSTANCE.getDocumentRoot_Probekit(), (Object)this._probekit);
        this._editingDomain.getCommandStack().execute((Command)command);
    }

    public void removeLabel(Label label) {
        RemoveCommand command = new RemoveCommand(this._editingDomain, (EObject)this._probekit, (EStructuralFeature)ProbekitPackage.eINSTANCE.getProbekit_Label(), (Object)label);
        this._editingDomain.getCommandStack().execute((Command)command);
    }

    protected void setErrorMessage(String message) {
        String text = ResourceUtil.getString(message);
        this._errorMessage.setText(text);
        this._errorMessage.pack(true);
    }

    public boolean setFocus() {
        super.setFocus();
        return this._idField.setFocus();
    }

    protected boolean isEqual(Label label1, Label label2) {
        if (label1 == label2) {
            return true;
        }
        if (!this.isEqual(label1.getName(), label2.getName())) {
            return false;
        }
        if (!this.isEqual(label1.getLang(), label2.getLang())) {
            return false;
        }
        return this.isEqual(label1.getDescription(), label2.getDescription());
    }

    protected boolean isEqual(String string1, String string2) {
        if (string1 == null) {
            return string2 == null;
        }
        return string1.equals(string2);
    }

    private class LanguageSelectionListener
    implements SelectionListener {
        LanguageSelectionListener() {
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void widgetSelected(SelectionEvent event) {
            if (event.widget.equals(GeneralTab.this._addButton)) {
                this.add();
            } else if (event.widget.equals(GeneralTab.this._editButton)) {
                this.edit();
            } else if (event.widget.equals(GeneralTab.this._removeButton)) {
                this.remove();
            } else {
                GeneralTab.this.refreshButtons();
                return;
            }
            GeneralTab.this.refresh();
            GeneralTab.this.validate();
        }

        private void add() {
            GeneralTab.this.createLabel();
            GeneralTab.this.refreshTable();
            this.select(GeneralTab.this._tableViewer.getTable().getItemCount() - 1);
        }

        private void edit() {
            Label item = GeneralTab.this.getSelectedItem();
            if (item != null) {
                LabelDialog dialog = new LabelDialog(GeneralTab.this.getParent().getShell(), ResourceUtil.getLanguages(), item);
                dialog.setBlockOnOpen(true);
                dialog.setTitle(ProbekitMessages._137);
                dialog.open();
                int index = GeneralTab.this._tableViewer.getTable().getSelectionIndex();
                Label updatedItem = dialog.getResult();
                if (!GeneralTab.this.isEqual(item, updatedItem)) {
                    GeneralTab.this.updateLabel(index, updatedItem, item);
                    GeneralTab.this.refreshTable();
                    this.select(index);
                }
            }
        }

        private void remove() {
            Label item = GeneralTab.this.getSelectedItem();
            int index = GeneralTab.this._tableViewer.getTable().getSelectionIndex();
            if (item != null) {
                GeneralTab.this.removeLabel(item);
                --index;
            }
            GeneralTab.this.refreshTable();
            this.select(index);
        }

        private void select(int index) {
            GeneralTab.this._tableViewer.getTable().select(index);
        }
    }

    private class LanguageCellModifier
    implements ICellModifier {
        LanguageCellModifier() {
        }

        public Object getValue(Object element, String property) {
            Object value = null;
            if (element instanceof Label) {
                Label item = (Label)element;
                if (property.equals(GeneralTab.this.COLUMNS[0])) {
                    value = ResourceUtil.getString(item.getName());
                } else if (property.equals(GeneralTab.this.COLUMNS[1])) {
                    String typeName = ResourceUtil.getString(item.getLang());
                    value = this.getCellIndex(typeName);
                } else if (property.equals(GeneralTab.this.COLUMNS[2])) {
                    value = ResourceUtil.getString(item.getDescription());
                }
            }
            return value;
        }

        private Integer getCellIndex(String name) {
            Integer index = null;
            String[] items = GeneralTab.this._languageBoxCellEditor.getItems();
            int i = 0;
            while (i < items.length) {
                String itemText = items[i];
                if (itemText.equals(name)) {
                    index = new Integer(i);
                    break;
                }
                ++i;
            }
            if (index == null) {
                index = new Integer(-1);
            }
            return index;
        }

        public boolean canModify(Object element, String property) {
            return true;
        }

        public void modify(Object element, String property, Object value) {
            String itemName;
            TableItem item = (TableItem)element;
            Label label = (Label)item.getData();
            int index = GeneralTab.this._tableViewer.getTable().getSelectionIndex();
            boolean isDirty = false;
            if (property.equals(GeneralTab.this.COLUMNS[0])) {
                String itemName2 = (String)value;
                if (!itemName2.equals(label.getName())) {
                    isDirty = true;
                    label.setName(itemName2);
                }
            } else if (property.equals(GeneralTab.this.COLUMNS[1])) {
                Integer cellIndex = (Integer)value;
                String itemName3 = GeneralTab.DESCRIPTION_DEFAULT;
                if (cellIndex < 0) {
                    itemName3 = ((CCombo)GeneralTab.this._languageBoxCellEditor.getControl()).getText();
                    Integer languageIndex = this.getCellIndex(itemName3);
                    if (languageIndex < 0) {
                        String[] items = GeneralTab.this._languageBoxCellEditor.getItems();
                        String[] newItems = new String[items.length + 1];
                        System.arraycopy(items, 0, newItems, 0, items.length);
                        newItems[items.length] = itemName3;
                        GeneralTab.this._languageBoxCellEditor.setItems(newItems);
                    }
                } else {
                    String[] items = GeneralTab.this._languageBoxCellEditor.getItems();
                    itemName3 = items[cellIndex];
                }
                if (!itemName3.equals(label.getLang())) {
                    isDirty = true;
                    label.setLang(itemName3);
                }
            } else if (property.equals(GeneralTab.this.COLUMNS[2]) && !(itemName = (String)value).equals(label.getDescription())) {
                isDirty = true;
                label.setDescription(itemName);
            }
            if (isDirty) {
                GeneralTab.this.updateLabel(index, label, label);
                GeneralTab.this.refresh();
                GeneralTab.this.validate();
            }
        }
    }

    private class LanguageContentProvider
    implements IStructuredContentProvider {
        LanguageContentProvider() {
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            return GeneralTab.this.getLabels().toArray();
        }
    }

    private static class LanguageColumnLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        LanguageColumnLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element instanceof Label) {
                Label item = (Label)element;
                if (columnIndex == 0) {
                    return ResourceUtil.getString(item.getName());
                }
                if (columnIndex == 1) {
                    return ResourceUtil.getString(item.getLang());
                }
                return ResourceUtil.getString(item.getDescription());
            }
            return GeneralTab.DESCRIPTION_DEFAULT;
        }
    }

    private class ProbekitListener
    implements ModifyListener {
        ProbekitListener() {
        }

        public void modifyText(ModifyEvent e) {
            GeneralTab.this._probekit.setId(GeneralTab.this._idField.getText());
            GeneralTab.this._probekit.setVersion(GeneralTab.this._versionField.getText());
            GeneralTab.this.updateProbekit();
            GeneralTab.this.validate();
        }
    }

    private class GeneralTabSelectionListener
    implements ISelectionChangedListener {
        GeneralTabSelectionListener() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            if (event.getSource() != null && event.getSource() instanceof ProbekitEditor) {
                ProbekitEditor editor = (ProbekitEditor)((Object)event.getSource());
                ISelection selection = event.getSelection();
                Object currentSelection = null;
                if (selection != null && !selection.isEmpty() && selection instanceof IStructuredSelection) {
                    currentSelection = ((IStructuredSelection)selection).getFirstElement();
                }
                if (currentSelection instanceof Probekit) {
                    editor.setActivePage(GeneralTab.this);
                    GeneralTab.this._idField.setFocus();
                } else if (currentSelection instanceof Label) {
                    editor.setActivePage(GeneralTab.this);
                    Label selected = (Label)currentSelection;
                    TableItem[] items = GeneralTab.this._tableViewer.getTable().getItems();
                    int i = 0;
                    while (i < items.length) {
                        TableItem item = items[i];
                        Label tableLabel = (Label)item.getData();
                        if (GeneralTab.this.isEqual(tableLabel, selected)) {
                            GeneralTab.this._tableViewer.getTable().setSelection(i);
                            GeneralTab.this.refreshButtons();
                            break;
                        }
                        ++i;
                    }
                }
            }
        }
    }
}

