/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.probekit.editor.internal.presentation;

import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.hyades.models.internal.probekit.InvocationObject;
import org.eclipse.hyades.models.internal.probekit.impl.InvocationObjectImpl;
import org.eclipse.hyades.probekit.editor.internal.core.util.ProbekitMessages;
import org.eclipse.hyades.probekit.editor.internal.presentation.BaseDetails;
import org.eclipse.hyades.probekit.editor.internal.presentation.GridUtil;
import org.eclipse.hyades.probekit.editor.internal.presentation.ProbekitWidgetFactory;
import org.eclipse.hyades.probekit.editor.internal.provider.InvocationObjectItemProvider;
import org.eclipse.hyades.probekit.editor.internal.provider.ProbekitItemProviderAdapterFactory;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class InvocationObjectDetails
extends BaseDetails
implements ModifyListener {
    protected final String NAME = "Name";
    protected Text invocationObjectText;
    protected boolean isDisplaying;
    protected InvocationObject currentSelection;
    protected InvocationObjectItemProvider itemProvider;
    protected ProbekitItemProviderAdapterFactory itemFactory;

    public InvocationObjectDetails(ProbekitWidgetFactory factory, ProbekitItemProviderAdapterFactory itemFactory, Composite composite, int style) {
        super(composite, style);
        this.itemFactory = itemFactory;
        GridLayout detailLayout = new GridLayout();
        detailLayout.numColumns = 1;
        this.setLayout((Layout)detailLayout);
        this.setLayoutData(GridUtil.createFill());
        factory.createLabel(this, ProbekitMessages._21, 0);
        this.invocationObjectText = factory.createText(this, "", 0);
        this.invocationObjectText.setLayoutData((Object)new GridData(768));
        this.invocationObjectText.addModifyListener((ModifyListener)this);
        this.itemProvider = (InvocationObjectItemProvider)itemFactory.createInvocationObjectAdapter();
        this.addFocusListenerTo((Control)this.invocationObjectText);
    }

    public void display(Object object) {
        if (this.invocationObjectText.isFocusControl()) {
            return;
        }
        this.currentSelection = (InvocationObject)object;
        this.isDisplaying = true;
        this.invocationObjectText.setText(this.currentSelection.getName() == null ? "" : this.currentSelection.getName());
        this.isDisplaying = false;
    }

    public boolean updateCurrentSelection(Object currentSelection) {
        this.currentSelection = (InvocationObject)currentSelection;
        this.currentSelection.setName(this.invocationObjectText.getText().trim());
        return false;
    }

    public void setFocusToText() {
        this.invocationObjectText.setFocus();
        this.invocationObjectText.selectAll();
    }

    public void modifyText(ModifyEvent e) {
        String text;
        if (this.currentSelection == null) {
            return;
        }
        if (e.getSource() == this.invocationObjectText && !(text = this.invocationObjectText.getText().trim()).equals(this.currentSelection.getName())) {
            if (text.length() == 0 && this.currentSelection.getName() == null) {
                return;
            }
            IItemPropertyDescriptor descriptor = this.itemProvider.getPropertyDescriptor(this.currentSelection, "Name");
            if (descriptor != null) {
                descriptor.setPropertyValue((Object)this.currentSelection, (Object)text);
            }
        }
    }

    public void dispose() {
        this.itemFactory = null;
        this.itemProvider = null;
        this.invocationObjectText = null;
    }

    public boolean isDetailsFor(Object object) {
        return object instanceof InvocationObject || object instanceof InvocationObjectImpl;
    }

    public void setFocusTo() {
        this.setFocusToText();
    }

    public void refresh() {
    }
}

