/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.probekit.editor.internal.presentation;

import org.eclipse.hyades.models.internal.probekit.Label;
import org.eclipse.hyades.models.internal.probekit.ProbekitFactory;
import org.eclipse.hyades.probekit.editor.internal.core.util.ProbekitMessages;
import org.eclipse.hyades.probekit.editor.internal.core.util.ResourceUtil;
import org.eclipse.hyades.probekit.editor.internal.presentation.GridUtil;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

class LabelDialog
extends Dialog {
    private String _title = null;
    private Text _name = null;
    private Text _description = null;
    private Combo _combo = null;
    private Label _label = null;
    private String[] _languages = null;
    private Label _default = null;

    public LabelDialog(Shell shell, String[] languages, Label label) {
        super(shell);
        int shellStyle = this.getShellStyle();
        this.setShellStyle(shellStyle | 0x10 | 0x800);
        this._label = ProbekitFactory.eINSTANCE.createLabel();
        this._label.setLang(label.getLang());
        this._label.setName(label.getName());
        this._label.setDescription(label.getDescription());
        this._default = label;
        this._languages = languages;
    }

    public Label getResult() {
        if (this.getReturnCode() == 1) {
            return this._default;
        }
        return this.getLabel();
    }

    public Label getLabel() {
        return this._label;
    }

    private String[] getLanguages() {
        return this._languages;
    }

    void update() {
        String name = this._name.getText();
        this.getLabel().setName(name);
        String language = this._combo.getText();
        this.getLabel().setLang(language);
        String description = this._description.getText();
        this.getLabel().setDescription(description);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout();
        GridData data = new GridData(1808);
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)data);
        return this.createDialogContents(composite);
    }

    protected Composite createDialogContents(Composite parent) {
        LabelModifyListener listener = new LabelModifyListener();
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        GridData data = new GridData(1808);
        data.widthHint = 300;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)data);
        org.eclipse.swt.widgets.Label nameLabel = new org.eclipse.swt.widgets.Label(composite, 64);
        nameLabel.setText(ProbekitMessages._112);
        GridData nameLabelData = new GridData();
        nameLabel.setLayoutData((Object)nameLabelData);
        this._name = new Text(composite, 2048);
        this._name.setText(ResourceUtil.getString(this.getLabel().getName()));
        GridData nameData = GridUtil.createHorizontalFill();
        this._name.setLayoutData((Object)nameData);
        this._name.addModifyListener((ModifyListener)listener);
        org.eclipse.swt.widgets.Label comboLabel = new org.eclipse.swt.widgets.Label(composite, 64);
        comboLabel.setText(ProbekitMessages._113);
        this._combo = new Combo(composite, 4);
        GridData comboData = GridUtil.createHorizontalFill();
        this._combo.setItems(this.getLanguages());
        this._combo.setText(ResourceUtil.getString(this.getLabel().getLang()));
        this._combo.setLayoutData((Object)comboData);
        this._combo.addModifyListener((ModifyListener)listener);
        org.eclipse.swt.widgets.Label textLabel = new org.eclipse.swt.widgets.Label(composite, 0);
        textLabel.setText(ProbekitMessages._114);
        textLabel.setLayoutData((Object)GridUtil.createVerticalFill());
        this._description = new Text(composite, 2050);
        this._description.setText(ResourceUtil.getString(this.getLabel().getDescription()));
        GridData textData = GridUtil.createFill();
        textData.heightHint = 100;
        this._description.setLayoutData((Object)textData);
        this._description.addModifyListener((ModifyListener)listener);
        return composite;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        if (this.getTitle() != null) {
            shell.setText(this.getTitle());
        }
    }

    private String getTitle() {
        return this._title;
    }

    public void setTitle(String title) {
        this._title = title;
    }

    private class LabelModifyListener
    implements ModifyListener {
        LabelModifyListener() {
        }

        public void modifyText(ModifyEvent e) {
            LabelDialog.this.update();
        }
    }
}

