/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.probekit.editor.internal.presentation;

import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.hyades.models.internal.probekit.StaticField;
import org.eclipse.hyades.models.internal.probekit.impl.StaticFieldImpl;
import org.eclipse.hyades.probekit.editor.internal.core.util.ProbekitMessages;
import org.eclipse.hyades.probekit.editor.internal.presentation.BaseDetails;
import org.eclipse.hyades.probekit.editor.internal.presentation.GridUtil;
import org.eclipse.hyades.probekit.editor.internal.presentation.ProbekitWidgetFactory;
import org.eclipse.hyades.probekit.editor.internal.provider.ProbekitItemProviderAdapterFactory;
import org.eclipse.hyades.probekit.editor.internal.provider.StaticFieldItemProvider;
import org.eclipse.hyades.probekit.ui.internal.ProbekitUIPlugin;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class StaticFieldDetails
extends BaseDetails
implements ModifyListener {
    protected final String TYPE = ProbekitUIPlugin.getPlugin().getString("_UI_StaticField_type_feature");
    protected Text type;
    protected boolean isDisplaying;
    protected StaticField currentSelection;
    protected StaticFieldItemProvider itemProvider;
    protected ProbekitItemProviderAdapterFactory itemFactory;

    public StaticFieldDetails(ProbekitWidgetFactory factory, ProbekitItemProviderAdapterFactory itemFactory, Composite composite, int style) {
        super(composite, style);
        this.itemFactory = itemFactory;
        GridLayout detailLayout = new GridLayout();
        detailLayout.numColumns = 1;
        this.setLayout((Layout)detailLayout);
        this.setLayoutData(GridUtil.createFill());
        factory.createLabel(this, ProbekitMessages._29, 0);
        this.type = factory.createText(this, "", 0);
        this.type.setLayoutData((Object)new GridData(768));
        this.type.addModifyListener((ModifyListener)this);
        this.itemProvider = (StaticFieldItemProvider)itemFactory.createStaticFieldAdapter();
        this.addFocusListenerTo((Control)this.type);
    }

    public void display(Object object) {
        if (this.type.isFocusControl()) {
            return;
        }
        this.currentSelection = (StaticField)object;
        this.isDisplaying = true;
        this.type.setText(this.currentSelection.getType() == null ? "" : this.currentSelection.getType());
        this.isDisplaying = false;
        this.setFocusTo();
    }

    public boolean updateCurrentSelection(Object currentSelection) {
        this.currentSelection = (StaticField)currentSelection;
        this.currentSelection.setType(this.type.getText().trim());
        return false;
    }

    public void setFocusToText() {
        this.type.setFocus();
        this.type.selectAll();
    }

    public void modifyText(ModifyEvent e) {
        String text;
        if (this.currentSelection == null) {
            return;
        }
        if (e.getSource() == this.type && !(text = this.type.getText().trim()).equals(this.currentSelection.getType())) {
            if (text.length() == 0 && this.currentSelection.getType() == null) {
                return;
            }
            IItemPropertyDescriptor descriptor = this.itemProvider.getPropertyDescriptor(this.currentSelection, this.TYPE);
            if (descriptor != null) {
                descriptor.setPropertyValue((Object)this.currentSelection, (Object)text);
            }
        }
    }

    public void dispose() {
        this.itemFactory = null;
        this.itemProvider = null;
        this.type = null;
    }

    public boolean isDetailsFor(Object object) {
        return object instanceof StaticField || object instanceof StaticFieldImpl;
    }

    public void setFocusTo() {
        this.setFocusToText();
    }

    public void refresh() {
    }
}

