/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.probekit.editor.internal.presentation.codeassist;

import java.net.URL;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.hyades.models.internal.probekit.Probekit;
import org.eclipse.hyades.models.internal.probekit.StaticField;
import org.eclipse.hyades.probekit.CompilerFactory;
import org.eclipse.hyades.probekit.IProbeCompiler;
import org.eclipse.hyades.probekit.LocationAdapter;
import org.eclipse.hyades.probekit.ProbekitException;
import org.eclipse.hyades.probekit.editor.internal.core.util.ProbekitMessages;
import org.eclipse.hyades.probekit.editor.internal.core.util.ResourceUtil;
import org.eclipse.hyades.probekit.editor.internal.presentation.codeassist.SyntaxAdapter;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IProblemRequestor;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.WorkingCopyOwner;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Bundle;

public final class JavaSnippet {
    private static final int ERROR = 1;
    private static final int WARNING = 2;
    private static final int NO_PROBLEM = 0;
    private IPackageFragment _defaultPkg = null;
    private ICompilationUnit _compilationUnit = null;
    private IFile _probeFile = null;
    private IProbeCompiler _probeCompiler = null;
    private static final String BASE_NAME_SUFFIX = "_checkSyntax.java";
    private String _javaFileName = null;
    private Probekit _probekit = null;
    private static URL _errorURL = null;
    private static URL _warningURL = null;

    public JavaSnippet(IFile probeFile, Probekit probekit) {
        this._probeFile = probeFile;
        this._probekit = probekit;
        this._javaFileName = String.valueOf(ResourceUtil.getBaseName(probeFile)) + BASE_NAME_SUFFIX;
    }

    private String getJavaFileName() {
        return this._javaFileName;
    }

    private IProbeCompiler getProbeCompiler() throws ProbekitException {
        this._probeCompiler = null;
        this._probeCompiler = CompilerFactory.INSTANCE.createCompiler();
        String basename = this._probeCompiler.makeValidJavaIdentifier(this.getJavaFileName());
        this._probeCompiler.setClassPrefix(basename);
        this._probeCompiler.addResource(this.getResource(), (IResource)this.getProbeFile());
        return this._probeCompiler;
    }

    public IFile getProbeFile() {
        return this._probeFile;
    }

    private Resource getResource() {
        return this._probekit.eResource();
    }

    public Set compile() throws CoreException, JavaModelException, ProbekitException {
        this.clearOldProblems();
        try {
            this._probeFile.deleteMarkers("org.eclipse.core.resources.problemmarker", false, 0);
        }
        catch (CoreException coreException) {}
        Set problems = this.internalCompile();
        if (problems.size() > 0) {
            Iterator iterator = problems.iterator();
            while (iterator.hasNext()) {
                IProblem problem = (IProblem)iterator.next();
                this.addProblem(problem);
                IMarker marker = this._probeFile.createMarker("org.eclipse.core.resources.problemmarker");
                marker.setAttribute("message", (Object)problem.getMessage());
                marker.setAttribute("severity", problem.isError() ? 2 : 1);
                marker.setAttribute("location", (Object)this._probeFile.getName());
            }
        }
        this.compileStaticFields();
        return problems;
    }

    private void addProblem(IProblem problem) {
        int lineNumber = problem.getSourceLineNumber();
        EObject badObject = this.getEObject(lineNumber);
        if (badObject != null) {
            SyntaxAdapter adapter = JavaSnippet.getSyntaxAdapter(badObject);
            adapter.addProblem(problem);
        }
    }

    private EObject getEObject(int lineNumber) {
        Resource resource = this.getResource();
        TreeIterator resourceIterator = resource.getAllContents();
        Notifier result = null;
        LocationAdapter location = null;
        while (resourceIterator.hasNext()) {
            EObject eObject = (EObject)resourceIterator.next();
            LocationAdapter lAdapter = JavaSnippet.getLocationAdapter(eObject);
            if (lAdapter == null || !lAdapter.contains(lineNumber)) continue;
            location = this.getPreciseMatch(lineNumber, lAdapter, location);
            result = location.getTarget();
        }
        return (EObject)result;
    }

    public EObject getEObject(IProblem problem) {
        if (problem instanceof StaticFieldUnknownProblem) {
            return this.getStaticField(problem);
        }
        int lineNumber = problem.getSourceLineNumber();
        return this.getEObject(lineNumber);
    }

    private StaticField getStaticField(IProblem problem) {
        Resource resource = this.getResource();
        TreeIterator resourceIterator = resource.getAllContents();
        while (resourceIterator.hasNext()) {
            Object object = resourceIterator.next();
            if (!(object instanceof StaticField)) continue;
            StaticField staticField = (StaticField)object;
            SyntaxAdapter adapter = JavaSnippet.getSyntaxAdapter((EObject)staticField);
            IProblem[] problems = adapter.getKnownProblems();
            int i = 0;
            while (i < problems.length) {
                IProblem p = problems[i];
                if (problem.equals(p)) {
                    return staticField;
                }
                ++i;
            }
        }
        return null;
    }

    private LocationAdapter getPreciseMatch(int lineNumber, LocationAdapter a, LocationAdapter b) {
        int bEnd;
        int bEndDiff;
        int bStart;
        int bStartDiff;
        if (a == null) {
            return b;
        }
        if (b == null) {
            return a;
        }
        int aStart = a.getStartLineNumber();
        int aStartDiff = lineNumber - aStart;
        if (aStartDiff > (bStartDiff = lineNumber - (bStart = b.getStartLineNumber()))) {
            return b;
        }
        if (aStartDiff < bStartDiff) {
            return a;
        }
        int aEnd = a.getEndLineNumber();
        int aEndDiff = aEnd - lineNumber;
        if (aEndDiff > (bEndDiff = (bEnd = b.getEndLineNumber()) - lineNumber)) {
            return b;
        }
        return a;
    }

    private void clearOldProblems() {
        Resource resource = this.getResource();
        TreeIterator resourceIterator = resource.getAllContents();
        while (resourceIterator.hasNext()) {
            EObject eObject = (EObject)resourceIterator.next();
            SyntaxAdapter adapter = JavaSnippet.getSyntaxAdapter(eObject);
            adapter.clearProblems();
        }
    }

    private void compileStaticFields() throws JavaModelException {
        Resource resource = this.getResource();
        TreeIterator resourceIterator = resource.getAllContents();
        while (resourceIterator.hasNext()) {
            StaticField field;
            String type;
            Object object = resourceIterator.next();
            if (!(object instanceof StaticField) || this.isKnownType(type = (field = (StaticField)object).getType())) continue;
            SyntaxAdapter adapter = JavaSnippet.getSyntaxAdapter((EObject)field);
            StaticFieldUnknownProblem problem = new StaticFieldUnknownProblem(NLS.bind((String)ProbekitMessages._134, (Object[])new String[]{type}));
            adapter.addProblem(problem);
        }
    }

    private boolean isKnownType(String typeName) throws JavaModelException {
        IProject project = this.getProbeFile().getProject();
        IJavaProject jp = JavaCore.create((IProject)project);
        IType type = jp.findType(typeName);
        return type != null;
    }

    public static SyntaxAdapter getSyntaxAdapter(EObject object) {
        SyntaxAdapter adapter = null;
        EList c = object.eAdapters();
        if (c != null) {
            Iterator iterator = c.iterator();
            while (iterator.hasNext()) {
                Adapter a = (Adapter)iterator.next();
                if (a == null || !(a instanceof SyntaxAdapter)) continue;
                adapter = (SyntaxAdapter)a;
                break;
            }
        }
        if (adapter == null) {
            adapter = new SyntaxAdapter();
            adapter.setTarget((Notifier)object);
            object.eAdapters().add((Object)adapter);
        }
        return adapter;
    }

    public static URL getImageURL(Object object) {
        int problemState = JavaSnippet.getProblemState(object);
        URL url = null;
        if ((problemState & 1) == 1) {
            url = JavaSnippet.getErrorURL();
        } else if ((problemState & 2) == 2) {
            url = JavaSnippet.getWarningURL();
        }
        return url;
    }

    public static URL getIconURL(IProblem problem) {
        if (problem.isError()) {
            return JavaSnippet.getErrorURL();
        }
        if (problem.isWarning()) {
            return JavaSnippet.getWarningURL();
        }
        return null;
    }

    private static URL getErrorURL() {
        Bundle plugin;
        if (_errorURL == null && (plugin = Platform.getBundle((String)"org.eclipse.ui")) != null) {
            _errorURL = plugin.getEntry("icons/full/obj16/error_tsk.gif");
        }
        return _errorURL;
    }

    private static URL getWarningURL() {
        Bundle plugin;
        if (_warningURL == null && (plugin = Platform.getBundle((String)"org.eclipse.ui")) != null) {
            _warningURL = plugin.getEntry("icons/full/obj16/warn_tsk.gif");
        }
        return _warningURL;
    }

    private static int getProblemState(Object object) {
        if (object instanceof EObject) {
            EObject eObject = (EObject)object;
            return JavaSnippet.internalGetProblemState(eObject);
        }
        if (object instanceof EObjectContainmentEList) {
            EObjectContainmentEList list = (EObjectContainmentEList)object;
            Iterator iterator = list.iterator();
            int result = 0;
            while (iterator.hasNext()) {
                EObject eObject = (EObject)iterator.next();
                result |= JavaSnippet.internalGetProblemState(eObject);
            }
            return result;
        }
        return 0;
    }

    private static int internalGetProblemState(EObject eObject) {
        SyntaxAdapter adapter = JavaSnippet.getSyntaxAdapter(eObject);
        int result = 0;
        if (adapter.containsErrors()) {
            result |= 1;
        } else if (adapter.containsWarnings()) {
            result |= 2;
        }
        return result;
    }

    public static LocationAdapter getLocationAdapter(EObject object) {
        LocationAdapter adapter = null;
        EList c = object.eAdapters();
        if (c != null) {
            Iterator iterator = c.iterator();
            while (iterator.hasNext()) {
                Adapter a = (Adapter)iterator.next();
                if (a == null || !(a instanceof LocationAdapter)) continue;
                adapter = (LocationAdapter)a;
                break;
            }
        }
        return adapter;
    }

    private Set internalCompile() throws CoreException, JavaModelException, ProbekitException {
        String javaCode = this.generateSource();
        JavaProblemRequestor problemRequestor = new JavaProblemRequestor();
        ICompilationUnit workingCopy = this.getCompilationUnit().getWorkingCopy(new WorkingCopyOwner(){}, (IProblemRequestor)problemRequestor, null);
        workingCopy.getBuffer().setContents(javaCode);
        workingCopy.reconcile(0, true, null, null);
        workingCopy.discardWorkingCopy();
        return problemRequestor.getProblems();
    }

    private ICompilationUnit getCompilationUnit() throws CoreException, JavaModelException {
        if (this._compilationUnit == null) {
            IPackageFragment defaultPackage = this.getDefaultPackage();
            if (defaultPackage == null) {
                String error = ProbekitMessages._138;
                IStatus status = ResourceUtil.createInitialStatus(4, error);
                throw new CoreException(status);
            }
            this._compilationUnit = defaultPackage.getCompilationUnit(this.getJavaFileName());
        }
        return this._compilationUnit;
    }

    public void release() throws JavaModelException {
        if (this._compilationUnit != null && this._compilationUnit.exists()) {
            this._compilationUnit.delete(true, (IProgressMonitor)new NullProgressMonitor());
        }
    }

    private IPackageFragment getDefaultPackage() throws JavaModelException {
        if (this._defaultPkg == null) {
            IJavaElement pkgRoot = JavaCore.create((IResource)this.getProbeFile().getParent());
            if (pkgRoot instanceof IPackageFragmentRoot) {
                this._defaultPkg = ((IPackageFragmentRoot)pkgRoot).getPackageFragment("");
            } else if (pkgRoot instanceof IJavaProject) {
                IJavaProject jp = (IJavaProject)pkgRoot;
                IPath path = jp.getPath();
                IPath defaultPath = path.append("");
                this._defaultPkg = jp.findPackageFragment(defaultPath);
            }
        }
        return this._defaultPkg;
    }

    private String generateSource() throws ProbekitException {
        return this.getProbeCompiler().getGeneratedSource();
    }

    private static class JavaProblemRequestor
    implements IProblemRequestor {
        private Set _problems = null;

        JavaProblemRequestor() {
        }

        public void acceptProblem(IProblem problem) {
            this.getProblems().add(problem);
        }

        public void beginReporting() {
        }

        public void endReporting() {
        }

        public boolean isActive() {
            return true;
        }

        public Set getProblems() {
            if (this._problems == null) {
                this._problems = new HashSet();
            }
            return this._problems;
        }
    }

    private static class StaticFieldUnknownProblem
    implements IProblem {
        private String _message;

        StaticFieldUnknownProblem(String translatedMessage) {
            this._message = translatedMessage;
        }

        public String[] getArguments() {
            return new String[0];
        }

        public int getID() {
            return 0x1000002;
        }

        public String getMessage() {
            return this._message;
        }

        public char[] getOriginatingFileName() {
            return new char[0];
        }

        public int getSourceEnd() {
            return 0;
        }

        public int getSourceLineNumber() {
            return 0;
        }

        public int getSourceStart() {
            return 0;
        }

        public boolean isError() {
            return true;
        }

        public boolean isWarning() {
            return false;
        }

        public void setSourceEnd(int sourceEnd) {
        }

        public void setSourceLineNumber(int lineNumber) {
        }

        public void setSourceStart(int sourceStart) {
        }
    }
}

