/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.probekit.editor.internal.ui;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.hyades.probekit.editor.internal.core.util.ResourceUtil;
import org.eclipse.hyades.probekit.editor.internal.ui.JavaElementContentProvider;
import org.eclipse.hyades.probekit.editor.internal.ui.ResourceContentProvider;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

public class CompoundTreeContentProvider
implements ITreeContentProvider {
    private ResourceContentProvider _resourceTreeContentProvider;
    private JavaElementContentProvider _javaTreeContentProvider;

    public CompoundTreeContentProvider(ResourceContentProvider resourceProvider, JavaElementContentProvider javaProvider) {
        this._resourceTreeContentProvider = resourceProvider;
        this._javaTreeContentProvider = javaProvider;
    }

    private ITreeContentProvider getTreeContentProvider(Object element) {
        if (element instanceof IResource) {
            return this._resourceTreeContentProvider;
        }
        if (element instanceof IJavaElement) {
            return this._javaTreeContentProvider;
        }
        return null;
    }

    public List getBaseJavaElements(Object[] selected) {
        List selectedList = Arrays.asList(selected);
        int i = 0;
        while (i < selected.length) {
            Object selection = selected[i];
            IProject container = null;
            if (selection instanceof IJavaProject) {
                IJavaProject jp = (IJavaProject)selection;
                container = jp.getProject();
            } else if (selection instanceof IContainer) {
                container = (IContainer)selection;
            }
            if (container != null) {
                selectedList = CompoundTreeContentProviderUtil.removeMembers((IContainer)container, selectedList);
            }
            ++i;
        }
        return selectedList;
    }

    public List getClassAndJarElements(Object[] selected) {
        ArrayList<Object> selectedList = new ArrayList<Object>();
        int i = 0;
        while (i < selected.length) {
            IPackageFragmentRoot pr;
            Object selection = selected[i];
            if (selection instanceof IFile) {
                selectedList.add(selection);
            } else if (selection instanceof IPackageFragmentRoot && (pr = (IPackageFragmentRoot)selection).isArchive()) {
                selectedList.add(selection);
            }
            ++i;
        }
        return selectedList;
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof IJavaProject) {
            IJavaProject jp = (IJavaProject)parentElement;
            Object[] resourceChildren = this._resourceTreeContentProvider.getChildren(jp.getProject());
            Object[] javaChildren = this._javaTreeContentProvider.getChildren(jp);
            Object[] result = new Object[javaChildren.length + resourceChildren.length];
            System.arraycopy(resourceChildren, 0, result, 0, resourceChildren.length);
            System.arraycopy(javaChildren, 0, result, resourceChildren.length, javaChildren.length);
            return result;
        }
        ITreeContentProvider provider = this.getTreeContentProvider(parentElement);
        if (provider == null) {
            return new Object[0];
        }
        return provider.getChildren(parentElement);
    }

    public Object getParent(Object element) {
        ITreeContentProvider provider = this.getTreeContentProvider(element);
        if (provider == null) {
            return null;
        }
        Object parent = provider.getParent(element);
        if (parent instanceof IProject) {
            return JavaCore.create((IProject)((IProject)parent));
        }
        return parent;
    }

    public boolean hasChildren(Object element) {
        ITreeContentProvider provider = this.getTreeContentProvider(element);
        if (provider == null) {
            return false;
        }
        return provider.hasChildren(element);
    }

    public Object[] getElements(Object inputElement) {
        return (Object[])inputElement;
    }

    public void dispose() {
        this._resourceTreeContentProvider.dispose();
        this._javaTreeContentProvider.dispose();
        this._resourceTreeContentProvider = null;
        this._javaTreeContentProvider = null;
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    private static class CompoundTreeContentProviderUtil {
        CompoundTreeContentProviderUtil() {
        }

        public static List removeMembers(IContainer container, List compound) {
            Iterator iterator = compound.iterator();
            ArrayList trimmedList = new ArrayList(compound.size());
            while (iterator.hasNext()) {
                Object obj = iterator.next();
                boolean remove = false;
                if (obj instanceof IResource && ResourceUtil.isMember(container, (IResource)obj)) {
                    remove = true;
                }
                if (remove) continue;
                trimmedList.add(obj);
            }
            return trimmedList;
        }
    }
}

