/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.probekit.editor.internal.ui;

import java.util.ArrayList;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.CheckedTreeSelectionDialog;

public class WrappedCheckedTreeSelectionDialog
extends CheckedTreeSelectionDialog {
    private Label _label;

    public WrappedCheckedTreeSelectionDialog(Shell parent, ILabelProvider labelProvider, ITreeContentProvider contentProvider) {
        super(parent, labelProvider, contentProvider);
    }

    protected Label createMessageArea(Composite parent) {
        this._label = new Label(parent, 64);
        GridData labelData = new GridData(1808);
        this._label.setLayoutData((Object)labelData);
        this._label.setFont(parent.getFont());
        return this._label;
    }

    public void create() {
        super.create();
        Point currentShellSize = this.getShell().getSize();
        Point currentContentsSize = this.getContents().getSize();
        int currentWidth = currentContentsSize.x;
        if (this.getMessage() != null) {
            this._label.setText(this.getMessage());
        }
        this._label.pack();
        Point labelSize = this._label.computeSize(currentWidth, -1, true);
        Point newContentsSize = new Point(currentWidth, currentContentsSize.y + labelSize.y);
        this.getContents().setSize(newContentsSize);
        Point newShellSize = this.getShell().computeSize(currentWidth, currentShellSize.y + labelSize.y, true);
        this.getShell().setSize(newShellSize);
    }

    protected void computeResult() {
        CheckboxTreeViewer viewer = this.getTreeViewer();
        Object[] checked = viewer.getCheckedElements();
        ArrayList<Object> checkedNotGray = new ArrayList<Object>(checked.length);
        int i = 0;
        while (i < checked.length) {
            Object check = checked[i];
            if (!viewer.getGrayed(check)) {
                checkedNotGray.add(check);
            }
            ++i;
        }
        this.setResult(checkedNotGray);
    }

    public Button getButton(int buttonId) {
        return super.getButton(buttonId);
    }
}

