/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.probekit.editor.internal.ui.instrument;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.hyades.probekit.editor.internal.core.instrument.InstrumentOperation;
import org.eclipse.hyades.probekit.editor.internal.core.util.JavaUtil;
import org.eclipse.hyades.probekit.editor.internal.core.util.ProbekitMessages;
import org.eclipse.hyades.probekit.editor.internal.core.util.ProbekitUtil;
import org.eclipse.hyades.probekit.editor.internal.ui.DialogUtil;
import org.eclipse.hyades.probekit.editor.internal.ui.SelectOneIncludedValidator;
import org.eclipse.hyades.probekit.editor.internal.ui.instrument.InstrumentRunnableWithProgress;
import org.eclipse.hyades.probekit.ui.internal.ContextIds;
import org.eclipse.hyades.probekit.ui.internal.ProbekitUIPlugin;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionDelegate;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.CheckedTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;

public class InstrumentClassesAction
implements IActionDelegate {
    private ISelection _selection;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public void run(IAction action) {
        Display display = PlatformUI.getWorkbench().getDisplay();
        Shell shell = display.getActiveShell();
        IFile probeFile = this.getProbeFile(shell);
        if (probeFile == null) {
            return;
        }
        List resourcesToInstrument = this.getResourcesToInstrument();
        InstrumentRunnableWithProgress runInstrument = new InstrumentRunnableWithProgress(shell, display, probeFile, resourcesToInstrument);
        runInstrument.open();
    }

    private IFile getProbeFile(Shell shell) {
        IFile probeFile;
        block9: {
            probeFile = null;
            try {
                List allProbeFiles = ProbekitUtil.getProbeFiles();
                CheckedTreeSelectionDialog dialog = DialogUtil.createResourceDialog(shell, (IResource[])JavaUtil.getProjects(allProbeFiles), allProbeFiles);
                dialog.setValidator((ISelectionStatusValidator)new SelectOneIncludedValidator(allProbeFiles, ProbekitMessages._92, ProbekitMessages._93));
                dialog.setInitialSelections(new Object[0]);
                dialog.setTitle(ProbekitMessages._96);
                dialog.setMessage(ProbekitMessages._97);
                dialog.create();
                dialog.getOkButton().setText(ProbekitMessages._146);
                Shell dialogShell = dialog.getShell();
                PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)dialogShell, ContextIds.PROBEKIT_INSTRUMENT);
                dialog.open();
                Object[] result = dialog.getResult();
                if (result == null) break block9;
                int i = 0;
                while (i < result.length) {
                    if (result[i] instanceof IFile) {
                        probeFile = (IFile)result[i];
                        break;
                    }
                    if (result[i] instanceof IAdaptable) {
                        IResource res;
                        IAdaptable a = (IAdaptable)result[i];
                        Class<?> clazz = class$0;
                        if (clazz == null) {
                            try {
                                clazz = Class.forName("org.eclipse.core.resources.IResource");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        if ((res = (IResource)a.getAdapter((Class)clazz)) instanceof IFile) {
                            probeFile = (IFile)res;
                            break;
                        }
                    }
                    ++i;
                }
            }
            catch (CoreException exc) {
                ProbekitUIPlugin.getPlugin().log((Object)exc);
                MessageDialog.openError((Shell)shell, (String)NLS.bind((String)ProbekitMessages._90, (Object[])new Object[]{probeFile.getName()}), (String)ProbekitMessages._91);
            }
        }
        return probeFile;
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this._selection = selection;
        boolean enabled = true;
        if (!ProbekitUtil.isSupportedPlatform()) {
            enabled = false;
        } else if (selection instanceof IStructuredSelection) {
            IStructuredSelection strSel = (IStructuredSelection)selection;
            Object[] selected = strSel.toArray();
            int i = 0;
            while (i < selected.length) {
                IClassFile cFile;
                Object theselected = selected[i];
                if (theselected instanceof IClassFile && this.isInArchive(cFile = (IClassFile)theselected)) {
                    enabled = false;
                    break;
                }
                ++i;
            }
        }
        action.setEnabled(enabled);
    }

    private boolean isInArchive(IClassFile cFile) {
        IPackageFragmentRoot container = (IPackageFragmentRoot)cFile.getAncestor(3);
        if (container == null) {
            return true;
        }
        return container.isArchive();
    }

    private List getClasses() {
        if (this._selection == null || this._selection.isEmpty() || !(this._selection instanceof IStructuredSelection)) {
            return null;
        }
        IStructuredSelection strSel = (IStructuredSelection)this._selection;
        ArrayList list = new ArrayList(strSel.toList());
        return list;
    }

    private List getResourcesToInstrument() {
        List selected = this.getClasses();
        Iterator iterator = selected.iterator();
        HashSet<IJavaElement> soFar = new HashSet<IJavaElement>(selected.size());
        while (iterator.hasNext()) {
            IJavaElement res;
            IAdaptable adaptable = (IAdaptable)iterator.next();
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = Class.forName("org.eclipse.jdt.core.IJavaElement");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((res = (IJavaElement)adaptable.getAdapter((Class)clazz)) == null || !InstrumentOperation.InstrumentOperationUtil.canFileBeProbed(res)) continue;
            soFar.add(res);
        }
        return selected;
    }
}

