/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.probekit.editor.internal.ui.instrument;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.hyades.probekit.editor.internal.core.util.ConversionUtil;
import org.eclipse.hyades.probekit.editor.internal.core.util.JavaUtil;
import org.eclipse.hyades.probekit.editor.internal.core.util.ProbekitMessages;
import org.eclipse.hyades.probekit.editor.internal.core.util.ProbekitUtil;
import org.eclipse.hyades.probekit.editor.internal.core.util.ResourceUtil;
import org.eclipse.hyades.probekit.editor.internal.ui.CompoundLabelProvider;
import org.eclipse.hyades.probekit.editor.internal.ui.CompoundTreeContentProvider;
import org.eclipse.hyades.probekit.editor.internal.ui.DialogUtil;
import org.eclipse.hyades.probekit.editor.internal.ui.JavaElementContentProvider;
import org.eclipse.hyades.probekit.editor.internal.ui.JavaElementLabelProvider;
import org.eclipse.hyades.probekit.editor.internal.ui.ResourceContentProvider;
import org.eclipse.hyades.probekit.editor.internal.ui.ResourceLabelProvider;
import org.eclipse.hyades.probekit.editor.internal.ui.SelectAnythingValidator;
import org.eclipse.hyades.probekit.editor.internal.ui.instrument.InstrumentRunnableWithProgress;
import org.eclipse.hyades.probekit.ui.internal.ContextIds;
import org.eclipse.hyades.probekit.ui.internal.ProbekitUIPlugin;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IParent;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionDelegate;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.CheckedTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;

public class ProbeInstrumenterAction
implements IActionDelegate {
    private ISelection _selection;

    public void run(IAction action) {
        IFile probeFile = this.getProbeFile();
        Display display = PlatformUI.getWorkbench().getDisplay();
        Shell shell = display.getActiveShell();
        List elementsToInstrument = this.getChosenResources(shell, probeFile);
        if (elementsToInstrument.size() == 0) {
            return;
        }
        InstrumentRunnableWithProgress runInstrument = new InstrumentRunnableWithProgress(shell, display, probeFile, elementsToInstrument);
        runInstrument.open();
    }

    private List getChosenResources(Shell shell, IFile probeFile) {
        try {
            IJavaProject jp;
            IContainer outputContainer = JavaUtil.getOutputContainer(probeFile);
            if (outputContainer == null) {
                MessageDialog.openError((Shell)shell, (String)NLS.bind((String)ProbekitMessages._90, (Object[])new Object[]{this.getProbeFile().getName()}), (String)ProbekitMessages._89);
                return Collections.EMPTY_LIST;
            }
            IClassFile[] generatedClassFiles = JavaUtil.getClassFiles(probeFile);
            IPackageFragmentRoot[] allArchives = ProbeInstrumenterActionUtil.getAllArchivesAsArray();
            IPackageFragmentRoot[] archives = ProbeInstrumenterActionUtil.getExternalArchives(allArchives);
            IFile[] classesAndArchives = ProbeInstrumenterActionUtil.getBinaryFilesExcluding(allArchives, generatedClassFiles);
            ArrayList<Object> binary = new ArrayList<Object>(archives.length + classesAndArchives.length);
            HashSet<IJavaProject> temp = new HashSet<IJavaProject>(archives.length + classesAndArchives.length);
            int i = 0;
            while (i < archives.length) {
                IPackageFragmentRoot archive = archives[i];
                binary.add(archive);
                jp = archive.getJavaProject();
                if (jp != null && jp.exists()) {
                    temp.add(jp);
                }
                ++i;
            }
            i = 0;
            while (i < classesAndArchives.length) {
                IFile file = classesAndArchives[i];
                binary.add(file);
                jp = JavaCore.create((IProject)file.getProject());
                if (jp != null && jp.exists()) {
                    temp.add(jp);
                }
                ++i;
            }
            IJavaProject[] javaProjects = temp.toArray(new IJavaProject[0]);
            CompoundLabelProvider labelProvider = new CompoundLabelProvider(new ResourceLabelProvider(), new JavaElementLabelProvider());
            CompoundTreeContentProvider treeContentProvider = new CompoundTreeContentProvider(new ResourceContentProvider((IResource[])classesAndArchives), new JavaElementContentProvider((IJavaElement[])archives));
            CheckedTreeSelectionDialog dialog = DialogUtil.createCompoundDialog(shell, javaProjects, treeContentProvider, labelProvider);
            dialog.setValidator((ISelectionStatusValidator)new SelectAnythingValidator(binary));
            dialog.setTitle(NLS.bind((String)ProbekitMessages._94, (Object[])new Object[]{this.getProbeFile().getName()}));
            dialog.setMessage(ProbekitMessages._95);
            dialog.create();
            Shell dialogShell = dialog.getShell();
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)dialogShell, ContextIds.PROBEKIT_INSTRUMENT);
            dialog.open();
            Object[] selected = dialog.getResult();
            if (selected != null) {
                List chosen = treeContentProvider.getClassAndJarElements(selected);
                return chosen;
            }
        }
        catch (CoreException exc) {
            ProbekitUIPlugin.getPlugin().log((Object)exc);
            MessageDialog.openError((Shell)shell, (String)NLS.bind((String)ProbekitMessages._90, (Object[])new Object[]{this.getProbeFile().getName()}), (String)ProbekitMessages._91);
        }
        return Collections.EMPTY_LIST;
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this._selection = selection;
        boolean enabled = true;
        IFile probeFile = this.getProbeFile();
        if (probeFile == null || !probeFile.isAccessible() || !ProbekitUtil.isSupportedPlatform()) {
            enabled = false;
        } else {
            IProject project = probeFile.getProject();
            IJavaProject jp = JavaCore.create((IProject)project);
            enabled = jp.isOnClasspath((IResource)probeFile);
        }
        action.setEnabled(enabled);
    }

    IFile getProbeFile() {
        if (this._selection == null || this._selection.isEmpty() || !(this._selection instanceof IStructuredSelection)) {
            return null;
        }
        IStructuredSelection strSel = (IStructuredSelection)this._selection;
        Object element = strSel.getFirstElement();
        if (!(element instanceof IFile)) {
            return null;
        }
        return (IFile)element;
    }

    private static class ProbeInstrumenterActionUtil {
        ProbeInstrumenterActionUtil() {
        }

        public static IPackageFragmentRoot[] getAllArchivesAsArray() throws JavaModelException, CoreException {
            IPackageFragmentRoot[] allArchives = ProbeInstrumenterActionUtil.getAllArchives().toArray(new IPackageFragmentRoot[0]);
            return allArchives;
        }

        public static IPackageFragmentRoot[] getExternalArchives(IPackageFragmentRoot[] allArchives) {
            ArrayList<IPackageFragmentRoot> result = new ArrayList<IPackageFragmentRoot>(allArchives.length);
            int i = 0;
            while (i < allArchives.length) {
                IPackageFragmentRoot archive = allArchives[i];
                if (archive.isExternal()) {
                    result.add(archive);
                }
                ++i;
            }
            return result.toArray(new IPackageFragmentRoot[0]);
        }

        private static List getAllArchives() throws JavaModelException, CoreException {
            IJavaProject[] javaProjects = JavaUtil.getAllJavaProjects();
            ArrayList list = new ArrayList(100);
            int i = 0;
            while (i < javaProjects.length) {
                IJavaProject jp = javaProjects[i];
                list.addAll(ProbeInstrumenterActionUtil.getArchives((IJavaElement)jp));
                ++i;
            }
            return list;
        }

        private static List getArchives(IJavaElement element) throws JavaModelException, CoreException {
            ArrayList<IJavaElement> allchildren = new ArrayList<IJavaElement>();
            if (JavaUtil.isArchive(element)) {
                allchildren.add(element);
                return allchildren;
            }
            if (element instanceof IParent) {
                IParent parent = (IParent)element;
                IJavaElement[] children = parent.getChildren();
                int i = 0;
                while (i < children.length) {
                    IJavaElement je = children[i];
                    allchildren.addAll(ProbeInstrumenterActionUtil.getArchives(je));
                    ++i;
                }
            }
            return allchildren;
        }

        public static IFile[] getBinaryFilesExcluding(IPackageFragmentRoot[] allArchives, IClassFile[] excludedFiles) throws JavaModelException, CoreException {
            IFile[] classFiles = ProbeInstrumenterActionUtil.getAllClassFilesExcluding(excludedFiles);
            IFile[] archives = ProbeInstrumenterActionUtil.getWorkspaceArchives(allArchives);
            IFile[] result = new IFile[classFiles.length + archives.length];
            System.arraycopy(classFiles, 0, result, 0, classFiles.length);
            System.arraycopy(archives, 0, result, classFiles.length, archives.length);
            return result;
        }

        private static IFile[] getAllClassFilesExcluding(IClassFile[] excludedFiles) throws JavaModelException, CoreException {
            List allClassFiles = ProbeInstrumenterActionUtil.getAllClassFiles();
            int i = 0;
            while (i < excludedFiles.length) {
                allClassFiles.remove(excludedFiles[i]);
                ++i;
            }
            IFile[] files = ConversionUtil.toFileArrayFromIClassFiles(allClassFiles);
            return files;
        }

        private static List getAllClassFiles() throws JavaModelException, CoreException {
            IJavaProject[] javaProjects = JavaUtil.getAllJavaProjects();
            ArrayList<IClassFile> classFiles = new ArrayList<IClassFile>();
            int i = 0;
            while (i < javaProjects.length) {
                IJavaProject jp = javaProjects[i];
                IContainer[] outputContainers = ProbeInstrumenterActionUtil.getOutputContainers(jp);
                int j = 0;
                while (j < outputContainers.length) {
                    IContainer container = outputContainers[j];
                    IClassFile[] cFiles = ProbeInstrumenterActionUtil.getClassFiles(container);
                    int k = 0;
                    while (k < cFiles.length) {
                        classFiles.add(cFiles[k]);
                        ++k;
                    }
                    ++j;
                }
                IContainer[] classContainers = JavaUtil.getClassContainers(jp);
                int j2 = 0;
                while (j2 < classContainers.length) {
                    IContainer container = classContainers[j2];
                    IClassFile[] cFiles = ProbeInstrumenterActionUtil.getClassFiles(container);
                    int k = 0;
                    while (k < cFiles.length) {
                        classFiles.add(cFiles[k]);
                        ++k;
                    }
                    ++j2;
                }
                ++i;
            }
            return classFiles;
        }

        private static IFile[] getWorkspaceArchives(IPackageFragmentRoot[] archives) {
            ArrayList<IResource> result = new ArrayList<IResource>(archives.length);
            int i = 0;
            while (i < archives.length) {
                IResource res;
                IPackageFragmentRoot archive = archives[i];
                if (!archive.isExternal() && (res = archive.getResource()) != null && res.isAccessible()) {
                    result.add(res);
                }
                ++i;
            }
            return result.toArray(new IFile[0]);
        }

        private static IContainer[] getOutputContainers(IJavaProject jp) throws JavaModelException {
            List entries = JavaUtil.getSourceContainerEntries(jp);
            HashSet<IContainer> containers = new HashSet<IContainer>(entries.size());
            Iterator iterator = entries.iterator();
            while (iterator.hasNext()) {
                IContainer container;
                IClasspathEntry entry = (IClasspathEntry)iterator.next();
                IPath outputLocation = entry.getOutputLocation();
                if (outputLocation == null || (container = (IContainer)ResourceUtil.ROOT.findMember(outputLocation)) == null || !container.isAccessible()) continue;
                containers.add(container);
            }
            IPath outputLocation = jp.getOutputLocation();
            IContainer container = (IContainer)ResourceUtil.ROOT.findMember(outputLocation);
            if (container != null && container.isAccessible()) {
                containers.add(container);
            }
            return containers.toArray(new IContainer[0]);
        }

        private static IClassFile[] getClassFiles(IContainer container) throws CoreException {
            List files = ProbeInstrumenterActionUtil.getFiles(container);
            HashSet<IClassFile> classFiles = new HashSet<IClassFile>(files.size());
            Iterator iterator = files.iterator();
            while (iterator.hasNext()) {
                IFile file = (IFile)iterator.next();
                IClassFile cfile = JavaUtil.getClassFile(file);
                if (cfile == null) continue;
                classFiles.add(cfile);
            }
            return classFiles.toArray(new IClassFile[0]);
        }

        private static List getFiles(IContainer container) throws CoreException {
            IResource[] children = container.members();
            ArrayList<IResource> result = new ArrayList<IResource>(children.length);
            int i = 0;
            while (i < children.length) {
                IResource res = children[i];
                if (res.getType() == 1) {
                    result.add(res);
                } else {
                    result.addAll(ProbeInstrumenterActionUtil.getFiles((IContainer)res));
                }
                ++i;
            }
            return result;
        }
    }
}

