/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.probekit.editor.internal.ui.newFile;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.hyades.probekit.editor.internal.core.newFile.CreateInitialModelOperation;
import org.eclipse.hyades.probekit.editor.internal.core.newFile.MethodProbeMetaData;
import org.eclipse.hyades.probekit.editor.internal.core.newFile.ProbeFileModel;
import org.eclipse.hyades.probekit.editor.internal.core.util.JavaUtil;
import org.eclipse.hyades.probekit.editor.internal.core.util.ProbekitMessages;
import org.eclipse.hyades.probekit.editor.internal.ui.newFile.NewProbekitDataPage;
import org.eclipse.hyades.probekit.editor.internal.ui.newFile.NewProbekitProbePage;
import org.eclipse.hyades.probekit.ui.internal.AddProbeNatureOperation;
import org.eclipse.hyades.probekit.ui.internal.ProbekitUIPlugin;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.part.ISetSelectionTarget;

public class ProbeSourceFileWizard
extends Wizard
implements INewWizard {
    private IStructuredSelection _selection;
    private IWorkbench _workbench;
    ProbeFileModel _model = null;

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this._workbench = workbench;
        this._selection = selection;
        this._model = new ProbeFileModel(new MethodProbeMetaData());
        this._model.setSourceContainer(this.getSelection());
        this.setWindowTitle(ProbekitMessages._37);
        this.setDefaultPageImageDescriptor(ExtendedImageRegistry.INSTANCE.getImageDescriptor(ProbekitUIPlugin.INSTANCE.getImage("full/wizban/NewProbekit")));
    }

    public boolean performFinish() {
        return this.createProbeFile();
    }

    private boolean createProbeFile() {
        try {
            this._model.forceValid();
            IFile modelFile = this._model.getModelFile();
            final ArrayList<IProject> list = new ArrayList<IProject>(1);
            list.add(modelFile.getProject());
            WorkspaceModifyOperation operation = new WorkspaceModifyOperation(){

                /*
                 * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                public void execute(IProgressMonitor monitor) {
                    try {
                        try {
                            AddProbeNatureOperation addProbeNature = new AddProbeNatureOperation(list);
                            addProbeNature.run(monitor);
                        }
                        catch (CoreException ex) {
                            ex.printStackTrace();
                        }
                    }
                    catch (Throwable throwable) {
                        Object var3_5 = null;
                        monitor.done();
                        throw throwable;
                    }
                    {
                        Object var3_6 = null;
                    }
                    monitor.done();
                }
            };
            try {
                this.getContainer().run(true, true, (IRunnableWithProgress)operation);
            }
            catch (InvocationTargetException exec) {
                exec.printStackTrace();
            }
            catch (InterruptedException exec) {
                exec.printStackTrace();
            }
            IRunnableWithProgress wrapper = new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException {
                    try {
                        CreateInitialModelOperation operation = new CreateInitialModelOperation(ProbeSourceFileWizard.this._model);
                        ResourcesPlugin.getWorkspace().run((IWorkspaceRunnable)operation, (ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot(), 0, monitor);
                    }
                    catch (CoreException exc) {
                        throw new InvocationTargetException(exc);
                    }
                }
            };
            this.getContainer().run(false, false, wrapper);
            IWorkbenchPage page = this.selectResource(modelFile);
            return this.openEditor(page, modelFile);
        }
        catch (JavaModelException exception) {
            ProbekitUIPlugin.INSTANCE.log((Object)exception);
            return false;
        }
        catch (InterruptedException exception) {
            ProbekitUIPlugin.INSTANCE.log(exception);
            return false;
        }
        catch (InvocationTargetException exception) {
            ProbekitUIPlugin.INSTANCE.log(exception);
            return false;
        }
    }

    private IWorkbenchPage selectResource(IFile modelFile) {
        IWorkbenchWindow workbenchWindow = this._workbench.getActiveWorkbenchWindow();
        IWorkbenchPage page = workbenchWindow.getActivePage();
        final IWorkbenchPart activePart = page.getActivePart();
        if (activePart instanceof ISetSelectionTarget) {
            StructuredSelection targetSelection = new StructuredSelection((Object)modelFile);
            this.getShell().getDisplay().asyncExec(new Runnable((ISelection)targetSelection){
                private final /* synthetic */ ISelection val$targetSelection;
                {
                    this.val$targetSelection = iSelection;
                }

                public void run() {
                    ((ISetSelectionTarget)activePart).selectReveal(this.val$targetSelection);
                }
            });
        }
        return page;
    }

    private boolean openEditor(IWorkbenchPage page, IFile modelFile) {
        try {
            page.openEditor((IEditorInput)new FileEditorInput(modelFile), this._workbench.getEditorRegistry().getDefaultEditor(modelFile.getFullPath().toString()).getId());
        }
        catch (PartInitException exception) {
            MessageDialog.openError((Shell)this.getContainer().getShell(), (String)ProbekitMessages._1, (String)exception.getMessage());
            return false;
        }
        return true;
    }

    public void addPages() {
        this.addPage((IWizardPage)new NewProbekitProbePage(this._model));
        this.addPage((IWizardPage)new NewProbekitDataPage(this._model));
    }

    public IContainer getSelection() {
        if (this._selection == null || this._selection.isEmpty()) {
            return null;
        }
        Object element = this._selection.getFirstElement();
        if (element instanceof IResource) {
            IResource res = (IResource)element;
            try {
                IContainer container = null;
                container = res.getType() == 1 ? res.getParent() : (IContainer)res;
                if (JavaUtil.isSourceContainer(container)) {
                    return container;
                }
            }
            catch (JavaModelException javaModelException) {
                return null;
            }
        }
        return null;
    }

    public boolean performCancel() {
        this._model.release();
        return super.performCancel();
    }
}

