/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.execution.recorder.http.local;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.hyades.execution.recorder.IRecorderDataProcessor;
import org.eclipse.hyades.internal.execution.recorder.utilities.RecorderFileUtil;
import org.eclipse.hyades.test.core.TestCorePlugin;
import org.eclipse.hyades.test.tools.ui.ToolsUiPlugin;
import org.eclipse.hyades.test.ui.UiPlugin;
import org.eclipse.tptp.test.provisional.recorder.framework.IRecorderMessageProvider;
import org.eclipse.tptp.test.provisional.recorder.messages.AbstractRecorderMessageProvider;

public class HttpRecorderDataProcessor
extends AbstractRecorderMessageProvider
implements IRecorderDataProcessor,
IRecorderMessageProvider {
    private IFile traceFile = null;
    private File javaTraceFile = null;
    private boolean sslWarningShown = false;

    public void initialize() throws IOException {
        String fileName = ToolsUiPlugin.getPreference("recording_path");
        if (this.getRecorder() != null) {
            fileName = this.getRecorder().getRecordingPath();
        }
        try {
            this.traceFile = RecorderFileUtil.createTraceFile((String)fileName);
            this.javaTraceFile = this.traceFile.getRawLocation().toFile();
            if (!this.javaTraceFile.exists()) {
                throw new IOException(TestCorePlugin.getDefault().getString("RecorderDataProcessor.UNABLE_TO_CREATE_TRACE_FILE_ERROR"));
            }
        }
        catch (CoreException e) {
            throw new IOException(String.valueOf(TestCorePlugin.getDefault().getString("RecorderDataProcessor.UNABLE_TO_CREATE_TRACE_FILE_ERROR")) + e.getMessage());
        }
        RecorderFileUtil.createTraceModel((String)fileName, (String)this.traceFile.getFullPath().toString());
    }

    public void complete() {
        try {
            if (this.traceFile != null) {
                this.traceFile.refreshLocal(0, (IProgressMonitor)new NullProgressMonitor());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void processData(byte[] data) {
        this.processDataFromDataProcessor(data);
    }

    public synchronized boolean processDataFromDataProcessor(byte[] data) {
        try {
            FileOutputStream outStream = new FileOutputStream(this.javaTraceFile, true);
            outStream.write(data);
            outStream.flush();
            outStream.close();
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public void processControlString(String controlString) {
        if (controlString.startsWith("-1") && !this.sslWarningShown) {
            new StringTokenizer(controlString, ",");
            UiPlugin.reportExceptionToUser((Exception)new Exception(ToolsUiPlugin.getString("HttpRecorderDataProcessor.SSL_RECORDER_ATTEMPTED_ERR_MESSAGE")), (String)ToolsUiPlugin.getString("HttpRecorderDataProcessor.PLAYBACK_MAY_BE_AFFECTED_WARNING"), (String)ToolsUiPlugin.getString("HttpRecorderDataProcessor.SSL_PACKET_IN_RECORDING_AND_NOT_SUPPORTED_WARNING"), (String)ToolsUiPlugin.getString("HttpRecorderDataProcessor.WARNING"));
            this.sslWarningShown = true;
        } else if (controlString.startsWith("-2") && !this.sslWarningShown) {
            UiPlugin.reportExceptionToUser((Exception)new Exception(ToolsUiPlugin.getString("HttpRecorderDataProcessor.SSL_RECORDER_ATTEMPTED_ERR_MESSAGE")), (String)ToolsUiPlugin.getString("HttpRecorderDataProcessor.PLAYBACK_MAY_BE_AFFECTED_WARNING"), (String)ToolsUiPlugin.getString("HttpRecorderDataProcessor.TESTKEYS_NOT_FOUND"), (String)ToolsUiPlugin.getString("HttpRecorderDataProcessor.WARNING"));
            this.sslWarningShown = true;
        } else if (controlString.startsWith("-3") && !this.sslWarningShown) {
            UiPlugin.reportExceptionToUser((Exception)new Exception(ToolsUiPlugin.getString("HttpRecorderDataProcessor.PROBLEM_CREATING_CLIENTSIDEREADER")), (String)ToolsUiPlugin.getString("HttpRecorderLaunchWizard.UNABLE_TO_START_RECORDER_MESSAGE"), (String)ToolsUiPlugin.getString("HttpRecorderDataProcessor.PROBLEM_CREATING_CLIENTSIDEREADER"), (String)ToolsUiPlugin.getString("HttpRecorderDataProcessor.SOCKET_BIND_ERROR"));
            this.sslWarningShown = true;
        }
    }

    public void processDebugString(String debugString) {
        System.out.println(debugString);
    }

    protected String translateString(String str) {
        return str;
    }
}

