/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.execution.recorder.http.ui.preferences;

import java.io.File;
import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Path;
import org.eclipse.hyades.execution.recorder.local.appadapters.IRecorderApplicationAdapter;
import org.eclipse.hyades.execution.recorder.local.appadapters.RecorderAppAdapterFactory;
import org.eclipse.hyades.internal.execution.recorder.ui.RecorderUIUtility;
import org.eclipse.hyades.test.core.testgen.TestGeneratorFactory;
import org.eclipse.hyades.test.tools.ui.ToolsUiPlugin;
import org.eclipse.hyades.test.ui.UiPlugin;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.help.WorkbenchHelp;

public class HttpRecorderPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private Button autoStartAppBtn;
    private Combo recordedAppAdapterCombo;
    private Combo testGeneratorsCombo;
    private Text proxyPort;
    private Button autoStartTestGenBtn;
    private Text txtAppPath;
    private Label lblAppPath;
    private ArrayList appIDsByIndex;

    public HttpRecorderPreferencePage() {
        this.setPreferenceStore(ToolsUiPlugin.getDefault().getPreferenceStore());
    }

    public void init(IWorkbench workbench) {
    }

    protected Control createContents(Composite grandParent) {
        Composite parent = null;
        try {
            this.setTitle(ToolsUiPlugin.getString("HttpRecorderPreferencePage.HTTP_PROXY_RECORD_OPTIONS_TITLE"));
            parent = new Composite(grandParent, 0);
            WorkbenchHelp.setHelp((Control)parent, (String)"org.eclipse.hyades.execution.recorder.http.HttpRecorderPreferencePage");
            parent.setLayoutData((Object)new GridData(768));
            RecorderUIUtility.assignGridLayout((Composite)parent, (int)3, (boolean)false);
            this.createApplicationOptionsGroup(parent);
            this.createTestGenOptionsGroup(parent);
            this.createRecorderProxyGroup(parent);
        }
        catch (RecorderUIUtility.RecorderHarnessUIException e) {
            e.printStackTrace();
        }
        this.setControl((Control)grandParent);
        return grandParent;
    }

    private void createRecorderProxyGroup(Composite parent) throws RecorderUIUtility.RecorderHarnessUIException {
        Label proxyPortLabel = RecorderUIUtility.createLabel((Composite)parent, (String)ToolsUiPlugin.getString("HttpRecorderPreferencePage.PROXY_RECORDER_LOCAL_PORT_LABEL"), null);
        RecorderUIUtility.layoutControlInGrid((Control)proxyPortLabel, (int)1, (int)128);
        this.proxyPort = RecorderUIUtility.createEditControl((Composite)parent, (String)ToolsUiPlugin.getPreference("default_proxy_port"), null);
        RecorderUIUtility.layoutControlInGrid((Control)this.proxyPort, (int)2, (int)768);
        this.proxyPort.addListener(24, new Listener(){

            public void handleEvent(Event e) {
                if (e.widget == HttpRecorderPreferencePage.this.proxyPort) {
                    int port;
                    try {
                        port = Integer.parseInt(HttpRecorderPreferencePage.this.proxyPort.getText());
                    }
                    catch (NumberFormatException numberFormatException) {
                        HttpRecorderPreferencePage.this.setErrorMessage(ToolsUiPlugin.getString("HttpRecorderPreferencePage.PORT_NOT_A_NUMBER"));
                        HttpRecorderPreferencePage.this.setValid(false);
                        return;
                    }
                    if (port <= 0) {
                        HttpRecorderPreferencePage.this.setErrorMessage(ToolsUiPlugin.getString("HttpRecorderPreferencePage.PORT_TOO_SMALL"));
                        HttpRecorderPreferencePage.this.setValid(false);
                        return;
                    }
                    if (port > 64000) {
                        HttpRecorderPreferencePage.this.setErrorMessage(ToolsUiPlugin.getString("HttpRecorderPreferencePage.PORT_TOO_BIG"));
                        HttpRecorderPreferencePage.this.setValid(false);
                        return;
                    }
                    HttpRecorderPreferencePage.this.setErrorMessage(null);
                    HttpRecorderPreferencePage.this.setValid(true);
                }
            }
        });
    }

    private void createApplicationOptionsGroup(final Composite parent) throws RecorderUIUtility.RecorderHarnessUIException {
        this.appIDsByIndex = new ArrayList(2);
        Label recorderAppLabel = RecorderUIUtility.createLabel((Composite)parent, (String)ToolsUiPlugin.getString("HttpRecorderPreferencePage.APPLICATION_ADAPTER_SELECTOR_LABEL"), null);
        RecorderUIUtility.layoutControlInGrid((Control)recorderAppLabel, (int)1, (int)128);
        this.recordedAppAdapterCombo = new Combo(parent, 12);
        RecorderAppAdapterFactory adapterFactory = RecorderAppAdapterFactory.getInstance();
        String[] adapters = adapterFactory.getValidAdapterIDs();
        int i = 0;
        while (i < adapters.length) {
            String cfr_ignored_0 = adapters[i];
            this.recordedAppAdapterCombo.add(adapterFactory.getAdapterName(adapters[i]));
            this.appIDsByIndex.add(adapters[i]);
            ++i;
        }
        this.recordedAppAdapterCombo.add(ToolsUiPlugin.getString("HttpRecorderPreferencePage.NONE_SELECTED_TEXT"));
        this.appIDsByIndex.add("-1");
        RecorderUIUtility.layoutControlInGrid((Control)this.recordedAppAdapterCombo, (int)2, (int)768);
        this.lblAppPath = RecorderUIUtility.createLabel((Composite)parent, (String)ToolsUiPlugin.getString("HttpRecorderPreferencePage.APPLICATION_PATH_LABEL"), null);
        RecorderUIUtility.layoutControlInGrid((Control)this.lblAppPath, (int)1, (int)128);
        this.txtAppPath = RecorderUIUtility.createEditControl((Composite)parent, (String)"", null);
        RecorderUIUtility.layoutControlInGrid((Control)this.txtAppPath, (int)1, (int)768);
        final Button btnBrowse = RecorderUIUtility.createButton((Composite)parent, (String)ToolsUiPlugin.getString("STR_WB_BROWSE_BTN"), (int)0);
        btnBrowse.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog dlg = new FileDialog(parent.getShell(), 4096);
                File file = new Path(HttpRecorderPreferencePage.this.txtAppPath.getText()).toFile();
                dlg.setFileName(file.getName());
                dlg.setFilterPath(file.getParent());
                String newFile = dlg.open();
                if (newFile != null) {
                    HttpRecorderPreferencePage.this.txtAppPath.setText(newFile);
                    HttpRecorderPreferencePage.this.txtAppPath.setSelection(HttpRecorderPreferencePage.this.txtAppPath.getText().length());
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        RecorderUIUtility.layoutControlInGrid((Control)btnBrowse, (int)1, (int)128);
        this.recordedAppAdapterCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (HttpRecorderPreferencePage.this.recordedAppAdapterCombo.getSelectionIndex() > -1) {
                    String id = (String)HttpRecorderPreferencePage.this.appIDsByIndex.get(HttpRecorderPreferencePage.this.recordedAppAdapterCombo.getSelectionIndex());
                    IConfigurationElement element = RecorderAppAdapterFactory.getInstance().getAdapterConfigElement(id);
                    if (!(element == null || element.getAttribute("isPathEditable") != null && element.getAttribute("isPathEditable").equalsIgnoreCase("false"))) {
                        try {
                            IRecorderApplicationAdapter appAdapter = (IRecorderApplicationAdapter)element.createExecutableExtension("class");
                            HttpRecorderPreferencePage.this.txtAppPath.setText(appAdapter.getApplicationPath());
                            HttpRecorderPreferencePage.this.txtAppPath.setSelection(HttpRecorderPreferencePage.this.txtAppPath.getText().length());
                            HttpRecorderPreferencePage.this.lblAppPath.setEnabled(true);
                            HttpRecorderPreferencePage.this.txtAppPath.setEnabled(true);
                            btnBrowse.setEnabled(true);
                        }
                        catch (CoreException coreException) {
                            HttpRecorderPreferencePage.this.lblAppPath.setEnabled(false);
                            HttpRecorderPreferencePage.this.txtAppPath.setText("");
                            HttpRecorderPreferencePage.this.txtAppPath.setEnabled(false);
                            btnBrowse.setEnabled(false);
                        }
                    } else {
                        HttpRecorderPreferencePage.this.lblAppPath.setEnabled(false);
                        HttpRecorderPreferencePage.this.txtAppPath.setText("");
                        HttpRecorderPreferencePage.this.txtAppPath.setEnabled(false);
                        btnBrowse.setEnabled(false);
                    }
                }
            }
        });
        this.selectApplication(ToolsUiPlugin.getPreference("application_under_test"));
    }

    private void createTestGenOptionsGroup(Composite parent) throws RecorderUIUtility.RecorderHarnessUIException {
        Label testGeneratorLabel = RecorderUIUtility.createLabel((Composite)parent, (String)ToolsUiPlugin.getString("HttpRecorderPreferencePage.TEST_GENERATOR_LABEL"), null);
        RecorderUIUtility.layoutControlInGrid((Control)testGeneratorLabel, (int)1, (int)128);
        this.testGeneratorsCombo = new Combo(parent, 12);
        TestGeneratorFactory factory = TestGeneratorFactory.getInstance();
        int i = 0;
        while (i < factory.getGeneratorIDs().length) {
            String generatorName = factory.getGeneratorName(factory.getGeneratorIDs()[i]);
            this.testGeneratorsCombo.add(generatorName);
            ++i;
        }
        this.testGeneratorsCombo.add(ToolsUiPlugin.getString("HttpRecorderPreferencePage.NONE_SELECTED_TEXT"));
        this.selectGenerator(UiPlugin.getPreference((String)"default_test_generator"));
        RecorderUIUtility.layoutControlInGrid((Control)this.testGeneratorsCombo, (int)2, (int)768);
    }

    public void updateControls() {
    }

    protected void performDefaults() {
        IPreferenceStore store = ToolsUiPlugin.getDefault().getPreferenceStore();
        this.selectApplication(store.getDefaultString("application_under_test"));
        this.selectGenerator(UiPlugin.getDefault().getPreferenceStore().getDefaultString("default_test_generator"));
        this.proxyPort.setText(store.getDefaultString("default_proxy_port"));
        super.performDefaults();
    }

    protected void performApply() {
        String generatorID;
        IPreferenceStore store = this.getPreferenceStore();
        IPreferenceStore testuiStore = UiPlugin.getDefault().getPreferenceStore();
        String adapterID = (String)this.appIDsByIndex.get(this.recordedAppAdapterCombo.getSelectionIndex());
        if (adapterID != null) {
            store.setValue("application_under_test", adapterID);
            IConfigurationElement element = RecorderAppAdapterFactory.getInstance().getAdapterConfigElement(adapterID);
            if (!(element == null || element.getAttribute("isPathEditable") != null && element.getAttribute("isPathEditable").equalsIgnoreCase("false"))) {
                try {
                    IRecorderApplicationAdapter appAdapter = (IRecorderApplicationAdapter)element.createExecutableExtension("class");
                    appAdapter.setApplicationPath(this.txtAppPath.getText());
                }
                catch (CoreException coreException) {}
                if (adapterID.equals("org.eclipse.hyades.test.core.RecorderApplication.Mozilla")) {
                    testuiStore.setValue("RECORDER_MOZILLA_PATH", this.txtAppPath.getText());
                }
                if (adapterID.equals("org.eclipse.hyades.test.core.RecorderApplication.Firefox")) {
                    testuiStore.setValue("RECORDER_FIREFOX_PATH", this.txtAppPath.getText());
                }
            }
        } else {
            store.setValue("application_under_test", "-1");
        }
        if ((generatorID = TestGeneratorFactory.getInstance().getGeneratorIDByIndex(this.testGeneratorsCombo.getSelectionIndex())) != null) {
            testuiStore.setValue("default_test_generator", generatorID);
        } else {
            testuiStore.setValue("default_test_generator", "-1");
        }
        store.setValue("default_proxy_port", this.proxyPort.getText());
    }

    public boolean performOk() {
        this.performApply();
        return true;
    }

    private void selectApplication(String appID) {
        RecorderAppAdapterFactory adapterFactory = RecorderAppAdapterFactory.getInstance();
        String[] adapters = adapterFactory.getValidAdapterIDs();
        int i = 0;
        while (i < adapters.length) {
            adapterFactory.getAdapterName(adapters[i]);
            if (adapters[i].compareToIgnoreCase(appID) == 0) {
                this.recordedAppAdapterCombo.select(i);
                return;
            }
            ++i;
        }
        this.recordedAppAdapterCombo.select(this.recordedAppAdapterCombo.indexOf(ToolsUiPlugin.getString("HttpRecorderPreferencePage.NONE_SELECTED_TEXT")));
    }

    private void selectGenerator(String genID) {
        TestGeneratorFactory factory = TestGeneratorFactory.getInstance();
        int i = 0;
        while (i < factory.getGeneratorIDs().length) {
            factory.getGeneratorName(factory.getGeneratorIDs()[i]);
            if (factory.getGeneratorIDs()[i].compareToIgnoreCase(genID) == 0) {
                this.testGeneratorsCombo.select(i);
                return;
            }
            ++i;
        }
        this.testGeneratorsCombo.select(this.testGeneratorsCombo.indexOf(ToolsUiPlugin.getString("HttpRecorderPreferencePage.NONE_SELECTED_TEXT")));
    }

    class SelectionChangeHandler
    implements SelectionListener {
        SelectionChangeHandler() {
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void widgetSelected(SelectionEvent e) {
            HttpRecorderPreferencePage.this.updateControls();
        }
    }
}

