/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.execution.recorder.http.ui.wizards;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.hyades.execution.recorder.Recorder;
import org.eclipse.hyades.execution.recorder.RecorderException;
import org.eclipse.hyades.execution.recorder.RecorderFactory;
import org.eclipse.hyades.execution.recorder.http.ui.wizards.HttpRecorderFileSelectPage;
import org.eclipse.hyades.execution.recorder.http.ui.wizards.HttpRecorderNoProjectsPage;
import org.eclipse.hyades.internal.execution.recorder.ui.RecorderClientUI;
import org.eclipse.hyades.internal.execution.recorder.ui.views.RecorderControlView;
import org.eclipse.hyades.internal.execution.recorder.ui.wizards.RecorderWizard;
import org.eclipse.hyades.internal.recorder.http.util.RecorderParamHelper;
import org.eclipse.hyades.test.tools.ui.ToolsUiPlugin;
import org.eclipse.hyades.test.ui.UiPlugin;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.tptp.test.internal.recorder.ui.wizards.IRecorderWizard;

public class HttpRecorderLaunchWizard
extends RecorderWizard {
    private HttpRecorderFileSelectPage fileSelectPage;
    private HttpRecorderNoProjectsPage newProjectPage;
    private boolean hasNoProjects = false;
    static /* synthetic */ Class class$0;

    protected boolean verifyRecorderData() {
        if (this.hasNoProjects) {
            return true;
        }
        String recName = this.fileSelectPage.getSelectedFilePath();
        int n = recName.lastIndexOf(".rec");
        if (n == -1) {
            n = recName.length();
        }
        String tsName = String.valueOf(recName.substring(0, recName.lastIndexOf(".rec"))) + ".testsuite";
        IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(recName));
        boolean bRec = file.exists();
        boolean bTS = false;
        if (!UiPlugin.getPreference((String)"default_test_generator").equals("-1")) {
            file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(tsName));
            bTS = file.exists();
        }
        if (bRec && bTS) {
            return MessageDialog.openConfirm((Shell)this.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)ToolsUiPlugin.getString("HttpRecorderLaunchWizard.FILES_EXIST_TITLE"), (String)ToolsUiPlugin.getString("HttpRecorderLaunchWizard.BOTH_EXIST"));
        }
        if (bRec) {
            return MessageDialog.openConfirm((Shell)this.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)ToolsUiPlugin.getString("HttpRecorderLaunchWizard.FILES_EXIST_TITLE"), (String)ToolsUiPlugin.getString("HttpRecorderLaunchWizard.REC_EXISTS"));
        }
        if (bTS) {
            return MessageDialog.openConfirm((Shell)this.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)ToolsUiPlugin.getString("HttpRecorderLaunchWizard.FILES_EXIST_TITLE"), (String)ToolsUiPlugin.getString("HttpRecorderLaunchWizard.TESTSUITE_EXISTS"));
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void run() {
        if (RecorderFactory.getInstance().getActiveRecorder() != null) {
            UiPlugin.reportExceptionToUser((Exception)new RecorderException(ToolsUiPlugin.getString("HttpRecorderLaunchWizard.ANOTHER_RECODER_ACTIVE_ERROR")), (String)ToolsUiPlugin.getString("HttpRecorderLaunchWizard.UNABLE_TO_START_RECORDER_MESSAGE"), (String)ToolsUiPlugin.getString("HttpRecorderLaunchWizard.ANOTHER_RECODER_ACTIVE_ERROR"), (String)ToolsUiPlugin.getString("HttpRecorderLaunchWizard.RECORDER_ERROR"));
            return;
        }
        Recorder recorder = null;
        try {
            String recordingFileName;
            recorder = ToolsUiPlugin.getDefault().getRecorder();
            recorder.setApplicationAdapterID(ToolsUiPlugin.getPreference("application_under_test"));
            String recorderParams = RecorderParamHelper.getRecorderParams(recorder.getApplicationAdapterID());
            if (this.hasNoProjects) {
                IProject project = this.newProjectPage.createJavaProject(this.monitor);
                if (project == null) throw new RecorderException(ToolsUiPlugin.getString("HttpRecorderLaunchWizard.JAVA_PROJECT_NOT_CREATED_ERROR"));
                recordingFileName = String.valueOf(project.getFullPath().toString()) + "/" + this.newProjectPage.getRecFile();
            } else {
                recordingFileName = this.fileSelectPage.getSelectedFilePath();
            }
            String generatorFileName = String.valueOf(recordingFileName.substring(0, recordingFileName.lastIndexOf(46))) + ".testsuite";
            ToolsUiPlugin.storePreference("recording_path", recordingFileName);
            recorder.setConfigParams(recorderParams);
            recorder.setRecordingPath(recordingFileName);
            recorder.setScriptgenID(UiPlugin.getPreference((String)"default_test_generator"));
            recorder.setTestPath(generatorFileName);
            RecorderClientUI.launchRecorder((Recorder)recorder, (IRecorderWizard)this);
            return;
        }
        catch (Exception e) {
            if (recorder != null) {
                recorder.setActive(false);
            }
            e.printStackTrace();
            RecorderControlView.getInstance().addMessage(String.valueOf(ToolsUiPlugin.getString("HttpRecorderLaunchWizard.RECORDING_ABORTED_DUE_TO_EXCEPTION_MESSAGE")) + e.getMessage());
        }
    }

    public void addPages() {
        this.setWindowTitle(ToolsUiPlugin.getString("NAME"));
        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        boolean openProjExists = false;
        int i = 0;
        while (!openProjExists && i < projects.length) {
            if (projects[i].isOpen()) {
                openProjExists = true;
            }
            ++i;
        }
        if (!openProjExists) {
            this.hasNoProjects = true;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.hyades.execution.recorder.http.ui.wizards.HttpRecorderNoProjectsPage");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.newProjectPage = new HttpRecorderNoProjectsPage(clazz.getName());
            this.addPage((IWizardPage)this.newProjectPage);
            this.newProjectPage.setInitialProjectName(ToolsUiPlugin.getString("HttpRecorderLaunchWizard.DEFAULT_PROJECT_NAME"));
        } else {
            this.fileSelectPage = new HttpRecorderFileSelectPage();
            this.addPage((IWizardPage)this.fileSelectPage);
        }
    }
}

