/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.execution.recorder.http.ui.wizards;

import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.hyades.internal.execution.recorder.ui.RecorderUIUtility;
import org.eclipse.hyades.internal.execution.recorder.ui.wizards.IRecorderWizardPage;
import org.eclipse.hyades.test.tools.ui.ToolsUiPlugin;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.tptp.test.provisional.recorder.ui.wizards.IGenericRecorderPage;
import org.eclipse.tptp.test.provisional.recorder.ui.wizards.IGenericRecorderWizard;
import org.eclipse.ui.dialogs.WizardNewProjectCreationPage;

public class HttpRecorderNoProjectsPage
extends WizardNewProjectCreationPage
implements IRecorderWizardPage,
IGenericRecorderPage {
    private Text recFileText;
    public static final String SOURCE_DIR = "src";
    private Listener modifyListener = new Listener(){

        public void handleEvent(Event e) {
            if (e.widget == HttpRecorderNoProjectsPage.this.recFileText) {
                HttpRecorderNoProjectsPage.this.setPageComplete(HttpRecorderNoProjectsPage.this.validatePage());
            }
        }
    };

    public HttpRecorderNoProjectsPage(IGenericRecorderWizard wizard, String pageName) {
        this(pageName);
        this.setWizard((IWizard)wizard);
    }

    public HttpRecorderNoProjectsPage(String pageName) {
        super(pageName);
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        this.setDescription(ToolsUiPlugin.getString("HttpRecorderNoProjectsPage.DESCRIPTION"));
        this.setTitle(ToolsUiPlugin.getString("HttpRecorderNoProjectsPage.TITLE"));
        Composite control = (Composite)this.getControl();
        Composite recFileCanvas = new Composite(control, 0);
        recFileCanvas.setLayoutData((Object)new GridData(768));
        RecorderUIUtility.assignGridLayout((Composite)recFileCanvas, (int)2, (boolean)false);
        RecorderUIUtility.createLabel((Composite)recFileCanvas, (String)ToolsUiPlugin.getString("HttpRecorderFileSelectPage.SELECT_RECORDING_FILE_LOCATION_WIZARDPAGE_FILENAME_LABEL"), null);
        this.recFileText = RecorderUIUtility.createEditControl((Composite)recFileCanvas, (String)"", null);
        this.recFileText.setLayoutData((Object)new GridData(768));
        this.recFileText.addListener(24, this.modifyListener);
        try {
            Control[] childComposites = control.getChildren();
            int i = 0;
            while (i < childComposites.length) {
                if (childComposites[i] instanceof Composite) {
                    Control[] controls = ((Composite)childComposites[i]).getChildren();
                    boolean bIsProjName = false;
                    Text projText = null;
                    int j = 0;
                    while (j < controls.length) {
                        if (controls[j] instanceof Text) {
                            projText = (Text)controls[j];
                        }
                        if (controls[j] instanceof Label && ((Label)controls[j]).getText().equals(ToolsUiPlugin.getString("WizardNewProjectCreationPage.nameLabel"))) {
                            bIsProjName = true;
                        }
                        ++j;
                    }
                    if (bIsProjName && projText != null) {
                        projText.addListener(24, this.modifyListener);
                        this.modifyListener.handleEvent(new Event());
                        break;
                    }
                }
                ++i;
            }
        }
        catch (SWTException sWTException) {}
        try {
            if (!"".equals(this.getProjectName())) {
                this.recFileText.setFocus();
            }
        }
        catch (SWTException sWTException) {}
    }

    public String getContextHelpID() {
        return "org.eclipse.hyades.execution.recorder.http.RecordingLocationSelector";
    }

    public void saveSettings() {
    }

    protected boolean validatePage() {
        boolean b;
        boolean bl = b = super.validatePage() && this.isFileNameValid(this.getRecFile());
        if (!this.isFileNameValid(this.getRecFile())) {
            this.setMessage(ToolsUiPlugin.getString("HttpRecorderNoProjectsPage.INVALID_REC_FILE"), 2);
        }
        return b;
    }

    protected boolean isFileNameValid(String filename) {
        if (filename.length() < 1) {
            return false;
        }
        char[] RESERVED_CHARS = new char[]{';', '/', '?', ':', '@', '&', '=', '+', '$', ',', '<', '>', '#', '%', '\"', ' ', '{', '}', '|', '\\', '^', '[', ']', '\'', '*'};
        int i = 0;
        while (i < RESERVED_CHARS.length) {
            if (filename.indexOf(RESERVED_CHARS[i]) > -1) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public String getRecFile() {
        if (this.recFileText == null) {
            return "";
        }
        if (this.recFileText.getText().equals("")) {
            return "";
        }
        String recText = this.recFileText.getText();
        if (!recText.endsWith(".rec")) {
            recText = String.valueOf(recText) + ".rec";
        }
        return recText;
    }

    public IProject createJavaProject(IProgressMonitor monitor) throws CoreException {
        if (!this.isPageComplete()) {
            return null;
        }
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IProject proj = this.getProjectHandle();
        if (proj == null) {
            return null;
        }
        IProjectDescription projDesc = ResourcesPlugin.getWorkspace().newProjectDescription(this.getProjectName());
        if (!this.useDefaults()) {
            projDesc.setLocation(this.getLocationPath());
        }
        if (!proj.exists()) {
            proj.create(projDesc, monitor);
        }
        proj.open(monitor);
        projDesc = proj.getDescription();
        String[] natures = projDesc.getNatureIds();
        String[] newNatures = new String[natures.length + 1];
        System.arraycopy(natures, 0, newNatures, 0, natures.length);
        newNatures[natures.length] = "org.eclipse.jdt.core.javanature";
        projDesc.setNatureIds(newNatures);
        proj.setDescription(projDesc, 1, null);
        IJavaProject javaProj = JavaCore.create((IProject)proj);
        IClasspathEntry[] cp = javaProj.getRawClasspath();
        IClasspathEntry[] newCp = new IClasspathEntry[cp.length + 1];
        System.arraycopy(cp, 0, newCp, 0, cp.length);
        newCp[cp.length] = JavaCore.newContainerEntry((IPath)new Path(JavaRuntime.JRE_CONTAINER));
        Path srcDir = new Path(proj.getFullPath() + "/" + SOURCE_DIR);
        IFolder srcFolder = root.getFolder((IPath)srcDir);
        if (!srcFolder.exists()) {
            srcFolder.create(true, true, monitor);
        }
        boolean bSourceDir = false;
        int i = 0;
        while (i < newCp.length) {
            IClasspathEntry entry = newCp[i];
            if (entry.getEntryKind() == 3 && !bSourceDir) {
                newCp[i] = JavaCore.newSourceEntry((IPath)srcDir);
                bSourceDir = true;
            }
            ++i;
        }
        if (!bSourceDir) {
            IClasspathEntry[] tempCp = new IClasspathEntry[newCp.length + 1];
            System.arraycopy(newCp, 0, tempCp, 0, newCp.length);
            tempCp[newCp.length] = JavaCore.newSourceEntry((IPath)srcDir);
            newCp = tempCp;
        }
        javaProj.setRawClasspath(newCp, null);
        return proj;
    }

    public String getRecorderData(String key) {
        if (key.equals("keyWizardPath")) {
            return "/" + this.getProjectName() + "/" + this.getRecFile();
        }
        if (key.equals("keyTestgenPath")) {
            String rec = this.getRecFile();
            if (rec.endsWith(".rec")) {
                return "/" + this.getProjectName() + "/" + rec.substring(0, rec.length() - 4) + ".testsuite";
            }
            return "/" + this.getProjectName() + "/" + rec + ".testsuite";
        }
        return null;
    }

    public Object getRecorderObjectData(String key) {
        return null;
    }
}

