/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.internal.recorder.http.util;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Locale;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.hyades.execution.recorder.RecorderException;
import org.eclipse.hyades.execution.recorder.http.remote.PeekServerSocket;
import org.eclipse.hyades.execution.recorder.local.appadapters.FirefoxPrefs;
import org.eclipse.hyades.execution.recorder.local.appadapters.MozillaPrefs;
import org.eclipse.hyades.execution.recorder.local.appadapters.RecorderAppAdapterFactory;
import org.eclipse.hyades.internal.execution.recorder.ui.views.RecorderControlView;
import org.eclipse.hyades.internal.execution.recorder.ui.wizards.RecorderRegistryInfo;
import org.eclipse.hyades.test.tools.core.CorePlugin;
import org.eclipse.hyades.test.tools.ui.ToolsUiPlugin;
import org.eclipse.hyades.test.ui.UiPlugin;
import org.osgi.framework.Bundle;

public class RecorderParamHelper {
    public static String getRecorderParams(String adapterID) throws RecorderException {
        RecorderRegistryInfo regInfo = null;
        MozillaPrefs prefsInfo = null;
        FirefoxPrefs FFprefsInfo = null;
        int goodProxyPort = 0;
        String listenPort = ToolsUiPlugin.getPreference("default_proxy_port");
        goodProxyPort = RecorderParamHelper.findAvailableClientPort(listenPort);
        String recorderParams = "port," + goodProxyPort;
        try {
            if (!adapterID.equalsIgnoreCase("-1")) {
                if (adapterID.endsWith("InternetExplorer")) {
                    regInfo = new RecorderRegistryInfo();
                    RecorderParamHelper.handleInvalidProxySettings(regInfo);
                    recorderParams = regInfo.isProxyEnabled() ? String.valueOf(recorderParams) + ";proxyInfo," + regInfo.getProxyType() + "=" + regInfo.getProxyAddr() + ":" + regInfo.getProxyPort() : String.valueOf(recorderParams) + ";proxyInfo,socks";
                } else if (adapterID.endsWith("Firefox")) {
                    FFprefsInfo = new FirefoxPrefs(goodProxyPort);
                    RecorderParamHelper.handleInvalidProxySettings(FFprefsInfo);
                    recorderParams = FFprefsInfo.isHttpProxyEnabled() ? String.valueOf(recorderParams) + ";proxyInfo," + "http=" + FFprefsInfo.getHttpProxyAddr() + ":" + FFprefsInfo.getHttpProxyPort() : String.valueOf(recorderParams) + ";proxyInfo,socks";
                } else {
                    prefsInfo = new MozillaPrefs(goodProxyPort);
                    RecorderParamHelper.handleInvalidProxySettings(prefsInfo);
                    recorderParams = prefsInfo.isHttpProxyEnabled() ? String.valueOf(recorderParams) + ";proxyInfo," + "http=" + prefsInfo.getHttpProxyAddr() + ":" + prefsInfo.getHttpProxyPort() : String.valueOf(recorderParams) + ";proxyInfo,socks";
                }
            } else {
                recorderParams = String.valueOf(recorderParams) + ";proxyInfo,socks";
            }
        }
        catch (RecorderException e1) {
            e1.printStackTrace();
            throw e1;
        }
        try {
            File sslfile;
            URL resolvedTestkeys = new URL(Platform.resolve((URL)CorePlugin.getInstance().getBundle().getEntry("/")), "testkeys");
            String keyfile = resolvedTestkeys.toString();
            if (resolvedTestkeys.getProtocol().equals("file")) {
                keyfile = resolvedTestkeys.getFile();
            }
            if ((sslfile = new File(keyfile)).exists()) {
                recorderParams = String.valueOf(recorderParams) + ";sslkeyfile," + sslfile.getAbsolutePath();
            }
        }
        catch (IOException iOException) {}
        try {
            String appParams = String.valueOf(recorderParams) + ";startupURL," + RecorderParamHelper.getStartupURL();
            if (!adapterID.equalsIgnoreCase("-1")) {
                RecorderAppAdapterFactory.getInstance().getAppAdapter(ToolsUiPlugin.getPreference("application_under_test")).setInitString(appParams);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (!adapterID.equalsIgnoreCase("-1")) {
            if (adapterID.endsWith("InternetExplorer")) {
                if (regInfo != null && regInfo.isSSLProxyEnabled()) {
                    recorderParams = String.valueOf(recorderParams) + ";sslProxyInfo," + "https=" + regInfo.getSslProxyAddr() + ":" + regInfo.getSslProxyPort();
                }
            } else if (adapterID.endsWith("Firefox")) {
                if (FFprefsInfo != null && FFprefsInfo.isSSLProxyEnabled()) {
                    recorderParams = String.valueOf(recorderParams) + ";sslProxyInfo," + "https=" + FFprefsInfo.getSslProxyAddr() + ":" + FFprefsInfo.getSslProxyPort();
                }
            } else if (prefsInfo != null && prefsInfo.isSSLProxyEnabled()) {
                recorderParams = String.valueOf(recorderParams) + ";sslProxyInfo," + "https=" + prefsInfo.getSslProxyAddr() + ":" + prefsInfo.getSslProxyPort();
            }
        }
        if (regInfo != null && regInfo.isProxyOverrideEnabled()) {
            recorderParams = String.valueOf(recorderParams) + ";proxyOverride," + regInfo.getProxyOverrideString();
        }
        if (regInfo != null && regInfo.isAutoConfigURLEnabled()) {
            recorderParams = String.valueOf(recorderParams) + ";autoConfigURL," + regInfo.getAutoConfigURLString();
        }
        return recorderParams;
    }

    private static int findAvailableClientPort(String currentProxyPort) {
        int originalPort = 0;
        int availablePort = 0;
        Integer tmpPort = Integer.decode(currentProxyPort);
        availablePort = originalPort = tmpPort.intValue();
        PeekServerSocket tmpServersocket = null;
        try {
            tmpServersocket = new PeekServerSocket(availablePort);
            tmpServersocket.close();
        }
        catch (IOException iOException) {
            try {
                tmpServersocket = new PeekServerSocket(0);
                availablePort = tmpServersocket.getLocalPort();
                tmpServersocket.close();
            }
            catch (IOException iOException2) {}
        }
        if (availablePort != originalPort) {
            String availPortStr = String.valueOf(availablePort);
            Object[] bothPorts = new String[]{currentProxyPort, availPortStr};
            String formatString = ToolsUiPlugin.getString("HttpRecorderLaunchWizard.RECORDING_CHANGE_PORT_MESSAGE");
            RecorderControlView.getInstance().addMessage(MessageFormat.format(formatString, bothPorts));
        }
        return availablePort;
    }

    protected static String getStartupURL() throws IOException {
        String strLocalizedFile;
        File file;
        IConfigurationElement[] elements = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.hyades.test.tools.ui.HttpRecorderStartupPage");
        if (elements.length > 0) {
            IConfigurationElement maxElement = elements[0];
            int nMax = -1;
            int i = 0;
            while (i < elements.length) {
                int n = 0;
                try {
                    n = Integer.parseInt(elements[i].getAttribute("priority"));
                }
                catch (NumberFormatException numberFormatException) {
                    n = 0;
                }
                if (n > nMax) {
                    maxElement = elements[i];
                }
                ++i;
            }
            String appendPath = maxElement.getAttribute("path");
            URL url = Platform.find((Bundle)Platform.getBundle((String)maxElement.getNamespace()), (IPath)new Path(appendPath));
            if (url != null) {
                return Platform.resolve((URL)url).toString();
            }
        }
        String startupURLroot = "readme";
        String HTML = ".html";
        URL startupURL = Platform.resolve((URL)ToolsUiPlugin.getDefault().getDescriptor().getInstallURL());
        String strInstall = null;
        if (startupURL.getProtocol().equals("file")) {
            strInstall = String.valueOf(startupURL.getFile()) + startupURLroot;
        }
        if (!((file = new File(strLocalizedFile = String.valueOf(strInstall) + "_" + Locale.getDefault().toString() + HTML)).exists() || (file = new File(strLocalizedFile = String.valueOf(strInstall) + "_" + Locale.getDefault().getLanguage() + "_" + Locale.getDefault().getCountry() + HTML)).exists() || (file = new File(strLocalizedFile = String.valueOf(strInstall) + "_" + Locale.getDefault().getLanguage() + HTML)).exists() || (file = new File(strLocalizedFile = String.valueOf(strInstall) + HTML)).exists())) {
            return "about:blank";
        }
        return "file://" + strLocalizedFile;
    }

    private static void handleInvalidProxySettings(RecorderRegistryInfo regInfo) throws RecorderException {
        if (regInfo.isBadProxySettings()) {
            int thisProxyError = regInfo.getProxyError();
            regInfo.getClass();
            if (thisProxyError == -1) {
                UiPlugin.reportExceptionToUser((Exception)((Object)new RecorderException(ToolsUiPlugin.getString("HttpRecorderLaunchWizard.SOCKS_ONLY_ERROR"))), (String)ToolsUiPlugin.getString("HttpRecorderLaunchWizard.UNABLE_TO_START_RECORDER_MESSAGE"), (String)ToolsUiPlugin.getString("HttpRecorderLaunchWizard.SOCKS_ONLY_ERROR"), (String)ToolsUiPlugin.getString("HttpRecorderLaunchWizard.RECORDER_REGISTRY_ERROR"));
                throw new RecorderException(ToolsUiPlugin.getString("HttpRecorderLaunchWizard.SOCKS_ONLY_ERROR"));
            }
            regInfo.getClass();
            if (thisProxyError == -2) {
                UiPlugin.reportExceptionToUser((Exception)((Object)new RecorderException(ToolsUiPlugin.getString("HttpRecorderLaunchWizard.HTTP_PROXY_ONLY_ERROR"))), (String)ToolsUiPlugin.getString("HttpRecorderLaunchWizard.UNABLE_TO_START_RECORDER_MESSAGE"), (String)ToolsUiPlugin.getString("HttpRecorderLaunchWizard.HTTP_PROXY_ONLY_ERROR"), (String)ToolsUiPlugin.getString("HttpRecorderLaunchWizard.RECORDER_REGISTRY_ERROR"));
                throw new RecorderException(ToolsUiPlugin.getString("HttpRecorderLaunchWizard.HTTP_PROXY_ONLY_ERROR"));
            }
            regInfo.getClass();
            if (thisProxyError == -3) {
                UiPlugin.reportExceptionToUser((Exception)((Object)new RecorderException(ToolsUiPlugin.getString("HttpRecorderLaunchWizard.SECURE_PROXY_ONLY_ERROR"))), (String)ToolsUiPlugin.getString("HttpRecorderLaunchWizard.UNABLE_TO_START_RECORDER_MESSAGE"), (String)ToolsUiPlugin.getString("HttpRecorderLaunchWizard.SECURE_PROXY_ONLY_ERROR"), (String)ToolsUiPlugin.getString("HttpRecorderLaunchWizard.RECORDER_REGISTRY_ERROR"));
                throw new RecorderException(ToolsUiPlugin.getString("HttpRecorderLaunchWizard.SECURE_PROXY_ONLY_ERROR"));
            }
            regInfo.getClass();
            if (thisProxyError == -4) {
                UiPlugin.reportExceptionToUser((Exception)((Object)new RecorderException(ToolsUiPlugin.getString("HttpRecorderLaunchWizard.HTTP_SECURE_MISMATCH_ERROR"))), (String)ToolsUiPlugin.getString("HttpRecorderLaunchWizard.UNABLE_TO_START_RECORDER_MESSAGE"), (String)ToolsUiPlugin.getString("HttpRecorderLaunchWizard.HTTP_SECURE_MISMATCH_ERROR"), (String)ToolsUiPlugin.getString("HttpRecorderLaunchWizard.RECORDER_REGISTRY_ERROR"));
                throw new RecorderException(ToolsUiPlugin.getString("HttpRecorderLaunchWizard.HTTP_SECURE_MISMATCH_ERROR"));
            }
            regInfo.getClass();
            if (thisProxyError == -5) {
                UiPlugin.reportExceptionToUser((Exception)((Object)new RecorderException(ToolsUiPlugin.getString("HttpRecorderLaunchWizard.LOCALHOST_ERROR"))), (String)ToolsUiPlugin.getString("HttpRecorderLaunchWizard.UNABLE_TO_START_RECORDER_MESSAGE"), (String)ToolsUiPlugin.getString("HttpRecorderLaunchWizard.LOCALHOST_ERROR"), (String)ToolsUiPlugin.getString("HttpRecorderLaunchWizard.RECORDER_REGISTRY_ERROR"));
                throw new RecorderException(ToolsUiPlugin.getString("HttpRecorderLaunchWizard.LOCALHOST_ERROR"));
            }
            regInfo.getClass();
            if (thisProxyError == -7) {
                String tmpStr = String.valueOf(ToolsUiPlugin.getString("HttpRecorderLaunchWizard.RECORDING_AUTO_CONFIG_MESSAGE")) + "\n ";
                tmpStr = String.valueOf(tmpStr) + ToolsUiPlugin.getString("HttpRecorderLaunchWizard.RECORDING_SUPPORTED_CONFIG_MESSAGE");
                UiPlugin.reportExceptionToUser((Exception)((Object)new RecorderException(ToolsUiPlugin.getString("HttpRecorderLaunchWizard.RECORDING_AUTO_CONFIG_MESSAGE"))), (String)ToolsUiPlugin.getString("HttpRecorderLaunchWizard.UNABLE_TO_START_RECORDER_MESSAGE"), (String)tmpStr, (String)ToolsUiPlugin.getString("HttpRecorderLaunchWizard.RECORDER_REGISTRY_ERROR"));
                throw new RecorderException(ToolsUiPlugin.getString("HttpRecorderLaunchWizard.RECORDING_AUTO_CONFIG_MESSAGE"));
            }
            regInfo.getClass();
            if (thisProxyError == -6) {
                String tmpStr = String.valueOf(ToolsUiPlugin.getString("HttpRecorderLaunchWizard.RECORDING_PROXY_OVERRIDE_MESSAGE")) + "\n ";
                tmpStr = String.valueOf(tmpStr) + ToolsUiPlugin.getString("HttpRecorderLaunchWizard.RECORDING_SUPPORTED_CONFIG_MESSAGE");
                UiPlugin.reportExceptionToUser((Exception)((Object)new RecorderException(ToolsUiPlugin.getString("HttpRecorderLaunchWizard.RECORDING_PROXY_OVERRIDE_MESSAGE"))), (String)ToolsUiPlugin.getString("HttpRecorderLaunchWizard.UNABLE_TO_START_RECORDER_MESSAGE"), (String)tmpStr, (String)ToolsUiPlugin.getString("HttpRecorderLaunchWizard.RECORDER_REGISTRY_ERROR"));
                throw new RecorderException(ToolsUiPlugin.getString("HttpRecorderLaunchWizard.RECORDING_PROXY_OVERRIDE_MESSAGE"));
            }
        }
    }

    private static void handleInvalidProxySettings(MozillaPrefs prefsInfo) throws RecorderException {
        if (prefsInfo.isBadProxySettings()) {
            int thisProxyError = prefsInfo.getProxyError();
            prefsInfo.getClass();
            if (thisProxyError == -1) {
                UiPlugin.reportExceptionToUser((Exception)((Object)new RecorderException(ToolsUiPlugin.getString("HttpRecorderLaunchWizard.SOCKS_ONLY_ERROR"))), (String)ToolsUiPlugin.getString("HttpRecorderLaunchWizard.UNABLE_TO_START_RECORDER_MESSAGE"), (String)ToolsUiPlugin.getString("HttpRecorderLaunchWizard.SOCKS_ONLY_ERROR"), (String)ToolsUiPlugin.getString("HttpRecorderLaunchWizard.RECORDER_REGISTRY_ERROR"));
                throw new RecorderException(ToolsUiPlugin.getString("HttpRecorderLaunchWizard.SOCKS_ONLY_ERROR"));
            }
            prefsInfo.getClass();
            if (thisProxyError == -2) {
                UiPlugin.reportExceptionToUser((Exception)((Object)new RecorderException(ToolsUiPlugin.getString("HttpRecorderLaunchWizard.HTTP_PROXY_ONLY_ERROR"))), (String)ToolsUiPlugin.getString("HttpRecorderLaunchWizard.UNABLE_TO_START_RECORDER_MESSAGE"), (String)ToolsUiPlugin.getString("HttpRecorderLaunchWizard.HTTP_PROXY_ONLY_ERROR"), (String)ToolsUiPlugin.getString("HttpRecorderLaunchWizard.RECORDER_REGISTRY_ERROR"));
                throw new RecorderException(ToolsUiPlugin.getString("HttpRecorderLaunchWizard.HTTP_PROXY_ONLY_ERROR"));
            }
            prefsInfo.getClass();
            if (thisProxyError == -3) {
                UiPlugin.reportExceptionToUser((Exception)((Object)new RecorderException(ToolsUiPlugin.getString("HttpRecorderLaunchWizard.SECURE_PROXY_ONLY_ERROR"))), (String)ToolsUiPlugin.getString("HttpRecorderLaunchWizard.UNABLE_TO_START_RECORDER_MESSAGE"), (String)ToolsUiPlugin.getString("HttpRecorderLaunchWizard.SECURE_PROXY_ONLY_ERROR"), (String)ToolsUiPlugin.getString("HttpRecorderLaunchWizard.RECORDER_REGISTRY_ERROR"));
                throw new RecorderException(ToolsUiPlugin.getString("HttpRecorderLaunchWizard.SECURE_PROXY_ONLY_ERROR"));
            }
            prefsInfo.getClass();
            if (thisProxyError == -4) {
                UiPlugin.reportExceptionToUser((Exception)((Object)new RecorderException(ToolsUiPlugin.getString("HttpRecorderLaunchWizard.HTTP_SECURE_MISMATCH_ERROR"))), (String)ToolsUiPlugin.getString("HttpRecorderLaunchWizard.UNABLE_TO_START_RECORDER_MESSAGE"), (String)ToolsUiPlugin.getString("HttpRecorderLaunchWizard.HTTP_SECURE_MISMATCH_ERROR"), (String)ToolsUiPlugin.getString("HttpRecorderLaunchWizard.RECORDER_REGISTRY_ERROR"));
                throw new RecorderException(ToolsUiPlugin.getString("HttpRecorderLaunchWizard.HTTP_SECURE_MISMATCH_ERROR"));
            }
            prefsInfo.getClass();
            if (thisProxyError == -5) {
                UiPlugin.reportExceptionToUser((Exception)((Object)new RecorderException(ToolsUiPlugin.getString("HttpRecorderLaunchWizard.LOCALHOST_ERROR"))), (String)ToolsUiPlugin.getString("HttpRecorderLaunchWizard.UNABLE_TO_START_RECORDER_MESSAGE"), (String)ToolsUiPlugin.getString("HttpRecorderLaunchWizard.LOCALHOST_ERROR"), (String)ToolsUiPlugin.getString("HttpRecorderLaunchWizard.RECORDER_REGISTRY_ERROR"));
                throw new RecorderException(ToolsUiPlugin.getString("HttpRecorderLaunchWizard.LOCALHOST_ERROR"));
            }
            prefsInfo.getClass();
            if (thisProxyError == -7) {
                String tmpStr = String.valueOf(ToolsUiPlugin.getString("HttpRecorderLaunchWizard.RECORDING_AUTO_CONFIG_MESSAGE")) + "\n ";
                tmpStr = String.valueOf(tmpStr) + ToolsUiPlugin.getString("HttpRecorderLaunchWizard.RECORDING_SUPPORTED_CONFIG_MESSAGE");
                UiPlugin.reportExceptionToUser((Exception)((Object)new RecorderException(ToolsUiPlugin.getString("HttpRecorderLaunchWizard.RECORDING_AUTO_CONFIG_MESSAGE"))), (String)ToolsUiPlugin.getString("HttpRecorderLaunchWizard.UNABLE_TO_START_RECORDER_MESSAGE"), (String)tmpStr, (String)ToolsUiPlugin.getString("HttpRecorderLaunchWizard.RECORDER_REGISTRY_ERROR"));
                throw new RecorderException(ToolsUiPlugin.getString("HttpRecorderLaunchWizard.RECORDING_AUTO_CONFIG_MESSAGE"));
            }
            prefsInfo.getClass();
            if (thisProxyError == -6) {
                String tmpStr = String.valueOf(ToolsUiPlugin.getString("HttpRecorderLaunchWizard.RECORDING_PROXY_OVERRIDE_MESSAGE")) + "\n ";
                tmpStr = String.valueOf(tmpStr) + ToolsUiPlugin.getString("HttpRecorderLaunchWizard.RECORDING_SUPPORTED_CONFIG_MESSAGE");
                UiPlugin.reportExceptionToUser((Exception)((Object)new RecorderException(ToolsUiPlugin.getString("HttpRecorderLaunchWizard.RECORDING_PROXY_OVERRIDE_MESSAGE"))), (String)ToolsUiPlugin.getString("HttpRecorderLaunchWizard.UNABLE_TO_START_RECORDER_MESSAGE"), (String)tmpStr, (String)ToolsUiPlugin.getString("HttpRecorderLaunchWizard.RECORDER_REGISTRY_ERROR"));
                throw new RecorderException(ToolsUiPlugin.getString("HttpRecorderLaunchWizard.RECORDING_PROXY_OVERRIDE_MESSAGE"));
            }
            prefsInfo.getClass();
            if (thisProxyError == -8) {
                String tmpStr = String.valueOf(ToolsUiPlugin.getString("HttpRecorderLaunchWizard.RECORDING_PREFS_NOT_FOUND_ERROR")) + "\n ";
                tmpStr = String.valueOf(tmpStr) + ToolsUiPlugin.getString("HttpRecorderLaunchWizard.RECORDING_SELECT_DIFFERENT_BROWSER");
                UiPlugin.reportExceptionToUser((Exception)((Object)new RecorderException(ToolsUiPlugin.getString("HttpRecorderLaunchWizard.RECORDING_PREFS_NOT_FOUND_ERROR"))), (String)ToolsUiPlugin.getString("HttpRecorderLaunchWizard.UNABLE_TO_START_RECORDER_MESSAGE"), (String)tmpStr, (String)ToolsUiPlugin.getString("HttpRecorderLaunchWizard.BROWSER_PREFS_FILE_ERROR"));
                throw new RecorderException(ToolsUiPlugin.getString("HttpRecorderLaunchWizard.BROWSER_PREFS_FILE_ERROR"));
            }
        }
    }

    private static void handleInvalidProxySettings(FirefoxPrefs prefsInfo) throws RecorderException {
        if (prefsInfo.isBadProxySettings()) {
            int thisProxyError = prefsInfo.getProxyError();
            prefsInfo.getClass();
            if (thisProxyError == -1) {
                UiPlugin.reportExceptionToUser((Exception)((Object)new RecorderException(ToolsUiPlugin.getString("HttpRecorderLaunchWizard.SOCKS_ONLY_ERROR"))), (String)ToolsUiPlugin.getString("HttpRecorderLaunchWizard.UNABLE_TO_START_RECORDER_MESSAGE"), (String)ToolsUiPlugin.getString("HttpRecorderLaunchWizard.SOCKS_ONLY_ERROR"), (String)ToolsUiPlugin.getString("HttpRecorderLaunchWizard.RECORDER_REGISTRY_ERROR"));
                throw new RecorderException(ToolsUiPlugin.getString("HttpRecorderLaunchWizard.SOCKS_ONLY_ERROR"));
            }
            prefsInfo.getClass();
            if (thisProxyError == -2) {
                UiPlugin.reportExceptionToUser((Exception)((Object)new RecorderException(ToolsUiPlugin.getString("HttpRecorderLaunchWizard.HTTP_PROXY_ONLY_ERROR"))), (String)ToolsUiPlugin.getString("HttpRecorderLaunchWizard.UNABLE_TO_START_RECORDER_MESSAGE"), (String)ToolsUiPlugin.getString("HttpRecorderLaunchWizard.HTTP_PROXY_ONLY_ERROR"), (String)ToolsUiPlugin.getString("HttpRecorderLaunchWizard.RECORDER_REGISTRY_ERROR"));
                throw new RecorderException(ToolsUiPlugin.getString("HttpRecorderLaunchWizard.HTTP_PROXY_ONLY_ERROR"));
            }
            prefsInfo.getClass();
            if (thisProxyError == -3) {
                UiPlugin.reportExceptionToUser((Exception)((Object)new RecorderException(ToolsUiPlugin.getString("HttpRecorderLaunchWizard.SECURE_PROXY_ONLY_ERROR"))), (String)ToolsUiPlugin.getString("HttpRecorderLaunchWizard.UNABLE_TO_START_RECORDER_MESSAGE"), (String)ToolsUiPlugin.getString("HttpRecorderLaunchWizard.SECURE_PROXY_ONLY_ERROR"), (String)ToolsUiPlugin.getString("HttpRecorderLaunchWizard.RECORDER_REGISTRY_ERROR"));
                throw new RecorderException(ToolsUiPlugin.getString("HttpRecorderLaunchWizard.SECURE_PROXY_ONLY_ERROR"));
            }
            prefsInfo.getClass();
            if (thisProxyError == -4) {
                UiPlugin.reportExceptionToUser((Exception)((Object)new RecorderException(ToolsUiPlugin.getString("HttpRecorderLaunchWizard.HTTP_SECURE_MISMATCH_ERROR"))), (String)ToolsUiPlugin.getString("HttpRecorderLaunchWizard.UNABLE_TO_START_RECORDER_MESSAGE"), (String)ToolsUiPlugin.getString("HttpRecorderLaunchWizard.HTTP_SECURE_MISMATCH_ERROR"), (String)ToolsUiPlugin.getString("HttpRecorderLaunchWizard.RECORDER_REGISTRY_ERROR"));
                throw new RecorderException(ToolsUiPlugin.getString("HttpRecorderLaunchWizard.HTTP_SECURE_MISMATCH_ERROR"));
            }
            prefsInfo.getClass();
            if (thisProxyError == -5) {
                UiPlugin.reportExceptionToUser((Exception)((Object)new RecorderException(ToolsUiPlugin.getString("HttpRecorderLaunchWizard.LOCALHOST_ERROR"))), (String)ToolsUiPlugin.getString("HttpRecorderLaunchWizard.UNABLE_TO_START_RECORDER_MESSAGE"), (String)ToolsUiPlugin.getString("HttpRecorderLaunchWizard.LOCALHOST_ERROR"), (String)ToolsUiPlugin.getString("HttpRecorderLaunchWizard.RECORDER_REGISTRY_ERROR"));
                throw new RecorderException(ToolsUiPlugin.getString("HttpRecorderLaunchWizard.LOCALHOST_ERROR"));
            }
            prefsInfo.getClass();
            if (thisProxyError == -7) {
                String tmpStr = String.valueOf(ToolsUiPlugin.getString("HttpRecorderLaunchWizard.RECORDING_AUTO_CONFIG_MESSAGE")) + "\n ";
                tmpStr = String.valueOf(tmpStr) + ToolsUiPlugin.getString("HttpRecorderLaunchWizard.RECORDING_SUPPORTED_CONFIG_MESSAGE");
                UiPlugin.reportExceptionToUser((Exception)((Object)new RecorderException(ToolsUiPlugin.getString("HttpRecorderLaunchWizard.RECORDING_AUTO_CONFIG_MESSAGE"))), (String)ToolsUiPlugin.getString("HttpRecorderLaunchWizard.UNABLE_TO_START_RECORDER_MESSAGE"), (String)tmpStr, (String)ToolsUiPlugin.getString("HttpRecorderLaunchWizard.RECORDER_REGISTRY_ERROR"));
                throw new RecorderException(ToolsUiPlugin.getString("HttpRecorderLaunchWizard.RECORDING_AUTO_CONFIG_MESSAGE"));
            }
            prefsInfo.getClass();
            if (thisProxyError == -6) {
                String tmpStr = String.valueOf(ToolsUiPlugin.getString("HttpRecorderLaunchWizard.RECORDING_PROXY_OVERRIDE_MESSAGE")) + "\n ";
                tmpStr = String.valueOf(tmpStr) + ToolsUiPlugin.getString("HttpRecorderLaunchWizard.RECORDING_SUPPORTED_CONFIG_MESSAGE");
                UiPlugin.reportExceptionToUser((Exception)((Object)new RecorderException(ToolsUiPlugin.getString("HttpRecorderLaunchWizard.RECORDING_PROXY_OVERRIDE_MESSAGE"))), (String)ToolsUiPlugin.getString("HttpRecorderLaunchWizard.UNABLE_TO_START_RECORDER_MESSAGE"), (String)tmpStr, (String)ToolsUiPlugin.getString("HttpRecorderLaunchWizard.RECORDER_REGISTRY_ERROR"));
                throw new RecorderException(ToolsUiPlugin.getString("HttpRecorderLaunchWizard.RECORDING_PROXY_OVERRIDE_MESSAGE"));
            }
            prefsInfo.getClass();
            if (thisProxyError == -8) {
                String tmpStr = String.valueOf(ToolsUiPlugin.getString("HttpRecorderLaunchWizard.RECORDING_PREFS_NOT_FOUND_ERROR")) + "\n ";
                tmpStr = String.valueOf(tmpStr) + ToolsUiPlugin.getString("HttpRecorderLaunchWizard.RECORDING_SELECT_DIFFERENT_BROWSER");
                UiPlugin.reportExceptionToUser((Exception)((Object)new RecorderException(ToolsUiPlugin.getString("HttpRecorderLaunchWizard.RECORDING_PREFS_NOT_FOUND_ERROR"))), (String)ToolsUiPlugin.getString("HttpRecorderLaunchWizard.UNABLE_TO_START_RECORDER_MESSAGE"), (String)tmpStr, (String)ToolsUiPlugin.getString("HttpRecorderLaunchWizard.BROWSER_PREFS_FILE_ERROR"));
                throw new RecorderException(ToolsUiPlugin.getString("HttpRecorderLaunchWizard.BROWSER_PREFS_FILE_ERROR"));
            }
        }
    }
}

