/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.tools.ui;

import java.net.URL;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.hyades.execution.recorder.IRecorderDataProcessor;
import org.eclipse.hyades.execution.recorder.Recorder;
import org.eclipse.hyades.execution.recorder.RecorderException;
import org.eclipse.hyades.execution.recorder.http.local.HttpRecorderAgentEnvironmentAdapter;
import org.eclipse.hyades.execution.recorder.http.local.HttpRecorderDataProcessor;
import org.eclipse.hyades.execution.recorder.http.local.HttpRecorderExecutableObjectAdapter;
import org.eclipse.hyades.execution.recorder.remote.RecorderEnvironmentAdapter;
import org.eclipse.hyades.execution.recorder.remote.RecorderExecutableObjectAdapter;
import org.eclipse.hyades.test.core.TestCorePlugin;
import org.eclipse.hyades.test.core.util.ResourceBundleManager;
import org.eclipse.hyades.test.tools.core.CorePlugin;
import org.eclipse.hyades.test.tools.ui.common.TestCommonImages;
import org.eclipse.hyades.test.tools.ui.http.TestHttpImages;
import org.eclipse.hyades.test.tools.ui.java.TestJavaImages;
import org.eclipse.hyades.test.tools.ui.manual.TestManualImages;
import org.eclipse.hyades.test.tools.ui.plugin.internal.TestPluginImages;
import org.eclipse.hyades.test.ui.UiPlugin;
import org.eclipse.hyades.ui.HyadesUIPlugin;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class ToolsUiPlugin
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "org.eclipse.hyades.test.tools.ui";
    private static ToolsUiPlugin plugin;
    private ResourceBundle resourceBundle;
    private ResourceBundleManager resourceBundleManager;
    public static final String RECORDING_PATH = "recording_path";
    public static final String RECORDER_APP_ADAPTER = "application_under_test";
    public static final String PROXY_PORT = "default_proxy_port";
    public static final String DEFAULT_PORT = "1080";
    private Recorder recorder;

    public ToolsUiPlugin() {
        plugin = this;
    }

    public static ToolsUiPlugin getDefault() {
        return plugin;
    }

    public static String getResourceString(String key) {
        ResourceBundle bundle = ToolsUiPlugin.getDefault().getResourceBundle();
        try {
            return bundle != null ? bundle.getString(key) : key;
        }
        catch (MissingResourceException missingResourceException) {
            return key;
        }
    }

    public ResourceBundle getResourceBundle() {
        try {
            if (this.resourceBundle == null) {
                this.resourceBundle = Platform.getResourceBundle((Bundle)Platform.getBundle((String)PLUGIN_ID));
            }
        }
        catch (MissingResourceException missingResourceException) {
            this.resourceBundle = null;
        }
        return this.resourceBundle;
    }

    public void start(BundleContext context) throws Exception {
        this.resourceBundleManager = new ResourceBundleManager();
        this.resourceBundleManager.add(this.getResourceBundle());
        this.resourceBundleManager.add(CorePlugin.getInstance().getResourceBundle());
        this.resourceBundleManager.add(TestCorePlugin.getDefault().getResourceBundle());
        this.resourceBundleManager.add(HyadesUIPlugin.getInstance().getResourceBundle());
        this.resourceBundleManager.add(UiPlugin.getInstance().getResourceBundles());
        super.start(context);
        Runnable runnable = new Runnable(){

            public void run() {
                try {
                    TestCommonImages.INSTANCE.initialize(new URL(ToolsUiPlugin.this.getBundle().getEntry("/"), "icons/full/"), ToolsUiPlugin.this.getImageRegistry());
                    TestJavaImages.INSTANCE.initialize(new URL(ToolsUiPlugin.this.getBundle().getEntry("/"), "icons/full/"), ToolsUiPlugin.this.getImageRegistry());
                    TestHttpImages.INSTANCE.initialize(new URL(ToolsUiPlugin.this.getBundle().getEntry("/"), "icons/full/"), ToolsUiPlugin.this.getImageRegistry());
                    TestManualImages.INSTANCE.initialize(new URL(ToolsUiPlugin.this.getBundle().getEntry("/"), "icons/full/"), ToolsUiPlugin.this.getImageRegistry());
                    TestPluginImages.INSTANCE.initialize(new URL(ToolsUiPlugin.this.getBundle().getEntry("/"), "icons/full/"), ToolsUiPlugin.this.getImageRegistry());
                }
                catch (Exception e) {
                    ToolsUiPlugin.logError(e);
                }
            }
        };
        if (Display.getDefault() == Display.getCurrent()) {
            runnable.run();
        } else {
            Display.getDefault().asyncExec(runnable);
        }
    }

    public void stop(BundleContext context) throws Exception {
        this.resourceBundleManager.dispose();
        super.stop(context);
    }

    public static String getID() {
        return PLUGIN_ID;
    }

    public static String getString(String key) throws NullPointerException, MissingResourceException {
        return ToolsUiPlugin.plugin.resourceBundleManager.getString(key);
    }

    public static String getString(String key, String arg) throws NullPointerException, MissingResourceException {
        return ToolsUiPlugin.plugin.resourceBundleManager.getString(key, arg);
    }

    public static String getString(String key, String[] args) throws NullPointerException, MissingResourceException {
        return ToolsUiPlugin.plugin.resourceBundleManager.getString(key, args);
    }

    public static void logError(Throwable exc) {
        Status status = new Status(1, ToolsUiPlugin.getID(), 0, exc.toString(), exc);
        ToolsUiPlugin.getDefault().getLog().log((IStatus)status);
    }

    public static void logError(String text) {
        ToolsUiPlugin.logError(new Throwable(text));
    }

    public void getRecorderInfo() {
        try {
            this.recorder = new Recorder("org.eclipse.hyades.execution.recorder.http", (IRecorderDataProcessor)new HttpRecorderDataProcessor(), (RecorderEnvironmentAdapter)new HttpRecorderAgentEnvironmentAdapter(), (RecorderExecutableObjectAdapter)new HttpRecorderExecutableObjectAdapter());
        }
        catch (RecorderException e1) {
            e1.printStackTrace();
        }
    }

    public Recorder getRecorder() {
        if (this.recorder == null) {
            this.getRecorderInfo();
        }
        return this.recorder;
    }

    public static void storePreference(String key, String value) {
        ToolsUiPlugin.getDefault().getPreferenceStore().setValue(key, value);
    }

    protected void initializeDefaultPreferences(IPreferenceStore store) {
        if (Platform.getOS().equals("win32")) {
            store.setDefault(RECORDER_APP_ADAPTER, "org.eclipse.hyades.test.core.RecorderApplication.InternetExplorer");
        } else {
            store.setDefault(RECORDER_APP_ADAPTER, "-1");
        }
        ToolsUiPlugin.getDefault().getPreferenceStore().setDefault("default_test_generator", UiPlugin.getDefault().getDefaultGeneratorID());
        store.setDefault(PROXY_PORT, DEFAULT_PORT);
    }

    public static String getPreference(String key) {
        return ToolsUiPlugin.getDefault().getPreferenceStore().getString(key);
    }
}

