/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.tools.ui.common.internal.editor;

import org.eclipse.hyades.models.common.facades.behavioral.ITestSuite;
import org.eclipse.hyades.test.tools.ui.ToolsUiPlugin;
import org.eclipse.hyades.test.tools.ui.common.internal.editor.BehaviorAccessories;
import org.eclipse.hyades.test.tools.ui.common.internal.util.FormUtil;
import org.eclipse.hyades.test.tools.ui.common.internal.util.IITestSuiteProvider;
import org.eclipse.hyades.test.ui.UiPlugin;
import org.eclipse.hyades.test.ui.internal.editor.form.base.StructuredViewerPart;
import org.eclipse.hyades.test.ui.internal.editor.form.util.DetailPropertiesSection;
import org.eclipse.hyades.test.ui.internal.editor.form.util.DetailsPageProvider;
import org.eclipse.hyades.test.ui.internal.editor.form.util.EditorEclipseForm;
import org.eclipse.hyades.ui.editor.IEditorExtension;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;

public class BehaviorEclipseForm
extends EditorEclipseForm
implements IITestSuiteProvider,
ISelectionChangedListener {
    protected static final int HELP_FORM_CONTROL = 1;
    protected static final int HELP_SECTION_CONTROL = 2;
    protected static final int HELP_NAMED_ELEMENT_CONTROL = 3;
    private IEditorExtension formEditor;
    private ScrolledForm form;
    private Section sectionc;
    private FormUtil.CommonSection commonSection;
    private Section sectiond;
    private DetailPropertiesSection propertySection;
    private BehaviorAccessories.ExtendedObjectTree behaviourObjectTree;

    public BehaviorEclipseForm(IEditorExtension editor, String editorTitle, String id, String title) {
        super(editor, editorTitle, id, title);
        this.formEditor = editor;
    }

    public void dispose() {
        if (this.form != null) {
            this.form.dispose();
            this.form = null;
        }
        if (this.sectionc != null) {
            this.sectionc.dispose();
            this.sectionc = null;
        }
        if (this.commonSection != null) {
            this.commonSection.dispose();
            this.commonSection = null;
        }
        if (this.sectiond != null) {
            this.sectiond.dispose();
            this.sectiond = null;
        }
        if (this.propertySection != null) {
            this.propertySection.dispose();
            this.propertySection = null;
        }
        super.dispose();
    }

    protected void createFormContent(IManagedForm managedForm) {
        this.form = managedForm.getForm();
        super.createFormContent(managedForm);
    }

    protected void createRightColumnControls(Composite parent) {
        FormToolkit toolkit = ((FormEditor)this.formEditor.getHyadesEditorPart()).getToolkit();
        Control commonSection = this.createCommonPropertySection(toolkit, parent);
        this.propertySection = new DetailPropertiesSection(this.formEditor, (EditorEclipseForm)this, toolkit);
        Control detailSection = this.createDetailPropertySection(toolkit, parent);
        if (detailSection != null) {
            detailSection.setLayoutData((Object)new GridData(4, 1, true, false));
        }
        commonSection.setLayoutData((Object)new GridData(4, 1, true, false));
    }

    protected Control createCommonPropertySection(FormToolkit toolkit, Composite parent) {
        this.sectionc = FormUtil.createSection(toolkit, parent, this.form);
        FormUtil formUtil = FormUtil.getInstance();
        formUtil.getClass();
        this.commonSection = new FormUtil.CommonSection(formUtil, 2);
        Composite sectionClient = this.commonSection.createControl(this.formEditor, this.sectionc, toolkit, "", "");
        FormUtil.setSectionProperty(toolkit, this.sectionc, (Control)sectionClient, UiPlugin.getString((String)"TTL_CMN_PROPS"), UiPlugin.getString((String)"EDT_GENERAL_DSC"));
        return this.sectionc;
    }

    protected Control createDetailPropertySection(FormToolkit toolkit, Composite parent) {
        DetailsPageProvider detailPageProvider = new DetailsPageProvider();
        this.addDetails(detailPageProvider);
        this.sectiond = FormUtil.createSection(toolkit, parent, this.form);
        Composite sectionClient = this.propertySection.createDefaultControl((Composite)this.sectiond);
        this.propertySection.setDetailPageProvider((DetailPropertiesSection.IDetailFormProvider)detailPageProvider);
        FormUtil.setSectionProperty(toolkit, this.sectiond, (Control)sectionClient, UiPlugin.getString((String)"TTL_DTL_PROPS"), ToolsUiPlugin.getString("TST_SUITE_GENERAL_DETAILS_DESC"));
        return this.sectiond;
    }

    protected void createLeftColumnControls(Composite parent) {
        Control control = this.createBehaviorSection(parent, UiPlugin.getString((String)"W_BEHAVIOR"), UiPlugin.getString((String)"EDT_TC_BEH_DESCRIPTION"));
        control.setLayoutData((Object)new GridData(4, 4, true, true));
    }

    protected Control createBehaviorSection(Composite parent, String header, String desc) {
        BehaviorAccessories ba;
        FormToolkit toolkit = ((FormEditor)this.formEditor.getHyadesEditorPart()).getToolkit();
        Section section = FormUtil.createSection(toolkit, parent, this.form);
        BehaviorAccessories behaviorAccessories = ba = new BehaviorAccessories();
        behaviorAccessories.getClass();
        this.behaviourObjectTree = behaviorAccessories.new BehaviorAccessories.ExtendedObjectTree(this);
        Composite control = this.behaviourObjectTree.createControls((Composite)section, toolkit);
        control.setLayoutData((Object)new GridData(1810));
        this.behaviourObjectTree.getViewerPart().getViewer().setInput((Object)this.getTestSuite().getImplementor().getBlock());
        this.behaviourObjectTree.getTreeViewer().addSelectionChangedListener((ISelectionChangedListener)this);
        this.toggleEnableStatus(0, 0, true);
        this.toggleEnableStatus(1, 4, false);
        FormUtil.setSectionProperty(toolkit, section, (Control)control, header, desc);
        this.registerHelp(1, (Control)parent);
        this.registerHelp(2, (Control)control);
        return section;
    }

    public ITestSuite getTestSuite() {
        return super.getCommonTestSuite();
    }

    protected void registerHelp(int flag, Control object) {
    }

    public void selectionChanged(SelectionChangedEvent event) {
        if (!(event.getSource() instanceof TreeViewer)) {
            return;
        }
        IStructuredSelection structuredSelection = (IStructuredSelection)((TreeViewer)event.getSource()).getSelection();
        Object selection = structuredSelection.getFirstElement();
        this.commonSection.setInput(selection);
        if (this.propertySection != null) {
            this.propertySection.setInput((Object)structuredSelection);
        }
    }

    public void selectReveal(ISelection selection) {
        this.behaviourObjectTree.selectReveal(selection);
    }

    protected void toggleEnableStatus(int start, int end, boolean isEnabled) {
        StructuredViewerPart viewerPart = this.behaviourObjectTree.getViewerPart();
        int i = start;
        while (i <= end) {
            viewerPart.setButtonEnabled(i, isEnabled);
            ++i;
        }
    }

    public BehaviorAccessories.ExtendedObjectTree getBehaviourObjectTree() {
        return this.behaviourObjectTree;
    }
}

