/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.tools.ui.common.internal.editor;

import org.eclipse.hyades.models.common.facades.behavioral.ITestSuite;
import org.eclipse.hyades.test.tools.ui.common.internal.editor.BehaviorSection;
import org.eclipse.hyades.test.tools.ui.common.internal.util.IITestSuiteProvider;
import org.eclipse.hyades.test.ui.UiPlugin;
import org.eclipse.hyades.test.ui.editor.extension.BaseEditorExtension;
import org.eclipse.hyades.test.ui.editor.form.util.EditorForm;
import org.eclipse.hyades.test.ui.editor.form.util.NamedElementSection;
import org.eclipse.hyades.test.ui.editor.form.util.WidgetFactory;
import org.eclipse.hyades.test.ui.internal.editor.form.base.FormSection;
import org.eclipse.hyades.test.ui.internal.editor.form.base.FormWidgetFactory;
import org.eclipse.hyades.test.ui.internal.editor.form.util.DetailSection;
import org.eclipse.hyades.test.ui.internal.editor.form.util.StaticDetailPageProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public abstract class BehaviorForm
extends EditorForm
implements ISelectionChangedListener,
IITestSuiteProvider {
    protected static final int HELP_FORM_CONTROL = 1;
    protected static final int HELP_SECTION_CONTROL = 2;
    protected static final int HELP_NAMED_ELEMENT_CONTROL = 3;
    private BehaviorSection behaviorSection;
    private NamedElementSection commonSection;
    private DetailSection detailSection;
    private boolean firstActivation = true;

    public BehaviorForm(BaseEditorExtension testSuiteEditorExtension, WidgetFactory widgetFactory) {
        super(testSuiteEditorExtension, widgetFactory);
    }

    public void dispose() {
        this.behaviorSection.getTreeViewer().removeSelectionChangedListener((ISelectionChangedListener)this);
        this.behaviorSection.dispose();
        this.commonSection.dispose();
        if (this.detailSection != null) {
            this.detailSection.dispose();
        }
        super.dispose();
    }

    public ITestSuite getTestSuite() {
        return ((IITestSuiteProvider)this.getBaseEditorExtension()).getTestSuite();
    }

    protected void createEditorFormContents(Composite parent) {
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.makeColumnsEqualWidth = true;
        gridLayout.marginWidth = 10;
        gridLayout.horizontalSpacing = 15;
        parent.setLayout((Layout)gridLayout);
        Composite leftColumn = this.createColumn(parent);
        Composite rightColumn = this.createColumn(parent);
        this.behaviorSection = this.createBehaviorSection();
        this.registerSection((FormSection)this.behaviorSection);
        this.behaviorSection.setHeaderText(UiPlugin.getString((String)"W_BEHAVIOR"));
        Control control = this.behaviorSection.createControl(leftColumn, (FormWidgetFactory)this.getWidgetFactory());
        control.setLayoutData((Object)new GridData(1810));
        this.commonSection = new NamedElementSection((EditorForm)this);
        this.commonSection.setHeaderText(UiPlugin.getString((String)"TTL_CMN_PROPS"));
        this.registerSection((FormSection)this.commonSection);
        control = this.commonSection.createControl(rightColumn, (FormWidgetFactory)this.getWidgetFactory());
        GridData gridData = new GridData(770);
        control.setLayoutData((Object)gridData);
        StaticDetailPageProvider detailPageProvider = new StaticDetailPageProvider();
        this.addDetails(detailPageProvider);
        if (!detailPageProvider.isEmpty()) {
            this.detailSection = new DetailSection((EditorForm)this);
            this.detailSection.setDetailPageProvider((DetailSection.IDetailPageProvider)detailPageProvider);
            this.detailSection.setHeaderText(UiPlugin.getString((String)"TTL_DTL_PROPS"));
            this.registerSection((FormSection)this.detailSection);
            control = this.detailSection.createControl(rightColumn, (FormWidgetFactory)this.getWidgetFactory());
            gridData = new GridData(770);
            control.setLayoutData((Object)gridData);
        }
        this.registerHelp(1, parent);
        this.registerHelp(2, leftColumn);
        this.registerHelp(3, rightColumn);
    }

    protected abstract BehaviorSection createBehaviorSection();

    protected void addDetails(StaticDetailPageProvider detailPageProvider) {
    }

    protected void registerHelp(int flag, Object object) {
    }

    public void load() {
        this.behaviorSection.getTreeViewer().removeSelectionChangedListener((ISelectionChangedListener)this);
        this.behaviorSection.setInput(this.getTestSuite().getImplementor().getBlock());
        this.behaviorSection.getTreeViewer().addSelectionChangedListener((ISelectionChangedListener)this);
    }

    public void selectReveal(ISelection selection) {
        this.behaviorSection.selectReveal(selection);
    }

    public void selectionChanged(SelectionChangedEvent event) {
        if (event.getSource() == this.behaviorSection.getTreeViewer()) {
            IStructuredSelection structuredSelection = (IStructuredSelection)this.getSelection();
            this.commonSection.setInput((Object)structuredSelection);
            if (this.detailSection != null) {
                this.detailSection.setInput((Object)structuredSelection);
            }
        }
    }

    public ISelection getSelection() {
        return this.behaviorSection.getTreeViewer().getSelection();
    }

    public boolean activated() {
        if (this.firstActivation) {
            this.firstActivation = false;
            this.behaviorSection.setFocus();
        }
        return super.activated();
    }

    public void updateTitle() {
    }
}

